/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.audit.appender;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.properties.CollectionProperties;
import org.openspcoop2.utils.properties.PropertiesUtilities;
import org.openspcoop2.utils.xml.JaxbUtils;
import org.openspcoop2.web.lib.audit.AuditException;
import org.openspcoop2.web.lib.audit.appender.IAuditAppender;
import org.openspcoop2.web.lib.audit.log.Operation;
import org.openspcoop2.web.lib.audit.log.constants.Stato;
import org.openspcoop2.web.lib.audit.log.utils.CleanerOpenSPCoop2Extensions;
import org.slf4j.Logger;

public class AuditLog4JAppender
implements IAuditAppender {
    private String nomeAppender = null;
    private Logger logger = null;
    private boolean xml = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initAppender(String nomeAppender, Properties properties) throws AuditException {
        Properties loggerProperties = new Properties();
        try {
            CollectionProperties loggerPropertiesRidefinito;
            File fConf;
            String confDirectory;
            String nomeProprietaLoaderInstance;
            this.nomeAppender = nomeAppender;
            String fileConfigurazione = properties.getProperty("fileConfigurazione");
            if (fileConfigurazione == null) {
                throw new Exception("Proprieta' 'fileConfigurazione' non definita");
            }
            fileConfigurazione = fileConfigurazione.trim();
            String nomeFileLoaderInstance = properties.getProperty("nomeFileLoaderInstance");
            if (nomeFileLoaderInstance != null) {
                nomeFileLoaderInstance = nomeFileLoaderInstance.trim();
            }
            if ((nomeProprietaLoaderInstance = properties.getProperty("nomeProprietaLoaderInstance")) != null) {
                nomeProprietaLoaderInstance = nomeProprietaLoaderInstance.trim();
            }
            if ((confDirectory = properties.getProperty("confDirectory")) != null) {
                confDirectory = confDirectory.trim();
            }
            if ((fConf = new File(fileConfigurazione)).exists()) {
                try (FileInputStream fin = new FileInputStream(fConf);){
                    loggerProperties.load(fin);
                }
            }
            InputStream is = null;
            try {
                block31: {
                    try {
                        is = AuditLog4JAppender.class.getResourceAsStream(fileConfigurazione);
                    }
                    catch (Exception e) {
                        if (!fileConfigurazione.startsWith("/")) break block31;
                        throw e;
                    }
                }
                if (is == null && !fileConfigurazione.startsWith("/")) {
                    is = AuditLog4JAppender.class.getResourceAsStream("/" + fileConfigurazione);
                }
                if (is == null) {
                    throw new Exception("InputStream [" + fileConfigurazione + "] non trovato");
                }
                loggerProperties.load(is);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e) {}
            }
            if (nomeFileLoaderInstance != null && nomeProprietaLoaderInstance != null && (loggerPropertiesRidefinito = PropertiesUtilities.searchLocalImplementation((String)"GOVWAY_HOME", (Logger)LoggerWrapperFactory.getLogger(AuditLog4JAppender.class), (String)nomeProprietaLoaderInstance, (String)nomeFileLoaderInstance, (String)confDirectory)) != null && loggerPropertiesRidefinito.size() > 0) {
                Enumeration ridefinito = loggerPropertiesRidefinito.keys();
                while (ridefinito.hasMoreElements()) {
                    String key = (String)ridefinito.nextElement();
                    String value = loggerPropertiesRidefinito.get(key);
                    if (loggerProperties.containsKey(key)) {
                        loggerProperties.remove(key);
                    }
                    loggerProperties.put(key, value);
                }
            }
            LoggerWrapperFactory.setLogConfiguration((Properties)loggerProperties, (boolean)true);
            String category = properties.getProperty("category");
            if (category == null) {
                throw new Exception("Proprieta' 'category' non definita");
            }
            category = category.trim();
            this.logger = LoggerWrapperFactory.getLogger((String)category);
            String xml = properties.getProperty("xml");
            if (xml == null) {
                throw new Exception("Proprieta' 'xml' non definita");
            }
            xml = xml.trim();
            this.xml = Boolean.parseBoolean(xml);
        }
        catch (Exception e) {
            throw new AuditException("Inizializzazione appender[" + this.nomeAppender + "] non riuscita:" + e.getMessage(), e);
        }
    }

    @Override
    public Object registraOperazioneInFaseDiElaborazione(Operation operation) throws AuditException {
        try {
            if (this.xml) {
                CleanerOpenSPCoop2Extensions cleaner = new CleanerOpenSPCoop2Extensions();
                cleaner.clean(operation, true);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                JaxbUtils.objToXml((OutputStream)bout, Operation.class, (Object)operation);
                bout.flush();
                bout.close();
                this.logger.info(bout.toString());
            } else {
                if (operation.getInterfaceMsg() == null) {
                    throw new Exception("InterfaceMsg non fornito");
                }
                this.logger.info("<" + new Date() + "> " + operation.getInterfaceMsg() + "\n");
            }
            return operation;
        }
        catch (Exception e) {
            throw new AuditException("Appender[" + this.nomeAppender + "] Errore durante la registrazione dell'operazione: " + e.getMessage(), e);
        }
    }

    @Override
    public void registraOperazioneCompletataConSuccesso(Object idOperation) throws AuditException {
        try {
            Operation operation = (Operation)idOperation;
            operation.setStato(Stato.COMPLETED);
            operation.setTimeExecute(DateManager.getDate());
            if (this.xml) {
                CleanerOpenSPCoop2Extensions cleaner = new CleanerOpenSPCoop2Extensions();
                cleaner.clean(operation, true);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                JaxbUtils.objToXml((OutputStream)bout, Operation.class, (Object)operation);
                bout.flush();
                bout.close();
                this.logger.info(bout.toString());
            } else {
                if (operation.getInterfaceMsg() == null) {
                    throw new Exception("InterfaceMsg non fornito");
                }
                this.logger.info("<" + new Date() + "> " + operation.getInterfaceMsg() + "\n");
            }
        }
        catch (Exception e) {
            throw new AuditException("Appender[" + this.nomeAppender + "] Errore durante la registrazione dell'operazione: " + e.getMessage(), e);
        }
    }

    @Override
    public void registraOperazioneTerminataConErrore(Object idOperation, String motivoErrore) throws AuditException {
        try {
            Operation operation = (Operation)idOperation;
            operation.setStato(Stato.ERROR);
            operation.setError(motivoErrore);
            operation.setTimeExecute(DateManager.getDate());
            if (this.xml) {
                CleanerOpenSPCoop2Extensions cleaner = new CleanerOpenSPCoop2Extensions();
                cleaner.clean(operation, true);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                JaxbUtils.objToXml((OutputStream)bout, Operation.class, (Object)operation);
                bout.flush();
                bout.close();
                this.logger.info(bout.toString());
            } else {
                if (operation.getInterfaceMsg() == null) {
                    throw new Exception("InterfaceMsg non fornito");
                }
                this.logger.info("<" + new Date() + "> " + operation.getInterfaceMsg() + "\n");
            }
        }
        catch (Exception e) {
            throw new AuditException("Appender[" + this.nomeAppender + "] Errore durante la registrazione dell'operazione: " + e.getMessage(), e);
        }
    }
}

