/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.javascript;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSEncoder;
import org.ajax4jsf.javascript.ResponseWriterWrapper;
import org.ajax4jsf.javascript.ScriptString;
import org.ajax4jsf.javascript.StringBuilderWriter;
import org.apache.commons.beanutils.PropertyUtils;

public class ScriptUtils {
    private ScriptUtils() {
    }

    private static void writeScriptToStream(Writer writer, Object obj) throws IOException {
        if (null == obj) {
            writer.write("null");
        } else if (obj instanceof ScriptString) {
            writer.write(((ScriptString)obj).toScript());
        } else if (obj.getClass().isArray()) {
            writer.write("[");
            boolean first = true;
            for (int i = 0; i < Array.getLength(obj); ++i) {
                Object element = Array.get(obj, i);
                if (!first) {
                    writer.write(44);
                }
                ScriptUtils.writeScriptToStream(writer, element);
                first = false;
            }
            writer.write("] ");
        } else if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            writer.write("[");
            boolean first = true;
            for (Object element : collection) {
                if (!first) {
                    writer.write(44);
                }
                ScriptUtils.writeScriptToStream(writer, element);
                first = false;
            }
            writer.write("] ");
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            writer.write("{");
            boolean first = true;
            for (Map.Entry entry : map.entrySet()) {
                if (!first) {
                    writer.write(44);
                }
                ScriptUtils.writeEncodedString(writer, entry.getKey());
                writer.write(":");
                ScriptUtils.writeScriptToStream(writer, entry.getValue());
                first = false;
            }
            writer.write("} ");
        } else if (obj instanceof Number || obj instanceof Boolean) {
            writer.write(obj.toString());
        } else if (obj instanceof String) {
            ScriptUtils.writeEncodedString(writer, obj);
        } else if (obj instanceof Enum) {
            ScriptUtils.writeEncodedString(writer, obj);
        } else if (obj.getClass().getName().startsWith("java.sql.")) {
            writer.write("{");
            boolean first = true;
            for (PropertyDescriptor propertyDescriptor : PropertyUtils.getPropertyDescriptors((Object)obj)) {
                String key = propertyDescriptor.getName();
                if ("class".equals(key)) continue;
                Object value = null;
                try {
                    value = PropertyUtils.getProperty((Object)obj, (String)key);
                }
                catch (Exception e) {
                    continue;
                }
                if (!first) {
                    writer.write(44);
                }
                ScriptUtils.writeEncodedString(writer, key);
                writer.write(":");
                ScriptUtils.writeScriptToStream(writer, value);
                first = false;
            }
            writer.write("} ");
        } else {
            PropertyDescriptor[] propertyDescriptors;
            writer.write("{");
            try {
                propertyDescriptors = PropertyUtils.getPropertyDescriptors((Object)obj);
            }
            catch (Exception e) {
                throw new FacesException("Error in conversion Java Object to JavaScript", (Throwable)e);
            }
            boolean first = true;
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                Object propertyValue;
                String key = propertyDescriptor.getName();
                if ("class".equals(key)) continue;
                if (!first) {
                    writer.write(44);
                }
                ScriptUtils.writeEncodedString(writer, key);
                writer.write(":");
                try {
                    propertyValue = PropertyUtils.getProperty((Object)obj, (String)key);
                }
                catch (Exception e) {
                    throw new FacesException("Error in conversion Java Object to JavaScript", (Throwable)e);
                }
                ScriptUtils.writeScriptToStream(writer, propertyValue);
                first = false;
            }
            writer.write("} ");
        }
    }

    public static void writeToStream(ResponseWriter responseWriter, Object obj) throws IOException {
        ScriptUtils.writeScriptToStream(new ResponseWriterWrapper(responseWriter), obj);
    }

    public static String toScript(Object obj) {
        StringBuilder sb = new StringBuilder();
        try {
            ScriptUtils.writeScriptToStream(new StringBuilderWriter(sb), obj);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static void writeEncodedString(Writer w, Object obj) throws IOException {
        w.write("'");
        ScriptUtils.writeEncoded(w, obj);
        w.write("'");
    }

    public static void addEncodedString(StringBuilder buff, Object obj) {
        try {
            ScriptUtils.writeEncodedString(new StringBuilderWriter(buff), obj);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void writeEncoded(Writer w, Object obj) throws IOException {
        JSEncoder encoder = new JSEncoder();
        char[] chars = obj.toString().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (!encoder.compile(c)) {
                w.write(encoder.encode(c));
                continue;
            }
            w.write(c);
        }
    }

    public static void addEncoded(StringBuilder buff, Object obj) {
        try {
            ScriptUtils.writeEncoded(new StringBuilderWriter(buff), obj);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getValidJavascriptName(String s) {
        StringBuffer buf = null;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            byte[] bytes;
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') {
                if (buf == null) continue;
                buf.append(c);
                continue;
            }
            if (buf == null) {
                buf = new StringBuffer(s.length() + 10);
                buf.append(s.substring(0, i));
            }
            buf.append('_');
            if (c < '\u0010') {
                buf.append('0');
            }
            if (c < '\u0080') {
                buf.append(Integer.toHexString(c).toUpperCase());
                continue;
            }
            try {
                bytes = Character.toString(c).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            for (int j = 0; j < bytes.length; ++j) {
                int intVal = bytes[j];
                if (intVal < 0) {
                    intVal = 256 + intVal;
                } else if (intVal < 16) {
                    buf.append('0');
                }
                buf.append(Integer.toHexString(intVal).toUpperCase());
            }
        }
        return buf == null ? s : buf.toString();
    }
}

