/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message;

import java.io.InputStream;
import javax.mail.BodyPart;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2RestJsonMessage;
import org.openspcoop2.message.OpenSPCoop2RestMimeMultipartMessage;
import org.openspcoop2.message.OpenSPCoop2RestXmlMessage;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.exception.ParseExceptionUtils;
import org.openspcoop2.message.rest.MultipartContent;
import org.openspcoop2.message.soap.AbstractOpenSPCoop2Message_saaj_impl;
import org.openspcoop2.message.soap.AbstractOpenSPCoop2Message_soap_impl;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.mime.MimeMultipart;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;
import org.w3c.dom.Element;

public class MessageUtils {
    public static void registerParseException(OpenSPCoop2Message msg, Throwable e) {
        MessageUtils.registerParseException(msg, e, false);
    }

    public static void registerParseException(OpenSPCoop2Message o, Throwable e, boolean allException) {
        if (o != null && o.getParseException() == null) {
            if (allException) {
                o.setParseException(e);
            } else {
                Throwable t = ParseExceptionUtils.getParseException(e);
                if (t != null) {
                    o.setParseException(t);
                }
            }
        }
    }

    public static SOAPMessage getSOAPMessage(OpenSPCoop2SoapMessage soapMessage, boolean bufferMessage_readOnly, String idTransazione) throws MessageException {
        try {
            if (soapMessage instanceof AbstractOpenSPCoop2Message_soap_impl) {
                AbstractOpenSPCoop2Message_soap_impl soap = (AbstractOpenSPCoop2Message_soap_impl)soapMessage;
                return ((AbstractOpenSPCoop2Message_saaj_impl)soap.getContent(bufferMessage_readOnly, idTransazione)).getSOAPMessage();
            }
            return soapMessage.getSOAPMessage();
        }
        catch (MessageException me) {
            throw me;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public static SOAPPart getSOAPPart(OpenSPCoop2SoapMessage soapMessage, boolean bufferMessage_readOnly, String idTransazione) throws MessageException {
        try {
            if (soapMessage instanceof AbstractOpenSPCoop2Message_soap_impl) {
                AbstractOpenSPCoop2Message_soap_impl soap = (AbstractOpenSPCoop2Message_soap_impl)soapMessage;
                return ((AbstractOpenSPCoop2Message_saaj_impl)soap.getContent(bufferMessage_readOnly, idTransazione)).getSOAPPart();
            }
            return soapMessage.getSOAPPart();
        }
        catch (MessageException me) {
            throw me;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public static Element getContentElement(OpenSPCoop2Message msg, boolean checkSoapBodyEmpty, boolean bufferMessage_readOnly, String idTransazione) throws MessageException {
        try {
            MimeMultipart mm;
            MultipartContent mc;
            OpenSPCoop2RestMimeMultipartMessage mimeMsg;
            if (MessageType.SOAP_11.equals(msg.getMessageType()) || MessageType.SOAP_12.equals(msg.getMessageType())) {
                OpenSPCoop2SoapMessage soapMessage = msg.castAsSoap();
                if (!soapMessage.isSOAPBodyEmpty() || !checkSoapBodyEmpty) {
                    SOAPPart soapPart = MessageUtils.getSOAPPart(soapMessage, bufferMessage_readOnly, idTransazione);
                    if (soapPart == null) {
                        throw new MessageException("Messaggio (SOAPPart) non fornito");
                    }
                    SOAPEnvelope envelope = soapPart.getEnvelope();
                    if (envelope == null) {
                        throw new MessageException("Envelope non fornita");
                    }
                    return envelope;
                }
            } else if (MessageType.XML.equals(msg.getMessageType())) {
                OpenSPCoop2RestXmlMessage xmlMsg = msg.castAsRestXml();
                if (xmlMsg.hasContent()) {
                    return (Element)xmlMsg.getContent(bufferMessage_readOnly, idTransazione);
                }
            } else if (MessageType.MIME_MULTIPART.equals(msg.getMessageType()) && (mimeMsg = msg.castAsRestMimeMultipart()).hasContent() && (mc = (MultipartContent)mimeMsg.getContent()) != null && (mm = mc.getMimeMultipart()) != null && mm.countBodyParts() > 0) {
                for (int i = 0; i < mm.countBodyParts(); ++i) {
                    try {
                        BodyPart bodyPart = mm.getBodyPart(i);
                        String contentType = bodyPart.getContentType();
                        if (contentType != null && ("text/xml".equals(contentType) || "application/xml".equals(contentType) || RegularExpressionEngine.isMatch((String)contentType, (String)".*\\+xml"))) {
                            InputStream is = bodyPart.getInputStream();
                            byte[] xmlBytes = Utilities.getAsByteArray((InputStream)is);
                            return MessageXMLUtils.getInstance(msg.getFactory()).newElement(xmlBytes);
                        }
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            return null;
        }
        catch (MessageException me) {
            throw me;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public static String getContentString(OpenSPCoop2Message msg, boolean bufferMessage_readOnly, String idTransazione) throws MessageException {
        try {
            MimeMultipart mm;
            MultipartContent mc;
            OpenSPCoop2RestMimeMultipartMessage mimeMsg;
            if (MessageType.JSON.equals(msg.getMessageType())) {
                OpenSPCoop2RestJsonMessage json = msg.castAsRestJson();
                return (String)json.getContent(bufferMessage_readOnly, idTransazione);
            }
            if (MessageType.MIME_MULTIPART.equals(msg.getMessageType()) && (mimeMsg = msg.castAsRestMimeMultipart()).hasContent() && (mc = (MultipartContent)mimeMsg.getContent()) != null && (mm = mc.getMimeMultipart()) != null && mm.countBodyParts() > 0) {
                for (int i = 0; i < mm.countBodyParts(); ++i) {
                    try {
                        BodyPart bodyPart = mm.getBodyPart(i);
                        String contentType = bodyPart.getContentType();
                        if (contentType != null && ("application/json".equals(contentType) || RegularExpressionEngine.isMatch((String)contentType, (String)".*/json|.*/x-json|.*\\+json"))) {
                            InputStream is = bodyPart.getInputStream();
                            byte[] jsonBytes = Utilities.getAsByteArray((InputStream)is);
                            String charset = ContentTypeUtilities.readCharsetFromContentType((String)contentType);
                            if (charset == null) {
                                charset = Charset.UTF_8.getValue();
                            }
                            return new String(jsonBytes, charset);
                        }
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            return null;
        }
        catch (MessageException me) {
            throw me;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public static void setUpdatable(OpenSPCoop2Message msg) throws MessageException {
        try {
            if (MessageType.SOAP_11.equals(msg.getMessageType()) || MessageType.SOAP_12.equals(msg.getMessageType())) {
                OpenSPCoop2SoapMessage soapMessage = msg.castAsSoap();
                if (soapMessage instanceof AbstractOpenSPCoop2Message_soap_impl) {
                    AbstractOpenSPCoop2Message_soap_impl soap = (AbstractOpenSPCoop2Message_soap_impl)soapMessage;
                    soap.setContentUpdatable();
                }
            } else {
                msg.castAsRest().setContentUpdatable();
            }
        }
        catch (MessageException me) {
            throw me;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }
}

