/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.config;

import java.io.Serializable;
import java.util.List;
import org.openspcoop2.message.config.AbstractMediaTypeCollection;
import org.openspcoop2.message.config.IntegrationErrorCollection;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.exception.MessageException;

public abstract class AbstractConfigurationServiceBinding
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected ServiceBinding serviceBinding;
    protected boolean enabled;
    protected AbstractMediaTypeCollection request;
    protected AbstractMediaTypeCollection response;
    protected IntegrationErrorCollection internalIntegrationErrorConfiguration;
    protected IntegrationErrorCollection externalIntegrationErrorConfiguration;

    public AbstractConfigurationServiceBinding(ServiceBinding serviceBinding, boolean enabled, IntegrationErrorCollection internalIntegrationErrorConfiguration, IntegrationErrorCollection externalIntegrationErrorConfiguration) throws MessageException {
        if (serviceBinding == null) {
            throw new MessageException("ServiceBinding not defined");
        }
        this.serviceBinding = serviceBinding;
        this.enabled = enabled;
        if (enabled) {
            if (internalIntegrationErrorConfiguration == null) {
                throw new MessageException("InternalIntegrationErrorConfiguration for binding " + serviceBinding.name() + " not defined");
            }
            if (externalIntegrationErrorConfiguration == null) {
                throw new MessageException("ExternalIntegrationErrorConfiguration for binding " + serviceBinding.name() + " not defined");
            }
            this.internalIntegrationErrorConfiguration = internalIntegrationErrorConfiguration;
            this.externalIntegrationErrorConfiguration = externalIntegrationErrorConfiguration;
        }
    }

    public abstract void init();

    public abstract List<MessageType> getMessageTypeSupported();

    public ServiceBinding getServiceBinding() {
        return this.serviceBinding;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public AbstractMediaTypeCollection getRequest() {
        return this.request;
    }

    public AbstractMediaTypeCollection getResponse() {
        return this.response;
    }

    public IntegrationErrorCollection getInternalIntegrationErrorConfiguration() {
        return this.internalIntegrationErrorConfiguration;
    }

    public IntegrationErrorCollection getExternalIntegrationErrorConfiguration() {
        return this.externalIntegrationErrorConfiguration;
    }
}

