/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.config;

import java.io.Serializable;
import org.openspcoop2.message.config.AbstractMediaTypeCollection;
import org.openspcoop2.message.config.RestBinding;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.MessageException;

public class RestMediaTypeCollection
extends AbstractMediaTypeCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private RestBinding binding;

    public RestMediaTypeCollection(RestBinding binding) {
        this.binding = binding;
    }

    private void checkVersion(MessageType version) throws MessageException {
        if (MessageType.XML.equals(version)) {
            if (!this.binding.isBinding_xml()) {
                throw new MessageException("MessageType [" + version + "] not supported in RestBinding; Xml disabled");
            }
        } else if (MessageType.JSON.equals(version)) {
            if (!this.binding.isBinding_json()) {
                throw new MessageException("MessageType [" + version + "] not supported in RestBinding; Json disabled");
            }
        } else if (MessageType.BINARY.equals(version)) {
            if (!this.binding.isBinding_binary()) {
                throw new MessageException("MessageType [" + version + "] not supported in RestBinding; Binary disabled");
            }
        } else if (MessageType.MIME_MULTIPART.equals(version)) {
            if (!this.binding.isBinding_mimeMultipart()) {
                throw new MessageException("MessageType [" + version + "] not supported in RestBinding; MimeMultipart disabled");
            }
        } else {
            throw new MessageException("MessageType [" + version + "] not supported in RestBinding");
        }
    }

    @Override
    public void addDefaultMediaType(MessageType version) throws MessageException {
        this.checkVersion(version);
        super.addDefaultMediaType(version);
    }

    @Override
    public void addUndefinedMediaType(MessageType version) throws MessageException {
        this.checkVersion(version);
        super.addUndefinedMediaType(version);
    }

    @Override
    public void addMediaType(String mediaType, MessageType version, boolean regExpr) throws MessageException {
        this.checkVersion(version);
        super.addMediaType(mediaType, version, regExpr);
    }
}

