/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.rest;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.mail.BodyPart;
import javax.mail.Header;
import org.openspcoop2.message.OpenSPCoop2RestMessage;
import org.openspcoop2.message.OpenSPCoop2RestMimeMultipartMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.rest.BinaryContent;
import org.openspcoop2.message.rest.MultipartContent;
import org.openspcoop2.message.utils.DumpAttachment;
import org.openspcoop2.message.utils.DumpMessaggio;
import org.openspcoop2.message.utils.DumpMessaggioConfig;
import org.openspcoop2.message.utils.DumpMessaggioMultipartInfo;
import org.openspcoop2.utils.dch.MailcapActivationReader;
import org.openspcoop2.utils.mime.MimeMultipart;

public class DumpRestMessageUtils {
    private static boolean convert = false;

    public static DumpMessaggio dumpMessage(OpenSPCoop2RestMessage<?> msg, boolean dumpAllBodyParts) throws MessageException {
        return DumpRestMessageUtils.dumpMessage(msg, new DumpMessaggioConfig(), dumpAllBodyParts);
    }

    public static DumpMessaggio dumpMessage(OpenSPCoop2RestMessage<?> msg, DumpMessaggioConfig config, boolean dumpAllBodyParts) throws MessageException {
        try {
            boolean hasContent;
            DumpMessaggio dumpMessaggio = new DumpMessaggio();
            dumpMessaggio.setMessageType(msg.getMessageType());
            Map pTrasporto = null;
            if (msg.getTransportRequestContext() != null) {
                if (msg.getTransportRequestContext().getHeaders() != null && msg.getTransportRequestContext().getHeaders().size() > 0 && config.isDumpHeaders()) {
                    pTrasporto = msg.getTransportRequestContext().getHeaders();
                }
            } else if (msg.getTransportResponseContext() != null && msg.getTransportResponseContext().getHeaders() != null && msg.getTransportResponseContext().getHeaders().size() > 0 && config.isDumpHeaders()) {
                pTrasporto = msg.getTransportResponseContext().getHeaders();
            }
            if (config.isDumpHeaders() && pTrasporto != null) {
                for (String key : pTrasporto.keySet()) {
                    if (key == null) continue;
                    List values = (List)pTrasporto.get(key);
                    dumpMessaggio.getHeadersValues().put(key, values);
                }
            }
            if (hasContent = msg.hasContent()) {
                dumpMessaggio.setContentType(msg.getContentType());
                if (config.isDumpBody() && !MessageType.MIME_MULTIPART.equals(msg.getMessageType())) {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    switch (msg.getMessageType()) {
                        case XML: {
                            bout.write(msg.castAsRestXml().getContentAsByteArray());
                            break;
                        }
                        case JSON: {
                            bout.write(msg.castAsRestJson().getContentAsByteArray());
                            break;
                        }
                        case BINARY: {
                            bout.write(((BinaryContent)msg.castAsRestBinary().getContent()).getContent());
                            break;
                        }
                        default: {
                            throw new MessageException("MessageType [" + msg.getMessageType() + "] unsupported");
                        }
                    }
                    bout.flush();
                    bout.close();
                    dumpMessaggio.setBody(bout);
                }
            }
            if ((config.isDumpBody() || config.isDumpAttachments()) && hasContent && MessageType.MIME_MULTIPART.equals(msg.getMessageType())) {
                MimeMultipart mimeMultipart;
                OpenSPCoop2RestMimeMultipartMessage msgMime = msg.castAsRestMimeMultipart();
                MultipartContent mc = (MultipartContent)msgMime.getContent();
                MimeMultipart mimeMultipart2 = mimeMultipart = mc != null ? mc.getMimeMultipart() : null;
                if (mimeMultipart != null) {
                    for (int i = 0; i < mimeMultipart.countBodyParts(); ++i) {
                        Enumeration en;
                        BodyPart bodyPart = mimeMultipart.getBodyPart(i);
                        if (i > 0 && !config.isDumpAttachments()) break;
                        DumpMessaggioMultipartInfo multipartInfoBody = null;
                        DumpAttachment dumpAttach = null;
                        if (i == 0 && config.isDumpBody()) {
                            multipartInfoBody = new DumpMessaggioMultipartInfo();
                            multipartInfoBody.setContentId(mimeMultipart.getContentID(bodyPart));
                            multipartInfoBody.setContentLocation(mimeMultipart.getContentDisposition(bodyPart));
                            multipartInfoBody.setContentType(bodyPart.getContentType());
                        } else {
                            dumpAttach = new DumpAttachment();
                            dumpAttach.setContentId(mimeMultipart.getContentID(bodyPart));
                            dumpAttach.setContentLocation(mimeMultipart.getContentDisposition(bodyPart));
                            dumpAttach.setContentType(bodyPart.getContentType());
                        }
                        if (config.isDumpMultipartHeaders() && (en = bodyPart.getAllHeaders()) != null) {
                            while (en.hasMoreElements()) {
                                List<Object> lValues;
                                Header hdr;
                                Object keyO = en.nextElement();
                                if (keyO instanceof String) {
                                    String key = (String)keyO;
                                    String[] values = bodyPart.getHeader(key);
                                    ArrayList<String> lValues2 = new ArrayList<String>();
                                    if (values != null && values.length > 0) {
                                        for (int j = 0; j < values.length; ++j) {
                                            lValues2.add(values[j]);
                                        }
                                    }
                                    if (lValues2.isEmpty()) continue;
                                    if (multipartInfoBody != null) {
                                        multipartInfoBody.getHeadersValues().put(key, lValues2);
                                        continue;
                                    }
                                    dumpAttach.getHeadersValues().put(key, lValues2);
                                    continue;
                                }
                                if (!(keyO instanceof Header) || (hdr = (Header)keyO) == null || hdr.getName() == null) continue;
                                if (multipartInfoBody != null) {
                                    lValues = null;
                                    if (multipartInfoBody.getHeadersValues().containsKey(hdr.getName())) {
                                        lValues = multipartInfoBody.getHeadersValues().get(hdr.getName());
                                    } else {
                                        lValues = new ArrayList();
                                        multipartInfoBody.getHeadersValues().put(hdr.getName(), lValues);
                                    }
                                    lValues.add(hdr.getValue());
                                    continue;
                                }
                                lValues = null;
                                if (dumpAttach.getHeadersValues().containsKey(hdr.getName())) {
                                    lValues = dumpAttach.getHeadersValues().get(hdr.getName());
                                } else {
                                    lValues = new ArrayList();
                                    dumpAttach.getHeadersValues().put(hdr.getName(), lValues);
                                }
                                lValues.add(hdr.getValue());
                            }
                        }
                        ByteArrayOutputStream boutAttach = null;
                        if (dumpAllBodyParts) {
                            boutAttach = (ByteArrayOutputStream)DumpRestMessageUtils._dumpBodyPart(msg, bodyPart, true);
                        } else {
                            Object o = DumpRestMessageUtils._dumpBodyPart(msg, bodyPart, false);
                            if (o == null) {
                                dumpAttach.setErrorContentNotSerializable("Contenuto attachment non recuperato??");
                            } else if (o instanceof String) {
                                boutAttach = new ByteArrayOutputStream();
                                boutAttach.write(((String)o).getBytes());
                                boutAttach.flush();
                                boutAttach.close();
                            } else if (o instanceof ByteArrayOutputStream) {
                                boutAttach = (ByteArrayOutputStream)o;
                            } else {
                                dumpAttach.setErrorContentNotSerializable("Contenuto attachment non \u00e8 visualizzabile, tipo: " + o.getClass().getName());
                            }
                        }
                        if (multipartInfoBody != null) {
                            dumpMessaggio.setBody(boutAttach);
                            dumpMessaggio.setMultipartInfoBody(multipartInfoBody);
                            continue;
                        }
                        dumpAttach.setContent(boutAttach);
                        if (dumpMessaggio.getAttachments() == null) {
                            dumpMessaggio.setAttachments(new ArrayList<DumpAttachment>());
                        }
                        dumpMessaggio.getAttachments().add(dumpAttach);
                    }
                }
            }
            return dumpMessaggio;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public static String dumpMessageAsString(DumpMessaggio msg, boolean dumpAllAttachments) throws MessageException {
        return DumpRestMessageUtils.dumpMessageAsString(msg, new DumpMessaggioConfig(), dumpAllAttachments);
    }

    public static String dumpMessageAsString(DumpMessaggio msg, DumpMessaggioConfig config, boolean dumpAllAttachments) throws MessageException {
        try {
            StringBuilder out = new StringBuilder(msg.toString(config, dumpAllAttachments));
            return out.toString();
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public static String dumpMessageAsString(OpenSPCoop2RestMessage<?> msg, boolean dumpAllBodyParts) throws MessageException {
        return DumpRestMessageUtils.dumpMessageAsString(msg, new DumpMessaggioConfig(), dumpAllBodyParts);
    }

    public static String dumpMessageAsString(OpenSPCoop2RestMessage<?> msg, DumpMessaggioConfig config, boolean dumpAllBodyParts) throws MessageException {
        try {
            StringBuilder out = new StringBuilder();
            Map pTrasporto = null;
            if (msg.getTransportRequestContext() != null) {
                if (msg.getTransportRequestContext().getHeaders() != null && msg.getTransportRequestContext().getHeaders().size() > 0 && config.isDumpHeaders()) {
                    pTrasporto = msg.getTransportRequestContext().getHeaders();
                }
            } else if (msg.getTransportResponseContext() != null && msg.getTransportResponseContext().getHeaders() != null && msg.getTransportResponseContext().getHeaders().size() > 0 && config.isDumpHeaders()) {
                pTrasporto = msg.getTransportResponseContext().getHeaders();
            }
            if (config.isDumpHeaders()) {
                out.append("------ Header di trasporto ------\n");
                if (pTrasporto != null && pTrasporto.size() > 0) {
                    for (String key : pTrasporto.keySet()) {
                        List values;
                        if (key == null || (values = (List)pTrasporto.get(key)) == null || values.isEmpty()) continue;
                        for (String value : values) {
                            out.append("- " + key + ": " + value + "\n");
                        }
                    }
                } else {
                    out.append("Non presenti\n");
                }
            }
            boolean hasContent = msg.hasContent();
            String contentString = "Body";
            Object contentType = "";
            if (!hasContent) {
                contentString = "Empty Body";
            }
            if (hasContent && msg.getContentType() != null) {
                contentType = " (ContentType: " + msg.getContentType() + ")";
            }
            if (config.isDumpBody()) {
                out.append("------ " + contentString + (String)contentType + " (" + msg.getMessageType() + ") ------\n");
                if (!MessageType.MIME_MULTIPART.equals(msg.getMessageType())) {
                    out.append("\n");
                    if (hasContent) {
                        out.append(msg.getContentAsString());
                    }
                }
            }
            if ((config.isDumpBody() || config.isDumpAttachments()) && hasContent && MessageType.MIME_MULTIPART.equals(msg.getMessageType())) {
                MimeMultipart mimeMultipart;
                OpenSPCoop2RestMimeMultipartMessage msgMime = msg.castAsRestMimeMultipart();
                MultipartContent mc = (MultipartContent)msgMime.getContent();
                MimeMultipart mimeMultipart2 = mimeMultipart = mc != null ? mc.getMimeMultipart() : null;
                if (mimeMultipart != null) {
                    for (int i = 0; i < mimeMultipart.countBodyParts() && (i <= 0 || config.isDumpAttachments()); ++i) {
                        Enumeration en;
                        String contentLocationBodyPart;
                        BodyPart bodyPart = mimeMultipart.getBodyPart(i);
                        if (i > 0 || !config.isDumpBody()) {
                            out.append("\n------ BodyPart-" + (i + 1) + " ------\n");
                        }
                        out.append("\n*** MimePart Header ***\n");
                        String contentIdBodyPart = mimeMultipart.getContentID(bodyPart);
                        if (contentIdBodyPart != null) {
                            out.append("- Content-ID: " + contentIdBodyPart + "\n");
                        }
                        if ((contentLocationBodyPart = mimeMultipart.getContentDisposition(bodyPart)) != null) {
                            out.append("- Content-Disposition: " + contentLocationBodyPart + "\n");
                        }
                        if (bodyPart.getContentType() != null) {
                            out.append("- Content-Type: " + bodyPart.getContentType() + "\n");
                        }
                        if (config.isDumpMultipartHeaders() && (en = bodyPart.getAllHeaders()) != null) {
                            while (en.hasMoreElements()) {
                                String[] values;
                                String key;
                                Object keyO = en.nextElement();
                                if (!(keyO instanceof String) || "Content-ID".equalsIgnoreCase(key = (String)keyO) || "Content-Disposition".equalsIgnoreCase(key) || "Content-Type".equalsIgnoreCase(key) || (values = bodyPart.getHeader(key)) == null || values.length <= 0) continue;
                                for (int j = 0; j < values.length; ++j) {
                                    out.append("- " + key + ": " + values[j] + "\n");
                                }
                            }
                        }
                        out.append("\n");
                        if (dumpAllBodyParts) {
                            out.append(DumpRestMessageUtils.dumpBodyPart(msg, bodyPart));
                            continue;
                        }
                        Object o = bodyPart.getDataHandler().getContent();
                        if (o instanceof String) {
                            out.append((String)o);
                            continue;
                        }
                        out.append("Contenuto attachments non \u00e8 visualizzabile, tipo: " + o.getClass().getName());
                    }
                }
            }
            return out.toString();
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dumpBodyPart(OpenSPCoop2RestMessage<?> msg, BodyPart bodyPart) throws MessageException {
        Object o = DumpRestMessageUtils._dumpBodyPart(msg, bodyPart, false);
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream bout = null;
            try {
                bout = (ByteArrayOutputStream)o;
                String string = bout.toString();
                return string;
            }
            finally {
                try {
                    if (bout != null) {
                        bout.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        throw new MessageException("Dump error (return type " + o.getClass().getName() + " unknown)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] dumpBodyPartAsByteArray(OpenSPCoop2RestMessage<?> msg, BodyPart bodyPart) throws MessageException {
        Object o = DumpRestMessageUtils._dumpBodyPart(msg, bodyPart, false);
        if (o instanceof String) {
            return ((String)o).getBytes();
        }
        if (o instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream bout = null;
            try {
                bout = (ByteArrayOutputStream)o;
                byte[] byArray = bout.toByteArray();
                return byArray;
            }
            finally {
                try {
                    if (bout != null) {
                        bout.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        throw new MessageException("Dump error (return type " + o.getClass().getName() + " unknown)");
    }

    public static void setConvert(boolean convert) {
        DumpRestMessageUtils.convert = convert;
    }

    private static Object _dumpBodyPart(OpenSPCoop2RestMessage<?> msg, BodyPart bodyPart, boolean forceReturnAsByteArrayOutputStream) throws MessageException {
        try {
            ByteArrayOutputStream bout = null;
            Object o = bodyPart.getDataHandler().getContent();
            String s = null;
            if (o != null) {
                if (o instanceof byte[]) {
                    byte[] b = (byte[])o;
                    bout = new ByteArrayOutputStream();
                    bout.write(b);
                    bout.flush();
                    bout.close();
                } else if (o instanceof InputStream) {
                    InputStream is = (InputStream)o;
                    bout = new ByteArrayOutputStream();
                    byte[] readB = new byte[8192];
                    int readByte = 0;
                    while ((readByte = is.read(readB)) != -1) {
                        bout.write(readB, 0, readByte);
                    }
                    is.close();
                    bout.flush();
                    bout.close();
                } else if (o instanceof String) {
                    s = (String)o;
                    bout = new ByteArrayOutputStream();
                    bout.write(s.getBytes());
                    bout.flush();
                    bout.close();
                } else {
                    DataHandler dh = bodyPart.getDataHandler();
                    InputStream inputDH = dh.getInputStream();
                    bout = new ByteArrayOutputStream();
                    byte[] readB = new byte[8192];
                    int readByte = 0;
                    while ((readByte = inputDH.read(readB)) != -1) {
                        bout.write(readB, 0, readByte);
                    }
                    inputDH.close();
                    bout.flush();
                    bout.close();
                }
            } else {
                DataHandler dh = bodyPart.getDataHandler();
                InputStream inputDH = dh.getInputStream();
                bout = new ByteArrayOutputStream();
                byte[] readB = new byte[8192];
                int readByte = 0;
                while ((readByte = inputDH.read(readB)) != -1) {
                    bout.write(readB, 0, readByte);
                }
                inputDH.close();
                bout.flush();
                bout.close();
            }
            if (convert && MailcapActivationReader.existsDataContentHandler((String)bodyPart.getContentType()) && bodyPart.getContentType() != null && bodyPart.getContentType().startsWith("text/plain")) {
                DumpRestMessageUtils.processContentTypeTextPlain(s, bodyPart, bout);
            }
            if (s != null) {
                if (forceReturnAsByteArrayOutputStream) {
                    return bout;
                }
                return s;
            }
            return bout;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    private static void processContentTypeTextPlain(String s, BodyPart bodyPart, ByteArrayOutputStream bout) throws Exception {
    }
}

