/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.soap;

import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.context.MessageContext;
import org.openspcoop2.message.context.Soap;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.exception.MessageNotSupportedException;

public class OpenSPCoop2SoapMessageCore {
    public String soapAction;
    public boolean throwExceptionIfFoundMoreSecurityHeader = true;

    public void copyInstanceFieldValueTo(OpenSPCoop2SoapMessageCore core) {
        core.soapAction = this.soapAction;
        core.throwExceptionIfFoundMoreSecurityHeader = this.throwExceptionIfFoundMoreSecurityHeader;
    }

    public MessageContext serializeResourcesTo(MessageContext messageContext) throws MessageException {
        Soap soap = new Soap();
        soap.setSoapAction(this.soapAction);
        messageContext.setSoap(soap);
        return messageContext;
    }

    public void readResourcesFrom(MessageContext messageContext) throws MessageException {
        if (messageContext.getSoap() != null && messageContext.getSoap().getSoapAction() != null) {
            this.soapAction = messageContext.getSoap().getSoapAction();
        }
    }

    public SOAPMessage getSOAPMessage(SOAPMessage soapMessage, MessageType messageType) throws MessageException, MessageNotSupportedException {
        try {
            if (soapMessage != null) {
                soapMessage.setProperty("OP2_MESSAGE_TYPE", (Object)messageType);
                if (MessageType.SOAP_11.equals(messageType)) {
                    MimeHeaders mhs = soapMessage.getMimeHeaders();
                    mhs.removeHeader("SOAPAction");
                    mhs.addHeader("SOAPAction", this.getSoapAction());
                }
            }
            return soapMessage;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public boolean isThrowExceptionIfFoundMoreSecurityHeader() {
        return this.throwExceptionIfFoundMoreSecurityHeader;
    }

    public void setThrowExceptionIfFoundMoreSecurityHeader(boolean throwExceptionIfFoundMoreSecurityHeader) {
        this.throwExceptionIfFoundMoreSecurityHeader = throwExceptionIfFoundMoreSecurityHeader;
    }
}

