/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.utils;

import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.MessageException;

public class MessageUtilities {
    public static String getDefaultContentType(MessageType messageType) {
        String contentType = null;
        switch (messageType) {
            case SOAP_11: {
                contentType = "text/xml";
                break;
            }
            case SOAP_12: {
                contentType = "application/soap+xml";
                break;
            }
            case XML: {
                contentType = "application/xml";
                break;
            }
            case JSON: {
                contentType = "application/json";
                break;
            }
            case BINARY: {
                contentType = "application/octet-stream";
                break;
            }
            case MIME_MULTIPART: {
                contentType = "multipart/form-data";
            }
        }
        return contentType;
    }

    public static void checkType(MessageType messageType, OpenSPCoop2Message msg) throws MessageException {
        switch (messageType) {
            case SOAP_11: {
                msg.castAsSoap();
                break;
            }
            case SOAP_12: {
                msg.castAsSoap();
                break;
            }
            case XML: {
                msg.castAsRestXml();
                break;
            }
            case JSON: {
                msg.castAsRestJson();
                break;
            }
            case BINARY: {
                msg.castAsRestBinary();
                break;
            }
            case MIME_MULTIPART: {
                msg.castAsRestMimeMultipart();
            }
        }
    }

    public static OpenSPCoop2Message buildEmptyMessage(OpenSPCoop2MessageFactory messageFactory, MessageType messageType, MessageRole messageRole) {
        try {
            OpenSPCoop2Message msg = messageFactory.createEmptyMessage(messageType, messageRole);
            return msg;
        }
        catch (Exception e) {
            return null;
        }
    }
}

