/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPFault;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.soap.SOAPFaultCode;
import org.openspcoop2.utils.CopyStream;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.id.UUIDUtilsGenerator;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.mime.MimeTypes;
import org.openspcoop2.utils.mime.MultipartUtils;
import org.openspcoop2.utils.random.RandomUtilities;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.rest.problem.JsonSerializer;
import org.openspcoop2.utils.rest.problem.ProblemRFC7807;
import org.openspcoop2.utils.rest.problem.XmlSerializer;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.transport.http.HttpServletTransportRequestContext;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.slf4j.Logger;
import org.springframework.web.util.UriUtils;

public class ServletTestService
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected Logger log = null;
    protected int thresholdRequestDump = -1;
    protected File repositoryRequestDump = null;
    protected File repositoryResponseFiles = null;
    protected List<String> whitePropertiesList = null;
    protected boolean genericError = false;

    public ServletTestService(Logger log, int thresholdRequestDump, File repositoryRequestDump, File repositoryResponseFiles, List<String> whitePropertiesList, boolean genericError) {
        this.log = log;
        this.thresholdRequestDump = thresholdRequestDump;
        this.repositoryRequestDump = repositoryRequestDump;
        this.repositoryResponseFiles = repositoryResponseFiles;
        this.whitePropertiesList = whitePropertiesList;
        this.genericError = genericError;
    }

    public ServletTestService(Logger log, int thresholdRequestDump, File repositoryRequestDump, File repositoryResponseFiles, boolean genericError) {
        this(log, thresholdRequestDump, repositoryRequestDump, repositoryResponseFiles, null, genericError);
    }

    public ServletTestService(Logger log, int thresholdRequestDump, File repositoryRequestDump, File repositoryResponseFiles) {
        this(log, thresholdRequestDump, repositoryRequestDump, repositoryResponseFiles, null, false);
    }

    public ServletTestService(Logger log, int thresholdRequestDump, File repositoryRequestDump) {
        this(log, thresholdRequestDump, repositoryRequestDump, null, null, false);
    }

    private static String getParameterCheckWhiteList(HttpServletRequest request, List<String> whitePropertiesList, String parameter) {
        String value = request.getParameter(parameter);
        if (value != null) {
            value = value.trim();
            value = UriUtils.decode((String)value, (String)Charset.UTF_8.getValue());
        }
        if (whitePropertiesList != null && !whitePropertiesList.contains(parameter)) {
            return null;
        }
        return value;
    }

    private static List<String> getParametersCheckWhiteList(HttpServletRequest request, List<String> whitePropertiesList, String parameter) {
        List<String> lnull = null;
        ArrayList<String> l = new ArrayList<String>();
        String[] values = request.getParameterValues(parameter);
        if (values != null && values.length > 0) {
            if (whitePropertiesList != null && !whitePropertiesList.contains(parameter)) {
                return lnull;
            }
            for (String value : values) {
                value = value.trim();
                value = UriUtils.decode((String)value, (String)Charset.UTF_8.getValue());
                l.add(value);
            }
        }
        return l;
    }

    public static void checkHttpServletRequestParameter(HttpServletRequest request) throws ServletException {
        ServletTestService.checkHttpServletRequestParameter(request, null);
    }

    private static void checkHttpServletRequestParameter(HttpServletRequest request, List<String> whitePropertiesList) throws ServletException {
        String checkCORS;
        String checkEqualsCookie;
        String checkEqualsQueryParameter;
        String checkEqualsHttpHeader;
        String v;
        String notExistsCookies;
        String v2;
        String existsCookies;
        String notExistsQueryParameters;
        String existsQueryParameters;
        String notExistsHttpHeaders;
        String checkEqualsHttpMethod = ServletTestService.getParameterCheckWhiteList(request, whitePropertiesList, "checkEqualsHttpMethod");
        if (checkEqualsHttpMethod != null && !(checkEqualsHttpMethod = checkEqualsHttpMethod.trim()).equals(request.getMethod())) {
            throw new ServletException("Ricevuta una richiesta con metodo http [" + request.getMethod() + "] differente da quella attesa [" + checkEqualsHttpMethod + "]");
        }
        String existsHttpHeaders = ServletTestService.getParameterCheckWhiteList(request, whitePropertiesList, "existsHttpHeaders");
        if (existsHttpHeaders != null) {
            if (!(existsHttpHeaders = existsHttpHeaders.trim()).contains(",")) {
                List v3 = TransportUtils.getHeaderValues((HttpServletRequest)request, (String)existsHttpHeaders);
                if (v3 == null || v3.isEmpty()) {
                    throw new ServletException("Ricevuta una richiesta di verifica esistenza header (" + existsHttpHeaders + "). Header non presente");
                }
            } else {
                String[] split = existsHttpHeaders.split(",");
                if (split == null) {
                    throw new ServletException("Ricevuta una richiesta di verifica esistenza header non conforme (split null)");
                }
                for (String header : split) {
                    List v4 = TransportUtils.getHeaderValues((HttpServletRequest)request, (String)header);
                    if (v4 != null) continue;
                    throw new ServletException("Ricevuta una richiesta di verifica esistenza header (" + header + "). Header non presente");
                }
            }
        }
        if ((notExistsHttpHeaders = ServletTestService.getParameterCheckWhiteList(request, whitePropertiesList, "notExistsHttpHeaders")) != null) {
            if (!(notExistsHttpHeaders = notExistsHttpHeaders.trim()).contains(",")) {
                List v5 = TransportUtils.getHeaderValues((HttpServletRequest)request, (String)notExistsHttpHeaders);
                if (v5 != null && !v5.isEmpty()) {
                    throw new ServletException("Ricevuta una richiesta di verifica non esistenza header (" + notExistsHttpHeaders + "). Header presente");
                }
            } else {
                String[] split = notExistsHttpHeaders.split(",");
                if (split == null) {
                    throw new ServletException("Ricevuta una richiesta di verifica non esistenza header non conforme (split null)");
                }
                for (String header : split) {
                    List v6 = TransportUtils.getHeaderValues((HttpServletRequest)request, (String)header);
                    if (v6 == null || v6.isEmpty()) continue;
                    throw new ServletException("Ricevuta una richiesta di verifica non esistenza header (" + header + "). Header presente");
                }
            }
        }
        if ((existsQueryParameters = ServletTestService.getParameterCheckWhiteList(request, whitePropertiesList, "existsQueryParameters")) != null) {
            if (!(existsQueryParameters = existsQueryParameters.trim()).contains(",")) {
                List v7 = TransportUtils.getParameterValues((HttpServletRequest)request, (String)existsQueryParameters);
                if (v7 == null || v7.isEmpty()) {
                    throw new ServletException("Ricevuta una richiesta di verifica esistenza query parameter (" + existsQueryParameters + "). Parametro non presente");
                }
            } else {
                String[] split = existsQueryParameters.split(",");
                if (split == null) {
                    throw new ServletException("Ricevuta una richiesta di verifica esistenza query parameter non conforme (split null)");
                }
                for (String header : split) {
                    List v8 = TransportUtils.getParameterValues((HttpServletRequest)request, (String)header);
                    if (v8 != null && !v8.isEmpty()) continue;
                    throw new ServletException("Ricevuta una richiesta di verifica esistenza query parameter (" + header + "). Parametro non presente");
                }
            }
        }
        if ((notExistsQueryParameters = ServletTestService.getParameterCheckWhiteList(request, whitePropertiesList, "notExistsQueryParameters")) != null) {
            if (!(notExistsQueryParameters = notExistsQueryParameters.trim()).contains(",")) {
                List v9 = TransportUtils.getParameterValues((HttpServletRequest)request, (String)notExistsQueryParameters);
                if (v9 != null && !v9.isEmpty()) {
                    throw new ServletException("Ricevuta una richiesta di verifica non esistenza query parameter (" + notExistsQueryParameters + "). Parametro presente");
                }
            } else {
                String[] split = notExistsQueryParameters.split(",");
                if (split == null) {
                    throw new ServletException("Ricevuta una richiesta di verifica non esistenza query parameter non conforme (split null)");
                }
                for (String header : split) {
                    List v10 = TransportUtils.getParameterValues((HttpServletRequest)request, (String)header);
                    if (v10 == null || v10.isEmpty()) continue;
                    throw new ServletException("Ricevuta una richiesta di verifica non esistenza query parameter (" + header + "). Parametro presente");
                }
            }
        }
        if ((existsCookies = ServletTestService.getParameterCheckWhiteList(request, whitePropertiesList, "existsCookies")) != null) {
            if (!(existsCookies = existsCookies.trim()).contains(",")) {
                String v11 = TransportUtils.getCookie((HttpServletRequest)request, (String)existsCookies);
                if (v11 == null) {
                    throw new ServletException("Ricevuta una richiesta di verifica esistenza cookie (" + existsCookies + "). Cookie non presente");
                }
            } else {
                String[] split = existsCookies.split(",");
                if (split == null) {
                    throw new ServletException("Ricevuta una richiesta di verifica esistenza cookie non conforme (split null)");
                }
                for (String cookie : split) {
                    v2 = TransportUtils.getCookie((HttpServletRequest)request, (String)cookie);
                    if (v2 != null) continue;
                    throw new ServletException("Ricevuta una richiesta di verifica esistenza cookie (" + cookie + "). Cookie non presente");
                }
            }
        }
        if ((notExistsCookies = ServletTestService.getParameterCheckWhiteList(request, whitePropertiesList, "notExistsCookies")) != null) {
            if (!(notExistsCookies = notExistsCookies.trim()).contains(",")) {
                String v12 = TransportUtils.getCookie((HttpServletRequest)request, (String)notExistsCookies);
                if (v12 != null) {
                    throw new ServletException("Ricevuta una richiesta di verifica non esistenza cookie (" + notExistsCookies + "). Cookie presente");
                }
            } else {
                String[] split = notExistsCookies.split(",");
                if (split == null) {
                    throw new ServletException("Ricevuta una richiesta di verifica non esistenza cookie non conforme (split null)");
                }
                for (String header : split) {
                    v = TransportUtils.getCookie((HttpServletRequest)request, (String)header);
                    if (v == null) continue;
                    throw new ServletException("Ricevuta una richiesta di verifica non esistenza cookie (" + header + "). Cookie presente");
                }
            }
        }
        if ((checkEqualsHttpHeader = ServletTestService.getParameterCheckWhiteList(request, whitePropertiesList, "checkEqualsHttpHeader")) != null) {
            if (!(checkEqualsHttpHeader = checkEqualsHttpHeader.trim()).contains(":")) {
                throw new ServletException("Ricevuta una richiesta di verifica header non conforme (pattern nome:valore)");
            }
            String[] split = checkEqualsHttpHeader.split(":");
            if (split == null) {
                throw new ServletException("Ricevuta una richiesta di verifica header non conforme (pattern nome:valore) (split null)");
            }
            if (split.length < 2) {
                throw new ServletException("Ricevuta una richiesta di verifica header non conforme (pattern nome:valore) (split:" + split.length + ")");
            }
            String key = split[0];
            Object valore = null;
            for (int j = 1; j < split.length; ++j) {
                valore = j == 1 ? split[1] : (String)valore + ":" + split[j];
            }
            v2 = TransportUtils.getHeaderFirstValue((HttpServletRequest)request, (String)key);
            if (v2 == null) {
                if (!"header-non-atteso".equals(valore)) {
                    throw new ServletException("Ricevuta una richiesta di verifica header (" + key + ":" + (String)valore + "). Header [" + key + "] non presente");
                }
            } else {
                if ("header-non-atteso".equals(valore)) {
                    throw new ServletException("Ricevuta una richiesta di verifica header (" + key + ":" + (String)valore + "). L'header risulta presente e valorizzato con [" + v2 + "]");
                }
                if (!v2.equals(valore)) {
                    throw new ServletException("Ricevuta una richiesta di verifica header (" + key + ":" + (String)valore + "). Valore [" + v2 + "] differente da quello atteso '" + (String)valore + "'");
                }
            }
        }
        if ((checkEqualsQueryParameter = ServletTestService.getParameterCheckWhiteList(request, whitePropertiesList, "checkEqualsQueryParameter")) != null) {
            if (!(checkEqualsQueryParameter = checkEqualsQueryParameter.trim()).contains(":")) {
                throw new ServletException("Ricevuta una richiesta di verifica query parameter non conforme (pattern nome:valore)");
            }
            String[] split = checkEqualsQueryParameter.split(":");
            if (split == null) {
                throw new ServletException("Ricevuta una richiesta di verifica query parameter non conforme (pattern nome:valore) (split null)");
            }
            if (split.length < 2) {
                throw new ServletException("Ricevuta una richiesta di verifica query parameter non conforme (pattern nome:valore) (split:" + split.length + ")");
            }
            String key = split[0];
            Object valore = null;
            for (int j = 1; j < split.length; ++j) {
                valore = j == 1 ? split[1] : (String)valore + ":" + split[j];
            }
            v = TransportUtils.getParameterFirstValue((HttpServletRequest)request, (String)key);
            if (v == null) {
                if (!"param-non-atteso".equals(valore)) {
                    throw new ServletException("Ricevuta una richiesta di verifica query parameter (" + key + ":" + (String)valore + "). Parametro [" + key + "] non presente");
                }
            } else {
                if ("param-non-atteso".equals(valore)) {
                    throw new ServletException("Ricevuta una richiesta di verifica query parameter (" + key + ":" + (String)valore + "). Il parametro risulta presente e valorizzato con [" + v + "]");
                }
                if (!v.equals(valore)) {
                    throw new ServletException("Ricevuta una richiesta di verifica query parameter (" + key + ":" + (String)valore + "). Valore [" + v + "] differente da quello atteso '" + (String)valore + "'");
                }
            }
        }
        if ((checkEqualsCookie = ServletTestService.getParameterCheckWhiteList(request, whitePropertiesList, "checkEqualsCookie")) != null) {
            if (!(checkEqualsCookie = checkEqualsCookie.trim()).contains(":")) {
                throw new ServletException("Ricevuta una richiesta di verifica cookie non conforme (pattern nome:valore)");
            }
            String[] split = checkEqualsCookie.split(":");
            if (split == null) {
                throw new ServletException("Ricevuta una richiesta di verifica cookie non conforme (pattern nome:valore) (split null)");
            }
            if (split.length < 2) {
                throw new ServletException("Ricevuta una richiesta di verifica cookie non conforme (pattern nome:valore) (split:" + split.length + ")");
            }
            String key = split[0];
            Object valore = null;
            for (int j = 1; j < split.length; ++j) {
                valore = j == 1 ? split[1] : (String)valore + ":" + split[j];
            }
            String v13 = TransportUtils.getCookie((HttpServletRequest)request, (String)key);
            if (v13 == null) {
                throw new ServletException("Ricevuta una richiesta di verifica cookie (" + key + ":" + (String)valore + "). Cookie [" + key + "] non presente");
            }
            if (!v13.equals(valore)) {
                throw new ServletException("Ricevuta una richiesta di verifica cookie (" + key + ":" + (String)valore + "). Valore [" + v13 + "] differente da quello atteso '" + (String)valore + "'");
            }
        }
        if ((checkCORS = ServletTestService.getParameterCheckWhiteList(request, whitePropertiesList, "CORS")) != null && "true".equalsIgnoreCase(checkCORS = checkCORS.trim())) {
            boolean preflight = HttpRequestMethod.OPTIONS.equals(request.getMethod());
            String origin = TransportUtils.getHeaderFirstValue((HttpServletRequest)request, (String)"Origin");
            if (origin == null || "".equals(origin)) {
                throw new ServletException("Ricevuta una richiesta di verifica header (Origin). Header non presente");
            }
            if (preflight) {
                String method = TransportUtils.getHeaderFirstValue((HttpServletRequest)request, (String)"Access-Control-Request-Method");
                if (method == null || "".equals(method)) {
                    throw new ServletException("Ricevuta una richiesta di verifica header (Access-Control-Request-Method). Header non presente");
                }
                String header = TransportUtils.getHeaderFirstValue((HttpServletRequest)request, (String)"Access-Control-Request-Headers");
                if (header == null || "".equals(header)) {
                    throw new ServletException("Ricevuta una richiesta di verifica header (Access-Control-Request-Headers). Header non presente");
                }
            }
        }
    }

    private static void systemOut(String msg) {
        System.out.println(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEngine(HttpServletRequest req, HttpServletResponse res, boolean oneway, Properties headerRisposta) throws ServletException, IOException {
        block277: {
            DumpByteArrayOutputStream dumpByteArrayOutputStreamRichiesta = null;
            try {
                String sleep;
                ByteArrayOutputStream outStr;
                ServletInputStream sin;
                String saveMessageDir;
                String[] tmp;
                String replyQueryParameterAsHeaderString;
                String[] tmp2;
                String replyHeaderString;
                String checkCORS;
                String tunnelSoapMimeType;
                Enumeration en;
                boolean bl;
                String setCookie;
                Cookie[] cookies;
                HttpServletTransportRequestContext rc;
                ServletTestService.checkHttpServletRequestParameter(req, this.whitePropertiesList);
                String basicUsername = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "basicUsername");
                String basicPassword = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "basicPassword");
                String basicWWWAuthenticateDomain = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "basicDomain");
                if (!(basicUsername == null || basicPassword == null || (rc = new HttpServletTransportRequestContext(req, this.log)).getCredential() != null && basicUsername.equals(rc.getCredential().getUsername()) && basicPassword.equals(rc.getCredential().getPassword()))) {
                    String msgError = "TestService: credenziali fornite errate user[" + rc.getCredential().getUsername() + "]passw[" + rc.getCredential().getPassword() + "], attese user[" + basicUsername + "]passw[" + basicPassword + "]";
                    if (this.log != null) {
                        this.log.error(msgError);
                    } else {
                        ServletTestService.systemOut("ERRORE TestService: " + msgError);
                    }
                    if (basicWWWAuthenticateDomain != null) {
                        res.setHeader("WWW-Authenticate", "Basic realm=\"\"" + basicWWWAuthenticateDomain + "\"");
                    }
                    res.setStatus(401);
                    res.getOutputStream().flush();
                    res.getOutputStream().close();
                    return;
                }
                String cookie = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "cookie");
                boolean foundCookie = false;
                if (cookie != null && (cookies = req.getCookies()) != null && cookies.length > 0) {
                    for (int i = 0; i < cookies.length; ++i) {
                        if (!cookie.equals(cookies[i].getName())) continue;
                        ServletTestService.systemOut("name: " + cookies[i].getName());
                        ServletTestService.systemOut("path: " + cookies[i].getPath());
                        ServletTestService.systemOut("domain: " + cookies[i].getDomain());
                        ServletTestService.systemOut("comment: " + cookies[i].getComment());
                        ServletTestService.systemOut("maxAge: " + cookies[i].getMaxAge());
                        ServletTestService.systemOut("secure: " + cookies[i].getSecure());
                        ServletTestService.systemOut("value: " + cookies[i].getValue());
                        ServletTestService.systemOut("version: " + cookies[i].getVersion());
                        foundCookie = true;
                        break;
                    }
                }
                if (cookie != null && !foundCookie) {
                    Cookie newCookie = new Cookie(cookie, UUIDUtilsGenerator.newUUID());
                    newCookie.setMaxAge(300);
                    res.addCookie(newCookie);
                }
                if ((setCookie = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "setCookie")) != null) {
                    setCookie = setCookie.trim();
                    ArrayList<String> hdr = new ArrayList<String>();
                    if (!setCookie.contains(",")) {
                        hdr.add(setCookie);
                    } else {
                        String[] split = setCookie.split(",");
                        if (split == null) {
                            throw new ServletException("Ricevuta una richiesta di set cookie non conforme (split null)");
                        }
                        for (String string : split) {
                            hdr.add(string.trim());
                        }
                    }
                    if (!hdr.isEmpty()) {
                        for (String h : hdr) {
                            String value = TransportUtils.getHeaderFirstValue((HttpServletRequest)req, (String)h);
                            if (value == null || "".equals(value)) {
                                throw new ServletException("Ricevuta una richiesta di set cookie il cui valore \u00e8 da prendere da un header http non esistente: '" + h + "'");
                            }
                            List<HttpCookie> l = HttpCookie.parse(value);
                            for (HttpCookie httpCookie : l) {
                                Cookie newCookie = new Cookie(httpCookie.getName(), httpCookie.getValue());
                                if (httpCookie.getComment() != null) {
                                    newCookie.setComment(httpCookie.getComment());
                                }
                                if (httpCookie.getDomain() != null) {
                                    newCookie.setDomain(httpCookie.getDomain());
                                }
                                newCookie.setHttpOnly(httpCookie.isHttpOnly());
                                newCookie.setMaxAge((int)httpCookie.getMaxAge());
                                if (httpCookie.getPath() != null) {
                                    newCookie.setPath(httpCookie.getPath());
                                }
                                newCookie.setSecure(httpCookie.getSecure());
                                newCookie.setVersion(httpCookie.getVersion());
                                res.addCookie(newCookie);
                            }
                        }
                    }
                }
                boolean chunked = false;
                String chunkedValue = null;
                if (req.getHeader("Transfer-Encoding") != null) {
                    chunkedValue = req.getHeader("Transfer-Encoding");
                } else if (req.getHeader("transfer-encoding") != null) {
                    chunkedValue = req.getHeader("transfer-encoding");
                }
                if (chunkedValue != null && "chunked".equals(chunkedValue = chunkedValue.trim())) {
                    chunked = true;
                }
                String forceContentLengthOption = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "forceContentLength");
                boolean forceContentLength = false;
                if (forceContentLengthOption != null && "true".equals(forceContentLengthOption = forceContentLengthOption.trim())) {
                    forceContentLength = true;
                }
                String redirectOptions = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "redirect");
                boolean bl2 = false;
                if (redirectOptions != null && "true".equals(redirectOptions = redirectOptions.trim())) {
                    bl = true;
                }
                if (bl) {
                    String headerLocationName;
                    HashMap p = new HashMap();
                    Integer returnCode = 307;
                    String returnCodeOpt = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "redirectReturnCode");
                    if (returnCodeOpt != null) {
                        returnCode = Integer.parseInt(returnCodeOpt.trim());
                        TransportUtils.addParameter(p, (String)"redirectReturnCode", (String)("" + returnCode));
                    }
                    String protocol = "http";
                    String protocolOpt = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "redirectProtocol");
                    if (protocolOpt != null) {
                        protocol = protocolOpt.trim();
                        TransportUtils.addParameter(p, (String)"redirectProtocol", (String)protocol);
                    }
                    String host = "localhost";
                    String hostOpt = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "redirectHost");
                    if (hostOpt != null) {
                        host = hostOpt.trim();
                        TransportUtils.addParameter(p, (String)"redirectHost", (String)host);
                    }
                    String port = "8080";
                    String portOpt = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "redirectPort");
                    if (portOpt != null) {
                        port = portOpt.trim();
                        TransportUtils.addParameter(p, (String)"redirectPort", (String)port);
                    }
                    Object contesto = req.getRequestURI();
                    String contestoOpt = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "redirectContext");
                    if (contestoOpt != null) {
                        contesto = contestoOpt.trim();
                        if (!((String)contesto).startsWith("/")) {
                            contesto = "/" + (String)contesto;
                        }
                        TransportUtils.addParameter(p, (String)"redirectContext", (String)contesto);
                    }
                    Integer maxHop = 1;
                    String maxOpt = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "redirectMaxHop");
                    if (maxOpt != null) {
                        maxHop = Integer.parseInt(maxOpt.trim());
                        TransportUtils.addParameter(p, (String)"redirectMaxHop", (String)("" + maxHop));
                    }
                    Integer hop = 1;
                    String hopOpt = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "redirectHop");
                    if (hopOpt != null) {
                        hop = Integer.parseInt(hopOpt.trim());
                        TransportUtils.addParameter(p, (String)"redirectHop", (String)("" + hop));
                    }
                    boolean absoluteUrl = true;
                    String absoluteUrlParam = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "redirectAbsoluteUrl");
                    if (absoluteUrlParam != null) {
                        absoluteUrl = Boolean.parseBoolean(absoluteUrlParam.trim());
                        TransportUtils.addParameter(p, (String)"redirectAbsoluteUrl", (String)absoluteUrlParam);
                    }
                    headerLocationName = (headerLocationName = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "redirectHeaderLocation")) != null ? headerLocationName.trim() : "Location";
                    if (hop < maxHop) {
                        p.remove("redirectHop");
                        TransportUtils.addParameter(p, (String)"redirectHop", (String)("" + (hop + 1)));
                        TransportUtils.addParameter(p, (String)"redirect", (String)"true");
                    } else {
                        p.clear();
                    }
                    Object redirectUrl = protocol + "://" + host + ":" + port + (String)contesto;
                    if (!absoluteUrl) {
                        redirectUrl = contesto;
                    }
                    redirectUrl = TransportUtils.buildUrlWithParameters(p, (String)redirectUrl, (Logger)this.log);
                    res.setHeader(headerLocationName, (String)redirectUrl);
                    res.setStatus(returnCode.intValue());
                    return;
                }
                String fault = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "fault");
                String faultActor = "OpenSPCoopTrace";
                String faultSoapVersion = null;
                String faultNamespaceCode = "http://www.openspcoop2.org/example";
                String faultCode = "Server.OpenSPCoopExampleFault";
                String faultMessage = "Fault ritornato dalla servlet di trace, esempio di OpenSPCoop";
                if (fault != null && fault.equalsIgnoreCase("true")) {
                    if (ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "faultActor") != null) {
                        faultActor = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "faultActor");
                    }
                    if (ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "faultSoapVersion") != null) {
                        faultSoapVersion = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "faultSoapVersion");
                    }
                    if (ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "faultCode") != null) {
                        faultCode = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "faultCode");
                    }
                    if (ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "faultNamespaceCode") != null) {
                        faultNamespaceCode = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "faultNamespaceCode");
                    }
                    if (ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "faultMessage") != null) {
                        faultMessage = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "faultMessage");
                    }
                }
                String problem = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "problem");
                byte[] problemDetailSerialization = null;
                String problemDetailContentType = null;
                int problemDetailStatus = -1;
                if (problem != null && problem.equalsIgnoreCase("true")) {
                    ProblemRFC7807 problemRFC7807 = new ProblemRFC7807();
                    int status = 500;
                    String problemStatus = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "problemStatus");
                    if (problemStatus != null) {
                        status = Integer.valueOf(problemStatus);
                        problemRFC7807.setStatus(Integer.valueOf(status));
                    }
                    problemDetailStatus = status;
                    String title = HttpUtilities.getHttpReason((int)status);
                    String problemTitle = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "problemTitle");
                    if (problemTitle != null) {
                        title = problemTitle;
                    }
                    problemRFC7807.setTitle(title);
                    String type = String.format("https://httpstatuses.com/%d", status);
                    String problemType = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "problemType");
                    if (problemType != null) {
                        type = problemType;
                    }
                    problemRFC7807.setType(type);
                    String detail = "Problem ritornato dalla servlet di trace, esempio di OpenSPCoop";
                    String problemDetail = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "problemDetail");
                    if (problemDetail != null) {
                        detail = problemDetail;
                    }
                    problemRFC7807.setDetail(detail);
                    String serializationType = "json";
                    String problemSerializationType = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "problemSerializationType");
                    if (problemSerializationType != null) {
                        serializationType = problemSerializationType;
                    }
                    if ("xml".equalsIgnoreCase(serializationType)) {
                        XmlSerializer xmlSerializer = new XmlSerializer();
                        problemDetailSerialization = xmlSerializer.toByteArray(problemRFC7807, true);
                        problemDetailContentType = "application/problem+xml";
                    } else {
                        JsonSerializer jsonSerializer = new JsonSerializer();
                        problemDetailSerialization = jsonSerializer.toByteArray(problemRFC7807);
                        problemDetailContentType = "application/problem+json";
                    }
                }
                boolean echoFormUrlEncoded = false;
                StringBuilder sbEchoFormUrlEncoded = new StringBuilder();
                String contentTypeEchoFormUrlEncoded = null;
                String formUrlencoded = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "replyFormUrlEncoded");
                if (formUrlencoded != null && formUrlencoded.equalsIgnoreCase("true") && req.getContentType() != null && ContentTypeUtilities.isMatch((Logger)this.log, (String)"application/x-www-form-urlencoded", (String)req.getContentType()) && (en = req.getParameterNames()) != null) {
                    String tmp3 = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "replyFormUrlEncodedPrefix");
                    String prefix = null;
                    if (tmp3 != null && !"".equals(tmp3)) {
                        prefix = tmp3;
                    }
                    String wrapKep = "";
                    tmp3 = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "replyFormUrlEncodedWrapKey");
                    if (tmp3 != null && !"".equals(tmp3)) {
                        wrapKep = tmp3;
                    }
                    String wrapValue = "";
                    tmp3 = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "replyFormUrlEncodedWrapValue");
                    if (tmp3 != null && !"".equals(tmp3)) {
                        wrapValue = tmp3;
                    }
                    String separatorKeyValue = "=";
                    tmp3 = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "replyFormUrlEncodedSeparatorKeyValue");
                    if (tmp3 != null && !"".equals(tmp3)) {
                        separatorKeyValue = tmp3;
                    }
                    String separator = "&";
                    tmp3 = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "replyFormUrlEncodedSeparator");
                    if (tmp3 != null && !"".equals(tmp3)) {
                        separator = tmp3;
                    }
                    while (en.hasMoreElements()) {
                        String value;
                        String key = (String)en.nextElement();
                        if (key == null || key.startsWith("replyFormUrlEncoded") || "true".equals(tmp3 = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "replyFormUrlEncoded_ignoreParam_" + key)) || (value = req.getParameter(key)) == null) continue;
                        tmp3 = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "replyFormUrlEncoded_renameParam_" + key);
                        if (tmp3 != null && !"".equals(tmp3)) {
                            key = tmp3;
                        }
                        if (sbEchoFormUrlEncoded.length() > 0) {
                            sbEchoFormUrlEncoded.append(separator);
                        } else if (prefix != null) {
                            sbEchoFormUrlEncoded.append(prefix);
                        }
                        sbEchoFormUrlEncoded.append(wrapKep);
                        sbEchoFormUrlEncoded.append(key);
                        sbEchoFormUrlEncoded.append(wrapKep);
                        sbEchoFormUrlEncoded.append(separatorKeyValue);
                        sbEchoFormUrlEncoded.append(wrapValue);
                        sbEchoFormUrlEncoded.append(value);
                        sbEchoFormUrlEncoded.append(wrapValue);
                    }
                    tmp3 = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "replyFormUrlEncodedSuffix");
                    if (tmp3 != null && !"".equals(tmp3)) {
                        sbEchoFormUrlEncoded.append(tmp3);
                    }
                    boolean bl3 = echoFormUrlEncoded = sbEchoFormUrlEncoded.length() > 0;
                    if (echoFormUrlEncoded) {
                        contentTypeEchoFormUrlEncoded = req.getContentType();
                        tmp3 = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "replyFormUrlEncodedContentType");
                        if (tmp3 != null && !"".equals(tmp3)) {
                            contentTypeEchoFormUrlEncoded = tmp3;
                        }
                    }
                }
                String tunnelSoap = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "govway_soap_tunnel");
                boolean tunnel = false;
                if (tunnelSoap != null && "true".equals(tunnelSoap = tunnelSoap.trim())) {
                    tunnel = true;
                }
                if ((tunnelSoapMimeType = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "govway_soap_tunnel_mime")) != null) {
                    tunnelSoapMimeType = tunnelSoapMimeType.trim();
                }
                int returnCode = 200;
                String returnCodeString = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "returnCode");
                if (returnCodeString != null) {
                    try {
                        returnCode = Integer.parseInt(returnCodeString.trim());
                    }
                    catch (Exception e) {
                        if (this.log != null) {
                            String warn = "ERRORE TestService (param returnCode): " + e.toString();
                            this.log.warn(warn);
                        }
                        ServletTestService.systemOut("ERRORE TestService (param returnCode): " + e.toString());
                    }
                }
                String replace = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "replace");
                HashMap<String, String> replaceMap = new HashMap<String, String>();
                if (replace != null) {
                    if (replace.contains(",")) {
                        String[] list = replace.split(",");
                        for (int i = 0; i < list.length; ++i) {
                            String[] tmp4;
                            if (list[i].contains(":")) {
                                tmp4 = list[i].split(":");
                                if (tmp4 == null || tmp4.length != 2) {
                                    throw new MessageException("Opzione replace con valore errato [" + list[i] + "] (caso1 iter" + i + "), formato atteso: old:new[,old:new,....,old:new]");
                                }
                            } else {
                                throw new MessageException("Opzione replace con valore errato [" + list[i] + "] (caso2 iter" + i + "), formato atteso: old:new[,old:new,....,old:new]");
                            }
                            replaceMap.put(tmp4[0], tmp4[1]);
                        }
                    } else if (replace.contains(":")) {
                        String[] tmp5 = replace.split(":");
                        if (tmp5 == null || tmp5.length != 2) {
                            throw new MessageException("Opzione replace con valore errato [" + replace + "] (caso1), formato atteso: old:new[,old:new,....,old:new]");
                        }
                        replaceMap.put(tmp5[0], tmp5[1]);
                    } else {
                        throw new MessageException("Opzione replace con valore errato [" + replace + "] (caso2), formato atteso: old:new[,old:new,....,old:new]");
                    }
                }
                HashMap<CallSite, List> headers = new HashMap<CallSite, List>();
                List<String> returnHeadersString = ServletTestService.getParametersCheckWhiteList(req, this.whitePropertiesList, "returnHttpHeader");
                if (returnHeadersString != null && !returnHeadersString.isEmpty()) {
                    for (String returnHeaderString : returnHeadersString) {
                        boolean b;
                        if (!(returnHeaderString = returnHeaderString.trim()).contains(":")) {
                            throw new ServletException("Ricevuta una richiesta di generazione header di risposta non conforme (pattern nome:valore)");
                        }
                        String[] split = returnHeaderString.split(":");
                        if (split == null) {
                            throw new ServletException("Ricevuta una richiesta di generazione header di risposta non conforme (pattern nome:valore) (split null)");
                        }
                        if (split.length < 2) {
                            throw new ServletException("Ricevuta una richiesta di generazione header di risposta non conforme (pattern nome:valore) (split:" + split.length + ")");
                        }
                        String returnHeaderKey = null;
                        Object returnHeaderValue = null;
                        returnHeaderKey = split[0];
                        for (int j = 1; j < split.length; ++j) {
                            returnHeaderValue = j == 1 ? split[1] : (String)returnHeaderValue + ":" + split[j];
                        }
                        boolean checkMultiValue = true;
                        String returnHttpHeaderSingleValue = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "returnHttpHeaderSingleValue");
                        if (returnHttpHeaderSingleValue != null && (b = Boolean.valueOf(returnHttpHeaderSingleValue).booleanValue())) {
                            checkMultiValue = false;
                        }
                        if (checkMultiValue) {
                            if (!((String)returnHeaderValue).contains(",")) {
                                TransportUtils.addHeader(headers, (String)returnHeaderKey, (String)returnHeaderValue);
                                continue;
                            }
                            String[] splitMultiHeaders = ((String)returnHeaderValue).split(",");
                            if (splitMultiHeaders == null || splitMultiHeaders.length <= 0) continue;
                            String[] stringArray = splitMultiHeaders;
                            int n = stringArray.length;
                            for (int i = 0; i < n; ++i) {
                                String hdrValue = stringArray[i];
                                TransportUtils.addHeader(headers, (String)returnHeaderKey, (String)hdrValue);
                            }
                            continue;
                        }
                        TransportUtils.addHeader(headers, (String)returnHeaderKey, (String)returnHeaderValue);
                    }
                }
                if ((checkCORS = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "CORS")) != null && "true".equalsIgnoreCase(checkCORS = checkCORS.trim())) {
                    boolean preflight = HttpRequestMethod.OPTIONS.equals(req.getMethod());
                    String origin = TransportUtils.getHeaderFirstValue((HttpServletRequest)req, (String)"Origin");
                    TransportUtils.addHeader(headers, (String)"Access-Control-Allow-Origin", (String)origin);
                    if (preflight) {
                        String method = TransportUtils.getHeaderFirstValue((HttpServletRequest)req, (String)"Access-Control-Request-Method");
                        TransportUtils.addHeader(headers, (String)"Access-Control-Allow-Methods", (String)method);
                        String header = TransportUtils.getHeaderFirstValue((HttpServletRequest)req, (String)"Access-Control-Request-Headers");
                        TransportUtils.addHeader(headers, (String)"Access-Control-Allow-Headers", (String)header);
                    }
                }
                if ((replyHeaderString = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "replyHttpHeader")) != null && !"".equals(replyHeaderString) && (tmp2 = replyHeaderString.split(",")) != null && tmp2.length > 0) {
                    String replyPrefix = "";
                    String replyPrefixHeaderString = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "replyPrefixHttpHeader");
                    if (replyPrefixHeaderString != null && !"".equals(replyPrefixHeaderString)) {
                        replyPrefix = replyPrefixHeaderString;
                    }
                    boolean base64Reply = false;
                    String[] replyBase64HeaderString = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "replyHttpHeaderBase64Encoded");
                    if (replyBase64HeaderString != null && "true".equals(replyBase64HeaderString)) {
                        base64Reply = true;
                    }
                    for (String hdrName : tmp2) {
                        List reqHdr = TransportUtils.getHeaderValues((HttpServletRequest)req, (String)hdrName);
                        if (reqHdr == null || reqHdr.isEmpty()) continue;
                        if (base64Reply) {
                            ArrayList<String> l = new ArrayList<String>();
                            for (String r : reqHdr) {
                                l.add(Base64Utilities.encodeAsString((byte[])r.getBytes()));
                            }
                            headers.put((CallSite)((Object)(replyPrefix + hdrName)), l);
                            continue;
                        }
                        headers.put((CallSite)((Object)(replyPrefix + hdrName)), reqHdr);
                    }
                }
                if ((replyQueryParameterAsHeaderString = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "replyQueryParameter")) != null && !"".equals(replyQueryParameterAsHeaderString) && (tmp = replyQueryParameterAsHeaderString.split(",")) != null && tmp.length > 0) {
                    String replyPrefix = "";
                    String replyPrefixHeaderString = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "replyPrefixQueryParameter");
                    if (replyPrefixHeaderString != null && !"".equals(replyPrefixHeaderString)) {
                        replyPrefix = replyPrefixHeaderString;
                    }
                    for (String queryParmName : tmp) {
                        List reqQueryPar = TransportUtils.getParameterValues((HttpServletRequest)req, (String)queryParmName);
                        if (reqQueryPar == null || reqQueryPar.isEmpty()) continue;
                        headers.put((CallSite)((Object)(replyPrefix + queryParmName)), reqQueryPar);
                    }
                }
                Integer throttlingBytes = null;
                Integer throttlingMs = null;
                String throttlingTmp = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "throttlingBytes");
                if (throttlingTmp != null) {
                    throttlingTmp = throttlingTmp.trim();
                    throttlingBytes = Integer.valueOf(throttlingTmp);
                }
                if ((throttlingTmp = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "throttlingMs")) != null) {
                    throttlingTmp = throttlingTmp.trim();
                    throttlingMs = Integer.valueOf(throttlingTmp);
                }
                String throttlingType = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "throttlingType");
                boolean sendThrottling = false;
                boolean receiveThrottling = false;
                if (throttlingBytes != null && throttlingBytes > 0 && throttlingMs != null && throttlingMs > 0) {
                    if (throttlingType != null) {
                        throttlingType = throttlingType.trim();
                    }
                    if ("receive".equalsIgnoreCase(throttlingType)) {
                        receiveThrottling = true;
                    } else if ("send".equalsIgnoreCase(throttlingType)) {
                        sendThrottling = true;
                    } else if ("both".equalsIgnoreCase(throttlingType)) {
                        receiveThrottling = true;
                        sendThrottling = true;
                    } else {
                        sendThrottling = true;
                    }
                }
                String debugTmp = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "debug");
                boolean debug = true;
                if (debugTmp != null && "false".equals(debugTmp = debugTmp.trim())) {
                    debug = false;
                }
                String logMessageTmp = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "logMessage");
                boolean logMessage = false;
                if (logMessageTmp != null && "true".equals(logMessageTmp = logMessageTmp.trim())) {
                    logMessage = true;
                }
                if ((saveMessageDir = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "saveMessageDir")) != null) {
                    saveMessageDir = saveMessageDir.trim();
                }
                boolean consumeRequest = true;
                String consumeRequestTmp = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "consumeRequest");
                if (consumeRequestTmp != null) {
                    consumeRequestTmp = consumeRequestTmp.trim();
                    consumeRequest = Boolean.valueOf(consumeRequestTmp);
                }
                byte[] contenutoRichiesta = null;
                if (logMessage || saveMessageDir != null) {
                    if (receiveThrottling) {
                        contenutoRichiesta = this.readThrottling((InputStream)req.getInputStream(), throttlingBytes, throttlingMs);
                    } else {
                        int read;
                        sin = req.getInputStream();
                        outStr = new ByteArrayOutputStream();
                        while ((read = sin.read()) != -1) {
                            outStr.write(read);
                        }
                        contenutoRichiesta = outStr.toByteArray();
                    }
                } else if (consumeRequest) {
                    if (receiveThrottling) {
                        this.consumeThrottling((InputStream)req.getInputStream(), throttlingBytes, throttlingMs);
                    } else {
                        sin = req.getInputStream();
                        outStr = null;
                        outStr = oneway || this.thresholdRequestDump <= 0 || this.repositoryRequestDump == null ? NullOutputStream.INSTANCE : new DumpByteArrayOutputStream(this.thresholdRequestDump, this.repositoryRequestDump, null, "RichiestaTestService");
                        CopyStream.copy((InputStream)sin, (OutputStream)outStr);
                        outStr.flush();
                        ((OutputStream)outStr).close();
                        if (!oneway && outStr instanceof DumpByteArrayOutputStream) {
                            DumpByteArrayOutputStream dOut = (DumpByteArrayOutputStream)outStr;
                            if (dOut.isSerializedOnFileSystem()) {
                                dumpByteArrayOutputStreamRichiesta = dOut;
                            } else {
                                contenutoRichiesta = dOut.toByteArray();
                            }
                        }
                    }
                }
                String contentTypeRichiesta = req.getContentType();
                StringBuilder sb = new StringBuilder();
                if (debug || logMessage || saveMessageDir != null) {
                    sb.append("--------  Messaggio ricevuto il : " + new Date().toString() + " [ct:" + contentTypeRichiesta + "] [httpVersion:" + req.getProtocol() + "] -------------\n\n");
                }
                if (logMessage) {
                    if (contenutoRichiesta != null && contenutoRichiesta.length > 0) {
                        sb.append(new String(contenutoRichiesta));
                    } else if (dumpByteArrayOutputStreamRichiesta != null) {
                        String msg = "Richiesta pi\u00f9 grande della soglia (" + Utilities.convertBytesToFormatString((long)this.thresholdRequestDump) + ")";
                        sb.append(msg).append(": ").append(Utilities.convertBytesToFormatString((long)dumpByteArrayOutputStreamRichiesta.size()));
                    } else {
                        sb.append("Payload non presente");
                    }
                }
                if (saveMessageDir != null) {
                    File dir = new File(saveMessageDir);
                    if (!dir.exists()) {
                        throw new MessageException("Directory [" + dir.getAbsolutePath() + "] doesn't exists");
                    }
                    if (!dir.canWrite()) {
                        throw new MessageException("Directory [" + dir.getAbsolutePath() + "] without write permission");
                    }
                    if (!dir.canRead()) {
                        throw new MessageException("Directory [" + dir.getAbsolutePath() + "] without read permission");
                    }
                    String ext = "bin";
                    try {
                        String ct = new String(contentTypeRichiesta);
                        if (ct.contains(";")) {
                            ct = ct.split(";")[0];
                        }
                        ext = MimeTypes.getInstance().getExtension(ct);
                    }
                    catch (Exception e) {
                        this.log.warn("Riconoscimento ext file tramite contentType[" + contentTypeRichiesta + "] non riuscito: " + e.getMessage(), (Throwable)e);
                    }
                    File f = File.createTempFile("Message", "." + ext, dir);
                    if (contenutoRichiesta != null && contenutoRichiesta.length > 0) {
                        FileSystemUtilities.writeFile((File)f, (byte[])contenutoRichiesta);
                    } else if (dumpByteArrayOutputStreamRichiesta != null) {
                        CopyStream.copy((File)dumpByteArrayOutputStreamRichiesta.getSerializedFile(), (File)f);
                    }
                    if (logMessage) {
                        sb.append("\n\n");
                    }
                    sb.append("saved in: " + f.getAbsolutePath());
                }
                if (sb.length() > 0) {
                    sb.append("\n\n");
                    this.log.info(sb.toString());
                }
                if ((sleep = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "sleep")) != null) {
                    int millisecond = Integer.parseInt(sleep);
                    if (millisecond > 1000) {
                        int count = millisecond / 1000;
                        int resto = millisecond % 1000;
                        this.log.info("sleep " + millisecond + "ms ...");
                        for (int i = 0; i < count; ++i) {
                            Utilities.sleep((long)1000L);
                        }
                        Utilities.sleep((long)resto);
                        this.log.info("sleep " + millisecond + "ms terminated");
                    } else {
                        this.log.info("sleep " + millisecond + "ms ...");
                        Utilities.sleep((long)millisecond);
                        this.log.info("sleep " + millisecond + "ms terminated");
                    }
                }
                String min = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "sleepMin");
                String max = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "sleepMax");
                if (max != null) {
                    int sleepInteger;
                    int maxSleep = Integer.parseInt(max);
                    int minSleep = 0;
                    if (min != null) {
                        minSleep = Integer.parseInt(min);
                    }
                    if ((sleepInteger = minSleep + RandomUtilities.getRandom().nextInt(maxSleep - minSleep)) > 1000) {
                        int count = sleepInteger / 1000;
                        int resto = sleepInteger % 1000;
                        this.log.info("sleep " + sleepInteger + "ms ...");
                        for (int i = 0; i < count; ++i) {
                            Utilities.sleep((long)1000L);
                        }
                        Utilities.sleep((long)resto);
                        this.log.info("sleep " + sleepInteger + "ms terminated");
                    } else {
                        this.log.info("sleep " + sleepInteger + "ms ...");
                        Utilities.sleep((long)sleepInteger);
                        this.log.info("sleep " + sleepInteger + "ms terminated");
                    }
                }
                if (fault != null && fault.equalsIgnoreCase("true")) {
                    MessageType soapVersion = MessageType.SOAP_11;
                    if (faultSoapVersion != null && "12".equals(faultSoapVersion)) {
                        soapVersion = MessageType.SOAP_12;
                    }
                    OpenSPCoop2MessageFactory factory = OpenSPCoop2MessageFactory.getDefaultMessageFactory();
                    OpenSPCoop2Message msg = factory.createFaultMessage(soapVersion, false, faultMessage);
                    OpenSPCoop2SoapMessage soapMsg = msg.castAsSoap();
                    QName qName = new QName(faultNamespaceCode, faultCode);
                    SOAPBody bdy = soapMsg.getSOAPBody();
                    SOAPFault f = bdy.getFault();
                    soapMsg.setFaultCode(f, SOAPFaultCode.Receiver, qName);
                    f.setFaultActor(faultActor);
                    if (headers != null && !headers.isEmpty()) {
                        for (String returnHeaderKey : headers.keySet()) {
                            List returnHeaderValue = (List)headers.get(returnHeaderKey);
                            if (returnHeaderValue == null || returnHeaderValue.isEmpty()) continue;
                            for (String value : returnHeaderValue) {
                                res.addHeader(returnHeaderKey, value);
                            }
                        }
                    }
                    msg.saveChanges();
                    res.setContentType(msg.getContentType());
                    res.setStatus(returnCode);
                    ServletOutputStream sout = res.getOutputStream();
                    msg.writeTo((OutputStream)sout, true);
                } else if (problemDetailSerialization != null) {
                    if (headers != null && !headers.isEmpty()) {
                        for (String returnHeaderKey : headers.keySet()) {
                            List returnHeaderValue = (List)headers.get(returnHeaderKey);
                            if (returnHeaderValue == null || returnHeaderValue.isEmpty()) continue;
                            for (String value : returnHeaderValue) {
                                res.addHeader(returnHeaderKey, value);
                            }
                        }
                    }
                    res.setContentType(problemDetailContentType);
                    res.setStatus(problemDetailStatus);
                    res.getOutputStream().write(problemDetailSerialization);
                    res.getOutputStream().flush();
                    res.getOutputStream().close();
                } else if (echoFormUrlEncoded) {
                    if (headers != null && !headers.isEmpty()) {
                        for (String returnHeaderKey : headers.keySet()) {
                            List returnHeaderValue = (List)headers.get(returnHeaderKey);
                            if (returnHeaderValue == null || returnHeaderValue.isEmpty()) continue;
                            for (String value : returnHeaderValue) {
                                res.addHeader(returnHeaderKey, value);
                            }
                        }
                    }
                    res.setContentType(contentTypeEchoFormUrlEncoded);
                    res.setStatus(returnCode);
                    res.getOutputStream().write(sbEchoFormUrlEncoded.toString().getBytes());
                    res.getOutputStream().flush();
                    res.getOutputStream().close();
                } else {
                    byte[] contenutoRequest;
                    byte[] resp;
                    Object a;
                    if (oneway) {
                        if (headers != null && !headers.isEmpty()) {
                            for (String returnHeaderKey : headers.keySet()) {
                                List returnHeaderValue = (List)headers.get(returnHeaderKey);
                                if (returnHeaderValue == null || returnHeaderValue.isEmpty()) continue;
                                for (String value : returnHeaderValue) {
                                    res.addHeader(returnHeaderKey, value);
                                }
                            }
                        }
                        res.setStatus(returnCode);
                        return;
                    }
                    if (tunnel) {
                        res.setHeader("GovWay-Soap-Tunnel", "true");
                        if (tunnelSoapMimeType != null) {
                            res.setHeader("GovWay-Soap-Tunnel-Mime", tunnelSoapMimeType);
                        }
                    }
                    Object contentTypeRisposta = contentTypeRichiesta;
                    String fileDestinazione = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "destFile");
                    String fileResponse = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "response");
                    if (fileResponse == null) {
                        fileResponse = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "op");
                    }
                    String responseContent = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "responseContent");
                    String responseContentByHeader = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "responseContentByHeader");
                    String responseContentByParameter = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "responseContentByParameter");
                    ByteArrayOutputStream boutStaticFile = null;
                    if (fileDestinazione != null || fileResponse != null) {
                        String path = null;
                        if (fileDestinazione != null) {
                            path = fileDestinazione = fileDestinazione.trim();
                        } else {
                            path = fileResponse = fileResponse.trim();
                            if (this.repositoryResponseFiles == null) {
                                throw new MessageException("Property 'response' non utilizzabile se non viene definito un repository dei files");
                            }
                            File f = new File(this.repositoryResponseFiles, fileResponse);
                            path = f.getAbsolutePath();
                        }
                        FileInputStream fin = new FileInputStream(path);
                        boutStaticFile = new ByteArrayOutputStream();
                        CopyStream.copy((InputStream)fin, (OutputStream)boutStaticFile);
                        boutStaticFile.flush();
                        boutStaticFile.close();
                        fin.close();
                        String fileDestinazioneContentType = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "destFileContentType");
                        if (fileDestinazioneContentType == null) {
                            fileDestinazioneContentType = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "responseContentType");
                        }
                        if (fileDestinazioneContentType != null) {
                            fileDestinazioneContentType = fileDestinazioneContentType.trim();
                            contentTypeRisposta = fileDestinazioneContentType;
                        } else {
                            contentTypeRisposta = contentTypeRichiesta != null && !contentTypeRichiesta.contains("multipart/related") ? ContentTypeUtilities.readBaseTypeFromContentType((String)contentTypeRichiesta) : "text/xml";
                            a = boutStaticFile.toByteArray();
                            if (MultipartUtils.messageWithAttachment((byte[])a)) {
                                String fileDestinazioneMultipartParameterType = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "destFileContentTypeMultipartParameterType");
                                if (fileDestinazioneMultipartParameterType != null) {
                                    contentTypeRisposta = fileDestinazioneMultipartParameterType.trim();
                                }
                                String subType = "related";
                                String fileDestinazioneMultipartSubType = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "destFileContentTypeMultipartSubType");
                                if (fileDestinazioneMultipartSubType != null) {
                                    subType = fileDestinazioneMultipartSubType;
                                }
                                String IDfirst = MultipartUtils.firstContentID((byte[])a);
                                String boundary = MultipartUtils.findBoundary((byte[])a);
                                if (boundary == null) {
                                    throw new MessageException("Errore avvenuto durante la lettura del boundary associato al multipart message.");
                                }
                                contentTypeRisposta = IDfirst == null ? "multipart/" + subType + "; type=\"" + (String)contentTypeRisposta + "\"; \tboundary=\"" + boundary.substring(2, boundary.length()) + "\" " : "multipart/" + subType + "; type=\"" + (String)contentTypeRisposta + "\"; start=\"" + IDfirst + "\"; \tboundary=\"" + boundary.substring(2, boundary.length()) + "\" ";
                            }
                        }
                        if ("none".equals(contentTypeRisposta)) {
                            contentTypeRisposta = null;
                        }
                    } else if (responseContent != null || responseContentByHeader != null || responseContentByParameter != null) {
                        String v;
                        boutStaticFile = new ByteArrayOutputStream();
                        if (responseContent != null) {
                            boutStaticFile.write(responseContent.getBytes());
                        } else if (responseContentByParameter != null) {
                            v = TransportUtils.getParameterFirstValue((HttpServletRequest)req, (String)responseContentByParameter);
                            boutStaticFile.write(v.getBytes());
                        } else {
                            v = TransportUtils.getHeaderFirstValue((HttpServletRequest)req, (String)responseContentByHeader);
                            if (v == null || StringUtils.isEmpty((String)v)) {
                                throw new MessageException("Header '" + responseContentByHeader + "' not found");
                            }
                            if ("Authorization".equalsIgnoreCase(responseContentByHeader) && v.startsWith("Bearer ")) {
                                v = v.substring("Bearer ".length());
                            }
                            boutStaticFile.write(v.getBytes());
                        }
                        boutStaticFile.flush();
                        boutStaticFile.close();
                        String responseContentType = ServletTestService.getParameterCheckWhiteList(req, this.whitePropertiesList, "responseContentType");
                        if (responseContentType != null) {
                            responseContentType = responseContentType.trim();
                            contentTypeRisposta = responseContentType;
                        } else {
                            contentTypeRisposta = contentTypeRichiesta != null && !contentTypeRichiesta.contains("multipart/related") ? ContentTypeUtilities.readBaseTypeFromContentType((String)contentTypeRichiesta) : "text/xml";
                        }
                        if ("none".equals(contentTypeRisposta)) {
                            contentTypeRisposta = null;
                        }
                    }
                    if (!forceContentLength && chunked) {
                        res.setHeader("Transfer-Encoding", "chunked");
                        if (debug) {
                            this.log.info("Response send with Transfer-Encoding: chunked");
                        }
                    } else if (boutStaticFile != null) {
                        res.setContentLength(boutStaticFile.size());
                        forceContentLength = false;
                    } else if (contenutoRichiesta != null && contenutoRichiesta.length > 0) {
                        res.setContentLength(contenutoRichiesta.length);
                        forceContentLength = false;
                    } else if (dumpByteArrayOutputStreamRichiesta != null) {
                        res.setContentLength(dumpByteArrayOutputStreamRichiesta.size());
                        forceContentLength = false;
                    }
                    if (headerRisposta != null) {
                        Enumeration<Object> en2 = headerRisposta.keys();
                        while (en2.hasMoreElements()) {
                            String key = (String)en2.nextElement();
                            String value = headerRisposta.getProperty(key);
                            if (value == null) continue;
                            res.setHeader(key, value);
                        }
                    }
                    if (headers != null && !headers.isEmpty()) {
                        for (String returnHeaderKey : headers.keySet()) {
                            List returnHeaderValue = (List)headers.get(returnHeaderKey);
                            if (returnHeaderValue == null || returnHeaderValue.isEmpty()) continue;
                            a = returnHeaderValue.iterator();
                            while (a.hasNext()) {
                                String value = (String)a.next();
                                res.addHeader(returnHeaderKey, value);
                            }
                        }
                    }
                    res.setContentType((String)contentTypeRisposta);
                    res.setStatus(returnCode);
                    if (sendThrottling) {
                        this.log.info("Throttling bytes:" + throttlingBytes + " every " + throttlingMs + "ms ...");
                        byte[] contenutoInteroDaSpedire = null;
                        if (boutStaticFile != null) {
                            contenutoInteroDaSpedire = boutStaticFile.toByteArray();
                        } else if (contenutoRichiesta != null && contenutoRichiesta.length > 0) {
                            contenutoInteroDaSpedire = replaceMap != null && replaceMap.size() > 0 ? this.replace(contenutoRichiesta, replaceMap) : contenutoRichiesta;
                        } else {
                            if (dumpByteArrayOutputStreamRichiesta != null) {
                                throw new MessageException("Throttling unsupported with request messege bigger than threshold (" + Utilities.convertBytesToFormatString((long)this.thresholdRequestDump) + ")");
                            }
                            byte[] contenutoRequest2 = null;
                            contenutoRequest2 = receiveThrottling ? this.readThrottling((InputStream)req.getInputStream(), throttlingBytes, throttlingMs) : Utilities.getAsByteArray((InputStream)req.getInputStream());
                            contenutoInteroDaSpedire = replaceMap != null && replaceMap.size() > 0 ? this.replace(contenutoRequest2, replaceMap) : contenutoRequest2;
                        }
                        if (contenutoInteroDaSpedire != null && contenutoInteroDaSpedire.length > 0) {
                            int length;
                            if (forceContentLength) {
                                res.setContentLength(contenutoInteroDaSpedire.length);
                            }
                            int lengthSendContent = contenutoInteroDaSpedire.length;
                            for (int i = 0; i < lengthSendContent; i += length) {
                                int remaining = lengthSendContent - i;
                                length = throttlingBytes;
                                if (remaining < length) {
                                    length = remaining;
                                }
                                res.getOutputStream().write(contenutoInteroDaSpedire, i, length);
                                res.getOutputStream().flush();
                                this.log.info("send " + length + " bytes");
                                Utilities.sleep((long)throttlingMs.intValue());
                            }
                        }
                        this.log.info("Throttling bytes:" + throttlingBytes + " every " + throttlingMs + "ms finished");
                    } else if (boutStaticFile != null) {
                        resp = boutStaticFile.toByteArray();
                        if (forceContentLength) {
                            res.setContentLength(resp.length);
                        }
                        res.getOutputStream().write(resp);
                    } else if (contenutoRichiesta != null && contenutoRichiesta.length > 0) {
                        if (replaceMap != null && replaceMap.size() > 0) {
                            resp = this.replace(contenutoRichiesta, replaceMap);
                            if (forceContentLength) {
                                res.setContentLength(resp.length);
                            }
                            res.getOutputStream().write(resp);
                        } else {
                            if (forceContentLength) {
                                res.setContentLength(contenutoRichiesta.length);
                            }
                            res.getOutputStream().write(contenutoRichiesta);
                        }
                    } else if (dumpByteArrayOutputStreamRichiesta != null) {
                        if (replaceMap != null && replaceMap.size() > 0) {
                            throw new MessageException("Replace unsupported with request messege bigger than threshold (" + Utilities.convertBytesToFormatString((long)this.thresholdRequestDump) + ")");
                        }
                        if (forceContentLength) {
                            res.setContentLength(dumpByteArrayOutputStreamRichiesta.size());
                        }
                        try (FileInputStream fin = new FileInputStream(dumpByteArrayOutputStreamRichiesta.getSerializedFile());){
                            CopyStream.copy((InputStream)fin, (OutputStream)res.getOutputStream());
                        }
                    } else if (replaceMap != null && replaceMap.size() > 0) {
                        contenutoRequest = null;
                        contenutoRequest = receiveThrottling ? this.readThrottling((InputStream)req.getInputStream(), throttlingBytes, throttlingMs) : Utilities.getAsByteArray((InputStream)req.getInputStream());
                        byte[] resp2 = this.replace(contenutoRequest, replaceMap);
                        if (forceContentLength) {
                            res.setContentLength(resp2.length);
                        }
                        res.getOutputStream().write(resp2);
                    } else if (receiveThrottling) {
                        contenutoRequest = this.readThrottling((InputStream)req.getInputStream(), throttlingBytes, throttlingMs);
                        if (forceContentLength) {
                            res.setContentLength(contenutoRequest.length);
                        }
                        res.getOutputStream().write(contenutoRequest);
                    } else if (forceContentLength) {
                        resp = Utilities.getAsByteArray((InputStream)req.getInputStream(), (boolean)false);
                        if (resp != null && resp.length > 0) {
                            res.setContentLength(resp.length);
                            res.getOutputStream().write(resp);
                        } else {
                            res.setContentLength(0);
                        }
                    } else {
                        ServletInputStream is = req.getInputStream();
                        ServletOutputStream out = res.getOutputStream();
                        CopyStream.copy((InputStream)is, (OutputStream)out);
                    }
                    res.getOutputStream().flush();
                    res.getOutputStream().close();
                }
            }
            catch (Throwable e) {
                if (this.log != null) {
                    this.log.error("TestService: " + e.getMessage(), e);
                } else {
                    ServletTestService.systemOut("ERRORE TestService: " + e.toString());
                    e.printStackTrace(System.out);
                }
                if (this.genericError) {
                    res.setStatus(500);
                    res.getOutputStream().flush();
                    res.getOutputStream().close();
                    break block277;
                }
                throw new ServletException(e.getMessage(), e);
            }
            finally {
                try {
                    if (dumpByteArrayOutputStreamRichiesta != null) {
                        dumpByteArrayOutputStreamRichiesta.clearResources();
                    }
                }
                catch (Throwable t) {
                    this.log.error("TestService (cleanResources): " + t.getMessage(), t);
                }
            }
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpRequestMethod m = HttpRequestMethod.valueOf((String)req.getMethod().toUpperCase());
        switch (m) {
            case DELETE: {
                this.doDelete(req, resp);
                break;
            }
            case GET: {
                this.doGet(req, resp);
                break;
            }
            case HEAD: {
                this.doHead(req, resp);
                break;
            }
            case OPTIONS: {
                this.doOptions(req, resp);
                break;
            }
            case POST: {
                this.doPost(req, resp);
                break;
            }
            case PUT: {
                this.doPut(req, resp);
                break;
            }
            case TRACE: {
                this.doTrace(req, resp);
                break;
            }
            case PATCH: 
            case LINK: 
            case UNLINK: {
                this.doGet(req, resp);
                break;
            }
            default: {
                super.service(req, resp);
            }
        }
    }

    private byte[] replace(byte[] contenuto, Map<String, String> map) {
        String s = new String(contenuto);
        for (String oldValue : map.keySet()) {
            String newValue = map.get(oldValue);
            s = s.replaceAll(oldValue, newValue);
        }
        return s.getBytes();
    }

    private byte[] readThrottling(InputStream is, int throttlingBytes, int throttlingMs) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buffer = new byte[throttlingBytes];
        int letti = 0;
        while ((letti = is.read(buffer)) != -1) {
            bout.write(buffer, 0, letti);
            bout.flush();
            this.log.info("received " + letti + " bytes");
            Utilities.sleep((long)throttlingMs);
        }
        bout.close();
        return bout.toByteArray();
    }

    private void consumeThrottling(InputStream is, int throttlingBytes, int throttlingMs) throws Exception {
        NullOutputStream bout = NullOutputStream.INSTANCE;
        byte[] buffer = new byte[throttlingBytes];
        int letti = 0;
        while ((letti = is.read(buffer)) != -1) {
            bout.write(buffer, 0, letti);
            bout.flush();
            this.log.info("received " + letti + " bytes");
            Utilities.sleep((long)throttlingMs);
        }
        bout.close();
    }
}

