/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.xml.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.xml.ValidatoreXSD;
import org.openspcoop2.utils.xml.test.TestXXE;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XXETest {
    public static void main(String[] args) throws Exception {
        XXETest.test();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test() throws Exception {
        OpenSPCoop2MessageFactory factory = OpenSPCoop2MessageFactory.getDefaultMessageFactory();
        System.out.println("- newDocument(byte[])");
        try {
            MessageXMLUtils.getInstance(factory).newDocument(TestXXE.xmlMessage);
            throw new Exception("newDocument ok ?");
        }
        catch (Exception e) {
            if (!e.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                throw e;
            }
            System.out.println("\t Eccezione attesa: " + e.getMessage());
            System.out.println("");
            System.out.println("- newDocument(InputStream)");
            try {
                try (ByteArrayInputStream bin = new ByteArrayInputStream(TestXXE.xmlMessage);){
                    MessageXMLUtils.getInstance(factory).newDocument(bin);
                }
                throw new Exception("newDocument ok ?");
            }
            catch (Exception e2) {
                if (!e2.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                    throw e2;
                }
                System.out.println("\t Eccezione attesa: " + e2.getMessage());
                System.out.println("");
                System.out.println("- newDocument(File)");
                File file = File.createTempFile("testXXE", ".xml");
                try {
                    try {
                        FileSystemUtilities.writeFile((File)file, (byte[])TestXXE.xmlMessage);
                        MessageXMLUtils.getInstance(factory).newDocument(file);
                        throw new Exception("newDocument ok ?");
                    }
                    catch (Exception e3) {
                        if (!e3.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                            throw e3;
                        }
                        System.out.println("\t Eccezione attesa: " + e3.getMessage());
                        file.delete();
                    }
                }
                catch (Throwable throwable) {
                    file.delete();
                    throw throwable;
                }
                System.out.println("");
                System.out.println("- newDocument(InputSource)");
                try {
                    try (ByteArrayInputStream bin = new ByteArrayInputStream(TestXXE.xmlMessage);){
                        InputSource inputSource = new InputSource(bin);
                        MessageXMLUtils.getInstance(factory).newDocument(inputSource);
                    }
                    throw new Exception("newDocument ok ?");
                }
                catch (Exception e4) {
                    if (!e4.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                        throw e4;
                    }
                    System.out.println("\t Eccezione attesa: " + e4.getMessage());
                    System.out.println("");
                    System.out.println("- newElement(byte[])");
                    try {
                        MessageXMLUtils.getInstance(factory).newElement(TestXXE.xmlMessage);
                        throw new Exception("newElement ok ?");
                    }
                    catch (Exception e5) {
                        if (!e5.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                            throw e5;
                        }
                        System.out.println("\t Eccezione attesa: " + e5.getMessage());
                        System.out.println("");
                        System.out.println("- newElement(InputStream)");
                        try {
                            try (ByteArrayInputStream bin = new ByteArrayInputStream(TestXXE.xmlMessage);){
                                MessageXMLUtils.getInstance(factory).newElement(bin);
                            }
                            throw new Exception("newElement ok ?");
                        }
                        catch (Exception e6) {
                            if (!e6.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                                throw e6;
                            }
                            System.out.println("\t Eccezione attesa: " + e6.getMessage());
                            System.out.println("");
                            System.out.println("- newElement(File)");
                            file = File.createTempFile("testXXE", ".xml");
                            try {
                                try {
                                    FileSystemUtilities.writeFile((File)file, (byte[])TestXXE.xmlMessage);
                                    MessageXMLUtils.getInstance(factory).newElement(file);
                                    throw new Exception("newElement ok ?");
                                }
                                catch (Exception e7) {
                                    if (!e7.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                                        throw e7;
                                    }
                                    System.out.println("\t Eccezione attesa: " + e7.getMessage());
                                    file.delete();
                                }
                            }
                            catch (Throwable throwable) {
                                file.delete();
                                throw throwable;
                            }
                            System.out.println("");
                            System.out.println("- newElement(InputSource)");
                            try {
                                try (ByteArrayInputStream bin = new ByteArrayInputStream(TestXXE.xmlMessage);){
                                    InputSource inputSource = new InputSource(bin);
                                    MessageXMLUtils.getInstance(factory).newElement(inputSource);
                                }
                                throw new Exception("newElement ok ?");
                            }
                            catch (Exception e8) {
                                if (!e8.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                                    throw e8;
                                }
                                System.out.println("\t Eccezione attesa: " + e8.getMessage());
                                System.out.println("");
                                System.out.println("- getSAXParserFactory usage");
                                try {
                                    SAXParserFactory saxFactory = MessageXMLUtils.getInstance(factory).getSAXParserFactory();
                                    saxFactory.setNamespaceAware(true);
                                    SAXParser saxParser = saxFactory.newSAXParser();
                                    XMLReader xmlReader = saxParser.getXMLReader();
                                    try (ByteArrayInputStream bin = new ByteArrayInputStream(TestXXE.xmlMessage);){
                                        InputSource inputSource = new InputSource(bin);
                                        xmlReader.parse(inputSource);
                                    }
                                    throw new Exception("getSAXParserFactory usage ok ?");
                                }
                                catch (Exception e9) {
                                    if (!e9.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                                        throw e9;
                                    }
                                    System.out.println("\t Eccezione attesa: " + e9.getMessage());
                                    System.out.println("");
                                    System.out.println("- getSchemaFactory usage");
                                    try {
                                        try (ByteArrayInputStream bin = new ByteArrayInputStream(TestXXE.xsdSchema);){
                                            StreamSource streamSource = new StreamSource(bin);
                                            SchemaFactory schemafactory = MessageXMLUtils.getInstance(factory).getSchemaFactory();
                                            Schema schema = schemafactory.newSchema(streamSource);
                                        }
                                        throw new Exception("getSchemaFactory usage ok ?");
                                    }
                                    catch (Exception e10) {
                                        if (!e10.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                                            throw e10;
                                        }
                                        System.out.println("\t Eccezione attesa: " + e10.getMessage());
                                        System.out.println("");
                                        System.out.println("- ValidatoreXSD usage (schemaFactory)");
                                        try {
                                            try (ByteArrayInputStream bin = new ByteArrayInputStream(TestXXE.xsdSchema);){
                                                ValidatoreXSD streamSource = new ValidatoreXSD(LoggerWrapperFactory.getLogger(XXETest.class), "org.apache.xerces.jaxp.validation.XMLSchemaFactory", (InputStream)bin);
                                            }
                                            throw new Exception("ValidatoreXSD usage ok ?");
                                        }
                                        catch (Exception e11) {
                                            if (!e11.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                                                throw e11;
                                            }
                                            System.out.println("\t Eccezione attesa: " + e11.getMessage());
                                            System.out.println("");
                                            System.out.println("- ValidatoreXSD usage");
                                            try {
                                                try (ByteArrayInputStream bin = new ByteArrayInputStream(TestXXE.xsdSchema);){
                                                    ValidatoreXSD streamSource = new ValidatoreXSD(LoggerWrapperFactory.getLogger(XXETest.class), (InputStream)bin);
                                                }
                                                throw new Exception("ValidatoreXSD usage ok ?");
                                            }
                                            catch (Exception e12) {
                                                if (!e12.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                                                    throw e12;
                                                }
                                                System.out.println("\t Eccezione attesa: " + e12.getMessage());
                                                System.out.println("");
                                                System.out.println("- ValidatoreXSD usage (multipleIS + schemaFactory)");
                                                try {
                                                    try (ByteArrayInputStream bin = new ByteArrayInputStream(TestXXE.xsdSchema);){
                                                        ValidatoreXSD streamSource = new ValidatoreXSD(LoggerWrapperFactory.getLogger(XXETest.class), "org.apache.xerces.jaxp.validation.XMLSchemaFactory", new InputStream[]{bin, bin, bin, bin});
                                                    }
                                                    throw new Exception("ValidatoreXSD usage ok ?");
                                                }
                                                catch (Exception e13) {
                                                    if (!e13.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                                                        throw e13;
                                                    }
                                                    System.out.println("\t Eccezione attesa: " + e13.getMessage());
                                                    System.out.println("");
                                                    System.out.println("- ValidatoreXSD usage (multipleIS)");
                                                    try {
                                                        try (ByteArrayInputStream bin = new ByteArrayInputStream(TestXXE.xsdSchema);){
                                                            ValidatoreXSD streamSource = new ValidatoreXSD(LoggerWrapperFactory.getLogger(XXETest.class), new InputStream[]{bin, bin, bin, bin});
                                                        }
                                                        throw new Exception("ValidatoreXSD usage ok ?");
                                                    }
                                                    catch (Exception e14) {
                                                        if (!e14.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                                                            throw e14;
                                                        }
                                                        System.out.println("\t Eccezione attesa: " + e14.getMessage());
                                                        System.out.println("");
                                                        System.out.println("- getTransformerFactory usage");
                                                        try {
                                                            try (ByteArrayInputStream bin = new ByteArrayInputStream(TestXXE.xslt);){
                                                                DOMSource xsltSource = new DOMSource(MessageXMLUtils.getInstance(factory).newElement(TestXXE.xslt));
                                                                Transformer transformer = MessageXMLUtils.getInstance(factory).getTransformerFactory().newTransformer(xsltSource);
                                                            }
                                                            throw new Exception("getTransformerFactory usage ok ?");
                                                        }
                                                        catch (Exception e15) {
                                                            if (!e15.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                                                                throw e15;
                                                            }
                                                            System.out.println("\t Eccezione attesa: " + e15.getMessage());
                                                            return;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

