/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa;

import org.openspcoop2.protocol.modipa.AbstractModISecurityToken;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.TipoSerializzazione;

public class ModISecurityRestToken
extends AbstractModISecurityToken<String> {
    private String tokenIntegrityHeaderName;
    private String tokenIntegrity;
    private String headerName;

    public ModISecurityRestToken(String tokenAuthorization, String tokenIntegrityHeaderName, String tokenIntegrity) {
        super(tokenAuthorization);
        this.tokenIntegrityHeaderName = tokenIntegrityHeaderName;
        this.tokenIntegrity = tokenIntegrity;
    }

    public ModISecurityRestToken(String headerName, String token) {
        super(token);
        this.headerName = headerName;
    }

    @Override
    public String toString(TipoSerializzazione tipoSerializzazione) throws ProtocolException {
        switch (tipoSerializzazione) {
            case DEFAULT: {
                StringBuilder sb = new StringBuilder();
                if (this.tokenIntegrity != null) {
                    sb.append("Authorization").append(": ").append("Bearer ").append((String)this.getToken());
                    sb.append("\n");
                    sb.append(this.tokenIntegrityHeaderName).append(": ").append(this.tokenIntegrity);
                } else if ("Authorization".equals(this.headerName)) {
                    sb.append("Authorization").append(": ").append("Bearer ").append((String)this.getToken());
                } else {
                    sb.append(this.headerName).append(": ").append(this.tokenIntegrity);
                }
                if (this.tokenAudit != null) {
                    sb.append("\n");
                    sb.append(this.tokenAuditHeaderName).append(": ").append(this.tokenAudit);
                }
                return sb.toString();
            }
        }
        throw new ProtocolException("Tipo di serializzazione [" + tipoSerializzazione + "] non supportata");
    }

    @Override
    public byte[] toByteArray(TipoSerializzazione tipoSerializzazione) throws ProtocolException {
        switch (tipoSerializzazione) {
            case DEFAULT: {
                return this.toString(tipoSerializzazione).getBytes();
            }
        }
        throw new ProtocolException("Tipo di serializzazione [" + tipoSerializzazione + "] non supportata");
    }
}

