/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.builder;

import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.core.token.GestoreTokenNegoziazioneUtilities;
import org.openspcoop2.pdd.core.token.PolicyNegoziazioneToken;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.certificate.KeystoreParams;
import org.slf4j.Logger;

public class ImbustamentoUtils {
    private static final String PREFIX = "l'assegnazione di una token policy di negoziazione al connettore";
    private static final String NO_SIGNED_JWT = "non \u00e8 di tipo 'SignedJWT'";

    private ImbustamentoUtils() {
    }

    private static void logError(Logger log, String msg, Exception e) {
        log.error(msg, (Throwable)e);
    }

    private static String getPolicyIndicata(String tokenPolicy) {
        return "; la policy indicata '" + tokenPolicy + "' ";
    }

    public static PolicyNegoziazioneToken readPolicyNegoziazioneToken(Logger log, IState state, IDSoggetto soggettoFruitore, IDServizio idServizio, String azione, RequestInfo requestInfo, StringBuilder sbRequired) throws ProtocolException {
        try {
            PolicyNegoziazioneToken policyNegoziazioneToken = null;
            IDServizio idServizioClone = idServizio.clone();
            idServizioClone.setAzione(azione);
            ConfigurazionePdDManager configurazionePdDManager = ConfigurazionePdDManager.getInstance((IState)state);
            boolean functionAsRouter = false;
            Connettore connettore = configurazionePdDManager.getForwardRoute(soggettoFruitore, idServizio, functionAsRouter, requestInfo);
            if (connettore == null) {
                throw new ProtocolException("Connettore non individuato");
            }
            if (connettore.sizePropertyList() <= 0) {
                sbRequired.append(PREFIX);
                return policyNegoziazioneToken;
            }
            String tokenPolicy = null;
            for (Property p : connettore.getPropertyList()) {
                if (!"tokenPolicy".equals(p.getNome())) continue;
                tokenPolicy = p.getValore();
            }
            if (tokenPolicy != null) {
                tokenPolicy = tokenPolicy.trim();
            }
            if (tokenPolicy == null || StringUtils.isEmpty((String)tokenPolicy)) {
                sbRequired.append(PREFIX);
                return policyNegoziazioneToken;
            }
            GenericProperties gp = configurazionePdDManager.getGenericProperties("retrievePolicyToken", tokenPolicy);
            if (gp == null) {
                sbRequired.append(PREFIX + ImbustamentoUtils.getPolicyIndicata(tokenPolicy) + "non esiste");
                return policyNegoziazioneToken;
            }
            return TokenUtilities.convertTo((GenericProperties)gp);
        }
        catch (Exception e) {
            ImbustamentoUtils.logError(log, "Errore durante la lettura del connettore (tramite la sicurezza messaggio): " + e.getMessage(), e);
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static KeystoreParams readKeystoreParams(Logger log, PolicyNegoziazioneToken policyNegoziazioneToken, StringBuilder sbRequired) throws ProtocolException {
        try {
            KeystoreParams kp = null;
            String tokenPolicy = policyNegoziazioneToken.getName();
            if (!policyNegoziazioneToken.isRfc7523x509Grant()) {
                sbRequired.append(PREFIX + ImbustamentoUtils.getPolicyIndicata(tokenPolicy) + NO_SIGNED_JWT);
                return kp;
            }
            if (policyNegoziazioneToken.isJwtSignKeystoreApplicativoModI()) {
                sbRequired.append(PREFIX + ImbustamentoUtils.getPolicyIndicata(tokenPolicy) + "non \u00e8 utilizzabile essendo configurata con una modalit\u00e0 di keystore 'Definito nell'applicativo ModI'");
                return kp;
            }
            if (policyNegoziazioneToken.isJwtSignKeystoreFruizioneModI()) {
                sbRequired.append(PREFIX + ImbustamentoUtils.getPolicyIndicata(tokenPolicy) + "non \u00e8 utilizzabile essendo configurata con una modalit\u00e0 di keystore 'Definito nella fruizione ModI'");
                return kp;
            }
            kp = GestoreTokenNegoziazioneUtilities.readKeystoreParams((PolicyNegoziazioneToken)policyNegoziazioneToken);
            if (kp == null) {
                sbRequired.append(PREFIX + ImbustamentoUtils.getPolicyIndicata(tokenPolicy) + "non \u00e8 configurata correttamente");
                return kp;
            }
            return kp;
        }
        catch (Exception e) {
            ImbustamentoUtils.logError(log, "Errore durante la lettura del connettore (tramite la sicurezza messaggio): " + e.getMessage(), e);
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static String readClientId(Logger log, PolicyNegoziazioneToken policyNegoziazioneToken, StringBuilder sbRequired) throws ProtocolException {
        try {
            String clientId = null;
            String tokenPolicy = policyNegoziazioneToken.getName();
            if (!policyNegoziazioneToken.isRfc7523x509Grant()) {
                sbRequired.append(PREFIX + ImbustamentoUtils.getPolicyIndicata(tokenPolicy) + NO_SIGNED_JWT);
                return clientId;
            }
            if (policyNegoziazioneToken.isJwtClientIdApplicativoModI()) {
                sbRequired.append(PREFIX + ImbustamentoUtils.getPolicyIndicata(tokenPolicy) + "non \u00e8 utilizzabile essendo configurato un identificativo client con modalit\u00e0 'Definito nell'applicativo ModI'");
                return clientId;
            }
            if (policyNegoziazioneToken.isJwtClientIdFruizioneModI()) {
                sbRequired.append(PREFIX + ImbustamentoUtils.getPolicyIndicata(tokenPolicy) + "non \u00e8 utilizzabile essendo configurata un identificativo client con modalit\u00e0 'Definito nella fruizione ModI'");
                return clientId;
            }
            clientId = policyNegoziazioneToken.getJwtClientId();
            return clientId;
        }
        catch (Exception e) {
            ImbustamentoUtils.logError(log, "Errore durante la lettura del kid presente nella token policy (tramite la sicurezza messaggio): " + e.getMessage(), e);
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static String readKID(Logger log, PolicyNegoziazioneToken policyNegoziazioneToken, String clientId, KeystoreParams kp, StringBuilder sbRequired) throws ProtocolException {
        try {
            String kid = null;
            String tokenPolicy = policyNegoziazioneToken.getName();
            if (!policyNegoziazioneToken.isRfc7523x509Grant()) {
                sbRequired.append(PREFIX + ImbustamentoUtils.getPolicyIndicata(tokenPolicy) + NO_SIGNED_JWT);
                return kid;
            }
            if (policyNegoziazioneToken.isJwtSignIncludeKeyIdApplicativoModI()) {
                sbRequired.append(PREFIX + ImbustamentoUtils.getPolicyIndicata(tokenPolicy) + "non \u00e8 utilizzabile essendo configurato un identificativo kid con modalit\u00e0 'Definito nell'applicativo ModI'");
                return kid;
            }
            if (policyNegoziazioneToken.isJwtSignIncludeKeyIdFruizioneModI()) {
                sbRequired.append(PREFIX + ImbustamentoUtils.getPolicyIndicata(tokenPolicy) + "non \u00e8 utilizzabile essendo configurata un identificativo kid con modalit\u00e0 'Definito nella fruizione ModI'");
                return kid;
            }
            if (policyNegoziazioneToken.isJwtSignIncludeKeyIdWithClientId()) {
                kid = clientId;
            } else if (policyNegoziazioneToken.isJwtSignIncludeKeyIdWithKeyAlias()) {
                kid = kp.getKeyAlias();
            } else if (policyNegoziazioneToken.isJwtSignIncludeKeyIdCustom()) {
                kid = policyNegoziazioneToken.getJwtSignIncludeKeyIdCustom();
            }
            return kid;
        }
        catch (Exception e) {
            ImbustamentoUtils.logError(log, "Errore durante la lettura del kid presente nella token policy (tramite la sicurezza messaggio): " + e.getMessage(), e);
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }
}

