/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.mvc.properties.provider.InputValidationUtils;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.ConfigurazioneServizioAzione;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Property;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.constants.RuoloContesto;
import org.openspcoop2.core.registry.constants.RuoloTipologia;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.pdd.core.dynamic.DynamicHelperCostanti;
import org.openspcoop2.protocol.engine.utils.AzioniUtils;
import org.openspcoop2.protocol.modipa.config.ModIAuditClaimConfig;
import org.openspcoop2.protocol.modipa.config.ModIAuditConfig;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.modipa.config.ModISignalHubConfig;
import org.openspcoop2.protocol.modipa.config.ModISignalHubParamConfig;
import org.openspcoop2.protocol.modipa.constants.ModIConsoleCostanti;
import org.openspcoop2.protocol.modipa.properties.ModIDynamicConfigurationAccordiParteComuneUtilities;
import org.openspcoop2.protocol.modipa.properties.ModIDynamicConfigurationKeystoreUtilities;
import org.openspcoop2.protocol.modipa.utils.ModIPropertiesUtils;
import org.openspcoop2.protocol.modipa.utils.ModISecurityConfig;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ConsoleItemType;
import org.openspcoop2.protocol.sdk.constants.ConsoleItemValueType;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.AbstractConsoleItem;
import org.openspcoop2.protocol.sdk.properties.AbstractProperty;
import org.openspcoop2.protocol.sdk.properties.BaseConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BooleanConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BooleanProperty;
import org.openspcoop2.protocol.sdk.properties.ConsoleConfiguration;
import org.openspcoop2.protocol.sdk.properties.ConsoleItemInfo;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.protocol.sdk.properties.NumberConsoleItem;
import org.openspcoop2.protocol.sdk.properties.NumberProperty;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesFactory;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.protocol.sdk.properties.StringConsoleItem;
import org.openspcoop2.protocol.sdk.properties.StringProperty;
import org.openspcoop2.protocol.sdk.properties.SubtitleConsoleItem;
import org.openspcoop2.protocol.sdk.properties.TitleConsoleItem;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaFruizioniServizio;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaRuoli;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaServizi;
import org.openspcoop2.protocol.sdk.registry.RegistryException;
import org.openspcoop2.protocol.sdk.registry.RegistryNotFound;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;
import org.openspcoop2.utils.digest.DigestEncoding;
import org.openspcoop2.utils.sql.LikeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities {
    private static Logger logger = LoggerFactory.getLogger(ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.class);

    private ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities() {
    }

    static void addSicurezzaMessaggio(ModIProperties modiProperties, ConsoleConfiguration configuration, boolean rest, boolean fruizione, boolean request, boolean casoSpecialeModificaNomeFruizione, boolean digest, String patternDatiCorniceSicurezza, String schemaDatiCorniceSicurezza, boolean headerDuplicati, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDServizio idServizio, IDSoggetto idFruitore, boolean riferimentoX509, boolean kidMode, boolean auditOnly, boolean tokenNonLocale) throws ProtocolException {
        StringConsoleItem jtiItem;
        SubtitleConsoleItem subtitleItem;
        ConsoleItemInfo info;
        StringConsoleItem profiloSicurezzaMessaggioAudienceItem;
        BaseConsoleItem titolo;
        boolean requiredValue;
        boolean bl = requiredValue = !casoSpecialeModificaNomeFruizione;
        if (request) {
            titolo = ProtocolPropertiesFactory.newTitleItem((String)"modipaAPIImplRequestTitleId", (String)"ModI - Richiesta");
            configuration.addConsoleItem(titolo);
            configuration.addConsoleItem(ProtocolPropertiesFactory.newSubTitleItem((String)"modipaAPIImplProfiloSicurezzaRequestSubTitleId", (String)"Sicurezza Messaggio"));
        } else {
            titolo = ProtocolPropertiesFactory.newTitleItem((String)"modipaAPIImplResponseTitleId", (String)"ModI - Risposta");
            configuration.addConsoleItem(titolo);
            configuration.addConsoleItem(ProtocolPropertiesFactory.newSubTitleItem((String)"modipaAPIImplProfiloSicurezzaResponseSubTitleId", (String)"Sicurezza Messaggio"));
        }
        if (rest) {
            ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.addConfigurazioneFirmaRest(modiProperties, configuration, fruizione, request, digest, requiredValue, riferimentoX509);
        } else {
            ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.addConfigurazioneFirmaSoap(modiProperties, configuration, fruizione, request, digest);
        }
        if (fruizione && !request || !fruizione && request) {
            ModIDynamicConfigurationKeystoreUtilities.addTrustStoreCertificatiConfigChoice(configuration, false);
            if (rest) {
                ModIDynamicConfigurationKeystoreUtilities.addTrustStoreSSLConfigChoice(configuration, false);
            }
        }
        if (!fruizione && !request) {
            ModIDynamicConfigurationKeystoreUtilities.addTrustStoreKeystoreErogazioneConfigChoice(configuration);
        } else if (fruizione && request) {
            ModIDynamicConfigurationKeystoreUtilities.addTrustStoreKeystoreFruizioneConfigChoice(configuration, tokenNonLocale);
        }
        String idProfiloSicurezzaMessaggioIatTtlItem = null;
        String idProfiloSicurezzaMessaggioIatTtlSecondsItem = null;
        if (fruizione && !request) {
            idProfiloSicurezzaMessaggioIatTtlItem = "modipaSecurityMessageResponseIatMode";
            idProfiloSicurezzaMessaggioIatTtlSecondsItem = "modipaSecurityMessageResponseIatTtl";
        } else if (!fruizione && request) {
            idProfiloSicurezzaMessaggioIatTtlItem = "modipaSecurityMessageRequestIatMode";
            idProfiloSicurezzaMessaggioIatTtlSecondsItem = "modipaSecurityMessageRequestIatTtl";
        }
        if (idProfiloSicurezzaMessaggioIatTtlItem != null && idProfiloSicurezzaMessaggioIatTtlSecondsItem != null) {
            boolean modeIsDefault = "default".equals("default");
            String labelModeItem = modeIsDefault ? "Time to Live" : "Time to Live (secondi)";
            StringConsoleItem modeItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)idProfiloSicurezzaMessaggioIatTtlItem, (String)labelModeItem);
            modeItem.addLabelValue("Default", (Object)"default");
            modeItem.addLabelValue("Ridefinito", (Object)"ridefinisci");
            modeItem.setDefaultValue((Object)"default");
            modeItem.setReloadOnChange(true, true);
            configuration.addConsoleItem((BaseConsoleItem)modeItem);
            NumberConsoleItem secondsItem = (NumberConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.NUMBER, (ConsoleItemType)ConsoleItemType.NUMBER, (String)idProfiloSicurezzaMessaggioIatTtlSecondsItem, (String)"");
            secondsItem.setNote("I token creati precedentemente all'intervallo temporale indicato, in secondi, verranno rifiutati");
            secondsItem.setDefaultValue((Object)300L);
            secondsItem.setRequired(requiredValue);
            secondsItem.setMin(1);
            if (modeIsDefault) {
                secondsItem.setRequired(false);
                secondsItem.setType(ConsoleItemType.HIDDEN);
            }
            configuration.addConsoleItem((BaseConsoleItem)secondsItem);
        }
        String idProfiloSicurezzaMessaggioExpItem = null;
        if (fruizione && request) {
            idProfiloSicurezzaMessaggioExpItem = "modipaSecurityMessageRequestExp";
        } else if (!fruizione && !request) {
            idProfiloSicurezzaMessaggioExpItem = "modipaSecurityMessageResponseExp";
        }
        if (idProfiloSicurezzaMessaggioExpItem != null) {
            NumberConsoleItem profiloSicurezzaMessaggioTTLItem = (NumberConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.NUMBER, (ConsoleItemType)ConsoleItemType.NUMBER, (String)idProfiloSicurezzaMessaggioExpItem, (String)"Time to Live (secondi)");
            if (fruizione) {
                profiloSicurezzaMessaggioTTLItem.setNote("Indica la validit\u00e0 temporale, in secondi, a partire dalla data di creazione del security token");
            } else {
                profiloSicurezzaMessaggioTTLItem.setNote("Indica la validit\u00e0 temporale, in secondi, a partire dalla data di creazione del security token della risposta");
            }
            profiloSicurezzaMessaggioTTLItem.setDefaultValue((Object)300L);
            profiloSicurezzaMessaggioTTLItem.setRequired(requiredValue);
            profiloSicurezzaMessaggioTTLItem.setMin(1);
            configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioTTLItem);
        }
        if (request) {
            profiloSicurezzaMessaggioAudienceItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_AREA, (String)"modipaSecurityMessageRequestAud", (String)(rest ? "Audience" : "WSAddressing To"));
            profiloSicurezzaMessaggioAudienceItem.setNote(fruizione ? "Indica a chi \u00e8 riferito il security token; se non viene fornito un valore verr\u00e0 utilizzata la url del connettore" : "Se non viene fornito un valore, il valore atteso all'interno del security token corrisponder\u00e0 all'url di invocazione");
            profiloSicurezzaMessaggioAudienceItem.setRows(Integer.valueOf(2));
            if (fruizione) {
                info = new ConsoleItemInfo(rest ? "Audience" : "WSAddressing To");
                info.setHeaderBody("Il valore pu\u00f2 essere definito come costante o contenere parti dinamiche risolte a runtime dal Gateway.<br/>Le espressioni utilizzabili sono:");
                if (rest) {
                    info.setListBody(DynamicHelperCostanti.LABEL_PARAMETRO_MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_AUDIENCE_INFO_VALORI_REQUEST);
                } else {
                    info.setListBody(DynamicHelperCostanti.LABEL_PARAMETRO_MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_SOAP_AUDIENCE_INFO_VALORI_REQUEST);
                }
                profiloSicurezzaMessaggioAudienceItem.setInfo(info);
            }
            configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioAudienceItem);
        } else if (fruizione) {
            profiloSicurezzaMessaggioAudienceItem = (BooleanConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.BOOLEAN, (ConsoleItemType)ConsoleItemType.CHECKBOX, (String)"modipaSecurityMessageResponseAud", (String)(rest ? "Verifica Audience" : "Verifica WSAddressing To"));
            profiloSicurezzaMessaggioAudienceItem.setNote("La verifica utilizza, se configurato, il valore indicato di seguito altrimenti quello configurato nell'applicativo mittente");
            profiloSicurezzaMessaggioAudienceItem.setDefaultValue((Object)true);
            profiloSicurezzaMessaggioAudienceItem.setReloadOnChange(true, true);
            configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioAudienceItem);
            StringConsoleItem audValueItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_AREA, (String)"modipaSecurityMessageResponseAudExpected", (String)"");
            audValueItem.setRows(Integer.valueOf(2));
            ConsoleItemInfo info2 = new ConsoleItemInfo(rest ? "Verifica Audience" : "Verifica WSAddressing To");
            info2.setHeaderBody("Il valore pu\u00f2 essere definito come costante o contenere parti dinamiche risolte a runtime dal Gateway.<br/>Le espressioni utilizzabili sono:");
            if (rest) {
                info2.setListBody(DynamicHelperCostanti.LABEL_PARAMETRO_MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_AUDIENCE_INFO_VALORI_RESPONSE);
            } else {
                info2.setListBody(DynamicHelperCostanti.LABEL_PARAMETRO_MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_SOAP_AUDIENCE_INFO_VALORI_RESPONSE);
            }
            audValueItem.setInfo(info2);
            configuration.addConsoleItem((BaseConsoleItem)audValueItem);
        }
        if (rest && !auditOnly && (request && fruizione || !request && !fruizione)) {
            StringConsoleItem profiloSicurezzaMessaggioRestJwtClaimsItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_AREA, (String)(request && fruizione ? "modipaSecurityMessageRequestClaims" : "modipaSecurityMessageResponseClaims"), (String)"Claims");
            profiloSicurezzaMessaggioRestJwtClaimsItem.setNote("Indicare per riga i claims (nome=valore); visualizzare 'info' per maggiori dettagli");
            info = new ConsoleItemInfo("Claims");
            try {
                info.setHeaderBody(DynamicHelperCostanti.getLABEL_PARAMETRO_MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_JWT_CLAIMS_INFO((boolean)request, modiProperties.getUsedRestSecurityClaims(request, digest)));
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            info.setListBody(request ? DynamicHelperCostanti.LABEL_PARAMETRO_MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_JWT_CLAIMS_INFO_VALORI_REQUEST : DynamicHelperCostanti.LABEL_PARAMETRO_MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_JWT_CLAIMS_INFO_VALORI_RESPONSE);
            profiloSicurezzaMessaggioRestJwtClaimsItem.setInfo(info);
            profiloSicurezzaMessaggioRestJwtClaimsItem.setRows(Integer.valueOf(2));
            configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioRestJwtClaimsItem);
        }
        if (request && patternDatiCorniceSicurezza != null && StringUtils.isNotEmpty((String)patternDatiCorniceSicurezza)) {
            subtitleItem = null;
            if (fruizione || !"old".equals(patternDatiCorniceSicurezza)) {
                subtitleItem = (SubtitleConsoleItem)ProtocolPropertiesFactory.newSubTitleItem((String)"modipaAPIImplProfiloCorniceSicurezzaRequestSubTitleId", (String)"Informazioni Audit");
                subtitleItem.setCloseable(true);
                configuration.addConsoleItem((BaseConsoleItem)subtitleItem);
            }
            String lastItemId = null;
            if (fruizione) {
                lastItemId = "old".equals(patternDatiCorniceSicurezza) ? ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.addCorniceSicurezzaLegacy(configuration, rest) : ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.addCorniceSicurezzaSchema(configuration, rest, schemaDatiCorniceSicurezza, auditOnly);
            } else if (!"old".equals(patternDatiCorniceSicurezza)) {
                lastItemId = ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.addCorniceSicurezzaSchemaAudience(configuration);
            }
            if (subtitleItem != null) {
                subtitleItem.setLastItemId(lastItemId);
            }
        }
        if (rest && headerDuplicati && (request && fruizione || !request && !fruizione)) {
            subtitleItem = (SubtitleConsoleItem)ProtocolPropertiesFactory.newSubTitleItem((String)"modipaSecurityMessageDuplicateHdrSubImbId", (String)"Coesistenza Token Authorization e TEMPLATE".replace("TEMPLATE", modiProperties.getRestSecurityTokenHeaderModI()));
            subtitleItem.setCloseable(true);
            subtitleItem.setLastItemId(request ? "modipaSecurityMessageRequestClaimsModi" : "modipaSecurityMessageResponseClaimsModi");
            configuration.addConsoleItem((BaseConsoleItem)subtitleItem);
            jtiItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)(request ? "modipaSecurityMessageRequestJti" : "modipaSecurityMessageResponseJti"), (String)"Identificativo 'jti'");
            jtiItem.addLabelValue("Stesso identificativo", (Object)"same");
            jtiItem.addLabelValue("Differente identificativo", (Object)"different");
            jtiItem.setDefaultValue((Object)"same");
            jtiItem.setUseDefaultValueForCloseableSection(true);
            jtiItem.setReloadOnChange(true, true);
            configuration.addConsoleItem((BaseConsoleItem)jtiItem);
            StringConsoleItem jtiAsIdMessaggioItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)(request ? "modipaSecurityMessageRequestJtiIdMsg" : "modipaSecurityMessageResponseJtiIdMsg"), (String)"Usa come ID Messaggio");
            jtiAsIdMessaggioItem.addLabelValue("Authorization", (Object)"auth");
            jtiAsIdMessaggioItem.addLabelValue("TEMPLATE".replace("TEMPLATE", modiProperties.getRestSecurityTokenHeaderModI()), (Object)"modi");
            jtiAsIdMessaggioItem.setDefaultValue((Object)"modi");
            if ("same".equals("same")) {
                jtiAsIdMessaggioItem.setType(ConsoleItemType.HIDDEN);
            } else {
                jtiAsIdMessaggioItem.setUseDefaultValueForCloseableSection(true);
            }
            configuration.addConsoleItem((BaseConsoleItem)jtiAsIdMessaggioItem);
            if (request && fruizione) {
                StringConsoleItem audItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaSecurityMessageRequestIntegrityAudMode", (String)"Audience");
                audItem.addLabelValue("Stesso identificativo", (Object)"same");
                audItem.addLabelValue("Differente identificativo", (Object)"different");
                audItem.setDefaultValue((Object)"same");
                audItem.setUseDefaultValueForCloseableSection(true);
                audItem.setReloadOnChange(true, true);
                configuration.addConsoleItem((BaseConsoleItem)audItem);
                StringConsoleItem audValueItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_AREA, (String)"modipaSecurityMessageRequestIntegrityAud", (String)"");
                audValueItem.setRows(Integer.valueOf(2));
                if ("same".equals("same")) {
                    audValueItem.setType(ConsoleItemType.HIDDEN);
                } else {
                    audValueItem.setRequired(true);
                }
                configuration.addConsoleItem((BaseConsoleItem)audValueItem);
            }
            StringConsoleItem authorizationClaimsItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_AREA, (String)(request ? "modipaSecurityMessageRequestClaimsAuth" : "modipaSecurityMessageResponseClaimsAuth"), (String)"Claims 'Authorization'");
            authorizationClaimsItem.setNote("");
            ConsoleItemInfo infoAuthorization = new ConsoleItemInfo("Claims 'Authorization'");
            try {
                infoAuthorization.setHeaderBody(DynamicHelperCostanti.getLABEL_PARAMETRO_MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_JWT_CLAIMS_INFO((boolean)request, modiProperties.getUsedRestSecurityClaims(request, digest)));
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            infoAuthorization.setListBody(request ? DynamicHelperCostanti.LABEL_PARAMETRO_MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_JWT_CLAIMS_INFO_VALORI_REQUEST : DynamicHelperCostanti.LABEL_PARAMETRO_MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_JWT_CLAIMS_INFO_VALORI_RESPONSE);
            authorizationClaimsItem.setInfo(infoAuthorization);
            authorizationClaimsItem.setRows(Integer.valueOf(2));
            authorizationClaimsItem.setDefaultValue((Object)"");
            authorizationClaimsItem.setUseDefaultValueForCloseableSection(true);
            configuration.addConsoleItem((BaseConsoleItem)authorizationClaimsItem);
            StringConsoleItem modiClaimsItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_AREA, (String)(request ? "modipaSecurityMessageRequestClaimsModi" : "modipaSecurityMessageResponseClaimsModi"), (String)"Claims 'TEMPLATE'".replace("TEMPLATE", modiProperties.getRestSecurityTokenHeaderModI()));
            modiClaimsItem.setNote("Indicare per riga i claims (nome=valore); visualizzare 'info' per maggiori dettagli");
            ConsoleItemInfo infoModi = new ConsoleItemInfo("Claims 'TEMPLATE'".replace("TEMPLATE", modiProperties.getRestSecurityTokenHeaderModI()));
            try {
                infoModi.setHeaderBody(DynamicHelperCostanti.getLABEL_PARAMETRO_MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_JWT_CLAIMS_INFO((boolean)request, modiProperties.getUsedRestSecurityClaims(request, digest)));
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            infoModi.setListBody(request ? DynamicHelperCostanti.LABEL_PARAMETRO_MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_JWT_CLAIMS_INFO_VALORI_REQUEST : DynamicHelperCostanti.LABEL_PARAMETRO_MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_JWT_CLAIMS_INFO_VALORI_RESPONSE);
            modiClaimsItem.setInfo(infoModi);
            modiClaimsItem.setRows(Integer.valueOf(2));
            modiClaimsItem.setDefaultValue((Object)"");
            modiClaimsItem.setUseDefaultValueForCloseableSection(true);
            configuration.addConsoleItem((BaseConsoleItem)modiClaimsItem);
        }
        if (rest && headerDuplicati && (!request && fruizione || request && !fruizione)) {
            subtitleItem = (SubtitleConsoleItem)ProtocolPropertiesFactory.newSubTitleItem((String)"modipaSecurityMessageDuplicateHdrSubValId", (String)"Coesistenza Token Authorization e TEMPLATE".replace("TEMPLATE", modiProperties.getRestSecurityTokenHeaderModI()));
            subtitleItem.setCloseable(true);
            if (request) {
                subtitleItem.setLastItemId("modipaSecurityMessageRequestIntegrityAudMode");
            } else {
                subtitleItem.setLastItemId("modipaSecurityMessageResponseIntegrityAudMode");
            }
            configuration.addConsoleItem((BaseConsoleItem)subtitleItem);
            jtiItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)(request ? "modipaSecurityMessageRequestDuplicateJti" : "modipaSecurityMessageResponseDuplicateJti"), (String)"Id 'jti' per Filtro Duplicati");
            jtiItem.addLabelValue("Authorization", (Object)"auth");
            jtiItem.addLabelValue("TEMPLATE".replace("TEMPLATE", modiProperties.getRestSecurityTokenHeaderModI()), (Object)"modi");
            jtiItem.setDefaultValue((Object)"modi");
            jtiItem.setUseDefaultValueForCloseableSection(true);
            configuration.addConsoleItem((BaseConsoleItem)jtiItem);
            StringConsoleItem audItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)(request ? "modipaSecurityMessageRequestIntegrityAudMode" : "modipaSecurityMessageResponseIntegrityAudMode"), (String)"Audience");
            audItem.addLabelValue("Stesso identificativo", (Object)"same");
            audItem.addLabelValue("Differente identificativo", (Object)"different");
            audItem.setDefaultValue((Object)"same");
            audItem.setUseDefaultValueForCloseableSection(true);
            audItem.setReloadOnChange(true, true);
            configuration.addConsoleItem((BaseConsoleItem)audItem);
            StringConsoleItem audValueItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_AREA, (String)(request ? "modipaSecurityMessageRequestIntegrityAud" : "modipaSecurityMessageResponseIntegrityAud"), (String)"");
            audValueItem.setRows(Integer.valueOf(2));
            if ("same".equals("same")) {
                audValueItem.setType(ConsoleItemType.HIDDEN);
            } else {
                audValueItem.setRequired(true);
            }
            ConsoleItemInfo info3 = new ConsoleItemInfo("Audience");
            info3.setHeaderBody("Il valore pu\u00f2 essere definito come costante o contenere parti dinamiche risolte a runtime dal Gateway.<br/>Le espressioni utilizzabili sono:");
            info3.setListBody(DynamicHelperCostanti.LABEL_PARAMETRO_MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_AUDIENCE_INFO_VALORI_RESPONSE);
            audValueItem.setInfo(info3);
            configuration.addConsoleItem((BaseConsoleItem)audValueItem);
        }
        if (!headerDuplicati && tokenNonLocale && request && !fruizione) {
            String labelSub = null;
            labelSub = rest ? "Coesistenza Token Authorization e TEMPLATE".replace("TEMPLATE", modiProperties.getRestSecurityTokenHeaderModI()) : "Coesistenza Token Authorization e Integrity";
            SubtitleConsoleItem subtitleItem2 = (SubtitleConsoleItem)ProtocolPropertiesFactory.newSubTitleItem((String)"modipaSecurityMessageDuplicateHdrSubValId", (String)labelSub);
            subtitleItem2.setCloseable(true);
            subtitleItem2.setLastItemId("modipaSecurityMessageRequestDuplicateJti");
            configuration.addConsoleItem((BaseConsoleItem)subtitleItem2);
            StringConsoleItem jtiItem2 = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaSecurityMessageRequestDuplicateJti", (String)"Id 'jti' per Filtro Duplicati");
            jtiItem2.addLabelValue("Authorization", (Object)"auth");
            jtiItem2.addLabelValue("TEMPLATE".replace("TEMPLATE", modiProperties.getRestSecurityTokenHeaderModI()), (Object)"modi");
            jtiItem2.setDefaultValue((Object)"modi");
            jtiItem2.setUseDefaultValueForCloseableSection(true);
            configuration.addConsoleItem((BaseConsoleItem)jtiItem2);
        }
        if (fruizione && request) {
            boolean sicurezzaMessaggioPresente = true;
            ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.addSicurezzaTokenSignedJWT(rest, configuration, consoleOperationType, consoleHelper, registryReader, configIntegrationReader, idServizio, idFruitore, sicurezzaMessaggioPresente);
        }
        if (fruizione && !request || !fruizione && request) {
            ModIDynamicConfigurationKeystoreUtilities.addTrustStoreConfigSubSection(configuration, false, false);
            if (rest) {
                ModIDynamicConfigurationKeystoreUtilities.addTrustStoreConfigSubSection(configuration, true, false);
            }
        }
        if (!fruizione && !request) {
            ModIDynamicConfigurationKeystoreUtilities.addKeystoreConfig(configuration, true, false, requiredValue);
            boolean sicurezzaMessaggioPresente = true;
            if (rest && kidMode) {
                ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.addSicurezzaOAuth(rest, configuration, consoleOperationType, consoleHelper, registryReader, configIntegrationReader, idServizio, sicurezzaMessaggioPresente);
            }
        }
        if (fruizione && request) {
            ModIDynamicConfigurationKeystoreUtilities.addKeystoreConfig(configuration, true, false, requiredValue);
        }
    }

    private static String addCorniceSicurezzaSchema(ConsoleConfiguration configuration, boolean rest, String schemaDatiCorniceSicurezza, boolean auditOnly) throws ProtocolException {
        String lastItemModeId = null;
        List<ModIAuditConfig> list = ModIProperties.getInstance().getAuditConfig();
        if (list != null && !list.isEmpty()) {
            for (ModIAuditConfig modIAuditConfig : list) {
                if (!modIAuditConfig.getNome().equals(schemaDatiCorniceSicurezza)) continue;
                lastItemModeId = ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.addCorniceSicurezzaSchema(configuration, rest, modIAuditConfig, auditOnly);
                break;
            }
        }
        return lastItemModeId;
    }

    private static String addCorniceSicurezzaSchemaAudience(ConsoleConfiguration configuration) throws ProtocolException {
        String id = "modipaSecurityMessageRequestAuditAudMode";
        StringConsoleItem audItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)id, (String)"Audience");
        audItem.addLabelValue("Stesso identificativo", (Object)"same");
        audItem.addLabelValue("Differente identificativo", (Object)"different");
        audItem.setDefaultValue((Object)"same");
        audItem.setUseDefaultValueForCloseableSection(true);
        audItem.setReloadOnChange(true, true);
        configuration.addConsoleItem((BaseConsoleItem)audItem);
        StringConsoleItem audValueItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_AREA, (String)"modipaSecurityMessageRequestAuditAud", (String)"");
        audValueItem.setRows(Integer.valueOf(2));
        if ("same".equals("same")) {
            audValueItem.setType(ConsoleItemType.HIDDEN);
        } else {
            audValueItem.setRequired(true);
        }
        configuration.addConsoleItem((BaseConsoleItem)audValueItem);
        return id;
    }

    private static String addCorniceSicurezzaSchema(ConsoleConfiguration configuration, boolean rest, ModIAuditConfig modIAuditConfig, boolean auditOnly) throws ProtocolException {
        String lastItemModeId = null;
        if (modIAuditConfig.getClaims() != null && !modIAuditConfig.getClaims().isEmpty()) {
            if (!auditOnly) {
                ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.addCorniceSicurezzaSchemaAudience(configuration);
            }
            for (ModIAuditClaimConfig claimConfig : modIAuditConfig.getClaims()) {
                lastItemModeId = ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.addCorniceSicurezzaSchemaItem(configuration, claimConfig, rest);
            }
        }
        return lastItemModeId;
    }

    private static String addCorniceSicurezzaSchemaItem(ConsoleConfiguration configuration, ModIAuditClaimConfig claimConfig, boolean rest) throws ProtocolException {
        String modeId = "modipaSecurityMessageCorniceSicurezzaSchemaMode" + claimConfig.getNome();
        StringConsoleItem modeItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)modeId, (String)claimConfig.getLabel());
        modeItem.addLabelValue("Default", (Object)"default");
        modeItem.addLabelValue("Ridefinito", (Object)"ridefinisci");
        modeItem.setDefaultValue((Object)"default");
        modeItem.setUseDefaultValueForCloseableSection(true);
        modeItem.setReloadOnChange(true, true);
        configuration.addConsoleItem((BaseConsoleItem)modeItem);
        StringConsoleItem ridefineItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_AREA, (String)("modipaSecurityMessageCorniceSicurezzaSchemaValue" + claimConfig.getNome()), (String)"");
        ridefineItem.setRequired(true);
        ridefineItem.setRows(Integer.valueOf(2));
        ridefineItem.setInfo(ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.buildConsoleItemInfoCorniceSicurezza("Codice Ente", rest));
        if ("default".equals("default")) {
            ridefineItem.setType(ConsoleItemType.HIDDEN);
        }
        configuration.addConsoleItem((BaseConsoleItem)ridefineItem);
        return modeId;
    }

    static String addCorniceSicurezzaLegacy(ConsoleConfiguration configuration, boolean rest) throws ProtocolException {
        StringConsoleItem modeCodiceEnteItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaSecurityMessageCorniceSicurezzaCodiceEnteMode", (String)"Codice Ente");
        modeCodiceEnteItem.addLabelValue("Default", (Object)"default");
        modeCodiceEnteItem.addLabelValue("Ridefinito", (Object)"ridefinisci");
        modeCodiceEnteItem.setDefaultValue((Object)"default");
        modeCodiceEnteItem.setUseDefaultValueForCloseableSection(true);
        modeCodiceEnteItem.setReloadOnChange(true, true);
        configuration.addConsoleItem((BaseConsoleItem)modeCodiceEnteItem);
        StringConsoleItem profiloSicurezzaMessaggioCorniceCodiceEnteItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_AREA, (String)"modipaSecurityMessageCorniceSicurezzaCodiceEnte", (String)"");
        profiloSicurezzaMessaggioCorniceCodiceEnteItem.setRequired(true);
        profiloSicurezzaMessaggioCorniceCodiceEnteItem.setRows(Integer.valueOf(2));
        profiloSicurezzaMessaggioCorniceCodiceEnteItem.setInfo(ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.buildConsoleItemInfoCorniceSicurezza("Codice Ente", rest));
        if ("default".equals("default")) {
            profiloSicurezzaMessaggioCorniceCodiceEnteItem.setType(ConsoleItemType.HIDDEN);
        }
        configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioCorniceCodiceEnteItem);
        StringConsoleItem modeUserItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaSecurityMessageCorniceSicurezzaUserMode", (String)"UserID Utente");
        modeUserItem.addLabelValue("Default", (Object)"default");
        modeUserItem.addLabelValue("Ridefinito", (Object)"ridefinisci");
        modeUserItem.setDefaultValue((Object)"default");
        modeUserItem.setUseDefaultValueForCloseableSection(true);
        modeUserItem.setReloadOnChange(true, true);
        configuration.addConsoleItem((BaseConsoleItem)modeUserItem);
        StringConsoleItem profiloSicurezzaMessaggioCorniceUserItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_AREA, (String)"modipaSecurityMessageCorniceSicurezzaUser", (String)"");
        profiloSicurezzaMessaggioCorniceUserItem.setRequired(true);
        profiloSicurezzaMessaggioCorniceUserItem.setRows(Integer.valueOf(2));
        profiloSicurezzaMessaggioCorniceUserItem.setInfo(ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.buildConsoleItemInfoCorniceSicurezza("UserID Utente", rest));
        if ("default".equals("default")) {
            profiloSicurezzaMessaggioCorniceUserItem.setType(ConsoleItemType.HIDDEN);
        }
        configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioCorniceUserItem);
        StringConsoleItem modeIPUserItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaSecurityMessageCorniceSicurezzaIPUserMode", (String)"Indirizzo IP Utente");
        modeIPUserItem.addLabelValue("Default", (Object)"default");
        modeIPUserItem.addLabelValue("Ridefinito", (Object)"ridefinisci");
        modeIPUserItem.setDefaultValue((Object)"default");
        modeIPUserItem.setUseDefaultValueForCloseableSection(true);
        modeIPUserItem.setReloadOnChange(true, true);
        configuration.addConsoleItem((BaseConsoleItem)modeIPUserItem);
        StringConsoleItem profiloSicurezzaMessaggioCorniceIPUserItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_AREA, (String)"modipaSecurityMessageCorniceSicurezzaIPUser", (String)"");
        profiloSicurezzaMessaggioCorniceIPUserItem.setRequired(true);
        profiloSicurezzaMessaggioCorniceIPUserItem.setRows(Integer.valueOf(2));
        profiloSicurezzaMessaggioCorniceIPUserItem.setInfo(ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.buildConsoleItemInfoCorniceSicurezza("Indirizzo IP Utente", rest));
        if ("default".equals("default")) {
            profiloSicurezzaMessaggioCorniceIPUserItem.setType(ConsoleItemType.HIDDEN);
        }
        configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioCorniceIPUserItem);
        return "modipaSecurityMessageCorniceSicurezzaIPUserMode";
    }

    static boolean addSicurezzaTokenSignedJWT(boolean rest, ConsoleConfiguration configuration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDServizio idServizio, IDSoggetto idFruitore, boolean sicurezzaMessaggioPresente) throws ProtocolException {
        if (registryReader != null && configIntegrationReader != null) {
            boolean tokenSignedJWT = false;
            boolean pdnd = false;
            if (ConsoleOperationType.ADD.equals((Object)consoleOperationType)) {
                String tokenPolicyViaAPI = null;
                try {
                    tokenPolicyViaAPI = consoleHelper.getParameter("connettore_token_policy_via_api");
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
                if (tokenPolicyViaAPI != null && StringUtils.isNotEmpty((String)tokenPolicyViaAPI) && !"-".equals(tokenPolicyViaAPI)) {
                    tokenSignedJWT = ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.isTokenPolicySignedJWT(configIntegrationReader, tokenPolicyViaAPI);
                    if (tokenSignedJWT) {
                        pdnd = ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.isTokenPolicyPdnd(configIntegrationReader, tokenPolicyViaAPI);
                    }
                } else {
                    String tokenPolicyStato = null;
                    try {
                        tokenPolicyStato = consoleHelper.getParameter("connettore_token_policy_stat");
                    }
                    catch (Exception e) {
                        throw new ProtocolException(e.getMessage(), (Throwable)e);
                    }
                    if (ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.isEnabled(tokenPolicyStato)) {
                        String tokenPolicy = null;
                        try {
                            tokenPolicy = consoleHelper.getParameter("connettore_token_policy");
                        }
                        catch (Exception e) {
                            throw new ProtocolException(e.getMessage(), (Throwable)e);
                        }
                        if (tokenPolicy != null && StringUtils.isNotEmpty((String)tokenPolicy) && !"-".equals(tokenPolicy) && (tokenSignedJWT = ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.isTokenPolicySignedJWT(configIntegrationReader, tokenPolicy))) {
                            pdnd = ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.isTokenPolicyPdnd(configIntegrationReader, tokenPolicy);
                        }
                    }
                }
            } else if (idServizio != null && idFruitore != null) {
                try {
                    AccordoServizioParteSpecifica asps = registryReader.getAccordoServizioParteSpecifica(idServizio, false);
                    if (asps != null && asps.sizeFruitoreList() > 0) {
                        for (Fruitore fruitore : asps.getFruitoreList()) {
                            IDSoggetto check;
                            if (fruitore == null || !idFruitore.equals((Object)(check = new IDSoggetto(fruitore.getTipo(), fruitore.getNome())))) continue;
                            if (fruitore.getConnettore() != null && !TipiConnettore.DISABILITATO.getNome().equals(fruitore.getConnettore().getTipo()) && fruitore.getConnettore().sizePropertyList() > 0) {
                                for (Property p : fruitore.getConnettore().getPropertyList()) {
                                    String tokenPolicy;
                                    if (!"tokenPolicy".equals(p.getNome()) || (tokenPolicy = p.getValore()) == null || !StringUtils.isNotEmpty((String)tokenPolicy) || "-".equals(tokenPolicy)) continue;
                                    if (!tokenSignedJWT) {
                                        tokenSignedJWT = ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.isTokenPolicySignedJWT(configIntegrationReader, tokenPolicy);
                                    }
                                    if (!tokenSignedJWT || pdnd) continue;
                                    pdnd = ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.isTokenPolicyPdnd(configIntegrationReader, tokenPolicy);
                                }
                            }
                            if (fruitore.getConfigurazioneAzioneList() == null || fruitore.getConfigurazioneAzioneList().isEmpty()) continue;
                            for (ConfigurazioneServizioAzione csa : fruitore.getConfigurazioneAzioneList()) {
                                if (csa == null || csa.getConnettore() == null || TipiConnettore.DISABILITATO.getNome().equals(csa.getConnettore().getTipo()) || csa.getConnettore().sizePropertyList() <= 0) continue;
                                for (Property p : csa.getConnettore().getPropertyList()) {
                                    String tokenPolicy;
                                    if (!"tokenPolicy".equals(p.getNome()) || (tokenPolicy = p.getValore()) == null || !StringUtils.isNotEmpty((String)tokenPolicy) || "-".equals(tokenPolicy)) continue;
                                    if (!tokenSignedJWT) {
                                        tokenSignedJWT = ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.isTokenPolicySignedJWT(configIntegrationReader, tokenPolicy);
                                    }
                                    if (!tokenSignedJWT || pdnd) continue;
                                    pdnd = ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.isTokenPolicyPdnd(configIntegrationReader, tokenPolicy);
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if (tokenSignedJWT) {
                ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.addSicurezzaOAuth(rest, configuration, pdnd, sicurezzaMessaggioPresente, true);
            }
            return tokenSignedJWT;
        }
        return false;
    }

    private static void addSicurezzaOAuth(boolean rest, ConsoleConfiguration configuration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDServizio idServizio, boolean sicurezzaMessaggioPresente) throws ProtocolException {
        if (registryReader != null && configIntegrationReader != null) {
            boolean pdnd = false;
            if (ConsoleOperationType.ADD.equals((Object)consoleOperationType)) {
                String tokenPolicy = null;
                try {
                    tokenPolicy = consoleHelper.getParameter("gtPolicy");
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
                if (tokenPolicy != null && StringUtils.isNotEmpty((String)tokenPolicy) && !"-".equals(tokenPolicy)) {
                    pdnd = ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.isTokenPolicyErogazionePDND(tokenPolicy);
                }
            } else {
                pdnd = ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.isTokenPolicyErogazionePDNDChangeOperation(registryReader, configIntegrationReader, idServizio);
            }
            ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.addSicurezzaOAuth(rest, configuration, pdnd, sicurezzaMessaggioPresente, false);
        }
    }

    private static boolean isTokenPolicyErogazionePDNDChangeOperation(IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDServizio idServizio) throws ProtocolException {
        if (idServizio != null) {
            try {
                AccordoServizioParteSpecifica asps = registryReader.getAccordoServizioParteSpecifica(idServizio, false);
                if (asps != null) {
                    List list = configIntegrationReader.getMappingErogazionePortaApplicativaList(idServizio);
                    return ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.isTokenPolicyErogazionePDNDChangeOperation(list, configIntegrationReader);
                }
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    private static boolean isTokenPolicyErogazionePDNDChangeOperation(List<MappingErogazionePortaApplicativa> list, IConfigIntegrationReader configIntegrationReader) throws RegistryNotFound, RegistryException {
        if (list != null && !list.isEmpty()) {
            for (MappingErogazionePortaApplicativa mappingErogazionePortaApplicativa : list) {
                boolean pdnd;
                PortaApplicativa pa = configIntegrationReader.getPortaApplicativa(mappingErogazionePortaApplicativa.getIdPortaApplicativa());
                if (pa == null || pa.getGestioneToken() == null || pa.getGestioneToken().getPolicy() == null || !(pdnd = ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.isTokenPolicyErogazionePDND(pa.getGestioneToken().getPolicy()))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isTokenPolicyErogazionePDND(String tokenPolicy) {
        if (tokenPolicy != null && StringUtils.isNotEmpty((String)tokenPolicy) && !"-".equals(tokenPolicy)) {
            return tokenPolicy.toLowerCase().contains("pdnd");
        }
        return false;
    }

    private static void addSicurezzaOAuth(boolean rest, ConsoleConfiguration configuration, boolean pdnd, boolean sicurezzaMessaggioPresente, boolean section) throws ProtocolException {
        if (section) {
            String label;
            if (sicurezzaMessaggioPresente) {
                label = pdnd ? "Authorization PDND" : "Authorization OAuth";
                SubtitleConsoleItem subtitleItem = (SubtitleConsoleItem)ProtocolPropertiesFactory.newSubTitleItem((String)"modipaSecurityMessageOauthSubId", (String)label);
                subtitleItem.setCloseable(true);
                subtitleItem.setLastItemId("modipaSecurityOauthId");
                configuration.addConsoleItem((BaseConsoleItem)subtitleItem);
            } else {
                label = pdnd ? "ModI - Authorization PDND" : "ModI - Authorization OAuth";
                BaseConsoleItem titolo = ProtocolPropertiesFactory.newTitleItem((String)"modipaAPIImplOauthTitleId", (String)label);
                configuration.addConsoleItem(titolo);
            }
        }
        StringConsoleItem profiloSicurezzaOauthKidItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_AREA, (String)"modipaSecurityOauthKid", (String)"Key Id (kid) del Certificato");
        profiloSicurezzaOauthKidItem.setRows(Integer.valueOf(1));
        ConsoleItemInfo info = new ConsoleItemInfo("Key Id (kid) del Certificato");
        info.setHeaderBody("Il valore pu\u00f2 essere definito come costante o contenere parti dinamiche risolte a runtime dal Gateway.<br/>Le espressioni utilizzabili sono:");
        if (rest) {
            info.setListBody(DynamicHelperCostanti.LABEL_PARAMETRO_MODIPA_API_IMPL_PROFILO_SICUREZZA_OAUTH_REST_INFO_VALORI_REQUEST);
        } else {
            info.setListBody(DynamicHelperCostanti.LABEL_PARAMETRO_MODIPA_API_IMPL_PROFILO_SICUREZZA_OAUTH_SOAP_INFO_VALORI_REQUEST);
        }
        profiloSicurezzaOauthKidItem.setInfo(info);
        if (sicurezzaMessaggioPresente && section) {
            profiloSicurezzaOauthKidItem.setDefaultValue((Object)"");
            profiloSicurezzaOauthKidItem.setUseDefaultValueForCloseableSection(true);
        }
        configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaOauthKidItem);
        StringConsoleItem profiloSicurezzaOauthIdentificativoItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_AREA, (String)"modipaSecurityOauthId", (String)"Identificativo");
        profiloSicurezzaOauthIdentificativoItem.setRows(Integer.valueOf(1));
        info = new ConsoleItemInfo("Identificativo");
        info.setHeaderBody("Il valore pu\u00f2 essere definito come costante o contenere parti dinamiche risolte a runtime dal Gateway.<br/>Le espressioni utilizzabili sono:");
        if (rest) {
            info.setListBody(DynamicHelperCostanti.LABEL_PARAMETRO_MODIPA_API_IMPL_PROFILO_SICUREZZA_OAUTH_REST_INFO_VALORI_REQUEST);
        } else {
            info.setListBody(DynamicHelperCostanti.LABEL_PARAMETRO_MODIPA_API_IMPL_PROFILO_SICUREZZA_OAUTH_SOAP_INFO_VALORI_REQUEST);
        }
        profiloSicurezzaOauthIdentificativoItem.setInfo(info);
        if (sicurezzaMessaggioPresente && section) {
            profiloSicurezzaOauthIdentificativoItem.setDefaultValue((Object)"");
            profiloSicurezzaOauthIdentificativoItem.setUseDefaultValueForCloseableSection(true);
        }
        configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaOauthIdentificativoItem);
    }

    static boolean isTokenPolicySignedJWT(IConfigIntegrationReader configIntegrationReader, String tokenPolicy) throws ProtocolException {
        return ModIPropertiesUtils.isTokenPolicySignedJWT(configIntegrationReader, tokenPolicy);
    }

    static boolean isTokenPolicyPdnd(IConfigIntegrationReader configIntegrationReader, String tokenPolicy) throws ProtocolException {
        return ModIPropertiesUtils.isTokenPolicyPdnd(configIntegrationReader, tokenPolicy);
    }

    private static boolean isEnabled(String v) {
        return "true".equals(v) || "yes".equals(v);
    }

    static ConsoleItemInfo buildConsoleItemInfoCorniceSicurezza(String intestazione, boolean rest) {
        try {
            ConsoleItemInfo c = new ConsoleItemInfo(intestazione);
            c.setHeaderBody("Il valore pu\u00f2 essere definito come costante o contenere parti dinamiche risolte a runtime dal Gateway.<br/>Le espressioni utilizzabili sono:");
            boolean modi = true;
            boolean fruizione = false;
            boolean forceNoSecToken = true;
            if (rest) {
                c.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_TRASFORMAZIONI_TRASPORTO_REST_VALORI((boolean)modi, (boolean)fruizione, (boolean)forceNoSecToken));
            } else {
                c.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_TRASFORMAZIONI_TRASPORTO_SOAP_VALORI((boolean)modi, (boolean)fruizione, (boolean)forceNoSecToken));
            }
            return c;
        }
        catch (Exception t) {
            try {
                LoggerWrapperFactory.getLogger((String)"govwayConsole.core").error(t.getMessage(), (Throwable)t);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    static void addConfigurazioneFirmaRest(ModIProperties modiProperties, ConsoleConfiguration configuration, boolean fruizione, boolean request, boolean digest, boolean requiredValue, boolean riferimentoX509) throws ProtocolException {
        String idProfiloSicurezzaMessaggioAlgItem = null;
        if (fruizione && request) {
            idProfiloSicurezzaMessaggioAlgItem = "modipaSecurityMessageRestRequestAlg";
        } else if (!fruizione && !request) {
            idProfiloSicurezzaMessaggioAlgItem = "modipaSecurityMessageRestResponseAlg";
        }
        if (idProfiloSicurezzaMessaggioAlgItem != null) {
            StringConsoleItem profiloSicurezzaMessaggioAlgItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)idProfiloSicurezzaMessaggioAlgItem, (String)"Algoritmo");
            profiloSicurezzaMessaggioAlgItem.addLabelValue(ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_VALUE_RS256, (Object)ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_VALUE_RS256);
            profiloSicurezzaMessaggioAlgItem.addLabelValue(ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_VALUE_RS384, (Object)ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_VALUE_RS384);
            profiloSicurezzaMessaggioAlgItem.addLabelValue(ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_VALUE_RS512, (Object)ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_VALUE_RS512);
            profiloSicurezzaMessaggioAlgItem.addLabelValue(ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_VALUE_ES256, (Object)ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_VALUE_ES256);
            profiloSicurezzaMessaggioAlgItem.addLabelValue(ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_VALUE_ES384, (Object)ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_VALUE_ES384);
            profiloSicurezzaMessaggioAlgItem.addLabelValue(ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_VALUE_ES512, (Object)ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_VALUE_ES512);
            profiloSicurezzaMessaggioAlgItem.setDefaultValue((Object)ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_ALG_DEFAULT_VALUE);
            configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioAlgItem);
        }
        if (digest) {
            String idProfiloSicurezzaMessaggioDigestEncodingItem = null;
            if (fruizione && request) {
                idProfiloSicurezzaMessaggioDigestEncodingItem = "modipaSecurityMessageRestRequestDigestEncoding";
            } else if (!fruizione && !request) {
                idProfiloSicurezzaMessaggioDigestEncodingItem = "modipaSecurityMessageRestResponseDigestEncoding";
            }
            if (idProfiloSicurezzaMessaggioDigestEncodingItem != null) {
                StringConsoleItem profiloSicurezzaMessaggioDigestEncodingItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)idProfiloSicurezzaMessaggioDigestEncodingItem, (String)"Codifica Digest");
                profiloSicurezzaMessaggioDigestEncodingItem.addLabelValue("Base64", (Object)ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_DIGEST_ENCODING_VALUE_BASE64);
                profiloSicurezzaMessaggioDigestEncodingItem.addLabelValue("Hex", (Object)ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_REST_DIGEST_ENCODING_VALUE_HEX);
                try {
                    profiloSicurezzaMessaggioDigestEncodingItem.setDefaultValue((Object)modiProperties.getRestSecurityTokenDigestDefaultEncoding().name());
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
                profiloSicurezzaMessaggioDigestEncodingItem.setType(ConsoleItemType.HIDDEN);
                configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioDigestEncodingItem);
            }
        }
        if (digest && (request && fruizione || !request && !fruizione)) {
            StringConsoleItem profiloSicurezzaMessaggioHttpHeadersItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TAGS, (String)"modipaSecurityMessageHttpHeaders", (String)"HTTP Headers da firmare");
            try {
                profiloSicurezzaMessaggioHttpHeadersItem.setDefaultValue((Object)modiProperties.getRestSecurityTokenSignedHeadersAsString());
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            profiloSicurezzaMessaggioHttpHeadersItem.setRequired(true);
            configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioHttpHeadersItem);
        }
        if (!request && riferimentoX509) {
            StringConsoleItem profiloSicurezzaMessaggioRifX509AsRequestItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaSecurityMessageRestResponseX509CertAsReq", (String)"Riferimento X.509");
            profiloSicurezzaMessaggioRifX509AsRequestItem.addLabelValue("Utilizza impostazioni della Richiesta", (Object)"true");
            profiloSicurezzaMessaggioRifX509AsRequestItem.addLabelValue("Ridefinisci", (Object)"false");
            profiloSicurezzaMessaggioRifX509AsRequestItem.setDefaultValue((Object)"true");
            profiloSicurezzaMessaggioRifX509AsRequestItem.setReloadOnChange(true, true);
            configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioRifX509AsRequestItem);
        }
        if (riferimentoX509) {
            String rifX509Id = request ? "modipaSecurityMessageRestRequestX509Cert" : "modipaSecurityMessageRestResponseX509Cert";
            StringConsoleItem profiloSicurezzaMessaggioRifX509Item = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.MULTI_SELECT, (String)rifX509Id, (String)(request ? "Riferimento X.509" : ""));
            profiloSicurezzaMessaggioRifX509Item.setRows(Integer.valueOf(3));
            profiloSicurezzaMessaggioRifX509Item.addLabelValue("x5c (Certificate)", (Object)"x5c");
            profiloSicurezzaMessaggioRifX509Item.addLabelValue("x5t#256 (Certificate SHA-256 Thumbprint)", (Object)"x5t");
            profiloSicurezzaMessaggioRifX509Item.addLabelValue("URL (x5u)", (Object)"x5u");
            ArrayList<String> profiloSicurezzaMessaggioRifX509ItemDefault = new ArrayList<String>();
            profiloSicurezzaMessaggioRifX509ItemDefault.add("x5c");
            profiloSicurezzaMessaggioRifX509ItemDefault.add("x5t");
            ProtocolPropertiesUtils.setDefaultValueMultiSelect(profiloSicurezzaMessaggioRifX509ItemDefault, (StringConsoleItem)profiloSicurezzaMessaggioRifX509Item);
            profiloSicurezzaMessaggioRifX509Item.setReloadOnChange(true, true);
            configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioRifX509Item);
            String rifX509Xc5ChainId = null;
            if (fruizione && request) {
                rifX509Xc5ChainId = "modipaSecurityMessageRestRequestX509CertUseCertificateChain";
            } else if (!fruizione && !request) {
                rifX509Xc5ChainId = "modipaSecurityMessageRestResponseX509CertUseCertificateChain";
            }
            if (rifX509Xc5ChainId != null) {
                BooleanConsoleItem profiloSicurezzaMessaggioRifX509ItemX5CSingleCertificate = (BooleanConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.BOOLEAN, (ConsoleItemType)ConsoleItemType.CHECKBOX, (String)rifX509Xc5ChainId, (String)"Certificate Chain");
                profiloSicurezzaMessaggioRifX509ItemX5CSingleCertificate.setDefaultValue((Object)false);
                configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioRifX509ItemX5CSingleCertificate);
            }
        }
        String idUrl = null;
        if (fruizione && request) {
            idUrl = "modipaSecurityMessageRestRequestX509Url";
        } else if (!fruizione && !request) {
            idUrl = "modipaSecurityMessageRestResponseX509Url";
        }
        if (idUrl != null) {
            StringConsoleItem profiloSicurezzaMessaggioX5UItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_AREA, (String)idUrl, (String)"URL (x5u)");
            profiloSicurezzaMessaggioX5UItem.setRows(Integer.valueOf(2));
            profiloSicurezzaMessaggioX5UItem.setNote("URL che riferisce un certificato (o certificate chain) X.509 corrispondente alla chiave firmataria del security token");
            ConsoleItemInfo infoX5U = new ConsoleItemInfo("URL (x5u)");
            infoX5U.setHeaderBody("URL che riferisce un certificato (o certificate chain) X.509 corrispondente alla chiave firmataria del security token.");
            profiloSicurezzaMessaggioX5UItem.setInfo(infoX5U);
            profiloSicurezzaMessaggioX5UItem.setRequired(false);
            profiloSicurezzaMessaggioX5UItem.setType(ConsoleItemType.HIDDEN);
            if (fruizione && request) {
                profiloSicurezzaMessaggioX5UItem.setRequired(false);
                profiloSicurezzaMessaggioX5UItem.setType(ConsoleItemType.HIDDEN);
            }
            configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioX5UItem);
        }
    }

    static void addConfigurazioneFirmaSoap(ModIProperties modiProperties, ConsoleConfiguration configuration, boolean fruizione, boolean request, boolean digest) throws ProtocolException {
        String idProfiloSicurezzaMessaggioAlgItem = null;
        if (fruizione && request) {
            idProfiloSicurezzaMessaggioAlgItem = "modipaSecurityMessageSoapRequestAlg";
        } else if (!fruizione && !request) {
            idProfiloSicurezzaMessaggioAlgItem = "modipaSecurityMessageSoapResponseAlg";
        }
        if (idProfiloSicurezzaMessaggioAlgItem != null) {
            StringConsoleItem profiloSicurezzaMessaggioAlgItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)idProfiloSicurezzaMessaggioAlgItem, (String)"Algoritmo");
            profiloSicurezzaMessaggioAlgItem.addLabelValue("DSA-SHA-256", (Object)ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_VALUE_DSA_SHA_256);
            if (modiProperties.isModIVersioneBozza() != null && modiProperties.isModIVersioneBozza().booleanValue()) {
                profiloSicurezzaMessaggioAlgItem.addLabelValue("RSA-SHA-224", (Object)ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_VALUE_RSA_SHA_224);
            }
            profiloSicurezzaMessaggioAlgItem.addLabelValue("RSA-SHA-256", (Object)ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_VALUE_RSA_SHA_256);
            profiloSicurezzaMessaggioAlgItem.addLabelValue("RSA-SHA-384", (Object)ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_VALUE_RSA_SHA_384);
            profiloSicurezzaMessaggioAlgItem.addLabelValue("RSA-SHA-512", (Object)ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_VALUE_RSA_SHA_512);
            if (modiProperties.isModIVersioneBozza() != null && modiProperties.isModIVersioneBozza().booleanValue()) {
                profiloSicurezzaMessaggioAlgItem.addLabelValue("ECDSA-SHA-224", (Object)ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_VALUE_ECDSA_SHA_224);
            }
            profiloSicurezzaMessaggioAlgItem.addLabelValue("ECDSA-SHA-256", (Object)ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_VALUE_ECDSA_SHA_256);
            profiloSicurezzaMessaggioAlgItem.addLabelValue("ECDSA-SHA-384", (Object)ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_VALUE_ECDSA_SHA_384);
            profiloSicurezzaMessaggioAlgItem.addLabelValue("ECDSA-SHA-512", (Object)ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_VALUE_ECDSA_SHA_512);
            profiloSicurezzaMessaggioAlgItem.setDefaultValue((Object)ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_SOAP_ALG_DEFAULT_VALUE);
            configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioAlgItem);
        }
        String idProfiloSicurezzaMessaggioAlgC14NItem = null;
        if (fruizione && request) {
            idProfiloSicurezzaMessaggioAlgC14NItem = "modipaSecurityMessageSoapRequestCanonicalizationAlg";
        } else if (!fruizione && !request) {
            idProfiloSicurezzaMessaggioAlgC14NItem = "modipaSecurityMessageSoapResponseCanonicalizationAlg";
        }
        if (idProfiloSicurezzaMessaggioAlgC14NItem != null) {
            StringConsoleItem profiloSicurezzaMessaggioAlgC14NItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)idProfiloSicurezzaMessaggioAlgC14NItem, (String)"Forma Canonica XML");
            profiloSicurezzaMessaggioAlgC14NItem.addLabelValue("Canonical XML 1.0", (Object)ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_SOAP_CANONICALIZATION_ALG_VALUE_INCLUSIVE_C14N_10);
            profiloSicurezzaMessaggioAlgC14NItem.addLabelValue("Canonical XML 1.1", (Object)ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_SOAP_CANONICALIZATION_ALG_VALUE_INCLUSIVE_C14N_11);
            profiloSicurezzaMessaggioAlgC14NItem.addLabelValue("Exclusive XML Canonicalization 1.0", (Object)ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_SOAP_CANONICALIZATION_ALG_VALUE_EXCLUSIVE_C14N_10);
            profiloSicurezzaMessaggioAlgC14NItem.setDefaultValue((Object)ModIConsoleCostanti.MODIPA_API_IMPL_PROFILO_SICUREZZA_MESSAGGIO_SOAP_CANONICALIZATION_ALG_DEFAULT_VALUE);
            configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioAlgC14NItem);
        }
        if (digest && (request && fruizione || !request && !fruizione)) {
            StringConsoleItem profiloSicurezzaMessaggioSoapHeadersItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_AREA, (String)"modipaSecurityMessageSoapHeaders", (String)"SOAP Headers da firmare");
            profiloSicurezzaMessaggioSoapHeadersItem.setNote("Indicare per riga gli header da firmare; visualizzare 'info' per maggiori dettagli");
            profiloSicurezzaMessaggioSoapHeadersItem.setRequired(false);
            profiloSicurezzaMessaggioSoapHeadersItem.setRows(Integer.valueOf(3));
            ConsoleItemInfo info = new ConsoleItemInfo("SOAP Headers da firmare");
            info.setHeaderBody("Tramite questa configurazione \u00e8 possibile firmare ulteriori header soap rispetto a quelli previsti dalla specifica ModI (Timestamp, WSAddressing, Body).<BR/>Gli ulteriori header devono essere indicati su ogni riga tramite la sintassi: {namespace}localName<BR/>Ad esempio:<BR/>- {http://example.govway.org}NomeHeader1<BR/>- {http://example.govway.org}NomeHeader2");
            profiloSicurezzaMessaggioSoapHeadersItem.setInfo(info);
            configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioSoapHeadersItem);
        }
        String rifX509Id = null;
        if (fruizione && request) {
            rifX509Id = "modipaSecurityMessageSoapRequestX509Cert";
        } else if (!fruizione && !request) {
            rifX509Id = "modipaSecurityMessageSoapResponseX509Cert";
        }
        if (rifX509Id != null) {
            StringConsoleItem profiloSicurezzaMessaggioRifX509Item = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)rifX509Id, (String)"Riferimento X.509");
            profiloSicurezzaMessaggioRifX509Item.addLabelValue("Binary Security Token", (Object)"DirectReference");
            profiloSicurezzaMessaggioRifX509Item.addLabelValue("Issuer-Serial Security Token Reference", (Object)"IssuerSerial");
            profiloSicurezzaMessaggioRifX509Item.addLabelValue("X509 Key Identifier", (Object)"X509KeyIdentifier");
            profiloSicurezzaMessaggioRifX509Item.addLabelValue("Thumbprint Key Identifier", (Object)"Thumbprint");
            profiloSicurezzaMessaggioRifX509Item.addLabelValue("SKI Key Identifier", (Object)"SKIKeyIdentifier");
            profiloSicurezzaMessaggioRifX509Item.setDefaultValue((Object)"DirectReference");
            profiloSicurezzaMessaggioRifX509Item.setReloadOnChange(true, true);
            configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioRifX509Item);
            BooleanConsoleItem profiloSicurezzaMessaggioRifX509ItemBinarySecurityTokenSingleCertificate = (BooleanConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.BOOLEAN, (ConsoleItemType)ConsoleItemType.CHECKBOX, (String)(request ? "modipaSecurityMessageSoapRequestX509CertUseCertificateChain" : "modipaSecurityMessageSoapResponseX509CertUseCertificateChain"), (String)"Certificate Chain");
            if (!"DirectReference".equals("DirectReference")) {
                profiloSicurezzaMessaggioRifX509ItemBinarySecurityTokenSingleCertificate.setType(ConsoleItemType.HIDDEN);
            }
            profiloSicurezzaMessaggioRifX509ItemBinarySecurityTokenSingleCertificate.setDefaultValue((Object)false);
            configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioRifX509ItemBinarySecurityTokenSingleCertificate);
            BooleanConsoleItem profiloSicurezzaMessaggioRifX509ItemBinarySecurityTokenIncludeSignatureToken = (BooleanConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.BOOLEAN, (ConsoleItemType)ConsoleItemType.CHECKBOX, (String)(request ? "modipaSecurityMessageSoapRequestX509CertIncludeSignatureToken" : "modipaSecurityMessageSoapResponseX509CertIncludeSignatureToken"), (String)"Includi Signature Token");
            if (!("IssuerSerial".equals("DirectReference") || "Thumbprint".equals("DirectReference") || "SKIKeyIdentifier".equals("DirectReference"))) {
                profiloSicurezzaMessaggioRifX509ItemBinarySecurityTokenIncludeSignatureToken.setType(ConsoleItemType.HIDDEN);
            }
            profiloSicurezzaMessaggioRifX509ItemBinarySecurityTokenIncludeSignatureToken.setDefaultValue((Object)false);
            configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioRifX509ItemBinarySecurityTokenIncludeSignatureToken);
        }
    }

    static void updateSicurezzaMessaggio(ModIProperties modiProperties, ConsoleConfiguration consoleConfiguration, ProtocolProperties properties, boolean rest, boolean fruizione, boolean request, boolean casoSpecialeModificaNomeFruizione, String patternDatiCorniceSicurezza, String schemaDatiCorniceSicurezza, boolean headerDuplicati, IConsoleHelper consoleHelper, boolean kidMode, boolean tokenNonLocale) throws ProtocolException {
        StringProperty profiloSicurezzaMessaggioRequestRifX509ItemValue;
        boolean requiredValue;
        boolean bl = requiredValue = !casoSpecialeModificaNomeFruizione;
        if (fruizione && !request) {
            String idFruizioneKeystoreFruizioneMode = "modipaKeystoreFruizioneMode";
            StringProperty profiloSicurezzaKeystoreModeFruizioneItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idFruizioneKeystoreFruizioneMode);
            boolean keystoreDefinitoInFruizione = false;
            if (profiloSicurezzaKeystoreModeFruizioneItemValue != null && profiloSicurezzaKeystoreModeFruizioneItemValue.getValue() != null && "fruizione".equals(profiloSicurezzaKeystoreModeFruizioneItemValue.getValue())) {
                keystoreDefinitoInFruizione = true;
            }
            String idPropertyAud = "modipaSecurityMessageResponseAud";
            String idPropertyAudValue = "modipaSecurityMessageResponseAudExpected";
            AbstractConsoleItem profiloSicurezzaMessaggioRestAudItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)idPropertyAud);
            if (profiloSicurezzaMessaggioRestAudItem != null) {
                if (keystoreDefinitoInFruizione) {
                    profiloSicurezzaMessaggioRestAudItem.setNote(null);
                } else {
                    profiloSicurezzaMessaggioRestAudItem.setNote("La verifica utilizza, se configurato, il valore indicato di seguito altrimenti quello configurato nell'applicativo mittente");
                }
            }
            BooleanProperty profiloSicurezzaMessaggioRestAudItemValue = (BooleanProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idPropertyAud);
            StringProperty profiloSicurezzaMessaggioRestAudValueItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idPropertyAudValue);
            AbstractConsoleItem profiloSicurezzaMessaggioRestAudValueItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)idPropertyAudValue);
            if (profiloSicurezzaMessaggioRestAudValueItem != null) {
                if (profiloSicurezzaMessaggioRestAudItemValue != null && profiloSicurezzaMessaggioRestAudItemValue.getValue() != null && ((Boolean)profiloSicurezzaMessaggioRestAudItemValue.getValue()).booleanValue()) {
                    profiloSicurezzaMessaggioRestAudValueItem.setType(ConsoleItemType.TEXT_AREA);
                    profiloSicurezzaMessaggioRestAudValueItem.setRequired(keystoreDefinitoInFruizione);
                } else {
                    if (profiloSicurezzaMessaggioRestAudValueItem != null) {
                        profiloSicurezzaMessaggioRestAudValueItem.setType(ConsoleItemType.HIDDEN);
                        profiloSicurezzaMessaggioRestAudValueItem.setRequired(false);
                    }
                    if (profiloSicurezzaMessaggioRestAudValueItemValue != null) {
                        profiloSicurezzaMessaggioRestAudValueItemValue.setValue(null);
                    }
                }
            }
        }
        boolean keystoreDefinitoInFruizione = false;
        if (fruizione && request) {
            String idFruizioneKeystoreFruizioneMode = "modipaKeystoreFruizioneMode";
            String idFruizioneKeystoreMode = "modipaKeystoreCertMode";
            StringProperty profiloSicurezzaKeystoreModeFruizioneItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idFruizioneKeystoreFruizioneMode);
            AbstractConsoleItem profiloSicurezzaKeystoreModeItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)idFruizioneKeystoreMode);
            if (profiloSicurezzaKeystoreModeFruizioneItemValue != null && profiloSicurezzaKeystoreModeFruizioneItemValue.getValue() != null && "fruizione".equals(profiloSicurezzaKeystoreModeFruizioneItemValue.getValue())) {
                if (profiloSicurezzaKeystoreModeItem != null) {
                    profiloSicurezzaKeystoreModeItem.setType(ConsoleItemType.SELECT);
                    keystoreDefinitoInFruizione = true;
                }
            } else {
                StringProperty profiloSicurezzaKeystoreModeItemValue;
                if (profiloSicurezzaKeystoreModeItem != null) {
                    profiloSicurezzaKeystoreModeItem.setType(ConsoleItemType.HIDDEN);
                }
                if ((profiloSicurezzaKeystoreModeItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idFruizioneKeystoreMode)) != null) {
                    profiloSicurezzaKeystoreModeItemValue.setValue((Object)"default");
                }
            }
        }
        String idProfiloSicurezzaMessaggioIatTtlItem = null;
        String idProfiloSicurezzaMessaggioIatTtlSecondsItem = null;
        if (fruizione && !request) {
            idProfiloSicurezzaMessaggioIatTtlItem = "modipaSecurityMessageResponseIatMode";
            idProfiloSicurezzaMessaggioIatTtlSecondsItem = "modipaSecurityMessageResponseIatTtl";
        } else if (!fruizione && request) {
            idProfiloSicurezzaMessaggioIatTtlItem = "modipaSecurityMessageRequestIatMode";
            idProfiloSicurezzaMessaggioIatTtlSecondsItem = "modipaSecurityMessageRequestIatTtl";
        }
        if (idProfiloSicurezzaMessaggioIatTtlItem != null && idProfiloSicurezzaMessaggioIatTtlSecondsItem != null) {
            AbstractConsoleItem modeItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)idProfiloSicurezzaMessaggioIatTtlItem);
            StringProperty modeItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idProfiloSicurezzaMessaggioIatTtlItem);
            boolean modeIsDefault = "default".equals("default");
            if (modeItemValue != null && modeItemValue.getValue() != null) {
                modeIsDefault = ((String)modeItemValue.getValue()).equals("default");
            }
            if (modeItem != null) {
                modeItem.setLabel(modeIsDefault ? "Time to Live" : "Time to Live (secondi)");
            }
            AbstractConsoleItem secondsItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)idProfiloSicurezzaMessaggioIatTtlSecondsItem);
            NumberProperty secondsItemValue = (NumberProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idProfiloSicurezzaMessaggioIatTtlSecondsItem);
            if (secondsItem != null) {
                if (modeIsDefault) {
                    secondsItem.setRequired(false);
                    secondsItem.setType(ConsoleItemType.HIDDEN);
                    if (secondsItemValue != null) {
                        secondsItemValue.setValue(null);
                    }
                } else {
                    secondsItem.setRequired(requiredValue);
                    secondsItem.setType(ConsoleItemType.NUMBER);
                    if (secondsItemValue != null && secondsItemValue.getValue() == null) {
                        secondsItemValue.setValue((Object)300L);
                    }
                }
            }
        }
        boolean x5url = false;
        if (rest) {
            StringProperty profiloSicurezzaMessaggioHttpHeadersItemValue;
            AbstractConsoleItem profiloSicurezzaMessaggioHttpHeadersItem;
            String idProfiloSicurezzaMessaggioDigestEncodingItem = null;
            if (fruizione && request) {
                idProfiloSicurezzaMessaggioDigestEncodingItem = "modipaSecurityMessageRestRequestDigestEncoding";
            } else if (!fruizione && !request) {
                idProfiloSicurezzaMessaggioDigestEncodingItem = "modipaSecurityMessageRestResponseDigestEncoding";
            }
            if (idProfiloSicurezzaMessaggioDigestEncodingItem != null) {
                StringProperty profiloSicurezzaMessaggioDigestEncodingItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idProfiloSicurezzaMessaggioDigestEncodingItem);
                DigestEncoding actualValue = null;
                if (profiloSicurezzaMessaggioDigestEncodingItemValue != null && profiloSicurezzaMessaggioDigestEncodingItemValue.getValue() != null && StringUtils.isNotEmpty((String)((String)profiloSicurezzaMessaggioDigestEncodingItemValue.getValue()))) {
                    try {
                        actualValue = DigestEncoding.valueOf((String)((String)profiloSicurezzaMessaggioDigestEncodingItemValue.getValue()));
                    }
                    catch (Exception e) {
                        throw new ProtocolException(e.getMessage(), (Throwable)e);
                    }
                }
                AbstractConsoleItem profiloSicurezzaMessaggioDigestEncodingItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)idProfiloSicurezzaMessaggioDigestEncodingItem);
                boolean show = false;
                try {
                    show = modiProperties.isRestSecurityTokenDigestEncodingChoice();
                    if (show && consoleHelper.isModalitaStandard()) {
                        show = false;
                    }
                    if (!show && actualValue != null && !actualValue.equals((Object)modiProperties.getRestSecurityTokenDigestDefaultEncoding())) {
                        show = true;
                    }
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
                if (show) {
                    if (profiloSicurezzaMessaggioDigestEncodingItem != null) {
                        profiloSicurezzaMessaggioDigestEncodingItem.setType(ConsoleItemType.SELECT);
                    }
                } else {
                    if (profiloSicurezzaMessaggioDigestEncodingItem != null) {
                        profiloSicurezzaMessaggioDigestEncodingItem.setType(ConsoleItemType.HIDDEN);
                    }
                    if (profiloSicurezzaMessaggioDigestEncodingItemValue != null) {
                        profiloSicurezzaMessaggioDigestEncodingItemValue.setValue(null);
                    }
                }
            }
            boolean x5uRichiesta = false;
            boolean x5cRichiesta = false;
            profiloSicurezzaMessaggioRequestRifX509ItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageRestRequestX509Cert");
            if (profiloSicurezzaMessaggioRequestRifX509ItemValue != null && profiloSicurezzaMessaggioRequestRifX509ItemValue.getValue() != null && !"".equals(profiloSicurezzaMessaggioRequestRifX509ItemValue.getValue())) {
                List list = ProtocolPropertiesUtils.getListFromMultiSelectValue((String)((String)profiloSicurezzaMessaggioRequestRifX509ItemValue.getValue()));
                x5uRichiesta = list != null && list.contains("x5u");
                x5cRichiesta = list != null && list.contains("x5c");
            }
            boolean x5uRisposta = false;
            boolean x5cRisposta = false;
            if (!request) {
                StringProperty profiloSicurezzaMessaggioRifX509AsRequestItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageRestResponseX509CertAsReq");
                AbstractConsoleItem profiloSicurezzaMessaggioResponseX5UItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageRestResponseX509Cert");
                if (profiloSicurezzaMessaggioResponseX5UItem != null) {
                    if (profiloSicurezzaMessaggioRifX509AsRequestItemValue != null && "false".equals(profiloSicurezzaMessaggioRifX509AsRequestItemValue.getValue())) {
                        profiloSicurezzaMessaggioResponseX5UItem.setType(ConsoleItemType.MULTI_SELECT);
                        ((StringConsoleItem)profiloSicurezzaMessaggioResponseX5UItem).setRows(Integer.valueOf(3));
                        StringProperty profiloSicurezzaMessaggioResponseRifX509ItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageRestResponseX509Cert");
                        if (profiloSicurezzaMessaggioResponseRifX509ItemValue != null && profiloSicurezzaMessaggioResponseRifX509ItemValue.getValue() != null && !"".equals(profiloSicurezzaMessaggioResponseRifX509ItemValue.getValue())) {
                            List list = ProtocolPropertiesUtils.getListFromMultiSelectValue((String)((String)profiloSicurezzaMessaggioResponseRifX509ItemValue.getValue()));
                            x5uRisposta = list != null && list.contains("x5u");
                            x5cRisposta = list != null && list.contains("x5c");
                        }
                    } else {
                        profiloSicurezzaMessaggioResponseX5UItem.setType(ConsoleItemType.HIDDEN);
                        x5uRisposta = x5uRichiesta;
                        x5cRisposta = x5cRichiesta;
                    }
                }
            }
            boolean x5c = false;
            x5c = request ? x5cRichiesta : x5cRisposta;
            AbstractConsoleItem profiloSicurezzaMessaggioRifX509ItemX5CSingleCertificateItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)(request ? "modipaSecurityMessageRestRequestX509CertUseCertificateChain" : "modipaSecurityMessageRestResponseX509CertUseCertificateChain"));
            if (profiloSicurezzaMessaggioRifX509ItemX5CSingleCertificateItem != null) {
                if (x5c) {
                    profiloSicurezzaMessaggioRifX509ItemX5CSingleCertificateItem.setType(ConsoleItemType.CHECKBOX);
                } else {
                    profiloSicurezzaMessaggioRifX509ItemX5CSingleCertificateItem.setType(ConsoleItemType.HIDDEN);
                }
            }
            x5url = request ? x5uRichiesta : x5uRisposta;
            String idUrl = null;
            if (fruizione && request) {
                idUrl = "modipaSecurityMessageRestRequestX509Url";
            } else if (!fruizione && !request) {
                idUrl = "modipaSecurityMessageRestResponseX509Url";
            }
            if (idUrl != null) {
                StringProperty profiloSicurezzaMessaggioX5UItemItemValue;
                AbstractConsoleItem profiloSicurezzaMessaggioX5UItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)idUrl);
                if (profiloSicurezzaMessaggioX5UItem != null) {
                    if (x5url && (!fruizione || keystoreDefinitoInFruizione)) {
                        profiloSicurezzaMessaggioX5UItem.setType(ConsoleItemType.TEXT_AREA);
                        profiloSicurezzaMessaggioX5UItem.setRequired(requiredValue);
                    } else {
                        profiloSicurezzaMessaggioX5UItem.setRequired(false);
                        profiloSicurezzaMessaggioX5UItem.setType(ConsoleItemType.HIDDEN);
                    }
                }
                if ((profiloSicurezzaMessaggioX5UItemItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idUrl)) != null && (!x5url || fruizione && !keystoreDefinitoInFruizione)) {
                    profiloSicurezzaMessaggioX5UItemItemValue.setValue(null);
                }
            }
            if ((profiloSicurezzaMessaggioHttpHeadersItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageHttpHeaders")) != null && (profiloSicurezzaMessaggioHttpHeadersItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageHttpHeaders")) != null && (profiloSicurezzaMessaggioHttpHeadersItemValue.getValue() == null || "".equals(profiloSicurezzaMessaggioHttpHeadersItemValue.getValue()))) {
                try {
                    profiloSicurezzaMessaggioHttpHeadersItemValue.setValue((Object)modiProperties.getRestSecurityTokenSignedHeadersAsString());
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if (request && fruizione || !request && !fruizione) {
                String idProperty = request && fruizione ? "modipaSecurityMessageRequestClaims" : "modipaSecurityMessageResponseClaims";
                StringProperty profiloSicurezzaMessaggioRestJwtClaimsItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idProperty);
                AbstractConsoleItem profiloSicurezzaMessaggioRestJwtClaimsItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)idProperty);
                if (profiloSicurezzaMessaggioRestJwtClaimsItemValue != null && profiloSicurezzaMessaggioRestJwtClaimsItemValue.getValue() != null && profiloSicurezzaMessaggioRestJwtClaimsItem != null) {
                    String[] tmp = ((String)profiloSicurezzaMessaggioRestJwtClaimsItemValue.getValue()).split("\n");
                    if (tmp.length > 2) {
                        ((StringConsoleItem)profiloSicurezzaMessaggioRestJwtClaimsItem).setRows(Integer.valueOf(tmp.length > 10 ? 10 : tmp.length));
                    } else {
                        ((StringConsoleItem)profiloSicurezzaMessaggioRestJwtClaimsItem).setRows(Integer.valueOf(2));
                    }
                }
            }
            if (headerDuplicati && (request && fruizione || !request && !fruizione)) {
                String idPropertyJti = request && fruizione ? "modipaSecurityMessageRequestJti" : "modipaSecurityMessageResponseJti";
                String idPropertyJtiAsIdMessaggio = request && fruizione ? "modipaSecurityMessageRequestJtiIdMsg" : "modipaSecurityMessageResponseJtiIdMsg";
                StringProperty profiloSicurezzaMessaggioRestJtiItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idPropertyJti);
                StringProperty profiloSicurezzaMessaggioRestJtiAsIdMessaggioItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idPropertyJtiAsIdMessaggio);
                AbstractConsoleItem profiloSicurezzaMessaggioRestJtiAsIdMessaggioItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)idPropertyJtiAsIdMessaggio);
                if (profiloSicurezzaMessaggioRestJtiAsIdMessaggioItem != null) {
                    if (profiloSicurezzaMessaggioRestJtiItemValue != null && "different".equals(profiloSicurezzaMessaggioRestJtiItemValue.getValue())) {
                        profiloSicurezzaMessaggioRestJtiAsIdMessaggioItem.setType(ConsoleItemType.SELECT);
                        if (profiloSicurezzaMessaggioRestJtiAsIdMessaggioItemValue != null && profiloSicurezzaMessaggioRestJtiAsIdMessaggioItemValue.getValue() == null) {
                            profiloSicurezzaMessaggioRestJtiAsIdMessaggioItemValue.setValue((Object)"modi");
                        }
                    } else {
                        profiloSicurezzaMessaggioRestJtiAsIdMessaggioItem.setType(ConsoleItemType.HIDDEN);
                        if (profiloSicurezzaMessaggioRestJtiAsIdMessaggioItemValue != null) {
                            profiloSicurezzaMessaggioRestJtiAsIdMessaggioItemValue.setValue((Object)"modi");
                        }
                    }
                }
                String idPropertyClaimsAuthorization = request && fruizione ? "modipaSecurityMessageRequestClaimsAuth" : "modipaSecurityMessageResponseClaimsAuth";
                StringProperty profiloSicurezzaMessaggioRestJwtClaimsAuthorizationItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idPropertyClaimsAuthorization);
                AbstractConsoleItem profiloSicurezzaMessaggioRestJwtClaimsAuthorizationItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)idPropertyClaimsAuthorization);
                if (profiloSicurezzaMessaggioRestJwtClaimsAuthorizationItemValue != null && profiloSicurezzaMessaggioRestJwtClaimsAuthorizationItemValue.getValue() != null && profiloSicurezzaMessaggioRestJwtClaimsAuthorizationItem != null) {
                    String[] tmp = ((String)profiloSicurezzaMessaggioRestJwtClaimsAuthorizationItemValue.getValue()).split("\n");
                    if (tmp.length > 2) {
                        ((StringConsoleItem)profiloSicurezzaMessaggioRestJwtClaimsAuthorizationItem).setRows(Integer.valueOf(tmp.length > 10 ? 10 : tmp.length));
                    } else {
                        ((StringConsoleItem)profiloSicurezzaMessaggioRestJwtClaimsAuthorizationItem).setRows(Integer.valueOf(2));
                    }
                }
                String idPropertyClaimsModi = request && fruizione ? "modipaSecurityMessageRequestClaimsModi" : "modipaSecurityMessageResponseClaimsModi";
                StringProperty profiloSicurezzaMessaggioRestJwtClaimsModiItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idPropertyClaimsModi);
                AbstractConsoleItem profiloSicurezzaMessaggioRestJwtClaimsModiItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)idPropertyClaimsModi);
                if (profiloSicurezzaMessaggioRestJwtClaimsModiItemValue != null && profiloSicurezzaMessaggioRestJwtClaimsModiItemValue.getValue() != null && profiloSicurezzaMessaggioRestJwtClaimsModiItem != null) {
                    String[] tmp = ((String)profiloSicurezzaMessaggioRestJwtClaimsModiItemValue.getValue()).split("\n");
                    if (tmp.length > 2) {
                        ((StringConsoleItem)profiloSicurezzaMessaggioRestJwtClaimsModiItem).setRows(Integer.valueOf(tmp.length > 10 ? 10 : tmp.length));
                    } else {
                        ((StringConsoleItem)profiloSicurezzaMessaggioRestJwtClaimsModiItem).setRows(Integer.valueOf(2));
                    }
                }
            }
            if (headerDuplicati && request) {
                String idPropertyAud = "modipaSecurityMessageRequestIntegrityAudMode";
                String idPropertyAudValue = "modipaSecurityMessageRequestIntegrityAud";
                StringProperty profiloSicurezzaMessaggioRestAudItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idPropertyAud);
                StringProperty profiloSicurezzaMessaggioRestAudValueItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idPropertyAudValue);
                AbstractConsoleItem profiloSicurezzaMessaggioRestAudValueItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)idPropertyAudValue);
                if (profiloSicurezzaMessaggioRestAudValueItem != null) {
                    if (profiloSicurezzaMessaggioRestAudItemValue != null && "different".equals(profiloSicurezzaMessaggioRestAudItemValue.getValue())) {
                        profiloSicurezzaMessaggioRestAudValueItem.setType(ConsoleItemType.TEXT_AREA);
                        profiloSicurezzaMessaggioRestAudValueItem.setRequired(true);
                    } else {
                        if (profiloSicurezzaMessaggioRestAudValueItem != null) {
                            profiloSicurezzaMessaggioRestAudValueItem.setType(ConsoleItemType.HIDDEN);
                            profiloSicurezzaMessaggioRestAudValueItem.setRequired(false);
                        }
                        if (profiloSicurezzaMessaggioRestAudValueItemValue != null) {
                            profiloSicurezzaMessaggioRestAudValueItemValue.setValue(null);
                        }
                    }
                }
            }
            if (headerDuplicati && !request && fruizione) {
                String idPropertyAudVerifica = "modipaSecurityMessageResponseAud";
                BooleanProperty profiloSicurezzaMessaggioRestAudVerificaItemValue = (BooleanProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idPropertyAudVerifica);
                boolean verificaAbilitata = profiloSicurezzaMessaggioRestAudVerificaItemValue != null && profiloSicurezzaMessaggioRestAudVerificaItemValue.getValue() != null && (Boolean)profiloSicurezzaMessaggioRestAudVerificaItemValue.getValue() != false;
                String idPropertyAud = "modipaSecurityMessageResponseIntegrityAudMode";
                String idPropertyAudValue = "modipaSecurityMessageResponseIntegrityAud";
                StringProperty profiloSicurezzaMessaggioRestAudItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idPropertyAud);
                AbstractConsoleItem profiloSicurezzaMessaggioRestAudItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (AbstractProperty)profiloSicurezzaMessaggioRestAudItemValue);
                if (profiloSicurezzaMessaggioRestAudItem != null) {
                    if (verificaAbilitata) {
                        profiloSicurezzaMessaggioRestAudItem.setType(ConsoleItemType.SELECT);
                    } else {
                        profiloSicurezzaMessaggioRestAudItem.setType(ConsoleItemType.HIDDEN);
                        profiloSicurezzaMessaggioRestAudItemValue.setValue((Object)"same");
                    }
                }
                StringProperty profiloSicurezzaMessaggioRestAudValueItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idPropertyAudValue);
                AbstractConsoleItem profiloSicurezzaMessaggioRestAudValueItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)idPropertyAudValue);
                if (profiloSicurezzaMessaggioRestAudValueItem != null) {
                    if (verificaAbilitata && profiloSicurezzaMessaggioRestAudItemValue != null && "different".equals(profiloSicurezzaMessaggioRestAudItemValue.getValue())) {
                        profiloSicurezzaMessaggioRestAudValueItem.setType(ConsoleItemType.TEXT_AREA);
                        profiloSicurezzaMessaggioRestAudValueItem.setRequired(true);
                    } else {
                        if (profiloSicurezzaMessaggioRestAudValueItem != null) {
                            profiloSicurezzaMessaggioRestAudValueItem.setType(ConsoleItemType.HIDDEN);
                            profiloSicurezzaMessaggioRestAudValueItem.setRequired(false);
                        }
                        if (profiloSicurezzaMessaggioRestAudValueItemValue != null) {
                            profiloSicurezzaMessaggioRestAudValueItemValue.setValue(null);
                        }
                    }
                }
            }
        } else {
            StringProperty profiloSicurezzaMessaggioSoapHeadersItemValue;
            AbstractConsoleItem profiloSicurezzaMessaggioSoapHeadersItem;
            String rifX509Id;
            AbstractConsoleItem profiloSicurezzaMessaggioRifX509ItemIncludeSignatureTokenItem;
            String rifX509Id2;
            StringProperty profiloSicurezzaMessaggioRequestRifX509ItemValue2;
            AbstractConsoleItem profiloSicurezzaMessaggioRifX509ItemBinarySecurityTokenSingleCertificateItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)(request ? "modipaSecurityMessageSoapRequestX509CertUseCertificateChain" : "modipaSecurityMessageSoapResponseX509CertUseCertificateChain"));
            if (profiloSicurezzaMessaggioRifX509ItemBinarySecurityTokenSingleCertificateItem != null && (profiloSicurezzaMessaggioRequestRifX509ItemValue2 = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)(rifX509Id2 = request ? "modipaSecurityMessageSoapRequestX509Cert" : "modipaSecurityMessageSoapResponseX509Cert"))) != null) {
                if ("DirectReference".equals(profiloSicurezzaMessaggioRequestRifX509ItemValue2.getValue())) {
                    profiloSicurezzaMessaggioRifX509ItemBinarySecurityTokenSingleCertificateItem.setType(ConsoleItemType.CHECKBOX);
                } else {
                    profiloSicurezzaMessaggioRifX509ItemBinarySecurityTokenSingleCertificateItem.setType(ConsoleItemType.HIDDEN);
                }
            }
            if ((profiloSicurezzaMessaggioRifX509ItemIncludeSignatureTokenItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)(request ? "modipaSecurityMessageSoapRequestX509CertIncludeSignatureToken" : "modipaSecurityMessageSoapResponseX509CertIncludeSignatureToken"))) != null && (profiloSicurezzaMessaggioRequestRifX509ItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)(rifX509Id = request ? "modipaSecurityMessageSoapRequestX509Cert" : "modipaSecurityMessageSoapResponseX509Cert"))) != null) {
                if ("IssuerSerial".equals(profiloSicurezzaMessaggioRequestRifX509ItemValue.getValue()) || "Thumbprint".equals(profiloSicurezzaMessaggioRequestRifX509ItemValue.getValue()) || "SKIKeyIdentifier".equals(profiloSicurezzaMessaggioRequestRifX509ItemValue.getValue())) {
                    profiloSicurezzaMessaggioRifX509ItemIncludeSignatureTokenItem.setType(ConsoleItemType.CHECKBOX);
                } else {
                    profiloSicurezzaMessaggioRifX509ItemIncludeSignatureTokenItem.setType(ConsoleItemType.HIDDEN);
                }
            }
            if ((profiloSicurezzaMessaggioSoapHeadersItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageSoapHeaders")) != null && ((profiloSicurezzaMessaggioSoapHeadersItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageSoapHeaders")) == null || profiloSicurezzaMessaggioSoapHeadersItemValue.getValue() == null || "".equals(profiloSicurezzaMessaggioSoapHeadersItemValue.getValue())) && consoleHelper.isModalitaStandard() && profiloSicurezzaMessaggioSoapHeadersItem != null) {
                profiloSicurezzaMessaggioSoapHeadersItem.setType(ConsoleItemType.HIDDEN);
            }
        }
        if (request && patternDatiCorniceSicurezza != null && StringUtils.isNotEmpty((String)patternDatiCorniceSicurezza)) {
            if (fruizione) {
                if ("old".equals(patternDatiCorniceSicurezza)) {
                    ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.updateCorniceSicurezzaLegacy(consoleConfiguration, properties);
                } else {
                    ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.updateCorniceSicurezzaSchema(consoleConfiguration, properties, schemaDatiCorniceSicurezza);
                }
            } else if (!"old".equals(patternDatiCorniceSicurezza)) {
                ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.updateCorniceSicurezzaSchemaAudience(consoleConfiguration, properties);
            }
        }
        if (fruizione && request) {
            AbstractConsoleItem oauthKidItem;
            AbstractConsoleItem oauthIdentificativoItem;
            BaseConsoleItem subTitleItem = ProtocolPropertiesUtils.getBaseConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageOauthSubId");
            if (subTitleItem != null) {
                if (keystoreDefinitoInFruizione) {
                    subTitleItem.setType(ConsoleItemType.SUBTITLE);
                } else {
                    subTitleItem.setType(ConsoleItemType.HIDDEN);
                }
            }
            if ((oauthIdentificativoItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityOauthId")) != null) {
                if (keystoreDefinitoInFruizione) {
                    oauthIdentificativoItem.setType(ConsoleItemType.TEXT_AREA);
                } else {
                    oauthIdentificativoItem.setType(ConsoleItemType.HIDDEN);
                    StringProperty oauthIdentificativoItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityOauthId");
                    if (oauthIdentificativoItemValue != null) {
                        oauthIdentificativoItemValue.setValue(null);
                    }
                }
            }
            if ((oauthKidItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityOauthKid")) != null) {
                if (keystoreDefinitoInFruizione) {
                    oauthKidItem.setType(ConsoleItemType.TEXT_AREA);
                } else {
                    oauthKidItem.setType(ConsoleItemType.HIDDEN);
                    StringProperty oauthKidItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityOauthKid");
                    if (oauthKidItemValue != null) {
                        oauthKidItemValue.setValue(null);
                    }
                }
            }
        }
        if (fruizione && !request || !fruizione && request) {
            boolean addTrustStoreTypesChiaviPubbliche = rest || kidMode;
            List<RemoteStoreConfig> remoteStoreConfig = null;
            if (kidMode) {
                remoteStoreConfig = modiProperties.getRemoteStoreConfig();
            }
            ModIDynamicConfigurationKeystoreUtilities.updateTrustConfig(consoleConfiguration, properties, false, false, requiredValue, addTrustStoreTypesChiaviPubbliche, remoteStoreConfig);
            if (rest) {
                ModIDynamicConfigurationKeystoreUtilities.updateTrustConfig(consoleConfiguration, properties, true, x5url, requiredValue, false, null);
            }
        }
        if (!fruizione && !request) {
            boolean hideSceltaArchivioFilePath = false;
            boolean addHiddenSubjectIssuer = false;
            boolean ridefinisci = ModIDynamicConfigurationKeystoreUtilities.updateKeystoreConfig(consoleConfiguration, properties, true, hideSceltaArchivioFilePath, addHiddenSubjectIssuer, requiredValue, null, rest);
            ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.updateSicurezzaOAuth(consoleConfiguration, properties, ridefinisci);
        }
        if (fruizione && request) {
            boolean hideSceltaArchivioFilePath = false;
            boolean addHiddenSubjectIssuer = false;
            ModIDynamicConfigurationKeystoreUtilities.updateKeystoreConfig(consoleConfiguration, properties, true, hideSceltaArchivioFilePath, addHiddenSubjectIssuer, requiredValue, null, rest);
        }
    }

    private static void updateSicurezzaOAuth(ConsoleConfiguration configuration, ProtocolProperties properties, boolean ridefinisci) throws ProtocolException {
        StringProperty profiloSicurezzaOauthIdentificativoItemValue;
        AbstractConsoleItem profiloSicurezzaOauthIdentificativoItem;
        StringProperty profiloSicurezzaOauthKidItemValue;
        AbstractConsoleItem profiloSicurezzaOauthKidItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)configuration.getConsoleItem(), (String)"modipaSecurityOauthKid");
        if (profiloSicurezzaOauthKidItem != null) {
            profiloSicurezzaOauthKidItem.setType(ridefinisci ? ConsoleItemType.TEXT_AREA : ConsoleItemType.HIDDEN);
        }
        if ((profiloSicurezzaOauthKidItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityOauthKid")) != null && !ridefinisci) {
            profiloSicurezzaOauthKidItemValue.setValue(null);
        }
        if ((profiloSicurezzaOauthIdentificativoItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)configuration.getConsoleItem(), (String)"modipaSecurityOauthId")) != null) {
            profiloSicurezzaOauthIdentificativoItem.setType(ridefinisci ? ConsoleItemType.TEXT_AREA : ConsoleItemType.HIDDEN);
        }
        if ((profiloSicurezzaOauthIdentificativoItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityOauthId")) != null && !ridefinisci) {
            profiloSicurezzaOauthIdentificativoItemValue.setValue(null);
        }
    }

    private static void updateCorniceSicurezzaSchemaAudience(ConsoleConfiguration configuration, ProtocolProperties properties) throws ProtocolException {
        String idPropertyAud = "modipaSecurityMessageRequestAuditAudMode";
        String idPropertyAudValue = "modipaSecurityMessageRequestAuditAud";
        StringProperty profiloSicurezzaMessaggioRestAudItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idPropertyAud);
        StringProperty profiloSicurezzaMessaggioRestAudValueItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idPropertyAudValue);
        AbstractConsoleItem profiloSicurezzaMessaggioRestAudValueItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)configuration.getConsoleItem(), (String)idPropertyAudValue);
        if (profiloSicurezzaMessaggioRestAudValueItem != null) {
            if (profiloSicurezzaMessaggioRestAudItemValue != null && "different".equals(profiloSicurezzaMessaggioRestAudItemValue.getValue())) {
                profiloSicurezzaMessaggioRestAudValueItem.setType(ConsoleItemType.TEXT_AREA);
                profiloSicurezzaMessaggioRestAudValueItem.setRequired(true);
            } else {
                profiloSicurezzaMessaggioRestAudValueItem.setType(ConsoleItemType.HIDDEN);
                profiloSicurezzaMessaggioRestAudValueItem.setRequired(false);
                if (profiloSicurezzaMessaggioRestAudValueItemValue != null) {
                    profiloSicurezzaMessaggioRestAudValueItemValue.setValue(null);
                }
            }
        }
    }

    private static void updateCorniceSicurezzaSchema(ConsoleConfiguration configuration, ProtocolProperties properties, String schemaDatiCorniceSicurezza) throws ProtocolException {
        List<ModIAuditConfig> list = ModIProperties.getInstance().getAuditConfig();
        if (list != null && !list.isEmpty()) {
            ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.updateCorniceSicurezzaSchemaAudience(configuration, properties);
            for (ModIAuditConfig modIAuditConfig : list) {
                if (!modIAuditConfig.getNome().equals(schemaDatiCorniceSicurezza)) continue;
                ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.updateCorniceSicurezzaSchema(configuration, properties, modIAuditConfig);
                break;
            }
        }
    }

    private static void updateCorniceSicurezzaSchema(ConsoleConfiguration configuration, ProtocolProperties properties, ModIAuditConfig modIAuditConfig) throws ProtocolException {
        if (modIAuditConfig.getClaims() != null && !modIAuditConfig.getClaims().isEmpty()) {
            for (ModIAuditClaimConfig claimConfig : modIAuditConfig.getClaims()) {
                ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.updateCorniceSicurezzaSchema(configuration, properties, claimConfig);
            }
        }
    }

    private static void updateCorniceSicurezzaSchema(ConsoleConfiguration consoleConfiguration, ProtocolProperties properties, ModIAuditClaimConfig claimConfig) throws ProtocolException {
        String modeId = "modipaSecurityMessageCorniceSicurezzaSchemaMode" + claimConfig.getNome();
        boolean ridefinisciItem = false;
        StringProperty selectSchemaModeItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)modeId);
        ridefinisciItem = selectSchemaModeItemValue == null ? false : "ridefinisci".equals(selectSchemaModeItemValue.getValue());
        AbstractConsoleItem modeItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)modeId);
        if (ridefinisciItem) {
            modeItem.setInfo(null);
        } else {
            modeItem.setInfo(new ConsoleItemInfo(claimConfig.getLabel()));
            modeItem.getInfo().setHeaderBody("Il valore del claim 'CLAIM' deve essere indicato nella richiesta di fruizione tramite una delle seguenti modalit\u00e0:".replace("CLAIM", claimConfig.getNome()));
            modeItem.getInfo().setListBody(new ArrayList());
            modeItem.getInfo().getListBody().addAll(claimConfig.getRulesInfo());
        }
        String id = "modipaSecurityMessageCorniceSicurezzaSchemaValue" + claimConfig.getNome();
        AbstractConsoleItem valueItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)id);
        if (ridefinisciItem) {
            valueItem.setType(ConsoleItemType.TEXT_AREA);
        } else {
            valueItem.setType(ConsoleItemType.HIDDEN);
            StringProperty selectItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)id);
            if (selectItemValue != null) {
                selectItemValue.setValue(null);
            }
        }
    }

    private static void updateCorniceSicurezzaLegacy(ConsoleConfiguration consoleConfiguration, ProtocolProperties properties) throws ProtocolException {
        ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.updateCorniceSicurezzaLegacyCodiceEnte(consoleConfiguration, properties);
        ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.updateCorniceSicurezzaLegacyUser(consoleConfiguration, properties);
        ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.updateCorniceSicurezzaLegacyIpUser(consoleConfiguration, properties);
    }

    private static void updateCorniceSicurezzaLegacyCodiceEnte(ConsoleConfiguration consoleConfiguration, ProtocolProperties properties) throws ProtocolException {
        boolean ridefinisciCodiceEnte = false;
        StringProperty selectCodiceEnteModeItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageCorniceSicurezzaCodiceEnteMode");
        ridefinisciCodiceEnte = selectCodiceEnteModeItemValue == null ? false : "ridefinisci".equals(selectCodiceEnteModeItemValue.getValue());
        AbstractConsoleItem codiceEnteModeItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageCorniceSicurezzaCodiceEnteMode");
        if (ridefinisciCodiceEnte) {
            codiceEnteModeItem.setInfo(null);
        } else {
            codiceEnteModeItem.setInfo(new ConsoleItemInfo("Codice Ente"));
            codiceEnteModeItem.getInfo().setHeaderBody("Per default questa informazione assume il valore del soggetto registrato su GovWay, di dominio interno, per il quale si sta effettuando la richiesta di fruizione dell'API.");
        }
        AbstractConsoleItem codiceEnteItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageCorniceSicurezzaCodiceEnte");
        if (ridefinisciCodiceEnte) {
            codiceEnteItem.setType(ConsoleItemType.TEXT_AREA);
        } else {
            codiceEnteItem.setType(ConsoleItemType.HIDDEN);
            StringProperty selectCodiceEnteItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageCorniceSicurezzaCodiceEnte");
            if (selectCodiceEnteItemValue != null) {
                selectCodiceEnteItemValue.setValue(null);
            }
        }
    }

    private static void updateCorniceSicurezzaLegacyUser(ConsoleConfiguration consoleConfiguration, ProtocolProperties properties) throws ProtocolException {
        boolean ridefinisciUser = false;
        StringProperty selectUserModeItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageCorniceSicurezzaUserMode");
        ridefinisciUser = selectUserModeItemValue == null ? false : "ridefinisci".equals(selectUserModeItemValue.getValue());
        AbstractConsoleItem userModeItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageCorniceSicurezzaUserMode");
        if (ridefinisciUser) {
            userModeItem.setInfo(null);
        } else {
            userModeItem.setInfo(new ConsoleItemInfo("UserID Utente"));
            userModeItem.getInfo().setHeaderBody("L'identificativo dell'utente deve essere indicato nella richiesta di fruizione tramite una delle seguenti modalit\u00e0:");
            userModeItem.getInfo().setListBody(new ArrayList());
            userModeItem.getInfo().getListBody().add("Header http 'GovWay-CS-User'");
            userModeItem.getInfo().getListBody().add("Parametro della url 'govway_cs_user'");
        }
        AbstractConsoleItem userItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageCorniceSicurezzaUser");
        if (ridefinisciUser) {
            userItem.setType(ConsoleItemType.TEXT_AREA);
        } else {
            userItem.setType(ConsoleItemType.HIDDEN);
            StringProperty selectUserItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageCorniceSicurezzaUser");
            if (selectUserItemValue != null) {
                selectUserItemValue.setValue(null);
            }
        }
    }

    private static void updateCorniceSicurezzaLegacyIpUser(ConsoleConfiguration consoleConfiguration, ProtocolProperties properties) throws ProtocolException {
        boolean ridefinisciIpUser = false;
        StringProperty selectIpUserModeItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageCorniceSicurezzaIPUserMode");
        ridefinisciIpUser = selectIpUserModeItemValue == null ? false : "ridefinisci".equals(selectIpUserModeItemValue.getValue());
        AbstractConsoleItem ipUserModeItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageCorniceSicurezzaIPUserMode");
        if (ridefinisciIpUser) {
            ipUserModeItem.setInfo(null);
        } else {
            ipUserModeItem.setInfo(new ConsoleItemInfo("Indirizzo IP Utente"));
            ipUserModeItem.getInfo().setHeaderBody("La postazione dell\u2019utente deve essere indicata nella richiesta di fruizione tramite una delle seguenti modalit\u00e0:");
            ipUserModeItem.getInfo().setListBody(new ArrayList());
            ipUserModeItem.getInfo().getListBody().add("Header http 'GovWay-CS-IPUser'");
            ipUserModeItem.getInfo().getListBody().add("Parametro della url 'govway_cs_ipuser'");
        }
        AbstractConsoleItem ipUserItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageCorniceSicurezzaIPUser");
        if (ridefinisciIpUser) {
            ipUserItem.setType(ConsoleItemType.TEXT_AREA);
        } else {
            ipUserItem.setType(ConsoleItemType.HIDDEN);
            StringProperty selectIPUserItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageCorniceSicurezzaIPUser");
            if (selectIPUserItemValue != null) {
                selectIPUserItemValue.setValue(null);
            }
        }
    }

    static void addPdndInfo(ModIProperties modiProperties, ConsoleConfiguration configuration, boolean rest) throws ProtocolException {
        TitleConsoleItem titolo = (TitleConsoleItem)ProtocolPropertiesFactory.newTitleItem((String)"modipaAPIImplInfoGenTitleId", (String)"ModI - Informazioni Generali");
        configuration.addConsoleItem((BaseConsoleItem)titolo);
        StringConsoleItem modiEServiceIdItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_AREA, (String)"modipaInfoGenEserviceId", (String)"Identificativo eService");
        modiEServiceIdItem.setRows(Integer.valueOf(1));
        configuration.addConsoleItem((BaseConsoleItem)modiEServiceIdItem);
        StringConsoleItem modiDescriptorIdItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_AREA, (String)"modipaInfoGenDescriptorId", (String)"Identificativo Descrittore");
        modiDescriptorIdItem.setNote("Elencare pi\u00f9 descrittori separandoli con la ','");
        modiDescriptorIdItem.setRows(Integer.valueOf(1));
        configuration.addConsoleItem((BaseConsoleItem)modiDescriptorIdItem);
        if (modiProperties.isSignalHubEnabled()) {
            BooleanConsoleItem modiSignalHubItem = (BooleanConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.BOOLEAN, (ConsoleItemType)ConsoleItemType.CHECKBOX, (String)"modipaInfoGenSignalHub", (String)"Signal Hub");
            modiSignalHubItem.setReloadOnChange(true, true);
            configuration.addConsoleItem((BaseConsoleItem)modiSignalHubItem);
            ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.addSignalHubInfo(modiProperties, configuration, rest);
        }
    }

    private static void addSignalHubInfo(ModIProperties modiProperties, ConsoleConfiguration configuration, boolean rest) throws ProtocolException {
        SubtitleConsoleItem modiSignalHubSubtitleItem = (SubtitleConsoleItem)ProtocolPropertiesFactory.newSubTitleItem((String)"modipaAPIImplInfoGenSignalHubSubtitleId", (String)"Signal Hub");
        modiSignalHubSubtitleItem.setType(ConsoleItemType.HIDDEN);
        configuration.addConsoleItem((BaseConsoleItem)modiSignalHubSubtitleItem);
        StringConsoleItem modiSignalHubOpItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaInfoGenSignalHubOp", (String)(rest ? "Risorsa" : "Azione"));
        modiSignalHubOpItem.setNote("Indicare la risorsa che esporr\u00e0 le informazioni di pseudoanonimizzazione");
        modiSignalHubOpItem.setRequired(true);
        modiSignalHubOpItem.setType(ConsoleItemType.HIDDEN);
        configuration.addConsoleItem((BaseConsoleItem)modiSignalHubOpItem);
        StringConsoleItem modiSignalHubAlgItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaInfoGenSignalHubAlg", (String)"Algoritmo");
        List<String> algo = modiProperties.getSignalHubAlgorithms();
        if (algo != null && !algo.isEmpty()) {
            for (String a : algo) {
                modiSignalHubAlgItem.addLabelValue(a, (Object)a);
            }
        }
        modiSignalHubAlgItem.setDefaultValue((Object)modiProperties.getSignalHubDefaultAlgorithm());
        modiSignalHubAlgItem.setType(ConsoleItemType.HIDDEN);
        configuration.addConsoleItem((BaseConsoleItem)modiSignalHubAlgItem);
        NumberConsoleItem modiSignalHubAlgDimensioneSeme = (NumberConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.NUMBER, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaInfoGenSignalHubSeedSize", (String)"Dimensione Seme");
        List<Integer> size = modiProperties.getSignalHubSeedSize();
        if (size != null && !size.isEmpty()) {
            for (Integer a : size) {
                modiSignalHubAlgDimensioneSeme.addLabelValue(a.toString(), (Object)a.longValue());
            }
        }
        modiSignalHubAlgDimensioneSeme.setDefaultValue((Object)modiProperties.getSignalHubDefaultSeedSize().longValue());
        modiSignalHubAlgDimensioneSeme.setType(ConsoleItemType.HIDDEN);
        configuration.addConsoleItem((BaseConsoleItem)modiSignalHubAlgDimensioneSeme);
        NumberConsoleItem modiSignalHubAlgScadenzaSeme = (NumberConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.NUMBER, (ConsoleItemType)ConsoleItemType.TEXT_EDIT, (String)"modipaInfoGenSignalHubSeedLifetime", (String)"Giorni Rotazione Seme");
        if (!modiProperties.isSignalHubSeedLifetimeUnlimited()) {
            modiSignalHubAlgScadenzaSeme.setRequired(true);
            modiSignalHubAlgScadenzaSeme.setDefaultValue((Object)modiProperties.getSignalHubDeSeedSeedLifetimeDaysDefault().longValue());
        }
        modiSignalHubAlgScadenzaSeme.setType(ConsoleItemType.HIDDEN);
        configuration.addConsoleItem((BaseConsoleItem)modiSignalHubAlgScadenzaSeme);
        StringConsoleItem modiSignalHubPublisherItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT, (String)"modipaInfoGenSignalHubPulisherText", (String)"&nbsp;");
        modiSignalHubPublisherItem.setDefaultValue((Object)"Pubblicatore");
        configuration.addConsoleItem((BaseConsoleItem)modiSignalHubPublisherItem);
        StringConsoleItem modiSignalHubPublisherSAItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaInfoGenSignalHubPulisherSA", (String)"Applicativo");
        modiSignalHubPublisherSAItem.setType(ConsoleItemType.HIDDEN);
        configuration.addConsoleItem((BaseConsoleItem)modiSignalHubPublisherSAItem);
        StringConsoleItem modiSignalHubPublisherRoleItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaInfoGenSignalHubPulisherRole", (String)"Ruolo");
        modiSignalHubPublisherRoleItem.setNote("Solo l'applicativo indicato o con il ruolo configurato potr\u00e0 pubblicare segnali di variazione del servizio");
        modiSignalHubPublisherRoleItem.setType(ConsoleItemType.HIDDEN);
        configuration.addConsoleItem((BaseConsoleItem)modiSignalHubPublisherRoleItem);
    }

    static void updatePdndInfo(ConsoleConfiguration consoleConfiguration, ProtocolProperties properties, AccordoServizioParteComune api, String portType, IDServizio idServizio, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, Logger log) throws ProtocolException {
        AbstractConsoleItem modiEServiceIdItem;
        ModIProperties modiProperties = ModIProperties.getInstance();
        boolean signalHub = false;
        if (modiProperties.isSignalHubEnabled()) {
            BooleanProperty modiSignalHubItemValue = (BooleanProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInfoGenSignalHub");
            boolean bl = signalHub = modiSignalHubItemValue != null && modiSignalHubItemValue.getValue() != null && (Boolean)modiSignalHubItemValue.getValue() != false;
        }
        if ((modiEServiceIdItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaInfoGenEserviceId")) != null) {
            modiEServiceIdItem.setRequired(signalHub);
        }
        if (modiProperties.isSignalHubEnabled()) {
            ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.updateSignalHubInfo(consoleConfiguration, properties, api, portType, idServizio, log, signalHub);
            ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.updateSignalHubPublisherInfo(consoleConfiguration, properties, idServizio, registryReader, configIntegrationReader, log, signalHub);
        }
    }

    private static void updateSignalHubInfo(ConsoleConfiguration consoleConfiguration, ProtocolProperties properties, AccordoServizioParteComune api, String portType, IDServizio idServizio, Logger log, boolean signalHub) throws ProtocolException {
        ModIProperties modiProperties = ModIProperties.getInstance();
        BaseConsoleItem modiSignalHubSubtitleItem = ProtocolPropertiesUtils.getBaseConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaAPIImplInfoGenSignalHubSubtitleId");
        if (modiSignalHubSubtitleItem != null) {
            if (signalHub) {
                modiSignalHubSubtitleItem.setType(ConsoleItemType.SUBTITLE);
            } else {
                modiSignalHubSubtitleItem.setType(ConsoleItemType.HIDDEN);
            }
        }
        ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.updatePdndInfoSignalHubOperation(api, portType, idServizio, consoleConfiguration, properties, log, signalHub);
        ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.updatePdndInfoSignalHubAlgo(modiProperties, consoleConfiguration, properties, signalHub);
        ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.updatePdndInfoSignalHubSeed(modiProperties, consoleConfiguration, properties, signalHub);
    }

    private static void updateSignalHubPublisherInfo(ConsoleConfiguration consoleConfiguration, ProtocolProperties properties, IDServizio idServizio, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, Logger log, boolean signalHub) throws ProtocolException {
        ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.updatePdndInfoSignalHubPublisher(consoleConfiguration, properties, idServizio, registryReader, configIntegrationReader, log, signalHub);
    }

    private static void updatePdndInfoSignalHubOperation(AccordoServizioParteComune api, String portType, IDServizio idServizio, ConsoleConfiguration consoleConfiguration, ProtocolProperties properties, Logger log, boolean signalHub) throws ProtocolException {
        StringProperty modiSignalHubOpItemValue;
        AbstractConsoleItem modiSignalHubOpItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaInfoGenSignalHubOp");
        if (modiSignalHubOpItem != null) {
            modiSignalHubOpItem.setRequired(signalHub);
            if (signalHub) {
                modiSignalHubOpItem.setType(ConsoleItemType.SELECT);
                ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.addSignalHubOperations(api, idServizio, portType, modiSignalHubOpItem, log);
            } else {
                modiSignalHubOpItem.setType(ConsoleItemType.HIDDEN);
                modiSignalHubOpItem.clearMapLabelValues();
            }
        }
        if ((modiSignalHubOpItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInfoGenSignalHubOp")) != null && modiSignalHubOpItemValue.getValue() != null && !signalHub) {
            modiSignalHubOpItemValue.setValue(null);
        }
    }

    private static void updatePdndInfoSignalHubAlgo(ModIProperties modiProperties, ConsoleConfiguration consoleConfiguration, ProtocolProperties properties, boolean signalHub) throws ProtocolException {
        StringProperty modiSignalHubAlgItemValue;
        AbstractConsoleItem modiSignalHubAlgItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaInfoGenSignalHubAlg");
        if (modiSignalHubAlgItem != null) {
            if (signalHub) {
                modiSignalHubAlgItem.setType(ConsoleItemType.SELECT);
            } else {
                modiSignalHubAlgItem.setType(ConsoleItemType.HIDDEN);
            }
        }
        if ((modiSignalHubAlgItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInfoGenSignalHubAlg")) != null) {
            if (signalHub) {
                if (modiSignalHubAlgItemValue.getValue() == null || StringUtils.isEmpty((String)((String)modiSignalHubAlgItemValue.getValue()))) {
                    modiSignalHubAlgItemValue.setValue((Object)modiProperties.getSignalHubDefaultAlgorithm());
                }
            } else if (modiSignalHubAlgItemValue.getValue() != null) {
                modiSignalHubAlgItemValue.setValue(null);
            }
        }
    }

    private static void updatePdndInfoSignalHubSeed(ModIProperties modiProperties, ConsoleConfiguration consoleConfiguration, ProtocolProperties properties, boolean signalHub) throws ProtocolException {
        ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.updatePdndInfoSignalHubSeedSize(modiProperties, consoleConfiguration, properties, signalHub);
        ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.updatePdndInfoSignalHubSeedLifeTime(consoleConfiguration, properties, signalHub);
    }

    private static void updatePdndInfoSignalHubSeedSize(ModIProperties modiProperties, ConsoleConfiguration consoleConfiguration, ProtocolProperties properties, boolean signalHub) throws ProtocolException {
        NumberProperty modiSignalHubSeedSizeItemValue;
        AbstractConsoleItem modiSignalHubSeedSizeItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaInfoGenSignalHubSeedSize");
        if (modiSignalHubSeedSizeItem != null) {
            if (signalHub) {
                modiSignalHubSeedSizeItem.setType(ConsoleItemType.SELECT);
            } else {
                modiSignalHubSeedSizeItem.setType(ConsoleItemType.HIDDEN);
            }
        }
        if ((modiSignalHubSeedSizeItemValue = (NumberProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInfoGenSignalHubSeedSize")) != null) {
            if (signalHub) {
                if (modiSignalHubSeedSizeItemValue.getValue() == null) {
                    modiSignalHubSeedSizeItemValue.setValue((Object)modiProperties.getSignalHubDefaultSeedSize().longValue());
                }
            } else if (modiSignalHubSeedSizeItemValue.getValue() != null) {
                modiSignalHubSeedSizeItemValue.setValue(null);
            }
        }
    }

    private static void updatePdndInfoSignalHubSeedLifeTime(ConsoleConfiguration consoleConfiguration, ProtocolProperties properties, boolean signalHub) throws ProtocolException {
        NumberProperty modiSignalHubSeedLifeTimeItemValue;
        AbstractConsoleItem modiSignalHubSeedLifeTimeItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaInfoGenSignalHubSeedLifetime");
        if (modiSignalHubSeedLifeTimeItem != null) {
            modiSignalHubSeedLifeTimeItem.setRequired(signalHub);
            if (signalHub) {
                modiSignalHubSeedLifeTimeItem.setType(ConsoleItemType.TEXT_EDIT);
            } else {
                modiSignalHubSeedLifeTimeItem.setType(ConsoleItemType.HIDDEN);
            }
        }
        if ((modiSignalHubSeedLifeTimeItemValue = (NumberProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInfoGenSignalHubSeedLifetime")) != null && !signalHub && modiSignalHubSeedLifeTimeItemValue.getValue() != null) {
            modiSignalHubSeedLifeTimeItemValue.setValue(null);
        }
    }

    private static void updatePdndInfoSignalHubPublisher(ConsoleConfiguration consoleConfiguration, ProtocolProperties properties, IDServizio idServizio, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, Logger log, boolean signalHub) throws ProtocolException {
        StringProperty modiSignalHubPublisherItemValue;
        AbstractConsoleItem modiSignalHubPublisherItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaInfoGenSignalHubPulisherText");
        if (modiSignalHubPublisherItem != null) {
            if (signalHub) {
                modiSignalHubPublisherItem.setType(ConsoleItemType.TEXT);
            } else {
                modiSignalHubPublisherItem.setType(ConsoleItemType.HIDDEN);
            }
        }
        if ((modiSignalHubPublisherItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInfoGenSignalHubPulisherText")) != null) {
            if (signalHub) {
                modiSignalHubPublisherItemValue.setValue((Object)"Pubblicatore");
            } else {
                modiSignalHubPublisherItemValue.setValue(null);
            }
        }
        ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.updatePdndInfoSignalHubPublisherSA(consoleConfiguration, properties, idServizio, registryReader, configIntegrationReader, log, signalHub);
        ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.updatePdndInfoSignalHubPublisherRole(consoleConfiguration, properties, registryReader, log, signalHub);
    }

    private static void updatePdndInfoSignalHubPublisherSA(ConsoleConfiguration consoleConfiguration, ProtocolProperties properties, IDServizio idServizio, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, Logger log, boolean signalHub) throws ProtocolException {
        StringProperty modiSignalHubPublisherSAItemValue;
        AbstractConsoleItem modiSignalHubPublisherSAItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaInfoGenSignalHubPulisherSA");
        if (modiSignalHubPublisherSAItem != null) {
            if (signalHub) {
                modiSignalHubPublisherSAItem.setType(ConsoleItemType.SELECT);
                ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.addSignalHubServiziApplicativi(registryReader, configIntegrationReader, modiSignalHubPublisherSAItem, log, idServizio);
            } else {
                modiSignalHubPublisherSAItem.setType(ConsoleItemType.HIDDEN);
                modiSignalHubPublisherSAItem.clearMapLabelValues();
            }
        }
        if ((modiSignalHubPublisherSAItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInfoGenSignalHubPulisherSA")) != null && !signalHub) {
            modiSignalHubPublisherSAItemValue.setValue(null);
        }
    }

    private static void updatePdndInfoSignalHubPublisherRole(ConsoleConfiguration consoleConfiguration, ProtocolProperties properties, IRegistryReader registryReader, Logger log, boolean signalHub) throws ProtocolException {
        StringProperty modiSignalHubPublisherRoleItemValue;
        AbstractConsoleItem modiSignalHubPublisherRoleItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaInfoGenSignalHubPulisherRole");
        if (modiSignalHubPublisherRoleItem != null) {
            if (signalHub) {
                modiSignalHubPublisherRoleItem.setType(ConsoleItemType.SELECT);
                ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.addSignalHubRuoli(registryReader, modiSignalHubPublisherRoleItem, log);
            } else {
                modiSignalHubPublisherRoleItem.setType(ConsoleItemType.HIDDEN);
                modiSignalHubPublisherRoleItem.clearMapLabelValues();
            }
        }
        if ((modiSignalHubPublisherRoleItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInfoGenSignalHubPulisherRole")) != null && !signalHub) {
            modiSignalHubPublisherRoleItemValue.setValue(null);
        }
    }

    private static void addSignalHubOperations(AccordoServizioParteComune api, IDServizio idServizio, String portType, AbstractConsoleItem<?> modiSignalHubOpItem, Logger log) throws ProtocolException {
        Map<String, String> azioni = ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.getSignalHubOperations(api, idServizio, portType, log);
        if (azioni != null && !azioni.isEmpty()) {
            for (Map.Entry<String, String> entry : azioni.entrySet()) {
                String azioneId = entry.getKey();
                String azioneLabel = entry.getValue();
                ((StringConsoleItem)modiSignalHubOpItem).addLabelValue(azioneLabel, (Object)azioneId);
            }
        }
    }

    private static Map<String, String> getSignalHubOperations(AccordoServizioParteComune api, IDServizio idServizio, String portType, Logger log) throws ProtocolException {
        AccordoServizioParteSpecifica aspsRicercaAzioni = new AccordoServizioParteSpecifica();
        aspsRicercaAzioni.setTipo(idServizio.getTipo());
        aspsRicercaAzioni.setNome(idServizio.getNome());
        aspsRicercaAzioni.setVersione(idServizio.getVersione());
        if (idServizio.getSoggettoErogatore() != null) {
            aspsRicercaAzioni.setTipoSoggettoErogatore(idServizio.getSoggettoErogatore().getTipo());
            aspsRicercaAzioni.setNomeSoggettoErogatore(idServizio.getSoggettoErogatore().getNome());
        }
        aspsRicercaAzioni.setPortType(portType);
        AccordoServizioParteComuneSintetico aspcSelected = new AccordoServizioParteComuneSintetico(api);
        ArrayList filtraAzioniUtilizzate = new ArrayList();
        Map azioni = null;
        try {
            azioni = AzioniUtils.getAzioniConLabel((AccordoServizioParteSpecifica)aspsRicercaAzioni, (AccordoServizioParteComuneSintetico)aspcSelected, (boolean)true, (boolean)false, filtraAzioniUtilizzate, (String)"-", (String)"-", (Logger)log);
        }
        catch (Exception e) {
            throw new ProtocolException("Lettura azioni '" + idServizio + "' non riuscita: " + e.getMessage(), (Throwable)e);
        }
        return azioni;
    }

    private static IDPortaDelegata readPDSignalHub(IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, Logger log, IDServizio idServizio, IDAccordo idAccordoSignalHubPushAPI) {
        ProtocolFiltroRicercaFruizioniServizio filtro = new ProtocolFiltroRicercaFruizioniServizio();
        filtro.setIdAccordoServizioParteComune(idAccordoSignalHubPushAPI);
        filtro.setSoggettoFruitore(idServizio.getSoggettoErogatore());
        try {
            List list = registryReader.findIdFruizioni(filtro);
            if (list != null && !list.isEmpty()) {
                return ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.readPDSignalHub(configIntegrationReader, list);
            }
        }
        catch (Exception e) {
            log.error("Lettura id servizio signalhub api push fallita: " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static IDPortaDelegata readPDSignalHub(IConfigIntegrationReader configIntegrationReader, List<IDFruizione> list) throws RegistryException {
        List listMF;
        IDFruizione idF = list.get(0);
        if (idF != null && (listMF = configIntegrationReader.getMappingFruizionePortaDelegataList(idF.getIdFruitore(), idF.getIdServizio())) != null && !listMF.isEmpty()) {
            for (MappingFruizionePortaDelegata mappingFruizionePortaDelegata : listMF) {
                if (!mappingFruizionePortaDelegata.isDefault()) continue;
                return mappingFruizionePortaDelegata.getIdPortaDelegata();
            }
        }
        return null;
    }

    private static void addSignalHubServiziApplicativi(IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, AbstractConsoleItem<?> modiSignalHubPublisherSAItem, Logger log, IDServizio idServizio) {
        ((StringConsoleItem)modiSignalHubPublisherSAItem).addLabelValue("-", (Object)"-");
        if (idServizio != null) {
            try {
                List<IDServizioApplicativo> idSA = ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.getSignalHubServiziApplicativi(registryReader, configIntegrationReader, idServizio);
                if (idSA != null && !idSA.isEmpty()) {
                    ArrayList<String> nomi = new ArrayList<String>();
                    for (IDServizioApplicativo idServizioApplicativo : idSA) {
                        nomi.add(idServizioApplicativo.getNome());
                    }
                    Collections.sort(nomi);
                    for (String s : nomi) {
                        ((StringConsoleItem)modiSignalHubPublisherSAItem).addLabelValue(s, (Object)s);
                    }
                }
            }
            catch (Exception e) {
                log.error("Lettura porta delegata per signalhub api push fallita: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static List<IDServizioApplicativo> getSignalHubServiziApplicativi(IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDServizio idServizio) throws RegistryNotFound, RegistryException, DriverRegistroServiziException, ProtocolException {
        IDAccordo idAccordoSignalHubPushAPI = ModIDynamicConfigurationAccordiParteComuneUtilities.getIdAccordoSignalHubPush(registryReader, ModIProperties.getInstance());
        IDPortaDelegata idPD = ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.readPDSignalHub(registryReader, configIntegrationReader, logger, idServizio, idAccordoSignalHubPushAPI);
        PortaDelegata pd = configIntegrationReader.getPortaDelegata(idPD);
        return configIntegrationReader.findIdServiziApplicativiByPdAuth(pd, true, true);
    }

    private static void addSignalHubRuoli(IRegistryReader registryReader, AbstractConsoleItem<?> modiSignalHubPublisherRoleItem, Logger log) {
        ((StringConsoleItem)modiSignalHubPublisherRoleItem).addLabelValue("-", (Object)"-");
        List<IDRuolo> l = ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.getSignalHubRuoli(registryReader, log);
        if (l != null && !l.isEmpty()) {
            for (IDRuolo idRuolo : l) {
                ((StringConsoleItem)modiSignalHubPublisherRoleItem).addLabelValue(idRuolo.getNome(), (Object)idRuolo.getNome());
            }
        }
    }

    private static List<IDRuolo> getSignalHubRuoli(IRegistryReader registryReader, Logger log) {
        List l = List.of();
        try {
            ProtocolFiltroRicercaRuoli filtro = new ProtocolFiltroRicercaRuoli();
            filtro.setContesto(RuoloContesto.PORTA_DELEGATA);
            filtro.setTipologia(RuoloTipologia.INTERNO);
            l = registryReader.findIdRuoli(filtro);
        }
        catch (RegistryNotFound e) {
            log.debug("Ruoli per signalhub api push non presenti" + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error("Lettura id accordo signalhub api push fallita: " + e.getMessage(), (Throwable)e);
        }
        return l;
    }

    public static void validatePdndInfo(IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, AccordoServizioParteComune api, IDServizio idServizio, String portType, ConsoleConfiguration consoleConfiguration, ProtocolProperties properties) throws ProtocolException {
        ModIProperties modiProperties = ModIProperties.getInstance();
        String modiEServiceIdItemValue = ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.validatePdndInfoId(registryReader, idServizio, consoleConfiguration, properties, "modipaInfoGenEserviceId", "Identificativo eService", ModIProperties.getInstance().isPdndEServiceIdCheckUnique());
        ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.validatePdndInfoId(registryReader, idServizio, consoleConfiguration, properties, "modipaInfoGenDescriptorId", "Identificativo Descrittore", ModIProperties.getInstance().isPdndDescriptorIdCheckUnique());
        boolean signalHub = false;
        if (modiProperties.isSignalHubEnabled()) {
            BooleanProperty modiSignalHubItemValue = (BooleanProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInfoGenSignalHub");
            boolean bl = signalHub = modiSignalHubItemValue != null && modiSignalHubItemValue.getValue() != null && (Boolean)modiSignalHubItemValue.getValue() != false;
        }
        if (signalHub) {
            if (modiEServiceIdItemValue == null) {
                throw new ProtocolException("SignalHub richiede che sia indicata l'id dell'eservice erogato");
            }
            ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.validatePdndInfoSignalHub(registryReader, configIntegrationReader, api, idServizio, portType, consoleConfiguration, properties);
        }
    }

    private static String validatePdndInfoId(IRegistryReader registryReader, IDServizio idServizio, ConsoleConfiguration consoleConfiguration, ProtocolProperties properties, String id, String label, boolean checkUnique) throws ProtocolException {
        AbstractConsoleItem modiEServiceIdItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)id);
        StringProperty modiEServiceIdItemValue = null;
        if (modiEServiceIdItem != null) {
            modiEServiceIdItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)id);
            String idValue = null;
            if (modiEServiceIdItemValue != null && modiEServiceIdItemValue.getValue() != null && !"".equals(modiEServiceIdItemValue.getValue())) {
                try {
                    InputValidationUtils.validateTextAreaInput((String)((String)modiEServiceIdItemValue.getValue()), (String)label);
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
                idValue = (String)modiEServiceIdItemValue.getValue();
            }
            ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.validatePdndInfoIdExists(registryReader, idServizio, id, label, checkUnique, idValue);
            return idValue;
        }
        return null;
    }

    private static void validatePdndInfoIdExists(IRegistryReader registryReader, IDServizio idServizio, String id, String label, boolean checkUnique, String idValue) throws ProtocolException {
        if (idValue != null && checkUnique) {
            if ("modipaInfoGenDescriptorId".equals(id)) {
                List<String> values = ModISecurityConfig.convertToList(idValue);
                if (values != null && !values.isEmpty()) {
                    for (String v : values) {
                        ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.validatePdndInfoIdExists(registryReader, idServizio, id, label, v, LikeConfig.contains((boolean)false));
                    }
                }
            } else {
                ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.validatePdndInfoIdExists(registryReader, idServizio, id, label, idValue, null);
            }
        }
    }

    private static void validatePdndInfoIdExists(IRegistryReader registryReader, IDServizio idServizio, String id, String label, String idValue, LikeConfig likeConfig) throws ProtocolException {
        ProtocolFiltroRicercaServizi filtro = new ProtocolFiltroRicercaServizi();
        filtro.setProtocolPropertiesServizi(new ProtocolProperties());
        filtro.getProtocolPropertiesServizi().addProperty(id, idValue, likeConfig);
        List list = null;
        try {
            list = registryReader.findIdAccordiServizioParteSpecifica(filtro);
            if (list != null && !list.isEmpty()) {
                for (IDServizio check : list) {
                    if (check.equals(idServizio, false)) continue;
                    String msg = "L'erogazione '" + check.getNome() + " v" + check.getVersione() + "' erogata da '" + check.getSoggettoErogatore().getNome() + "' risulta gi\u00e0 registrata con il campo '" + label + "' valorizzato con l'identificativo fornito";
                    if (likeConfig == null) {
                        msg = msg + " '" + idValue + "'";
                    }
                    throw new ProtocolException(msg);
                }
            }
        }
        catch (RegistryNotFound registryNotFound) {
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    private static void validatePdndInfoSignalHub(IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, AccordoServizioParteComune api, IDServizio idServizio, String portType, ConsoleConfiguration consoleConfiguration, ProtocolProperties properties) throws ProtocolException {
        ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.validatePdndInfoSignalHubOperation(api, idServizio, portType, consoleConfiguration, properties);
        ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.validatePdndInfoSignalHubAlgorithm(consoleConfiguration, properties);
        ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.validatePdndInfoSignalHubSeedSize(consoleConfiguration, properties);
        ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.validatePdndInfoSignalHubLifeTime(consoleConfiguration, properties);
        ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.validatePdndInfoSignalHubPublisher(registryReader, configIntegrationReader, idServizio, consoleConfiguration, properties);
    }

    private static void validatePdndInfoSignalHubOperation(AccordoServizioParteComune api, IDServizio idServizio, String portType, ConsoleConfiguration consoleConfiguration, ProtocolProperties properties) throws ProtocolException {
        AbstractConsoleItem profiloSignalHubOperationItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaInfoGenSignalHubOp");
        StringProperty profiloSignalHubOperationItemValue = null;
        String profiloSignalHubOperation = null;
        if (profiloSignalHubOperationItem != null && (profiloSignalHubOperationItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInfoGenSignalHubOp")) != null && profiloSignalHubOperationItemValue.getValue() != null && !"".equals(profiloSignalHubOperationItemValue.getValue())) {
            profiloSignalHubOperation = (String)profiloSignalHubOperationItemValue.getValue();
        }
        if (profiloSignalHubOperation == null || "".equals(profiloSignalHubOperation) || "-".equals(profiloSignalHubOperation)) {
            throw new ProtocolException("SignalHub richiede che sia indicata l'operazione che esporr\u00e0 le informazioni di pseudoanonimizzazione");
        }
        Map<String, String> operations = ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.getSignalHubOperations(api, idServizio, portType, logger);
        if (!operations.containsKey(profiloSignalHubOperation)) {
            throw new ProtocolException("Risorsa che espone le informazioni di pseudoanonimizzazione non riconosciuta");
        }
    }

    private static void validatePdndInfoSignalHubAlgorithm(ConsoleConfiguration consoleConfiguration, ProtocolProperties properties) throws ProtocolException {
        List<String> algorithms;
        StringProperty profiloSignalHubAlgorithmItemValue;
        AbstractConsoleItem profiloSignalHubAlgorithmItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaInfoGenSignalHubAlg");
        if (profiloSignalHubAlgorithmItem != null && (profiloSignalHubAlgorithmItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInfoGenSignalHubAlg")) != null && profiloSignalHubAlgorithmItemValue.getValue() != null && !"".equals(profiloSignalHubAlgorithmItemValue.getValue()) && !(algorithms = ModIProperties.getInstance().getSignalHubAlgorithms()).contains(profiloSignalHubAlgorithmItemValue.getValue())) {
            throw new ProtocolException("Algoritmo per la generazione del digest non riconosciuto tra quelli indicate tra le proprieta ModI");
        }
    }

    private static void validatePdndInfoSignalHubSeedSize(ConsoleConfiguration consoleConfiguration, ProtocolProperties properties) throws ProtocolException {
        List<Integer> seedSizes;
        NumberProperty profiloSignalHubSeedSizeItemValue;
        AbstractConsoleItem profiloSignalHubSeedSizetem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaInfoGenSignalHubSeedSize");
        Integer seedSize = null;
        if (profiloSignalHubSeedSizetem != null && (profiloSignalHubSeedSizeItemValue = (NumberProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInfoGenSignalHubSeedSize")) != null && profiloSignalHubSeedSizeItemValue.getValue() != null && !(seedSizes = ModIProperties.getInstance().getSignalHubSeedSize()).contains(seedSize = Integer.valueOf(((Long)profiloSignalHubSeedSizeItemValue.getValue()).intValue()))) {
            throw new ProtocolException("Dimensione del seme per la generazione del digest non riconosciuto tra quelli indicate tra le proprieta ModI");
        }
    }

    private static void validatePdndInfoSignalHubLifeTime(ConsoleConfiguration consoleConfiguration, ProtocolProperties properties) throws ProtocolException {
        NumberProperty profiloSignalHubSeedLifeTimeItemValue;
        AbstractConsoleItem profiloSignalHubSeedLifeTimeItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaInfoGenSignalHubSeedLifetime");
        if (profiloSignalHubSeedLifeTimeItem != null && (profiloSignalHubSeedLifeTimeItemValue = (NumberProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInfoGenSignalHubSeedLifetime")) != null && profiloSignalHubSeedLifeTimeItemValue.getValue() != null) {
            try {
                long i = (Long)profiloSignalHubSeedLifeTimeItemValue.getValue();
                if (i <= 0L) {
                    throw new ProtocolException("deve essere fornito un numero intero maggiore di 0");
                }
            }
            catch (Exception e) {
                throw new ProtocolException("Giorni Rotazione Seme '" + profiloSignalHubSeedLifeTimeItemValue.getValue() + "' non valido; must be a positive integer greater than 0");
            }
        }
    }

    private static void validatePdndInfoSignalHubPublisher(IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDServizio idServizio, ConsoleConfiguration consoleConfiguration, ProtocolProperties properties) throws ProtocolException {
        boolean publisherSAundefined = ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.validatePdndIfnoSignalHubPublisherSA(registryReader, configIntegrationReader, idServizio, consoleConfiguration, properties);
        boolean publisherRoleUndefined = ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.validatePdndIfnoSignalHubPublisherRole(registryReader, consoleConfiguration, properties);
        if (publisherSAundefined && publisherRoleUndefined) {
            throw new ProtocolException("Deve essere selezionato un applicativo o un ruolo autorizzato a pubblicare segnali di variazione del servizio");
        }
    }

    private static boolean validatePdndIfnoSignalHubPublisherSA(IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDServizio idServizio, ConsoleConfiguration consoleConfiguration, ProtocolProperties properties) throws ProtocolException {
        AbstractConsoleItem profiloSignalHubSAItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaInfoGenSignalHubPulisherSA");
        StringProperty profiloSignalHubSAItemValue = null;
        String profiloSignalHubSA = null;
        if (profiloSignalHubSAItem != null && (profiloSignalHubSAItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInfoGenSignalHubPulisherSA")) != null && profiloSignalHubSAItemValue.getValue() != null && !"".equals(profiloSignalHubSAItemValue.getValue()) && !"-".equals(profiloSignalHubSAItemValue.getValue())) {
            profiloSignalHubSA = (String)profiloSignalHubSAItemValue.getValue();
            try {
                String finalSAName = profiloSignalHubSA;
                List<IDServizioApplicativo> idSAs = ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.getSignalHubServiziApplicativi(registryReader, configIntegrationReader, idServizio);
                long matched = idSAs.stream().filter(id -> id.getNome().equals(finalSAName)).count();
                if (matched < 1L) {
                    throw new ProtocolException("L'applicativo definito non risulta abilitato alla pubblicazione di segnali");
                }
            }
            catch (DriverRegistroServiziException | RegistryException | RegistryNotFound e) {
                throw new ProtocolException("L'applicativo definito non risulta abilitato alla pubblicazione di segnali", e);
            }
        }
        return profiloSignalHubSA == null || "".equals(profiloSignalHubSA) || "-".equals(profiloSignalHubSA);
    }

    private static boolean validatePdndIfnoSignalHubPublisherRole(IRegistryReader registryReader, ConsoleConfiguration consoleConfiguration, ProtocolProperties properties) throws ProtocolException {
        AbstractConsoleItem profiloSignalHubRoleItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaInfoGenSignalHubPulisherRole");
        StringProperty profiloSignalHubRoleItemValue = null;
        String profiloSignalHubRole = null;
        if (profiloSignalHubRoleItem != null && (profiloSignalHubRoleItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInfoGenSignalHubPulisherRole")) != null && profiloSignalHubRoleItemValue.getValue() != null && !"".equals(profiloSignalHubRoleItemValue.getValue()) && !"-".equals(profiloSignalHubRoleItemValue.getValue())) {
            String finalRole = profiloSignalHubRole = (String)profiloSignalHubRoleItemValue.getValue();
            List<IDRuolo> roles = ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.getSignalHubRuoli(registryReader, logger);
            long matched = roles.stream().filter(r -> r.getNome().equals(finalRole)).count();
            if (matched == 0L) {
                throw new ProtocolException("Il ruolo interno indicato non esiste");
            }
        }
        return profiloSignalHubRole == null || "".equals(profiloSignalHubRole) || "-".equals(profiloSignalHubRole);
    }

    static void addSignaHubFruizioneConfig(ModIProperties modiProperties, ConsoleConfiguration configuration, boolean rest) throws ProtocolException {
        TitleConsoleItem titolo = (TitleConsoleItem)ProtocolPropertiesFactory.newTitleItem((String)"modipaSignalHubPush", (String)"ModI - Signal Hub");
        configuration.addConsoleItem((BaseConsoleItem)titolo);
        ModISignalHubConfig c = modiProperties.getSignalHubConfig();
        if (c != null && c.getClaims() != null && !c.getClaims().isEmpty()) {
            for (ModISignalHubParamConfig modISignalHubParamConfig : c.getClaims()) {
                ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.addSignaHubFruizioneConfig(configuration, modISignalHubParamConfig, rest);
            }
        }
    }

    private static String addSignaHubFruizioneConfig(ConsoleConfiguration configuration, ModISignalHubParamConfig paramConfig, boolean rest) throws ProtocolException {
        String modeId = "modipaSignalHubPushParamMode" + paramConfig.getNome();
        StringConsoleItem modeItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)modeId, (String)paramConfig.getLabel());
        modeItem.addLabelValue("Default", (Object)"default");
        modeItem.addLabelValue("Ridefinito", (Object)"ridefinisci");
        modeItem.setDefaultValue((Object)"default");
        modeItem.setReloadOnChange(true, true);
        configuration.addConsoleItem((BaseConsoleItem)modeItem);
        StringConsoleItem ridefineItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_AREA, (String)("modipaSignalHubPushParamValue" + paramConfig.getNome()), (String)"");
        ridefineItem.setRequired(true);
        ridefineItem.setRows(Integer.valueOf(2));
        ridefineItem.setInfo(ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.buildConsoleItemInfoCorniceSicurezza(paramConfig.getLabel(), rest));
        if ("default".equals("default")) {
            ridefineItem.setType(ConsoleItemType.HIDDEN);
        }
        configuration.addConsoleItem((BaseConsoleItem)ridefineItem);
        return modeId;
    }

    static void updateSignaHubFruizioneConfig(ModIProperties modiProperties, ConsoleConfiguration configuration, ProtocolProperties properties) throws ProtocolException {
        ModISignalHubConfig c = modiProperties.getSignalHubConfig();
        if (c != null && c.getClaims() != null && !c.getClaims().isEmpty()) {
            for (ModISignalHubParamConfig modISignalHubParamConfig : c.getClaims()) {
                ModIDynamicConfigurationAccordiParteSpecificaSicurezzaMessaggioUtilities.updateSignaHubFruizioneConfig(configuration, properties, modISignalHubParamConfig);
            }
        }
    }

    private static void updateSignaHubFruizioneConfig(ConsoleConfiguration consoleConfiguration, ProtocolProperties properties, ModISignalHubParamConfig paramConfig) throws ProtocolException {
        String modeId = "modipaSignalHubPushParamMode" + paramConfig.getNome();
        boolean ridefinisciItem = false;
        StringProperty selectSchemaModeItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)modeId);
        ridefinisciItem = selectSchemaModeItemValue == null ? false : "ridefinisci".equals(selectSchemaModeItemValue.getValue());
        AbstractConsoleItem modeItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)modeId);
        if (ridefinisciItem) {
            modeItem.setInfo(null);
        } else {
            modeItem.setInfo(new ConsoleItemInfo(paramConfig.getLabel()));
            modeItem.getInfo().setHeaderBody("Il parametro 'PARAM' deve essere indicato nella richiesta di fruizione tramite una delle seguenti modalit\u00e0:".replace("PARAM", paramConfig.getNome()));
            modeItem.getInfo().setListBody(new ArrayList());
            modeItem.getInfo().getListBody().addAll(paramConfig.getRulesInfo());
        }
        String id = "modipaSignalHubPushParamValue" + paramConfig.getNome();
        AbstractConsoleItem valueItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)id);
        if (ridefinisciItem) {
            valueItem.setType(ConsoleItemType.TEXT_AREA);
        } else {
            valueItem.setType(ConsoleItemType.HIDDEN);
            StringProperty selectItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)id);
            if (selectItemValue != null) {
                selectItemValue.setValue(null);
            }
        }
    }
}

