/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.tracciamento;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.tracciamento.Proprieta;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.basic.tracciamento.TracciaSerializer;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.modipa.utils.ModIPropertiesUtils;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.tracciamento.TracciaExtInfo;
import org.openspcoop2.protocol.sdk.tracciamento.TracciaExtInfoDefinition;

public class ModITracciaSerializer
extends TracciaSerializer {
    private ModIProperties modiProperties = ModIProperties.getInstance();

    public ModITracciaSerializer(IProtocolFactory<?> factory) throws ProtocolException {
        super(factory);
    }

    public boolean isSupportedExtInfo() {
        return true;
    }

    public List<TracciaExtInfoDefinition> getExtInfoDefinition() {
        ArrayList<TracciaExtInfoDefinition> list = new ArrayList<TracciaExtInfoDefinition>();
        TracciaExtInfoDefinition interazioneAsincrona = new TracciaExtInfoDefinition();
        interazioneAsincrona.setPrefixId("ProfiloInterazioneAsincrona-");
        interazioneAsincrona.setLabel("Interazione Non Bloccante");
        list.add(interazioneAsincrona);
        TracciaExtInfoDefinition sicurezzaMessaggio = new TracciaExtInfoDefinition();
        sicurezzaMessaggio.setPrefixId("ProfiloSicurezzaMessaggio-");
        sicurezzaMessaggio.setLabel("Sicurezza Messaggio");
        list.add(sicurezzaMessaggio);
        TracciaExtInfoDefinition sicurezzaMessaggioSignedHeaders = new TracciaExtInfoDefinition();
        sicurezzaMessaggioSignedHeaders.setPrefixId("ProfiloSicurezzaMessaggioSignedHeader-");
        sicurezzaMessaggioSignedHeaders.setLabel("Headers HTTP Firmati");
        list.add(sicurezzaMessaggioSignedHeaders);
        TracciaExtInfoDefinition sicurezzaMessaggioSignedSoapParts = new TracciaExtInfoDefinition();
        sicurezzaMessaggioSignedSoapParts.setPrefixId("ProfiloSicurezzaMessaggioSignedSoap-");
        sicurezzaMessaggioSignedSoapParts.setLabel("Elementi SOAP Firmati");
        list.add(sicurezzaMessaggioSignedSoapParts);
        TracciaExtInfoDefinition sicurezzaMessaggioTokenAudit = new TracciaExtInfoDefinition();
        sicurezzaMessaggioTokenAudit.setPrefixId("ProfiloSicurezzaMessaggioAudit-");
        sicurezzaMessaggioTokenAudit.setLabel("Informazioni Audit");
        list.add(sicurezzaMessaggioTokenAudit);
        return list;
    }

    public List<TracciaExtInfo> extractExtInfo(Busta busta, ServiceBinding tipoApi) {
        boolean terminologiaBozza = this.modiProperties.isModIVersioneBozza();
        List list = super.extractExtInfo(busta, tipoApi);
        if (list != null && !list.isEmpty()) {
            for (TracciaExtInfo tracciaExtInfo : list) {
                List proprieta = tracciaExtInfo.getProprieta();
                if (proprieta == null || proprieta.isEmpty()) continue;
                for (Proprieta p : proprieta) {
                    if ("ProfiloInterazione".equals(p.getNome())) {
                        p.setNome("Interazione");
                        if ("crud".equalsIgnoreCase(p.getValore())) {
                            p.setValore("Accesso CRUD");
                            continue;
                        }
                        if ("bloccante".equalsIgnoreCase(p.getValore())) {
                            p.setValore("Bloccante");
                            continue;
                        }
                        if (!"nonBloccante".equalsIgnoreCase(p.getValore())) continue;
                        p.setValore("Non Bloccante");
                        continue;
                    }
                    if ("ProfiloSicurezzaCanale".equals(p.getNome())) {
                        p.setNome("Sicurezza Canale");
                        if ("idac01".equalsIgnoreCase(p.getValore())) {
                            p.setValore(terminologiaBozza ? "IDAC01" : "ID_AUTH_CHANNEL_01");
                            continue;
                        }
                        if (!"idac02".equalsIgnoreCase(p.getValore())) continue;
                        p.setValore(terminologiaBozza ? "IDAC02" : "ID_AUTH_CHANNEL_02");
                        continue;
                    }
                    if ("ProfiloSicurezzaMessaggio".equals(p.getNome())) {
                        p.setNome("Sicurezza Messaggio");
                        if (tipoApi != null && ServiceBinding.REST.equals((Object)tipoApi)) {
                            if (ModIPropertiesUtils.convertProfiloSicurezzaToSDKValue("idam01", true).equalsIgnoreCase(p.getValore())) {
                                p.setValore(terminologiaBozza ? "IDAR01" : "ID_AUTH_REST_01");
                                continue;
                            }
                            if (ModIPropertiesUtils.convertProfiloSicurezzaToSDKValue("idam02", true).equalsIgnoreCase(p.getValore())) {
                                p.setValore(terminologiaBozza ? "IDAR02" : "ID_AUTH_REST_02");
                                continue;
                            }
                            if (ModIPropertiesUtils.convertProfiloSicurezzaToSDKValue("idam0301", true).equalsIgnoreCase(p.getValore())) {
                                p.setValore(terminologiaBozza ? "IDAR03 con IDAR01" : "INTEGRITY_REST_01 con ID_AUTH_REST_01");
                                continue;
                            }
                            if (ModIPropertiesUtils.convertProfiloSicurezzaToSDKValue("idam0302", true).equalsIgnoreCase(p.getValore())) {
                                p.setValore(terminologiaBozza ? "IDAR03 con IDAR02" : "INTEGRITY_REST_01 con ID_AUTH_REST_02");
                                continue;
                            }
                            if (ModIPropertiesUtils.convertProfiloSicurezzaToSDKValue("idam0401", true).equalsIgnoreCase(p.getValore())) {
                                p.setValore("INTEGRITY_REST_02 con ID_AUTH_REST_01");
                                continue;
                            }
                            if (!ModIPropertiesUtils.convertProfiloSicurezzaToSDKValue("idam0402", true).equalsIgnoreCase(p.getValore())) continue;
                            p.setValore("INTEGRITY_REST_02 con ID_AUTH_REST_02");
                            continue;
                        }
                        if (tipoApi == null || !ServiceBinding.SOAP.equals((Object)tipoApi)) continue;
                        if (ModIPropertiesUtils.convertProfiloSicurezzaToSDKValue("idam01", false).equalsIgnoreCase(p.getValore())) {
                            p.setValore(terminologiaBozza ? "IDAS01" : "ID_AUTH_SOAP_01");
                            continue;
                        }
                        if (ModIPropertiesUtils.convertProfiloSicurezzaToSDKValue("idam02", false).equalsIgnoreCase(p.getValore())) {
                            p.setValore(terminologiaBozza ? "IDAS02" : "ID_AUTH_SOAP_02");
                            continue;
                        }
                        if (ModIPropertiesUtils.convertProfiloSicurezzaToSDKValue("idam0301", false).equalsIgnoreCase(p.getValore())) {
                            p.setValore(terminologiaBozza ? "IDAS03 con IDAS01" : "INTEGRITY_SOAP_01 con ID_AUTH_SOAP_01");
                            continue;
                        }
                        if (!ModIPropertiesUtils.convertProfiloSicurezzaToSDKValue("idam0302", false).equalsIgnoreCase(p.getValore())) continue;
                        p.setValore(terminologiaBozza ? "IDAS03 con IDAS02" : "INTEGRITY_SOAP_01 con ID_AUTH_SOAP_02");
                        continue;
                    }
                    if ("GenerazioneTokenIDAuth".equals(p.getNome())) {
                        p.setNome("Generazione Token");
                        continue;
                    }
                    if ("ProfiloSicurezzaAudit".equals(p.getNome())) {
                        p.setNome("Informazioni Audit");
                        continue;
                    }
                    if ("ProfiloSicurezzaAudit-SchemaDati".equals(p.getNome())) {
                        p.setNome("Schema Dati Audit");
                        continue;
                    }
                    if (!"Headers HTTP Firmati".equals(tracciaExtInfo.getLabel()) || p.getNome() == null || !p.getNome().contains("___#") || p.getNome().endsWith("___#")) continue;
                    p.setNome(p.getNome().substring(0, p.getNome().indexOf("___#")));
                }
            }
        }
        return list;
    }
}

