/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.validator;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.Credenziali;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.PortaApplicativaSoggettiFruitori;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.FiltroRicercaProtocolPropertyConfig;
import org.openspcoop2.core.config.driver.FiltroRicercaServiziApplicativi;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.core.GestoreRichieste;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.services.core.RicezioneBusteGestioneAutenticazione;
import org.openspcoop2.protocol.engine.ConfigurazioneFiltroServiziApplicativi;
import org.openspcoop2.protocol.modipa.constants.ModIConsoleCostanti;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.Trasmissione;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaServiziApplicativi;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestFruitore;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.utils.ModIUtils;
import org.openspcoop2.security.keystore.MerlinKeystore;
import org.openspcoop2.security.keystore.cache.GestoreKeystoreCache;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.ArchiveType;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.certificate.CertificateUtils;
import org.openspcoop2.utils.certificate.PrincipalType;
import org.slf4j.Logger;

public class IdentificazioneApplicativoMittenteUtils {
    private IdentificazioneApplicativoMittenteUtils() {
    }

    private static void logError(Logger log, String msg, Exception e) {
        log.error(msg, (Throwable)e);
    }

    public static IDServizioApplicativo identificazioneApplicativoMittenteByX509(Logger log, IState state, X509Certificate x509, OpenSPCoop2Message msg, Busta busta, Context context, IProtocolFactory<?> factory, RequestInfo requestInfo, MsgDiagnostico msgDiag) throws ProtocolException {
        try {
            IDSoggetto idSoggettoMittente = null;
            if (busta.getTipoMittente() != null && busta.getMittente() != null) {
                idSoggettoMittente = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
            }
            IDServizioApplicativo idServizioApplicativo = null;
            boolean rilevatoSoggettoIntermediario = false;
            if (x509 != null) {
                CertificateInfo certificate = new CertificateInfo(x509, "applicativoMittente");
                RequestFruitore requestFruitoreToken = null;
                String certificateKey = null;
                try {
                    certificateKey = GestoreRichieste.toCertificateKey((CertificateInfo)certificate);
                    if (certificateKey != null) {
                        requestFruitoreToken = GestoreRichieste.readFruitoreTokenModI((RequestInfo)requestInfo, (String)certificateKey);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                idServizioApplicativo = certificateKey != null && requestFruitoreToken != null && requestFruitoreToken.getCertificateKey() != null && requestFruitoreToken.getCertificateKey().equals(certificateKey) ? requestFruitoreToken.getIdServizioApplicativoFruitore() : IdentificazioneApplicativoMittenteUtils.identificazioneApplicativoMittenteByX509Engine(state, requestInfo, certificate);
                if (idServizioApplicativo != null) {
                    if (idSoggettoMittente == null) {
                        idSoggettoMittente = idServizioApplicativo.getIdSoggettoProprietario();
                    } else if (!idServizioApplicativo.getIdSoggettoProprietario().equals((Object)idSoggettoMittente)) {
                        Soggetto soggettoCanale = RegistroServiziManager.getInstance((IState)state).getSoggetto(idSoggettoMittente, null, requestInfo);
                        if (ModIUtils.isSoggettoCanaleIntermediario((Soggetto)soggettoCanale, (Logger)log)) {
                            String idTransazione = null;
                            if (context.containsKey(Costanti.ID_TRANSAZIONE)) {
                                idTransazione = (String)context.getObject(Costanti.ID_TRANSAZIONE);
                            }
                            RicezioneBusteGestioneAutenticazione.registraIntermediario((IDSoggetto)idSoggettoMittente, (MsgDiagnostico)msgDiag, (String)idTransazione, null, (Context)context);
                            idSoggettoMittente = idServizioApplicativo.getIdSoggettoProprietario();
                            rilevatoSoggettoIntermediario = true;
                        } else {
                            String msgError = ModIUtils.getMessaggioErroreDominioCanaleDifferenteDominioApplicativo((IDServizioApplicativo)idServizioApplicativo, (IDSoggetto)idSoggettoMittente);
                            throw new ProtocolException(msgError);
                        }
                    }
                }
                if (certificateKey != null && requestFruitoreToken == null && idServizioApplicativo != null) {
                    ConfigurazionePdDManager configurazionePdDManager = ConfigurazionePdDManager.getInstance((IState)state);
                    RegistroServiziManager registroServiziManager = RegistroServiziManager.getInstance((IState)state);
                    RequestFruitore rf = new RequestFruitore();
                    rf.setIdSoggettoFruitore(idServizioApplicativo.getIdSoggettoProprietario());
                    try {
                        Soggetto soggettoRegistry = registroServiziManager.getSoggetto(idServizioApplicativo.getIdSoggettoProprietario(), null, requestInfo);
                        rf.setSoggettoFruitoreRegistry(soggettoRegistry);
                    }
                    catch (Exception t) {
                        IdentificazioneApplicativoMittenteUtils.logError(log, "Errore durante la lettura del soggetto '" + idServizioApplicativo.getIdSoggettoProprietario() + "' dal registro: " + t.getMessage(), t);
                    }
                    try {
                        org.openspcoop2.core.config.Soggetto soggettoConfig = configurazionePdDManager.getSoggetto(idServizioApplicativo.getIdSoggettoProprietario(), requestInfo);
                        rf.setSoggettoFruitoreConfig(soggettoConfig);
                    }
                    catch (Exception t) {
                        IdentificazioneApplicativoMittenteUtils.logError(log, "Errore durante la lettura del soggetto '" + idServizioApplicativo.getIdSoggettoProprietario() + "' dalla configurazione: " + t.getMessage(), t);
                    }
                    try {
                        String idPorta = configurazionePdDManager.getIdentificativoPorta(idServizioApplicativo.getIdSoggettoProprietario(), factory, requestInfo);
                        rf.setSoggettoFruitoreIdentificativoPorta(idPorta);
                    }
                    catch (Exception t) {
                        IdentificazioneApplicativoMittenteUtils.logError(log, "Errore durante la lettura dell'identificativo porta del soggetto '" + idServizioApplicativo.getIdSoggettoProprietario() + "' dal registro: " + t.getMessage(), t);
                    }
                    try {
                        boolean soggettoVirtualeFRU = configurazionePdDManager.isSoggettoVirtuale(idServizioApplicativo.getIdSoggettoProprietario(), requestInfo);
                        rf.setSoggettoFruitoreSoggettoVirtuale(Boolean.valueOf(soggettoVirtualeFRU));
                    }
                    catch (Exception t) {
                        IdentificazioneApplicativoMittenteUtils.logError(log, "Errore durante la lettura dell'indicazione sul soggetto virtuale associato al soggetto '" + idServizioApplicativo.getIdSoggettoProprietario() + "' dal registro: " + t.getMessage(), t);
                    }
                    try {
                        if (rf != null) {
                            if (rf.getSoggettoFruitoreRegistry().getPortaDominio() != null && StringUtils.isNotEmpty((String)rf.getSoggettoFruitoreRegistry().getPortaDominio())) {
                                PortaDominio pdd = registroServiziManager.getPortaDominio(rf.getSoggettoFruitoreRegistry().getPortaDominio(), null, requestInfo);
                                rf.setSoggettoFruitorePddReaded(Boolean.valueOf(true));
                                rf.setSoggettoFruitorePdd(pdd);
                            } else {
                                rf.setSoggettoFruitorePddReaded(Boolean.valueOf(true));
                            }
                        }
                    }
                    catch (Exception t) {
                        IdentificazioneApplicativoMittenteUtils.logError(log, "Errore durante la lettura dei dati della pdd del soggetto '" + idServizioApplicativo.getIdSoggettoProprietario() + "' dal registro: " + t.getMessage(), t);
                    }
                    try {
                        String impl = registroServiziManager.getImplementazionePdD(idServizioApplicativo.getIdSoggettoProprietario(), null, requestInfo);
                        rf.setSoggettoFruitoreImplementazionePdd(impl);
                    }
                    catch (Exception t) {
                        IdentificazioneApplicativoMittenteUtils.logError(log, "Errore durante la lettura dell'implementazione pdd del soggetto '" + idServizioApplicativo.getIdSoggettoProprietario() + "' dal registro: " + t.getMessage(), t);
                    }
                    rf.setIdServizioApplicativoFruitore(idServizioApplicativo);
                    try {
                        ServizioApplicativo sa = configurazionePdDManager.getServizioApplicativo(idServizioApplicativo, requestInfo);
                        rf.setServizioApplicativoFruitore(sa);
                    }
                    catch (Exception t) {
                        IdentificazioneApplicativoMittenteUtils.logError(log, "Errore durante la lettura del servizio applicativo '" + idServizioApplicativo + "' dalla configurazione: " + t.getMessage(), t);
                    }
                    try {
                        rf.setCertificateKey(certificateKey);
                        GestoreRichieste.saveRequestFruitoreTokenModI((RequestInfo)requestInfo, (RequestFruitore)rf);
                    }
                    catch (Exception e) {
                        IdentificazioneApplicativoMittenteUtils.logError(log, "Errore durante il salvataggio nella cache e nel thread context delle informazioni sul fruitore token ModI: " + e.getMessage(), e);
                    }
                }
            }
            IdentificazioneApplicativoMittenteUtils.setInformazioniInBustaAndContext(log, state, busta, context, requestInfo, rilevatoSoggettoIntermediario, idSoggettoMittente, idServizioApplicativo);
            return idServizioApplicativo;
        }
        catch (Exception e) {
            IdentificazioneApplicativoMittenteUtils.logError(log, "Errore durante il riconoscimento dell'applicativo mittente (tramite la sicurezza messaggio): " + e.getMessage(), e);
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    private static IDServizioApplicativo identificazioneApplicativoMittenteByX509Engine(IState state, RequestInfo requestInfo, CertificateInfo certificate) throws ProtocolException {
        try {
            ConfigurazionePdDManager configurazionePdDManager = ConfigurazionePdDManager.getInstance((IState)state);
            String subject = null;
            if (certificate != null && certificate.getCertificate() != null) {
                subject = certificate.getCertificate().getSubjectX500Principal().toString();
            }
            String issuer = null;
            if (certificate != null && certificate.getCertificate() != null && certificate.getCertificate().getIssuerX500Principal() != null) {
                issuer = certificate.getCertificate().getIssuerX500Principal().toString();
            }
            IDServizioApplicativo idServizioApplicativo = null;
            ConfigurazioneFiltroServiziApplicativi filtroFirma = ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiModIFirma();
            if (certificate != null) {
                idServizioApplicativo = configurazionePdDManager.getIdServizioApplicativoByCredenzialiSsl(certificate, true, filtroFirma.getTipiSoggetti(), filtroFirma.isIncludiApplicativiNonModI(), filtroFirma.isIncludiApplicativiModIEsterni(), filtroFirma.isIncludiApplicativiModIInterni());
            }
            if (idServizioApplicativo == null && certificate != null) {
                idServizioApplicativo = configurazionePdDManager.getIdServizioApplicativoByCredenzialiSsl(certificate, false, filtroFirma.getTipiSoggetti(), filtroFirma.isIncludiApplicativiNonModI(), filtroFirma.isIncludiApplicativiModIEsterni(), filtroFirma.isIncludiApplicativiModIInterni());
            }
            if (idServizioApplicativo == null) {
                idServizioApplicativo = configurazionePdDManager.getIdServizioApplicativoByCredenzialiSsl(subject, issuer, filtroFirma.getTipiSoggetti(), filtroFirma.isIncludiApplicativiNonModI(), filtroFirma.isIncludiApplicativiModIEsterni(), filtroFirma.isIncludiApplicativiModIInterni());
            }
            if (idServizioApplicativo == null) {
                idServizioApplicativo = configurazionePdDManager.getIdServizioApplicativoByCredenzialiSsl(subject, null, filtroFirma.getTipiSoggetti(), filtroFirma.isIncludiApplicativiNonModI(), filtroFirma.isIncludiApplicativiModIEsterni(), filtroFirma.isIncludiApplicativiModIInterni());
            }
            if (idServizioApplicativo == null && StatoFunzionalita.ABILITATO.equals((Object)configurazionePdDManager.getConfigurazioneMultitenant().getStato()) && !PortaApplicativaSoggettiFruitori.SOGGETTI_ESTERNI.equals((Object)configurazionePdDManager.getConfigurazioneMultitenant().getErogazioneSceltaSoggettiFruitori())) {
                ProtocolFiltroRicercaServiziApplicativi filtro = IdentificazioneApplicativoMittenteUtils.createFilter(subject, issuer);
                List list = null;
                try {
                    list = configurazionePdDManager.getAllIdServiziApplicativi((FiltroRicercaServiziApplicativi)filtro);
                }
                catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                    // empty catch block
                }
                if (list != null) {
                    for (IDServizioApplicativo idServizioApplicativoSubjectIssuerCheck : list) {
                        ServizioApplicativo sa = configurazionePdDManager.getServizioApplicativo(idServizioApplicativoSubjectIssuerCheck, requestInfo);
                        Certificate certificatoCheck = IdentificazioneApplicativoMittenteUtils.readServizioApplicativoByCertificate(sa, requestInfo);
                        if (!(certificatoCheck instanceof X509Certificate) || certificate == null || !certificate.equals((X509Certificate)certificatoCheck, true)) continue;
                        idServizioApplicativo = idServizioApplicativoSubjectIssuerCheck;
                        break;
                    }
                }
            }
            return idServizioApplicativo;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static IDServizioApplicativo identificazioneApplicativoMittenteByToken(Logger log, IState state, Busta busta, Context context, RequestInfo requestInfo, MsgDiagnostico msgDiag, StringBuilder errorDetails) throws ProtocolException {
        try {
            IDSoggetto idSoggettoMittente = null;
            if (busta.getTipoMittente() != null && busta.getMittente() != null) {
                idSoggettoMittente = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
            }
            IDServizioApplicativo idServizioApplicativo = null;
            if (busta.getServizioApplicativoFruitore() != null && idSoggettoMittente != null) {
                idServizioApplicativo = new IDServizioApplicativo();
                idServizioApplicativo.setNome(busta.getServizioApplicativoFruitore());
                idServizioApplicativo.setIdSoggettoProprietario(idSoggettoMittente);
            }
            boolean rilevatoSoggettoIntermediario = false;
            IDServizioApplicativo idServizioApplicativoToken = null;
            if (context != null && context.containsKey(Costanti.ID_APPLICATIVO_TOKEN)) {
                idServizioApplicativoToken = (IDServizioApplicativo)context.getObject(Costanti.ID_APPLICATIVO_TOKEN);
                if (idSoggettoMittente == null) {
                    idSoggettoMittente = idServizioApplicativoToken.getIdSoggettoProprietario();
                } else if (!idServizioApplicativoToken.getIdSoggettoProprietario().equals((Object)idSoggettoMittente)) {
                    Soggetto soggettoCanale = RegistroServiziManager.getInstance((IState)state).getSoggetto(idSoggettoMittente, null, requestInfo);
                    if (ModIUtils.isSoggettoCanaleIntermediario((Soggetto)soggettoCanale, (Logger)log)) {
                        String idTransazione = null;
                        if (context.containsKey(Costanti.ID_TRANSAZIONE)) {
                            idTransazione = (String)context.getObject(Costanti.ID_TRANSAZIONE);
                        }
                        RicezioneBusteGestioneAutenticazione.registraIntermediario((IDSoggetto)idSoggettoMittente, (MsgDiagnostico)msgDiag, (String)idTransazione, null, (Context)context);
                        idSoggettoMittente = idServizioApplicativoToken.getIdSoggettoProprietario();
                        rilevatoSoggettoIntermediario = true;
                    } else {
                        String msgError = ModIUtils.getMessaggioErroreDominioCanaleDifferenteDominioApplicativo((IDServizioApplicativo)idServizioApplicativoToken, (IDSoggetto)idSoggettoMittente);
                        errorDetails.append(msgError);
                        throw new ProtocolException(msgError);
                    }
                }
                if (idServizioApplicativo != null) {
                    if (!idServizioApplicativo.equals((Object)idServizioApplicativoToken)) {
                        String msgError = "Rilevati due token di sicurezza firmati da applicativi differenti: '" + idServizioApplicativo.getNome() + "' e '" + idServizioApplicativoToken.getNome() + "'";
                        errorDetails.append(msgError);
                        throw new ProtocolException(msgError);
                    }
                } else {
                    idServizioApplicativo = idServizioApplicativoToken;
                }
            } else {
                return null;
            }
            IdentificazioneApplicativoMittenteUtils.setInformazioniInBustaAndContext(log, state, busta, context, requestInfo, rilevatoSoggettoIntermediario, idSoggettoMittente, idServizioApplicativo);
            return idServizioApplicativo;
        }
        catch (Exception e) {
            IdentificazioneApplicativoMittenteUtils.logError(log, "Errore durante il riconoscimento dell'applicativo mittente (tramite il token): " + e.getMessage(), e);
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static void checkApplicativoTokenByX509(Logger log, IDServizioApplicativo idServizioApplicativo, IState state, RequestInfo requestInfo, String tipoToken, CertificateInfo certificatoSicurezzaMessaggio, StringBuilder errorDetails) throws ProtocolException {
        try {
            Certificate certificatoCheck;
            ConfigurazionePdDManager configurazionePdDManager = ConfigurazionePdDManager.getInstance((IState)state);
            ServizioApplicativo saToken = configurazionePdDManager.getServizioApplicativo(idServizioApplicativo, requestInfo);
            String cnSubjectSicurezzaMessaggio = certificatoSicurezzaMessaggio.getSubject().getCN();
            String subjectSicurezzaMessaggio = certificatoSicurezzaMessaggio.getSubject().toString();
            String issuerSicurezzaMessaggio = null;
            if (certificatoSicurezzaMessaggio.getIssuer() != null) {
                issuerSicurezzaMessaggio = certificatoSicurezzaMessaggio.getIssuer().toString();
            }
            boolean registered = false;
            if (saToken.getInvocazionePorta() != null) {
                for (int z = 0; z < saToken.getInvocazionePorta().sizeCredenzialiList(); ++z) {
                    if (saToken.getInvocazionePorta().getCredenziali(z).getTipo() != null && !CostantiConfigurazione.CREDENZIALE_SSL.equals((Object)saToken.getInvocazionePorta().getCredenziali(z).getTipo())) continue;
                    Credenziali c = saToken.getInvocazionePorta().getCredenziali(z);
                    if (c.getCertificate() != null && cnSubjectSicurezzaMessaggio.equals(c.getCnSubject())) {
                        org.openspcoop2.utils.certificate.Certificate cer = ArchiveLoader.load((ArchiveType)ArchiveType.CER, (byte[])c.getCertificate(), (int)0, null);
                        boolean strict = true;
                        if (certificatoSicurezzaMessaggio.equals(cer.getCertificate(), strict)) {
                            registered = true;
                            break;
                        }
                        if (certificatoSicurezzaMessaggio.equals(cer.getCertificate(), !strict)) {
                            registered = true;
                            break;
                        }
                    }
                    if (c.getSubject() == null) continue;
                    boolean subjectValid = CertificateUtils.sslVerify((String)c.getSubject(), (String)subjectSicurezzaMessaggio, (PrincipalType)PrincipalType.SUBJECT, (Logger)log);
                    boolean issuerValid = true;
                    if (subjectValid && c.getIssuer() != null && issuerSicurezzaMessaggio != null) {
                        issuerValid = CertificateUtils.sslVerify((String)c.getIssuer(), (String)issuerSicurezzaMessaggio, (PrincipalType)PrincipalType.ISSUER, (Logger)log);
                    }
                    if (!subjectValid || !issuerValid) continue;
                    registered = true;
                    break;
                }
            }
            if (!registered && StatoFunzionalita.ABILITATO.equals((Object)configurazionePdDManager.getConfigurazioneMultitenant().getStato()) && !PortaApplicativaSoggettiFruitori.SOGGETTI_ESTERNI.equals((Object)configurazionePdDManager.getConfigurazioneMultitenant().getErogazioneSceltaSoggettiFruitori()) && (certificatoCheck = IdentificazioneApplicativoMittenteUtils.readServizioApplicativoByCertificate(saToken, requestInfo)) instanceof X509Certificate && certificatoSicurezzaMessaggio.equals((X509Certificate)certificatoCheck, true)) {
                registered = true;
            }
            if (!registered) {
                StringBuilder sb = new StringBuilder();
                sb.append("subject=\"").append(subjectSicurezzaMessaggio).append("\"");
                if (issuerSicurezzaMessaggio != null) {
                    sb.append(" issuer=\"").append(issuerSicurezzaMessaggio).append("\"");
                }
                String idApp = idServizioApplicativo.getNome() + " (Soggetto: " + idServizioApplicativo.getIdSoggettoProprietario().getNome() + ")";
                String msgError = "Applicativo Mittente " + idApp + " non autorizzato; il certificato di firma (" + sb.toString() + ") del security token (" + tipoToken + ") non corrisponde all'applicativo";
                errorDetails.append(msgError);
                throw new ProtocolException(msgError);
            }
        }
        catch (Exception e) {
            IdentificazioneApplicativoMittenteUtils.logError(log, "Errore durante la verifica del certificato di firma associato all'applicativo token: " + e.getMessage(), e);
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static void setInformazioniInBustaAndContext(Logger log, IState state, Busta busta, Context context, RequestInfo requestInfo, boolean rilevatoSoggettoIntermediario, IDSoggetto idSoggettoMittente, IDServizioApplicativo idServizioApplicativo) throws ProtocolException {
        block15: {
            Map configProperties;
            block14: {
                try {
                    Soggetto soggetto;
                    RegistroServiziManager registroServiziManager2;
                    if (idSoggettoMittente == null) break block14;
                    busta.setTipoMittente(idSoggettoMittente.getTipo());
                    busta.setMittente(idSoggettoMittente.getNome());
                    if (rilevatoSoggettoIntermediario) {
                        try {
                            registroServiziManager2 = RegistroServiziManager.getInstance((IState)state);
                            soggetto = registroServiziManager2.getSoggetto(idSoggettoMittente, null, requestInfo);
                            busta.setIdentificativoPortaMittente(soggetto.getIdentificativoPorta());
                            if (busta.sizeListaTrasmissioni() == 1) {
                                Trasmissione tr = busta.getTrasmissione(0);
                                tr.setTipoOrigine(idSoggettoMittente.getTipo());
                                tr.setOrigine(idSoggettoMittente.getNome());
                                tr.setIdentificativoPortaOrigine(soggetto.getIdentificativoPorta());
                            }
                        }
                        catch (Exception registroServiziManager2) {
                            // empty catch block
                        }
                    }
                    try {
                        if (!context.containsKey(Costanti.PROPRIETA_SOGGETTO_FRUITORE) && (configProperties = (registroServiziManager2 = RegistroServiziManager.getInstance((IState)state)).getProprietaConfigurazione(soggetto = registroServiziManager2.getSoggetto(idSoggettoMittente, null, requestInfo))) != null && !configProperties.isEmpty()) {
                            context.addObject(Costanti.PROPRIETA_SOGGETTO_FRUITORE, (Object)configProperties);
                        }
                    }
                    catch (Exception registroServiziManager3) {}
                }
                catch (Exception e) {
                    IdentificazioneApplicativoMittenteUtils.logError(log, "Errore durante l'impostazione nel contest del soggetto mittente: " + e.getMessage(), e);
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            try {
                if (idServizioApplicativo == null) break block15;
                busta.setServizioApplicativoFruitore(idServizioApplicativo.getNome());
                try {
                    ServizioApplicativo sa;
                    ConfigurazionePdDManager configurazionePdDManager;
                    if (!context.containsKey(Costanti.PROPRIETA_APPLICATIVO) && (configProperties = (configurazionePdDManager = ConfigurazionePdDManager.getInstance((IState)state)).getProprietaConfigurazione(sa = configurazionePdDManager.getServizioApplicativo(idServizioApplicativo, requestInfo))) != null && !configProperties.isEmpty()) {
                        context.addObject(Costanti.PROPRIETA_APPLICATIVO, (Object)configProperties);
                    }
                }
                catch (Exception configurazionePdDManager) {}
            }
            catch (Exception e) {
                IdentificazioneApplicativoMittenteUtils.logError(log, "Errore durante l'impostazione nel contest dell'applicativo mittente: " + e.getMessage(), e);
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static ProtocolFiltroRicercaServiziApplicativi createFilter(String subject, String issuer) {
        ProtocolFiltroRicercaServiziApplicativi filtro = new ProtocolFiltroRicercaServiziApplicativi();
        filtro.setTipoSoggetto("modipa");
        FiltroRicercaProtocolPropertyConfig filtroSubject = new FiltroRicercaProtocolPropertyConfig();
        filtroSubject.setName("modipaKeyCNSubject");
        filtroSubject.setValueAsString(subject);
        filtro.addProtocolProperty(filtroSubject);
        FiltroRicercaProtocolPropertyConfig filtroIssuer = new FiltroRicercaProtocolPropertyConfig();
        filtroIssuer.setName("modipaKeyCNIssuer");
        filtroIssuer.setValueAsString(issuer);
        filtro.addProtocolProperty(filtroIssuer);
        return filtro;
    }

    public static Certificate readServizioApplicativoByCertificate(ServizioApplicativo sa, RequestInfo requestInfo) throws ProtocolException {
        if (sa != null && sa.sizeProtocolPropertyList() > 0) {
            Certificate certificatoCheck = null;
            String mode = ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig((List)sa.getProtocolPropertyList(), (String)"modipaKeystoreMode");
            if (mode != null && !"".equals(mode) && !"archive".equals(mode)) {
                byte[] certificateBytes = ProtocolPropertiesUtils.getOptionalBinaryValuePropertyConfig((List)sa.getProtocolPropertyList(), (String)"modipaKeystoreCertificate");
                if (certificateBytes != null) {
                    org.openspcoop2.utils.certificate.Certificate c = null;
                    try {
                        c = ArchiveLoader.load((byte[])certificateBytes);
                    }
                    catch (Exception e) {
                        throw new ProtocolException(e.getMessage(), (Throwable)e);
                    }
                    if (c != null && c.getCertificate() != null) {
                        certificatoCheck = c.getCertificate().getCertificate();
                    }
                }
            } else {
                byte[] keystoreBytes = ProtocolPropertiesUtils.getOptionalBinaryValuePropertyConfig((List)sa.getProtocolPropertyList(), (String)"modipaKeystoreArchive");
                String keystoreType = ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig((List)sa.getProtocolPropertyList(), (String)"modipaKeystoreType");
                String keystorePassword = ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig((List)sa.getProtocolPropertyList(), (String)"modipaKeystorePassword");
                String keyAlias = ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig((List)sa.getProtocolPropertyList(), (String)"modipaKeyAlias");
                if (keystoreBytes != null && keystoreType != null && keystorePassword != null && keyAlias != null) {
                    ArchiveType archiveType = null;
                    archiveType = ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS.equals(keystoreType) ? ArchiveType.JKS : ArchiveType.PKCS12;
                    try {
                        MerlinKeystore merlinKs = GestoreKeystoreCache.getMerlinKeystore((RequestInfo)requestInfo, (byte[])keystoreBytes, (String)archiveType.name(), (String)keystorePassword);
                        certificatoCheck = merlinKs.getCertificate(keyAlias);
                    }
                    catch (Exception e) {
                        throw new ProtocolException(e.getMessage(), (Throwable)e);
                    }
                }
            }
            return certificatoCheck;
        }
        return null;
    }
}

