/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.pdd.core.dynamic.DynamicMapBuilderUtils;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.core.keystore.RemoteStoreProvider;
import org.openspcoop2.pdd.core.token.parser.TokenUtils;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.protocol.modipa.config.ModIAuditClaimConfig;
import org.openspcoop2.protocol.modipa.config.ModIAuditConfig;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.modipa.constants.ModICostanti;
import org.openspcoop2.protocol.modipa.constants.ModIHeaderType;
import org.openspcoop2.protocol.modipa.utils.ModISecurityConfig;
import org.openspcoop2.protocol.modipa.utils.ModITruststoreConfig;
import org.openspcoop2.protocol.modipa.utils.ModIUtilities;
import org.openspcoop2.protocol.modipa.validator.AbstractModIValidazioneSintatticaCommons;
import org.openspcoop2.protocol.modipa.validator.ModIRESTSecurity;
import org.openspcoop2.protocol.modipa.validator.ModIValidazioneAuditClaimValue;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.RestMessageSecurityToken;
import org.openspcoop2.protocol.sdk.SecurityToken;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.validator.ValidazioneUtils;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.MessageSecurityContextParameters;
import org.openspcoop2.security.message.engine.MessageSecurityContext_impl;
import org.openspcoop2.security.message.jose.MessageSecurityReceiver_jose;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.certificate.remote.RemoteKeyType;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.digest.DigestEncoding;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.slf4j.Logger;

public class ModIValidazioneSintatticaRest
extends AbstractModIValidazioneSintatticaCommons {
    public ModIValidazioneSintatticaRest(Logger log, IState state, Context context, IProtocolFactory<?> factory, RequestInfo requestInfo, ModIProperties modiProperties, ValidazioneUtils validazioneUtils) {
        super(log, state, context, factory, requestInfo, modiProperties, validazioneUtils);
    }

    private void logError(String msg) {
        this.log.error(msg);
    }

    private void logError(String msg, Exception e) {
        this.log.error(msg, (Throwable)e);
    }

    public void validateSyncInteractionProfile(OpenSPCoop2Message msg, boolean request, List<Eccezione> erroriValidazione) throws ProtocolException {
        if (!request) {
            boolean is4xx5xx;
            String returnCode = null;
            int returnCodeInt = -1;
            if (!request && msg.getTransportResponseContext() != null && (returnCode = msg.getTransportResponseContext().getCodiceTrasporto()) != null) {
                try {
                    returnCodeInt = Integer.valueOf(returnCode);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Integer[] returnCodeAttesi = this.modiProperties.getRestBloccanteHttpStatus();
            boolean bl = is4xx5xx = returnCodeInt >= 400 && returnCodeInt <= 599;
            if (!is4xx5xx && returnCodeAttesi != null) {
                boolean found = false;
                for (Integer integer : returnCodeAttesi) {
                    if (integer == -2) {
                        if (returnCodeInt >= 200 && returnCodeInt <= 299) {
                            found = true;
                        }
                    } else if (integer == returnCodeInt) {
                        found = true;
                    }
                    if (found) break;
                }
                if (!found) {
                    StringBuilder sb = new StringBuilder();
                    for (Integer integer : returnCodeAttesi) {
                        if (integer == -2) {
                            sb = new StringBuilder();
                            sb.append("2xx");
                            break;
                        }
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append(integer);
                    }
                    erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.PROFILO_TRASMISSIONE, "HTTP Status '" + returnCodeInt + "' differente da quello atteso per il profilo bloccante (atteso: " + sb.toString() + ")"));
                }
            }
        }
    }

    private String getErrorHeaderHttpPrefix(String hdr) {
        return "Header HTTP '" + hdr + "'";
    }

    private String getErrorHeaderHttpNonPresente(String hdr) {
        return this.getErrorHeaderHttpPrefix(hdr) + " non presente";
    }

    private String getErrorHeaderHttpPresentePiuVolte(String hdr) {
        return this.getErrorHeaderHttpPrefix(hdr) + " presente pi\u00f9 volte";
    }

    static String getErroreTokenSenzaClaim(String c) {
        return "Token senza claim '" + c + "'";
    }

    static String getErroreTokenClaimNonValido(String c, Exception e) {
        return "Token con claim '" + c + "' non valido: " + e.getMessage();
    }

    public void validateAsyncInteractionProfile(OpenSPCoop2Message msg, boolean request, String asyncInteractionType, String asyncInteractionRole, AccordoServizioParteComune apiContenenteRisorsa, String azione, Busta busta, List<Eccezione> erroriValidazione, String replyTo) throws ProtocolException {
        String correlationIdHeader = this.modiProperties.getRestCorrelationIdHeader();
        String correlationId = null;
        if (msg != null) {
            if (request && msg.getTransportRequestContext() != null) {
                correlationId = msg.getTransportRequestContext().getHeaderFirstValue(correlationIdHeader);
            } else if (!request && msg.getTransportResponseContext() != null) {
                correlationId = msg.getTransportResponseContext().getHeaderFirstValue(correlationIdHeader);
            }
        }
        String replyToHeader = this.modiProperties.getRestReplyToHeader();
        String replyToAddress = null;
        if (msg != null) {
            if (request && msg.getTransportRequestContext() != null) {
                replyToAddress = msg.getTransportRequestContext().getHeaderFirstValue(replyToHeader);
            } else if (!request && msg.getTransportResponseContext() != null) {
                replyToAddress = msg.getTransportResponseContext().getHeaderFirstValue(replyToHeader);
            }
        }
        String locationHeader = this.modiProperties.getRestLocationHeader();
        String location = null;
        if (msg != null) {
            if (request && msg.getTransportRequestContext() != null) {
                location = msg.getTransportRequestContext().getHeaderFirstValue(locationHeader);
            } else if (!request && msg.getTransportResponseContext() != null) {
                location = msg.getTransportResponseContext().getHeaderFirstValue(locationHeader);
            }
        }
        if (replyToAddress != null) {
            busta.addProperty("ProfiloInterazioneAsincrona-ReplyTo", replyToAddress);
        }
        if (correlationId != null) {
            busta.addProperty("ProfiloInterazioneAsincrona-CorrelationID", correlationId);
            if (correlationId.length() <= 255) {
                busta.setCollaborazione(correlationId);
            }
        }
        String returnCode = null;
        int returnCodeInt = -1;
        if (!request && msg.getTransportResponseContext() != null && (returnCode = msg.getTransportResponseContext().getCodiceTrasporto()) != null) {
            try {
                returnCodeInt = Integer.valueOf(returnCode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean is4xx5xx = false;
        if (!request) {
            is4xx5xx = returnCodeInt >= 400 && returnCodeInt <= 599;
        }
        Integer[] returnCodeAttesi = null;
        if (!is4xx5xx && asyncInteractionType != null) {
            Object correlationIdExtracted;
            if ("PUSH".equals(asyncInteractionType)) {
                if ("Richiesta".equals(asyncInteractionRole)) {
                    if (request) {
                        if (replyToAddress == null || "".equals(replyToAddress)) {
                            erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SERVIZIO_CORRELATO_NON_PRESENTE, this.getErrorHeaderHttpNonPresente(replyToHeader)));
                            return;
                        }
                        if (this.modiProperties.isRestSecurityTokenPushReplyToUpdateInErogazione()) {
                            if (msg.getTransportRequestContext() != null) {
                                msg.getTransportRequestContext().removeHeader(replyToHeader);
                            }
                            msg.forceTransportHeader(replyToHeader, replyTo);
                        }
                    } else {
                        if (correlationId == null || "".equals(correlationId)) {
                            erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.COLLABORAZIONE_NON_PRESENTE, this.getErrorHeaderHttpNonPresente(correlationIdHeader)));
                            return;
                        }
                        returnCodeAttesi = this.modiProperties.getRestNonBloccantePushRequestHttpStatus();
                    }
                } else if (request) {
                    if (correlationId == null || "".equals(correlationId)) {
                        erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.COLLABORAZIONE_NON_PRESENTE, this.getErrorHeaderHttpNonPresente(correlationIdHeader)));
                        return;
                    }
                } else {
                    returnCodeAttesi = this.modiProperties.getRestNonBloccantePushResponseHttpStatus();
                }
            } else if (request) {
                Object urlInvocata;
                if (("RichiestaStato".equals(asyncInteractionRole) || "Risposta".equals(asyncInteractionRole)) && (urlInvocata = msg.getTransportRequestContext().getFunctionParameters()) != null && !"".equals(urlInvocata)) {
                    String resourcePathAzione = null;
                    for (Resource r : apiContenenteRisorsa.getResourceList()) {
                        if (!r.getNome().equals(azione)) continue;
                        resourcePathAzione = r.getPath();
                        break;
                    }
                    if (!((String)urlInvocata).startsWith("/")) {
                        urlInvocata = "/" + (String)urlInvocata;
                    }
                    if ((correlationIdExtracted = ModIUtilities.extractCorrelationIdFromLocation(resourcePathAzione, (String)urlInvocata, false, this.log)) != null && ((String)correlationIdExtracted).length() <= 255) {
                        busta.setCollaborazione((String)correlationIdExtracted);
                    }
                }
            } else if ("Richiesta".equals(asyncInteractionRole)) {
                if (location == null || "".equals(location)) {
                    erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SERVIZIO_CORRELATO_NON_PRESENTE, this.getErrorHeaderHttpNonPresente(locationHeader)));
                    return;
                }
                busta.addProperty("ProfiloInterazioneAsincrona-Location", location);
                String correlationIdExtracted2 = ModIUtilities.extractCorrelationId(location, apiContenenteRisorsa, azione, asyncInteractionRole, this.log);
                if (correlationIdExtracted2 != null && correlationIdExtracted2.length() <= 255) {
                    busta.setCollaborazione(correlationIdExtracted2);
                }
                returnCodeAttesi = this.modiProperties.getRestNonBloccantePullRequestHttpStatus();
            } else if ("RichiestaStato".equals(asyncInteractionRole)) {
                Integer[] returnCodeResourceReady = this.modiProperties.getRestNonBloccantePullRequestStateOkHttpStatus();
                boolean isReady = false;
                for (Integer integer : returnCodeResourceReady) {
                    if (integer != returnCodeInt) continue;
                    isReady = true;
                    break;
                }
                if (isReady) {
                    if (location == null || "".equals(location)) {
                        erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SERVIZIO_CORRELATO_NON_PRESENTE, this.getErrorHeaderHttpNonPresente(locationHeader)));
                        return;
                    }
                    busta.addProperty("ProfiloInterazioneAsincrona-Location", location);
                    correlationIdExtracted = ModIUtilities.extractCorrelationId(location, apiContenenteRisorsa, azione, asyncInteractionRole, this.log);
                    if (correlationIdExtracted != null && ((String)correlationIdExtracted).length() <= 255) {
                        busta.setCollaborazione((String)correlationIdExtracted);
                    }
                    returnCodeAttesi = returnCodeResourceReady;
                } else {
                    int j;
                    Integer[] returnCodeAttesiNotReady = this.modiProperties.getRestNonBloccantePullRequestStateNotReadyHttpStatus();
                    returnCodeAttesi = new Integer[returnCodeResourceReady.length + returnCodeAttesiNotReady.length];
                    int i = 0;
                    for (j = 0; j < returnCodeAttesiNotReady.length; ++j) {
                        returnCodeAttesi[i] = returnCodeAttesiNotReady[j];
                        ++i;
                    }
                    for (j = 0; j < returnCodeResourceReady.length; ++j) {
                        returnCodeAttesi[i] = returnCodeResourceReady[j];
                        ++i;
                    }
                }
            } else {
                returnCodeAttesi = this.modiProperties.getRestNonBloccantePullResponseHttpStatus();
            }
        }
        if (returnCodeAttesi != null) {
            boolean found = false;
            for (Integer integer : returnCodeAttesi) {
                if (integer != returnCodeInt) continue;
                found = true;
                break;
            }
            if (!found) {
                StringBuilder sb = new StringBuilder();
                for (Integer integer : returnCodeAttesi) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(integer);
                }
                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.PROFILO_TRASMISSIONE, "HTTP Status '" + returnCodeInt + "' differente da quello atteso per il profilo non bloccante '" + asyncInteractionType + "' con ruolo '" + asyncInteractionRole + "' (atteso: " + sb.toString() + ")"));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String validateSecurityProfile(OpenSPCoop2Message msg, boolean request, String securityMessageProfile, boolean useKIDtokenHeader, String headerTokenRest, boolean corniceSicurezza, String patternCorniceSicurezza, String schemaCorniceSicurezza, boolean includiRequestDigest, Busta busta, List<Eccezione> erroriValidazione, ModITruststoreConfig trustStoreCertificati, ModITruststoreConfig trustStoreSsl, ModISecurityConfig securityConfig, boolean buildSecurityTokenInRequest, ModIHeaderType headerType, boolean integritaCustom, String integrityMode, boolean securityHeaderObbligatorio, Map<String, Object> dynamicMapParameter, Busta datiRichiesta, IDSoggetto idSoggetto, MsgDiagnostico msgDiag) throws ProtocolException {
        boolean findDigestInClaimSignedHeader;
        String claimSignedHeader;
        String digestHeader;
        boolean integrita;
        String token;
        block186: {
            Iterator headers;
            HashMap<String, List<String>> headerHttpAttesi;
            String digestValueInHeaderHTTP;
            block187: {
                String kid;
                X509Certificate x509;
                String payloadToken;
                boolean headerAuthentication;
                boolean headerDuplicati;
                Object prefix;
                boolean tokenAudit;
                boolean integritaKid;
                boolean integritaX509;
                String securityTokenHeader;
                String idTransazione;
                boolean bufferMessageReadOnly;
                block191: {
                    PortaApplicativa pa;
                    IDPortaApplicativa idPA;
                    StringBuilder sb;
                    block189: {
                        block190: {
                            if (msg == null) {
                                throw new ProtocolException("Param msg is null");
                            }
                            bufferMessageReadOnly = this.modiProperties.isReadByPathBufferEnabled();
                            idTransazione = null;
                            if (this.context != null) {
                                idTransazione = (String)this.context.getObject(Costanti.ID_TRANSAZIONE);
                            }
                            securityTokenHeader = headerTokenRest;
                            List securityTokens = null;
                            if (request && msg.getTransportRequestContext() != null) {
                                securityTokens = msg.getTransportRequestContext().getHeaderValues(securityTokenHeader);
                            } else if (!request && msg.getTransportResponseContext() != null) {
                                securityTokens = msg.getTransportResponseContext().getHeaderValues(securityTokenHeader);
                            }
                            String securityToken = null;
                            if (securityTokens != null && !securityTokens.isEmpty()) {
                                securityToken = (String)securityTokens.get(0);
                            }
                            boolean attesoSecurityHeader = securityHeaderObbligatorio;
                            if (!request) {
                                try {
                                    if (msg.isFault()) {
                                        attesoSecurityHeader = false;
                                    }
                                }
                                catch (Exception e) {
                                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                                }
                            }
                            if (securityToken == null || "".equals(securityToken)) {
                                if (!attesoSecurityHeader) return null;
                                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_TOKEN_NON_PRESENTE, this.getErrorHeaderHttpNonPresente(securityTokenHeader)));
                                return null;
                            }
                            if (securityTokens.size() > 1) {
                                if (!attesoSecurityHeader) return null;
                                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_TOKEN_PRESENTE_PIU_VOLTE, this.getErrorHeaderHttpPresentePiuVolte(securityTokenHeader)));
                                return null;
                            }
                            if (busta != null && integritaCustom) {
                                busta.addProperty("ProfiloSicurezzaMessaggio-Custom-JWT-Signature", headerTokenRest);
                            }
                            token = securityToken;
                            if ("Authorization".equalsIgnoreCase(securityTokenHeader)) {
                                if (request) {
                                    if (msg.getTransportRequestContext() == null || msg.getTransportRequestContext().getCredential() == null) {
                                        erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_TOKEN_NON_PRESENTE, this.getErrorHeaderHttpNonPresente("Authorization")));
                                        return null;
                                    }
                                    if (msg.getTransportRequestContext().getCredential().getBearerToken() == null) {
                                        if (msg.getTransportRequestContext().getCredential().getUsername() != null) {
                                            erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_TOKEN_NON_PRESENTE, this.getErrorHeaderHttpPrefix("Authorization") + " non presente con prefisso 'Bearer '"));
                                            return null;
                                        }
                                        erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_TOKEN_NON_PRESENTE, this.getErrorHeaderHttpNonPresente("Authorization")));
                                        return null;
                                    }
                                    token = msg.getTransportRequestContext().getCredential().getBearerToken();
                                } else if (token.toLowerCase().startsWith("Bearer ".toLowerCase())) {
                                    token = token.substring("Bearer ".length());
                                } else {
                                    if (token.toLowerCase().startsWith("Basic ".toLowerCase())) {
                                        if (!attesoSecurityHeader) return null;
                                        erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_TOKEN_NON_PRESENTE, this.getErrorHeaderHttpPrefix("Authorization") + " non presente con prefisso 'Bearer '"));
                                        return null;
                                    }
                                    if (!attesoSecurityHeader) return null;
                                    erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_TOKEN_NON_PRESENTE, this.getErrorHeaderHttpNonPresente("Authorization")));
                                    return null;
                                }
                            }
                            integritaX509 = false;
                            if ("idam0301".equals(securityMessageProfile) || "idam0302".equals(securityMessageProfile)) {
                                integritaX509 = true;
                            }
                            integritaKid = false;
                            if ("idam0401".equals(securityMessageProfile) || "idam0402".equals(securityMessageProfile)) {
                                integritaKid = true;
                            }
                            integrita = integritaX509 || integritaKid;
                            tokenAudit = corniceSicurezza && !"old".equals(patternCorniceSicurezza) && schemaCorniceSicurezza != null;
                            boolean apiSoap = ServiceBinding.SOAP.equals((Object)msg.getServiceBinding());
                            prefix = "";
                            headerDuplicati = headerType.isHeaderDuplicati();
                            headerAuthentication = headerType.isUsabledForAuthentication();
                            if (headerDuplicati || tokenAudit) {
                                prefix = "[Header '" + headerTokenRest + "'] ";
                            }
                            OpenSPCoop2Message msgToken = null;
                            try {
                                msgToken = msg.getFactory().createMessage(MessageType.JSON, MessageRole.NONE, "application/json", token.getBytes(), null, null).getMessage_throwParseException();
                            }
                            catch (Exception e) {
                                throw new ProtocolException(e.getMessage(), (Throwable)e);
                            }
                            payloadToken = null;
                            x509 = null;
                            kid = null;
                            try {
                                Long timeToLive = this.modiProperties.getRestSecurityTokenClaimsIatTimeCheckMilliseconds();
                                if (securityConfig.getCheckTtlIatMilliseconds() != null) {
                                    timeToLive = securityConfig.getCheckTtlIatMilliseconds();
                                }
                                if (timeToLive != null && msg != null) {
                                    msg.addContextProperty(ModICostanti.MODIPA_OPENSPCOOP2_MSG_CONTEXT_IAT_TTL_CHECK, (Object)timeToLive);
                                }
                                MessageSecurityReceiver_jose joseSignature = new MessageSecurityReceiver_jose();
                                MessageSecurityContextParameters messageSecurityContextParameters = new MessageSecurityContextParameters();
                                MessageSecurityContext_impl messageSecurityContext = new MessageSecurityContext_impl(messageSecurityContextParameters);
                                HashMap<String, String> secProperties = new HashMap<String, String>();
                                secProperties.put("securityEngine", "jose");
                                secProperties.put("action", "Signature");
                                secProperties.put("signatureMode", "compact");
                                secProperties.put("signatureDetached", "false");
                                secProperties.put("detachSecurityInfo", "true");
                                secProperties.put("joseUseHeaders", "true");
                                secProperties.put("joseUseHeaders.jwk", "false");
                                secProperties.put("joseUseHeaders.jku", "false");
                                secProperties.put("joseUseHeaders.x5t", "false");
                                if (integritaKid || useKIDtokenHeader) {
                                    secProperties.put("joseUseHeaders.kid", "true");
                                    secProperties.put("joseUseHeaders.x5c", "false");
                                    secProperties.put("joseUseHeaders.x5u", "false");
                                    secProperties.put("joseUseHeaders.x5t256", "false");
                                } else {
                                    secProperties.put("joseUseHeaders.kid", "false");
                                    boolean x5c = tokenAudit && apiSoap ? this.modiProperties.isSecurityTokenAuditApiSoapX509RiferimentoX5c() : securityConfig.isX5c();
                                    secProperties.put("joseUseHeaders.x5c", x5c ? "true" : "false");
                                    boolean x5u = tokenAudit && apiSoap ? this.modiProperties.isSecurityTokenAuditApiSoapX509RiferimentoX5u() : securityConfig.isX5u();
                                    secProperties.put("joseUseHeaders.x5u", x5u ? "true" : "false");
                                    boolean x5t = tokenAudit && apiSoap ? this.modiProperties.isSecurityTokenAuditApiSoapX509RiferimentoX5t() : securityConfig.isX5t();
                                    secProperties.put("joseUseHeaders.x5t256", x5t ? "true" : "false");
                                }
                                secProperties.put("joseUseHeaders.truststore.type", trustStoreCertificati.getSecurityMessageTruststoreType());
                                if (!trustStoreCertificati.isSecurityMessageTruststoreRemote()) {
                                    secProperties.put("joseUseHeaders.truststore.file", trustStoreCertificati.getSecurityMessageTruststorePath());
                                }
                                if (!trustStoreCertificati.isSecurityMessageTruststoreJWK() && !trustStoreCertificati.isSecurityMessageTruststoreRemote() && trustStoreCertificati.getSecurityMessageTruststorePassword() != null) {
                                    secProperties.put("joseUseHeaders.truststore.password", trustStoreCertificati.getSecurityMessageTruststorePassword());
                                }
                                if (trustStoreCertificati.getSecurityMessageTruststoreCRLs() != null) {
                                    secProperties.put("signatureCRL", trustStoreCertificati.getSecurityMessageTruststoreCRLs());
                                }
                                if (trustStoreCertificati.getSecurityMessageTruststoreOCSPPolicy() != null) {
                                    secProperties.put("signatureOCSP", trustStoreCertificati.getSecurityMessageTruststoreOCSPPolicy());
                                }
                                if (trustStoreCertificati.isSecurityMessageTruststoreRemote()) {
                                    RemoteKeyType keyType = this.modiProperties.getRemoteKeyType(trustStoreCertificati.getSecurityMessageTruststoreType());
                                    secProperties.put("joseUseHeaders.truststore.remoteStoreProvider", (String)new RemoteStoreProvider(this.requestInfo, keyType));
                                    secProperties.put("joseUseHeaders.truststore.remoteStoreKeyType", (String)keyType);
                                    secProperties.put("joseUseHeaders.truststore.remoteStoreConfig", (String)this.modiProperties.getRemoteStoreConfig(trustStoreCertificati.getSecurityMessageTruststoreType(), idSoggetto));
                                }
                                if (securityConfig.isX5u() && trustStoreSsl != null && trustStoreSsl.getSecurityMessageTruststorePath() != null) {
                                    secProperties.put("rs.security.keystore.file.ssl", trustStoreSsl.getSecurityMessageTruststorePath());
                                    secProperties.put("rs.security.keystore.type.ssl", trustStoreSsl.getSecurityMessageTruststoreType());
                                    if (trustStoreSsl.getSecurityMessageTruststorePassword() != null) {
                                        secProperties.put("rs.security.keystore.password.ssl", trustStoreSsl.getSecurityMessageTruststorePassword());
                                    }
                                    if (trustStoreSsl.getSecurityMessageTruststoreCRLs() != null) {
                                        secProperties.put("rs.security.keystore.ssl.crl", trustStoreSsl.getSecurityMessageTruststoreCRLs());
                                    }
                                    if (trustStoreSsl.getSecurityMessageTruststoreOCSPPolicy() != null) {
                                        secProperties.put("rs.security.keystore.ssl.ocsp", trustStoreSsl.getSecurityMessageTruststoreOCSPPolicy());
                                    }
                                }
                                messageSecurityContext.setIncomingProperties(secProperties, false);
                                DynamicMapBuilderUtils.injectDynamicMap((Busta)busta, (RequestInfo)this.requestInfo, (org.openspcoop2.utils.Map)this.context, (Logger)this.log);
                                joseSignature.process((MessageSecurityContext)messageSecurityContext, msgToken, busta, (org.openspcoop2.utils.Map)this.context);
                                joseSignature.detachSecurity((MessageSecurityContext)messageSecurityContext, msgToken.castAsRest());
                                ModIRESTSecurity restSecurity = (ModIRESTSecurity)msg.getContextProperty(ModICostanti.MODIPA_OPENSPCOOP2_MSG_CONTEXT_SBUSTAMENTO_REST);
                                if (restSecurity == null) {
                                    restSecurity = new ModIRESTSecurity(securityTokenHeader, request);
                                    msg.addContextProperty(ModICostanti.MODIPA_OPENSPCOOP2_MSG_CONTEXT_SBUSTAMENTO_REST, (Object)restSecurity);
                                } else {
                                    restSecurity.getTokenHeaderNames().add(securityTokenHeader);
                                }
                                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                                msgToken.writeTo((OutputStream)bout, true);
                                bout.flush();
                                bout.close();
                                payloadToken = bout.toString();
                                x509 = joseSignature.getX509Certificate();
                                kid = joseSignature.getCertificateId();
                            }
                            catch (Exception e) {
                                this.logError("Errore durante la validazione del token di sicurezza: " + e.getMessage(), e);
                                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_FIRMA_NON_VALIDA, (String)prefix + e.getMessage(), (Throwable)e));
                                return token;
                            }
                            if (!integritaKid && !useKIDtokenHeader) break block189;
                            if (kid != null) break block190;
                            erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(request ? CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_FRUITORE_NON_PRESENTE : CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_EROGATORE_NON_PRESENTE, (String)prefix + "Riferimento alla chiave (kid) non presente"));
                            break block191;
                        }
                        if (!headerDuplicati || headerAuthentication) {
                            busta.addProperty(tokenAudit ? "ProfiloSicurezzaMessaggioAudit-Kid" : "ProfiloSicurezzaMessaggio-Kid", kid);
                            if (headerDuplicati) {
                                this.context.addObject(ModICostanti.MODIPA_CONTEXT_KID_AUTHORIZATION, (Object)x509);
                            }
                        } else {
                            String kidAuthorization = null;
                            Object oKidAuthorization = this.context.removeObject(ModICostanti.MODIPA_CONTEXT_KID_AUTHORIZATION);
                            if (oKidAuthorization instanceof String) {
                                kidAuthorization = (String)oKidAuthorization;
                            }
                            if (kidAuthorization != null) {
                                if (!kidAuthorization.equals(kid)) {
                                    sb = new StringBuilder();
                                    sb.append("Authorization").append(" ");
                                    sb.append("kid=\"").append(kidAuthorization).append("\"");
                                    sb.append("\n");
                                    sb.append(headerTokenRest).append(" ");
                                    sb.append("kid=\"").append(kid).append("\"");
                                    erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(request ? CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_FRUITORE_NON_VALIDO : CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_EROGATORE_NON_VALIDO, "I token 'Authorization' e '" + headerTokenRest + "' risultano firmati da certificati differenti\n" + sb.toString()));
                                }
                            } else if (erroriValidazione.isEmpty()) {
                                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_TOKEN_NON_PRESENTE, "Riferimento alla chiave (kid) nell'header 'Authorization' non presente"));
                            }
                        }
                        if (request && (!headerDuplicati || headerAuthentication)) {
                            String clientId;
                            boolean autenticazioneToken;
                            if (msg == null) throw new ProtocolException("ID Porta non presente");
                            if (msg.getTransportRequestContext() == null) throw new ProtocolException("ID Porta non presente");
                            if (msg.getTransportRequestContext().getInterfaceName() == null) {
                                throw new ProtocolException("ID Porta non presente");
                            }
                            idPA = new IDPortaApplicativa();
                            idPA.setNome(msg.getTransportRequestContext().getInterfaceName());
                            pa = null;
                            try {
                                pa = this.factory.getCachedConfigIntegrationReader(this.state, this.requestInfo).getPortaApplicativa(idPA);
                            }
                            catch (Exception e) {
                                throw new ProtocolException(e.getMessage(), (Throwable)e);
                            }
                            boolean bl = autenticazioneToken = pa != null && pa.getGestioneToken() != null && pa.getGestioneToken().getPolicy() != null && StringUtils.isNotEmpty((String)pa.getGestioneToken().getPolicy());
                            if (!autenticazioneToken && (clientId = this.readClientIdSafe(payloadToken)) == null) {
                                // empty if block
                            }
                        }
                        break block191;
                    }
                    if (x509 == null || x509.getSubjectX500Principal() == null) {
                        erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(request ? CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_FRUITORE_NON_PRESENTE : CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_EROGATORE_NON_PRESENTE, (String)prefix + "Certificato X509 mittente non presente"));
                    } else {
                        if (!headerDuplicati || headerAuthentication) {
                            busta.addProperty(tokenAudit ? "ProfiloSicurezzaMessaggioAudit-X509-Subject" : "ProfiloSicurezzaMessaggio-X509-Subject", x509.getSubjectX500Principal().toString());
                            if (x509.getIssuerX500Principal() != null) {
                                busta.addProperty(tokenAudit ? "ProfiloSicurezzaMessaggioAudit-X509-Issuer" : "ProfiloSicurezzaMessaggio-X509-Issuer", x509.getIssuerX500Principal().toString());
                            }
                            if (headerDuplicati) {
                                this.context.addObject(ModICostanti.MODIPA_CONTEXT_X509_AUTHORIZATION, (Object)x509);
                            }
                        } else {
                            X509Certificate x509Authorization = null;
                            Object oX509Authorization = this.context.removeObject(ModICostanti.MODIPA_CONTEXT_X509_AUTHORIZATION);
                            if (oX509Authorization instanceof X509Certificate) {
                                x509Authorization = (X509Certificate)oX509Authorization;
                            }
                            if (x509Authorization != null) {
                                if (!x509Authorization.equals(x509)) {
                                    sb = new StringBuilder();
                                    sb.append("Authorization").append(" ");
                                    sb.append("subject=\"").append(x509Authorization.getSubjectX500Principal().toString()).append("\"");
                                    if (x509Authorization.getIssuerX500Principal() != null) {
                                        sb.append(" issuer=\"").append(x509Authorization.getIssuerX500Principal().toString()).append("\"");
                                    }
                                    sb.append("\n");
                                    sb.append(headerTokenRest).append(" ");
                                    sb.append("subject=\"").append(x509.getSubjectX500Principal().toString()).append("\"");
                                    if (x509.getIssuerX500Principal() != null) {
                                        sb.append(" issuer=\"").append(x509.getIssuerX500Principal().toString()).append("\"");
                                    }
                                    erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(request ? CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_FRUITORE_NON_VALIDO : CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_EROGATORE_NON_VALIDO, "I token 'Authorization' e '" + headerTokenRest + "' risultano firmati da certificati differenti\n" + sb.toString()));
                                }
                            } else if (erroriValidazione.isEmpty()) {
                                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_TOKEN_NON_PRESENTE, "Certificato x509 nell'header 'Authorization' non presente"));
                            }
                        }
                        if (request && (!headerDuplicati || headerAuthentication)) {
                            boolean autenticazioneToken;
                            if (msg == null) throw new ProtocolException("ID Porta non presente");
                            if (msg.getTransportRequestContext() == null) throw new ProtocolException("ID Porta non presente");
                            if (msg.getTransportRequestContext().getInterfaceName() == null) {
                                throw new ProtocolException("ID Porta non presente");
                            }
                            idPA = new IDPortaApplicativa();
                            idPA.setNome(msg.getTransportRequestContext().getInterfaceName());
                            pa = null;
                            try {
                                pa = this.factory.getCachedConfigIntegrationReader(this.state, this.requestInfo).getPortaApplicativa(idPA);
                            }
                            catch (Exception e) {
                                throw new ProtocolException(e.getMessage(), (Throwable)e);
                            }
                            boolean bl = autenticazioneToken = pa != null && pa.getGestioneToken() != null && pa.getGestioneToken().getPolicy() != null && StringUtils.isNotEmpty((String)pa.getGestioneToken().getPolicy());
                            if (!autenticazioneToken) {
                                this.identificazioneApplicativoMittente(x509, msg, busta, msgDiag);
                            }
                        }
                    }
                }
                if (request && this.context != null) {
                    SecurityToken securityTokenForContext = ModIUtilities.newSecurityToken(this.context);
                    RestMessageSecurityToken restSecurityToken = new RestMessageSecurityToken();
                    if (x509 != null) {
                        restSecurityToken.setCertificate(new CertificateInfo(x509, securityTokenHeader));
                    }
                    if (kid != null) {
                        restSecurityToken.setKid(kid);
                    }
                    restSecurityToken.setToken((Serializable)((Object)token));
                    restSecurityToken.setHttpHeaderName(securityTokenHeader);
                    if (tokenAudit) {
                        securityTokenForContext.setAudit(restSecurityToken);
                    } else if (headerDuplicati) {
                        if (headerAuthentication) {
                            securityTokenForContext.setAuthorization(restSecurityToken);
                        } else {
                            securityTokenForContext.setIntegrity(restSecurityToken);
                        }
                    } else if ("Authorization".equalsIgnoreCase(securityTokenHeader)) {
                        securityTokenForContext.setAuthorization(restSecurityToken);
                    } else {
                        securityTokenForContext.setIntegrity(restSecurityToken);
                    }
                }
                Map dynamicMap = null;
                Map<String, Object> dynamicMapRequest = null;
                if (!request) {
                    dynamicMapRequest = ModIUtilities.removeDynamicMapRequest(this.context);
                }
                try {
                    if (dynamicMapRequest != null) {
                        dynamicMap = DynamicUtils.buildDynamicMapResponse((OpenSPCoop2Message)msg, (Context)this.context, null, (Logger)this.log, (boolean)bufferMessageReadOnly, dynamicMapRequest);
                    } else {
                        dynamicMap = DynamicUtils.buildDynamicMap((OpenSPCoop2Message)msg, (Context)this.context, (Busta)datiRichiesta, (Logger)this.log, (boolean)bufferMessageReadOnly);
                        ModIUtilities.saveDynamicMapRequest(this.context, dynamicMap);
                    }
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
                if (dynamicMapParameter != null && dynamicMap != null) {
                    dynamicMapParameter.putAll(dynamicMap);
                }
                try {
                    JsonNode purposeId;
                    Object clientId;
                    JsonNode sub;
                    JsonNode iss;
                    ObjectNode objectNode;
                    block202: {
                        boolean jtiRequired;
                        block200: {
                            String id;
                            block203: {
                                JsonNode jti;
                                block201: {
                                    block198: {
                                        block196: {
                                            String audAuthorization;
                                            String audValue;
                                            block199: {
                                                JsonNode aud;
                                                block197: {
                                                    Date nbfDate;
                                                    JsonNode nbf;
                                                    block195: {
                                                        block194: {
                                                            Date expDate;
                                                            block193: {
                                                                block192: {
                                                                    Date iatDate;
                                                                    JsonNode jsonNode = JSONUtils.getInstance().getAsNode(payloadToken);
                                                                    if (!(jsonNode instanceof ObjectNode)) {
                                                                        throw new ProtocolException("Payload del token possiede una struttura non valida");
                                                                    }
                                                                    objectNode = (ObjectNode)jsonNode;
                                                                    if (!objectNode.has("iat")) break block192;
                                                                    JsonNode iat = objectNode.get("iat");
                                                                    if (iat == null) {
                                                                        erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.ORA_REGISTRAZIONE_NON_PRESENTE, (String)prefix + ModIValidazioneSintatticaRest.getErroreTokenSenzaClaim("iat")));
                                                                    }
                                                                    if ((iatDate = this.toDate(iat, erroriValidazione, CodiceErroreCooperazione.ORA_REGISTRAZIONE_NON_VALIDA, (String)prefix, "iat")) != null) {
                                                                        String iatValue = DateUtils.getSimpleDateFormatMs().format(iatDate);
                                                                        if (!headerDuplicati || headerAuthentication) {
                                                                            busta.addProperty(tokenAudit ? "ProfiloSicurezzaMessaggioAudit-IssuedAt" : "ProfiloSicurezzaMessaggio-IssuedAt", iatValue);
                                                                            break block193;
                                                                        } else {
                                                                            String iatAuthorization = busta.getProperty("ProfiloSicurezzaMessaggio-IssuedAt");
                                                                            if (!iatValue.equals(iatAuthorization)) {
                                                                                busta.addProperty("ProfiloSicurezzaMessaggio-IntegrityIssuedAt", iatValue);
                                                                            }
                                                                        }
                                                                    }
                                                                    break block193;
                                                                }
                                                                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.ORA_REGISTRAZIONE_NON_PRESENTE, (String)prefix + ModIValidazioneSintatticaRest.getErroreTokenSenzaClaim("iat")));
                                                            }
                                                            if (!objectNode.has("exp")) break block194;
                                                            JsonNode exp = objectNode.get("exp");
                                                            if (exp == null) {
                                                                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SCADENZA_NON_PRESENTE, (String)prefix + ModIValidazioneSintatticaRest.getErroreTokenSenzaClaim("exp")));
                                                            }
                                                            if ((expDate = this.toDate(exp, erroriValidazione, CodiceErroreCooperazione.SCADENZA_NON_VALIDA, (String)prefix, "exp")) != null) {
                                                                String expValue = DateUtils.getSimpleDateFormatMs().format(expDate);
                                                                if (!headerDuplicati || headerAuthentication) {
                                                                    busta.addProperty(tokenAudit ? "ProfiloSicurezzaMessaggioAudit-Expiration" : "ProfiloSicurezzaMessaggio-Expiration", expValue);
                                                                    break block195;
                                                                } else {
                                                                    String expAuthorization = busta.getProperty("ProfiloSicurezzaMessaggio-Expiration");
                                                                    if (!expValue.equals(expAuthorization)) {
                                                                        busta.addProperty("ProfiloSicurezzaMessaggio-IntegrityExpiration", expValue);
                                                                    }
                                                                }
                                                            }
                                                            break block195;
                                                        }
                                                        erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SCADENZA_NON_PRESENTE, (String)prefix + ModIValidazioneSintatticaRest.getErroreTokenSenzaClaim("exp")));
                                                    }
                                                    if (objectNode.has("nbf") && (nbf = objectNode.get("nbf")) != null && (nbfDate = this.toDate(nbf, erroriValidazione, CodiceErroreCooperazione.SCADENZA_NON_VALIDA, (String)prefix, "nbf")) != null) {
                                                        String nbfValue = DateUtils.getSimpleDateFormatMs().format(nbfDate);
                                                        if (!headerDuplicati || headerAuthentication) {
                                                            busta.addProperty(tokenAudit ? "ProfiloSicurezzaMessaggioAudit-NotBefore" : "ProfiloSicurezzaMessaggio-NotBefore", nbfValue);
                                                        } else {
                                                            String nbfAuthorization = busta.getProperty("ProfiloSicurezzaMessaggio-NotBefore");
                                                            if (!nbfValue.equals(nbfAuthorization)) {
                                                                busta.addProperty("ProfiloSicurezzaMessaggio-IntegrityNotBefore", nbfValue);
                                                            }
                                                        }
                                                    }
                                                    if (!objectNode.has("aud")) break block196;
                                                    aud = objectNode.get("aud");
                                                    if (aud != null) break block197;
                                                    erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(request ? CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_EROGATORE_NON_PRESENTE : CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_FRUITORE_NON_PRESENTE, (String)prefix + ModIValidazioneSintatticaRest.getErroreTokenSenzaClaim("aud")));
                                                    break block198;
                                                }
                                                audValue = this.toString(aud);
                                                if (!tokenAudit) break block199;
                                                audAuthorization = busta.getProperty("ProfiloSicurezzaMessaggio-Audience");
                                                if (audAuthorization == null || !audValue.equals(audAuthorization)) {
                                                    busta.addProperty("ProfiloSicurezzaMessaggioAudit-Audience", audValue);
                                                }
                                                break block198;
                                            }
                                            if (!headerDuplicati || headerAuthentication) {
                                                busta.addProperty("ProfiloSicurezzaMessaggio-Audience", audValue);
                                                break block198;
                                            } else {
                                                audAuthorization = busta.getProperty("ProfiloSicurezzaMessaggio-Audience");
                                                if (!audValue.equals(audAuthorization)) {
                                                    busta.addProperty("ProfiloSicurezzaMessaggio-IntegrityAudience", audValue);
                                                }
                                            }
                                            break block198;
                                        }
                                        if (request || buildSecurityTokenInRequest) {
                                            erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(request ? CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_EROGATORE_NON_PRESENTE : CodiceErroreCooperazione.SERVIZIO_APPLICATIVO_FRUITORE_NON_PRESENTE, (String)prefix + ModIValidazioneSintatticaRest.getErroreTokenSenzaClaim("aud")));
                                        }
                                    }
                                    jtiRequired = false;
                                    if ("idam02".equals(securityMessageProfile) || "idam0302".equals(securityMessageProfile) || "idam0402".equals(securityMessageProfile)) {
                                        jtiRequired = true;
                                    }
                                    if (!objectNode.has("jti")) break block200;
                                    jti = objectNode.get("jti");
                                    if (jti != null) break block201;
                                    if (jtiRequired) {
                                        erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_PRESENTE, (String)prefix + ModIValidazioneSintatticaRest.getErroreTokenSenzaClaim("jti")));
                                    }
                                    break block202;
                                }
                                id = this.toString(jti);
                                if (!tokenAudit) break block203;
                                busta.addProperty("ProfiloSicurezzaMessaggioAudit-MessageId", id);
                                break block202;
                            }
                            boolean addAsIdBusta = true;
                            if (headerDuplicati) {
                                String idActual;
                                if (headerAuthentication) {
                                    if (!securityConfig.isMultipleHeaderUseJtiAuthorizationAsIdMessaggio()) {
                                        idActual = busta.getProperty("ProfiloSicurezzaMessaggio-MessageId");
                                        if (idActual == null || !idActual.equals(id)) {
                                            busta.addProperty("ProfiloSicurezzaMessaggio-AuthorizationMessageId", id);
                                        }
                                        addAsIdBusta = false;
                                    }
                                } else if (securityConfig.isMultipleHeaderUseJtiAuthorizationAsIdMessaggio()) {
                                    idActual = busta.getProperty("ProfiloSicurezzaMessaggio-MessageId");
                                    if (idActual == null || !idActual.equals(id)) {
                                        busta.addProperty("ProfiloSicurezzaMessaggio-IntegrityMessageId", id);
                                    }
                                    addAsIdBusta = false;
                                } else {
                                    String idActualAuthorization = busta.getProperty("ProfiloSicurezzaMessaggio-AuthorizationMessageId");
                                    if (idActualAuthorization != null && idActualAuthorization.equals(id)) {
                                        busta.removeProperty("ProfiloSicurezzaMessaggio-AuthorizationMessageId");
                                    }
                                }
                            }
                            if (addAsIdBusta) {
                                busta.addProperty("ProfiloSicurezzaMessaggio-MessageId", id);
                                if (id.length() <= 255) {
                                    busta.setID(id);
                                }
                            }
                            break block202;
                        }
                        if (jtiRequired) {
                            erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_PRESENTE, (String)prefix + ModIValidazioneSintatticaRest.getErroreTokenSenzaClaim("jti")));
                        }
                    }
                    if (!request) {
                        corniceSicurezza = false;
                    }
                    boolean readIss = true;
                    boolean readSub = true;
                    if (corniceSicurezza) {
                        if ("old".equals(patternCorniceSicurezza)) {
                            readIss = this.readCorniceSicurezzaCodiceEnteLegacy(objectNode, busta, erroriValidazione, (String)prefix);
                            readSub = this.readCorniceSicurezzaUserLegacy(objectNode, busta, erroriValidazione, (String)prefix);
                            this.readCorniceSicurezzaIpUserLegacy(objectNode, busta, erroriValidazione, (String)prefix);
                        } else {
                            this.readCorniceSicurezzaSchema(objectNode, msg, busta, erroriValidazione, (String)prefix, schemaCorniceSicurezza, securityConfig.getCorniceSicurezzaSchemaConfig());
                        }
                    }
                    if (readIss && objectNode.has("iss") && (iss = objectNode.get("iss")) != null) {
                        busta.addProperty(tokenAudit ? "ProfiloSicurezzaMessaggioAudit-Issuer" : "ProfiloSicurezzaMessaggio-Issuer", this.toString(iss));
                    }
                    if (readSub && objectNode.has("sub") && (sub = objectNode.get("sub")) != null) {
                        busta.addProperty(tokenAudit ? "ProfiloSicurezzaMessaggioAudit-Subject" : "ProfiloSicurezzaMessaggio-Subject", this.toString(sub));
                    }
                    if ((clientId = this.readObjectClientId(objectNode)) != null) {
                        String clientIdValue = this.toString(clientId);
                        busta.addProperty(tokenAudit ? "ProfiloSicurezzaMessaggioAudit-ClientId" : "ProfiloSicurezzaMessaggio-ClientId", clientIdValue);
                    }
                    if ((tokenAudit || integritaX509 || integritaKid) && objectNode.has("purposeId") && (purposeId = objectNode.get("purposeId")) != null) {
                        busta.addProperty(tokenAudit ? "ProfiloSicurezzaMessaggioAudit-PurposeId" : "ProfiloSicurezzaMessaggio-IntegrityPurposeId", this.toString(purposeId));
                    }
                    digestHeader = "Digest";
                    digestValueInHeaderHTTP = null;
                    if (integrita && !integritaCustom) {
                        List digests = null;
                        if (msg != null) {
                            if (request && msg.getTransportRequestContext() != null) {
                                digests = msg.getTransportRequestContext().getHeaderValues(digestHeader);
                            } else if (!request && msg.getTransportResponseContext() != null) {
                                digests = msg.getTransportResponseContext().getHeaderValues(digestHeader);
                            }
                        }
                        String digest = null;
                        if (digests != null && !digests.isEmpty()) {
                            digest = (String)digests.get(0);
                        }
                        if (digest == null) {
                            if (msg.castAsRest().hasContent()) {
                                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.PROFILO_TRASMISSIONE_NON_PRESENTE, this.getErrorHeaderHttpNonPresente(digestHeader)));
                            }
                        } else if (digests.size() > 1) {
                            erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.PROFILO_TRASMISSIONE_PRESENTE_PIU_VOLTE, this.getErrorHeaderHttpPresentePiuVolte(digestHeader)));
                        } else {
                            digestValueInHeaderHTTP = this.toString(digest);
                            busta.addProperty("ProfiloSicurezzaMessaggio-Digest", digestValueInHeaderHTTP);
                            if (request && includiRequestDigest && this.context != null) {
                                this.context.addObject(ModICostanti.MODIPA_CONTEXT_REQUEST_DIGEST, (Object)digestValueInHeaderHTTP);
                            }
                            if (!msg.castAsRest().hasContent()) {
                                boolean canExists;
                                boolean bl = canExists = "always".equals(integrityMode) || request && "responsePayload".equals(integrityMode) || !request && "requestPayload".equals(integrityMode);
                                if (!canExists) {
                                    String role = MessageRole.REQUEST.equals((Object)msg.getMessageRole()) ? "richiesta" : "risposta";
                                    erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_FIRMA_INTESTAZIONE_NON_VALIDA, this.getErrorHeaderHttpPrefix(digestHeader) + " presente in una " + role + " con http payload vuoto"));
                                }
                            }
                        }
                    }
                    if (digestValueInHeaderHTTP != null) {
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        msg.castAsRest().writeTo((OutputStream)bout, false, bufferMessageReadOnly, idTransazione);
                        bout.flush();
                        bout.close();
                        List<DigestEncoding> digestEncoding = securityConfig.getDigestEncodingAccepted();
                        Map newDigestValue = null;
                        boolean formatoSupportato = true;
                        if (digestValueInHeaderHTTP.startsWith("SHA-256=")) {
                            newDigestValue = HttpUtilities.getDigestHeaderValues((byte[])bout.toByteArray(), (String)"SHA-256", (DigestEncoding[])digestEncoding.toArray(new DigestEncoding[1]));
                        } else if (digestValueInHeaderHTTP.startsWith("SHA-384=")) {
                            newDigestValue = HttpUtilities.getDigestHeaderValues((byte[])bout.toByteArray(), (String)"SHA-384", (DigestEncoding[])digestEncoding.toArray(new DigestEncoding[1]));
                        } else if (digestValueInHeaderHTTP.startsWith("SHA-512=")) {
                            newDigestValue = HttpUtilities.getDigestHeaderValues((byte[])bout.toByteArray(), (String)"SHA-512", (DigestEncoding[])digestEncoding.toArray(new DigestEncoding[1]));
                        } else {
                            formatoSupportato = false;
                            erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_FIRMA_INTESTAZIONE_NON_VALIDA, this.getErrorHeaderHttpPrefix(digestHeader) + " con un formato non supportato"));
                        }
                        if (formatoSupportato) {
                            if (newDigestValue == null || newDigestValue.isEmpty()) {
                                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_FIRMA_INTESTAZIONE_NON_VALIDA, "Calcolo Digest fallito"));
                            } else {
                                boolean valido = false;
                                for (DigestEncoding de : digestEncoding) {
                                    String check = (String)newDigestValue.get(de);
                                    if (check == null) {
                                        erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_FIRMA_INTESTAZIONE_NON_VALIDA, "Encoding Digest '" + de + "' fallito"));
                                        continue;
                                    }
                                    if (!check.equals(digestValueInHeaderHTTP)) continue;
                                    valido = true;
                                    break;
                                }
                                if (!valido) {
                                    erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_FIRMA_NON_VALIDA, this.getErrorHeaderHttpPrefix(digestHeader) + " possiede un valore non corrispondente al messaggio"));
                                }
                            }
                        }
                    }
                    claimSignedHeader = this.modiProperties.getRestSecurityTokenClaimSignedHeaders();
                    if (integrita && !integritaCustom && objectNode.has(claimSignedHeader)) {
                        findDigestInClaimSignedHeader = false;
                        headerHttpAttesi = new HashMap<String, List<String>>();
                        JsonNode signedHeaders = objectNode.get(claimSignedHeader);
                        if (signedHeaders == null) {
                            if (integrita && msg.castAsRest().hasContent()) {
                                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_FIRMA_INTESTAZIONE_NON_PRESENTE, (String)prefix + ModIValidazioneSintatticaRest.getErroreTokenSenzaClaim(claimSignedHeader)));
                            }
                        } else {
                            this.readSignedHeaders(signedHeaders, erroriValidazione, (String)prefix, headerDuplicati, busta, headerHttpAttesi, claimSignedHeader);
                        }
                        if (headerHttpAttesi == null || headerHttpAttesi.isEmpty()) break block186;
                        headers = headerHttpAttesi.keySet().iterator();
                        break block187;
                    }
                    if (!integrita) return token;
                    if (integritaCustom) return token;
                    if (!msg.castAsRest().hasContent()) return token;
                    erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_FIRMA_INTESTAZIONE_NON_PRESENTE, (String)prefix + ModIValidazioneSintatticaRest.getErroreTokenSenzaClaim(claimSignedHeader)));
                    return token;
                }
                catch (Exception e) {
                    this.logError("Errore durante il processamento del payload del token di sicurezza: " + e.getMessage(), e);
                    erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_TOKEN_NON_VALIDO, (String)prefix + e.getMessage()));
                }
                return token;
            }
            block15: while (headers.hasNext()) {
                String hdrName = (String)headers.next();
                List hrdAttesiValues = (List)headerHttpAttesi.get(hdrName);
                boolean checkHdrAttesiSize = true;
                List hdrFound = null;
                for (String hdrAttesoValue : hrdAttesiValues) {
                    boolean valid = false;
                    String valueInHttpHeader = null;
                    boolean multiHeader = false;
                    if (digestHeader.toLowerCase().equalsIgnoreCase(hdrName)) {
                        checkHdrAttesiSize = false;
                        findDigestInClaimSignedHeader = true;
                        if (digestValueInHeaderHTTP == null) {
                            erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_FIRMA_NON_VALIDA, this.getErrorHeaderHttpPrefix(hdrName) + ", dichiarato tra gli header firmati, non trovato"));
                            valid = true;
                        } else {
                            valueInHttpHeader = digestValueInHeaderHTTP;
                            valid = hdrAttesoValue.equals(digestValueInHeaderHTTP);
                        }
                    } else {
                        if (request && msg.getTransportRequestContext() != null) {
                            hdrFound = msg.getTransportRequestContext().getHeaderValues(hdrName);
                        } else if (!request && msg.getTransportResponseContext() != null) {
                            hdrFound = msg.getTransportResponseContext().getHeaderValues(hdrName);
                        }
                        if (checkHdrAttesiSize && hdrFound != null) {
                            if (hrdAttesiValues.size() != hdrFound.size()) {
                                this.logError(this.getErrorHeaderHttpPrefix(hdrName) + " possiede " + (hdrFound != null ? hdrFound.size() : 0) + " valori '" + (hdrFound != null ? hdrFound.toString() : "non presente") + "' mentre negli header firmati sono presenti " + hrdAttesiValues.size() + " valori '" + hrdAttesiValues.toString() + "'");
                                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_FIRMA_NON_VALIDA, this.getErrorHeaderHttpPrefix(hdrName) + " possiede un numero di valori (" + (hdrFound != null ? hdrFound.size() : 0) + ") differente rispetto al numero di valori (" + hrdAttesiValues.size() + ") definiti negli header firmati"));
                                valid = true;
                                if (valid) continue block15;
                            }
                            checkHdrAttesiSize = false;
                        }
                        if (hdrFound == null || hdrFound.isEmpty()) {
                            erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_FIRMA_NON_VALIDA, this.getErrorHeaderHttpPrefix(hdrName) + ", dichiarato tra gli header firmati, non trovato"));
                            valid = true;
                            if (valid) {
                                continue block15;
                            }
                        } else if (hdrFound.size() == 1) {
                            valueInHttpHeader = (String)hdrFound.get(0);
                            valid = hdrAttesoValue.equals(valueInHttpHeader);
                        } else {
                            multiHeader = true;
                            valueInHttpHeader = hdrFound.toString();
                            valid = hdrFound.contains(hdrAttesoValue);
                        }
                    }
                    if (valid) continue;
                    String errorMsg = "possiede un valore '" + valueInHttpHeader + "' differente";
                    String errorExc = "possiede un valore differente";
                    if (multiHeader) {
                        errorMsg = "possiede dei valori '" + valueInHttpHeader + "' differenti";
                        errorExc = "possiede dei valori differenti";
                    }
                    this.logError(this.getErrorHeaderHttpPrefix(hdrName) + " " + errorMsg + " rispetto a quello presente negli header firmati '" + hdrAttesoValue + "'");
                    erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_FIRMA_NON_VALIDA, this.getErrorHeaderHttpPrefix(hdrName) + " " + errorExc + " rispetto a quello presente negli header firmati"));
                }
            }
        }
        if (!integrita) return token;
        if (!msg.castAsRest().hasContent()) return token;
        if (findDigestInClaimSignedHeader) return token;
        erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_FIRMA_INTESTAZIONE_NON_PRESENTE, this.getErrorHeaderHttpPrefix(digestHeader) + " non presente nella lista degli header firmati (token claim '" + claimSignedHeader + "')"));
        return token;
    }

    private void readSignedHeaders(Object signedHeaders, List<Eccezione> erroriValidazione, String prefix, boolean headerDuplicati, Busta busta, Map<String, List<String>> headerHttpAttesi, String claimSignedHeader) throws ProtocolException {
        block9: {
            try {
                if (signedHeaders instanceof ArrayNode) {
                    ArrayNode arrayNode = (ArrayNode)signedHeaders;
                    if (arrayNode.size() <= 0) {
                        throw new ProtocolException("atteso un array con almeno un valore");
                    }
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        JsonNode hdrNode = arrayNode.get(i);
                        String prefixArray = "array[" + i + "]";
                        if (hdrNode == null) {
                            throw new ProtocolException(prefixArray + " non possiede un valore");
                        }
                        if (!(hdrNode instanceof ObjectNode)) {
                            throw new ProtocolException(prefixArray + " possiede una struttura errata");
                        }
                        ObjectNode oNode = (ObjectNode)hdrNode;
                        if (oNode.size() <= 0) {
                            throw new ProtocolException(prefixArray + " possiede una struttura senza elementi");
                        }
                        Iterator fieldNames = oNode.fieldNames();
                        while (fieldNames.hasNext()) {
                            String hdrName = (String)fieldNames.next();
                            this.addSignedHeader(oNode, hdrName, headerDuplicati, busta, headerHttpAttesi, prefixArray);
                        }
                    }
                    break block9;
                }
                throw new ProtocolException("atteso un array");
            }
            catch (Exception e) {
                this.logError("Errore durante il processamento del claim che definisce gli header HTTP firmati '" + claimSignedHeader + "': " + e.getMessage(), e);
                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SICUREZZA_FIRMA_INTESTAZIONE_NON_VALIDA, prefix + "Claim '" + claimSignedHeader + "' con un formato non valido; " + e.getMessage()));
            }
        }
    }

    private void addSignedHeader(ObjectNode oNode, String hdrName, boolean headerDuplicati, Busta busta, Map<String, List<String>> headerHttpAttesi, String prefixArray) throws ProtocolException {
        try {
            String hdrValue = this.toString(oNode.get(hdrName));
            if ("Authorization".equalsIgnoreCase(hdrName) && headerDuplicati) {
                ModIUtilities.addHeaderProperty(busta, hdrName, "Bearer ...TOKEN...");
            } else {
                ModIUtilities.addHeaderProperty(busta, hdrName, hdrValue);
            }
            TransportUtils.addHeader(headerHttpAttesi, (String)hdrName, (String)hdrValue);
        }
        catch (Exception e) {
            throw new ProtocolException(prefixArray + " possiede header '" + hdrName + "' con un valore non valido: " + e.getMessage(), (Throwable)e);
        }
    }

    private String readClientIdSafe(String payloadToken) {
        try {
            JsonNode jsonNode = JSONUtils.getInstance().getAsNode(payloadToken);
            if (!(jsonNode instanceof ObjectNode)) {
                throw new ProtocolException("Payload del token possiede una struttura non valida");
            }
            ObjectNode objectNode = (ObjectNode)jsonNode;
            Object clientIdO = this.readObjectClientId(objectNode);
            if (clientIdO != null) {
                return this.toString(clientIdO);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object readObjectClientId(ObjectNode objectNode) throws ProtocolException {
        JsonNode clientId = null;
        String claimName = this.modiProperties.getRestSecurityTokenClaimsClientIdHeader();
        if (objectNode.has("client_id")) {
            clientId = objectNode.get("client_id");
        } else if (objectNode.has("azp")) {
            clientId = objectNode.get("azp");
        } else if (objectNode.has(claimName)) {
            clientId = objectNode.get(claimName);
        }
        return clientId;
    }

    private void readCorniceSicurezzaSchema(ObjectNode objectNode, OpenSPCoop2Message msg, Busta busta, List<Eccezione> erroriValidazione, String prefix, String schemaCorniceSicurezza, ModIAuditConfig auditConfig) throws ProtocolException {
        if (schemaCorniceSicurezza != null && StringUtils.isNotEmpty((String)schemaCorniceSicurezza) && auditConfig != null) {
            this.readCorniceSicurezzaSchema(objectNode, msg, busta, erroriValidazione, prefix, auditConfig.getClaims());
        }
    }

    private void readCorniceSicurezzaSchema(ObjectNode objectNode, OpenSPCoop2Message msg, Busta busta, List<Eccezione> erroriValidazione, String prefix, List<ModIAuditClaimConfig> claims) throws ProtocolException {
        if (claims != null && !claims.isEmpty()) {
            for (ModIAuditClaimConfig modIAuditClaimConfig : claims) {
                String claimName = modIAuditClaimConfig.getNome();
                if (objectNode.has(claimName)) {
                    JsonNode o = objectNode.get(claimName);
                    if (o == null) continue;
                    this.processCorniceSicurezzaSchemaClaimValue(msg, modIAuditClaimConfig, busta, erroriValidazione, prefix, claimName, o);
                    continue;
                }
                if (!modIAuditClaimConfig.isRequired()) continue;
                erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.MITTENTE_NON_PRESENTE, prefix + ModIValidazioneSintatticaRest.getErroreTokenSenzaClaim(claimName)));
            }
        }
    }

    private void processCorniceSicurezzaSchemaClaimValue(OpenSPCoop2Message msg, ModIAuditClaimConfig modIAuditClaimConfig, Busta busta, List<Eccezione> erroriValidazione, String prefix, String claimName, Object o) throws ProtocolException {
        String v = this.toString(o);
        if (modIAuditClaimConfig.isTrace()) {
            busta.addProperty("ProfiloSicurezzaMessaggioAudit-" + claimName, v);
        }
        ModIValidazioneAuditClaimValue validator = new ModIValidazioneAuditClaimValue(claimName, v, o, modIAuditClaimConfig);
        validator.validate(this.validazioneUtils, erroriValidazione, prefix);
        String header = modIAuditClaimConfig.getForwardBackend();
        if (header != null && StringUtils.isNotEmpty((String)header)) {
            msg.forceTransportHeader(header, v);
        }
    }

    private boolean readCorniceSicurezzaCodiceEnteLegacy(ObjectNode objectNode, Busta busta, List<Eccezione> erroriValidazione, String prefix) throws ProtocolException {
        boolean readIss = true;
        String claimNameCodiceEnte = this.modiProperties.getSicurezzaMessaggioCorniceSicurezzaRestCodiceEnte();
        if ("iss".equals(claimNameCodiceEnte)) {
            readIss = false;
        }
        if (objectNode.has(claimNameCodiceEnte)) {
            JsonNode codiceEnte = objectNode.get(claimNameCodiceEnte);
            if (codiceEnte != null) {
                busta.addProperty("ProfiloSicurezzaMessaggio-CorniceSicurezza-Ente", this.toString(codiceEnte));
            }
        } else {
            erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.MITTENTE_NON_PRESENTE, prefix + ModIValidazioneSintatticaRest.getErroreTokenSenzaClaim(claimNameCodiceEnte)));
        }
        return readIss;
    }

    private boolean readCorniceSicurezzaUserLegacy(ObjectNode objectNode, Busta busta, List<Eccezione> erroriValidazione, String prefix) throws ProtocolException {
        boolean readSub = true;
        String claimNameUser = this.modiProperties.getSicurezzaMessaggioCorniceSicurezzaRestUser();
        if ("sub".equals(claimNameUser)) {
            readSub = false;
        }
        if (objectNode.has(claimNameUser)) {
            JsonNode user = objectNode.get(claimNameUser);
            if (user != null) {
                busta.addProperty("ProfiloSicurezzaMessaggio-CorniceSicurezza-User", this.toString(user));
            }
        } else {
            erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.MITTENTE_NON_PRESENTE, prefix + ModIValidazioneSintatticaRest.getErroreTokenSenzaClaim(claimNameUser)));
        }
        return readSub;
    }

    private void readCorniceSicurezzaIpUserLegacy(ObjectNode objectNode, Busta busta, List<Eccezione> erroriValidazione, String prefix) throws ProtocolException {
        String claimNameIpUser = this.modiProperties.getSicurezzaMessaggioCorniceSicurezzaRestIpuser();
        if (objectNode.has(claimNameIpUser)) {
            JsonNode userIp = objectNode.get(claimNameIpUser);
            if (userIp != null) {
                busta.addProperty("ProfiloSicurezzaMessaggio-CorniceSicurezza-UserIP", this.toString(userIp));
            }
        } else {
            erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.MITTENTE_NON_PRESENTE, prefix + ModIValidazioneSintatticaRest.getErroreTokenSenzaClaim(claimNameIpUser)));
        }
    }

    private Date toDate(Object tmp, List<Eccezione> erroriValidazione, CodiceErroreCooperazione codiceErroreCooperazione, String prefix, String claim) throws ProtocolException {
        try {
            return this.toDate(tmp);
        }
        catch (Exception e) {
            erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(codiceErroreCooperazione, prefix + ModIValidazioneSintatticaRest.getErroreTokenClaimNonValido(claim, e), (Throwable)e));
            return null;
        }
    }

    private Date toDate(Object tmp) throws ProtocolException {
        String tmpV = null;
        if (tmp == null) {
            throw new ProtocolException("Value undefined");
        }
        tmpV = tmp instanceof String ? (String)tmp : this.toString(tmp);
        Date d = TokenUtils.parseTimeInSecond((String)tmpV);
        if (d != null) {
            return d;
        }
        throw new ProtocolException("Value '" + tmpV + "' not valid");
    }

    private String toString(Object tmp) {
        if (tmp instanceof TextNode) {
            TextNode text = (TextNode)tmp;
            return text.asText();
        }
        return tmp.toString();
    }
}

