/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.archive;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.openspcoop2.protocol.as4.archive.XMLWriteUtils;
import org.openspcoop2.protocol.basic.archive.ZIPUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.ArchiveSoggetto;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.slf4j.Logger;

public class ZIPWriteUtils {
    protected Logger log = null;
    protected IProtocolFactory<?> protocolFactory;
    protected IRegistryReader registryReader;
    protected IConfigIntegrationReader configIntegrationReader;
    protected XMLWriteUtils xmlWriteUtils;

    public ZIPWriteUtils(Logger log, IProtocolFactory<?> protocolFactory, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader) throws ProtocolException {
        this.log = log;
        this.protocolFactory = protocolFactory;
        this.registryReader = registryReader;
        this.configIntegrationReader = configIntegrationReader;
        this.xmlWriteUtils = new XMLWriteUtils(log, protocolFactory, registryReader, configIntegrationReader);
    }

    public byte[] generate(List<ArchiveSoggetto> soggetti) throws ProtocolException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.generate(bout, soggetti);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public void generate(OutputStream out, List<ArchiveSoggetto> soggetti) throws ProtocolException {
        ZipOutputStream zipOut = null;
        try {
            zipOut = new ZipOutputStream(out);
            Object rootPackageDir = "";
            rootPackageDir = "pmodes" + File.separatorChar;
            for (ArchiveSoggetto archiveSoggetto : soggetti) {
                String nomeSoggetto = archiveSoggetto.getIdSoggetto().getNome();
                String nomeFile = ZIPUtils.convertNameToSistemaOperativoCompatible((String)nomeSoggetto) + ".xml";
                zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + nomeFile));
                byte[] pmode = this.xmlWriteUtils.generate(nomeSoggetto);
                zipOut.write(pmode);
            }
            zipOut.flush();
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (zipOut != null) {
                    zipOut.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

