/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.builder;

import eu.domibus.configuration.Payload;
import eu.domibus.configuration.PayloadProfile;
import eu.domibus.configuration.PayloadProfiles;
import eu.domibus.configuration.Properties;
import eu.domibus.configuration.Property;
import eu.domibus.configuration.PropertySet;
import eu.domibus.configuration.utils.ProjectInfo;
import eu.domibus.configuration.utils.serializer.JaxbDeserializer;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.Azione;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.protocol.as4.pmode.TranslatorPayloadProfilesDefault;
import org.openspcoop2.protocol.as4.pmode.TranslatorPropertiesDefault;
import org.openspcoop2.protocol.as4.utils.AS4PropertiesUtils;
import org.openspcoop2.protocol.sdk.ProtocolException;

public class AS4BuilderUtils {
    public static String readPropertyInfoAction(AccordoServizioParteComune aspc, String nomePortType, String azione) throws ProtocolException {
        return AS4BuilderUtils._readProperty(aspc, nomePortType, azione, "ebmsUserMessageCollaborationInfoAction");
    }

    public static String readPropertyPayloadProfile(AccordoServizioParteComune aspc, String nomePortType, String azione) throws ProtocolException {
        return AS4BuilderUtils._readProperty(aspc, nomePortType, azione, "ebmsActionPayloadProfile");
    }

    public static String readPropertyPropertySet(AccordoServizioParteComune aspc, String nomePortType, String azione) throws ProtocolException {
        return AS4BuilderUtils._readProperty(aspc, nomePortType, azione, "ebmsActionPropertySet");
    }

    private static String _readProperty(AccordoServizioParteComune aspc, String nomePortType, String azione, String propertyName) throws ProtocolException {
        String propertySet;
        String payloadProfile;
        String actionProperty;
        block11: {
            actionProperty = null;
            payloadProfile = null;
            propertySet = null;
            if (ServiceBinding.REST.equals((Object)aspc.getServiceBinding())) {
                for (Resource resource : aspc.getResourceList()) {
                    if (!resource.getNome().equals(azione)) continue;
                    actionProperty = AS4PropertiesUtils.getRequiredStringValue(resource.getProtocolPropertyList(), "ebmsUserMessageCollaborationInfoAction");
                    payloadProfile = AS4PropertiesUtils.getOptionalStringValue(resource.getProtocolPropertyList(), "ebmsActionPayloadProfile");
                    propertySet = AS4PropertiesUtils.getOptionalStringValue(resource.getProtocolPropertyList(), "ebmsActionPropertySet");
                    break;
                }
            } else if (nomePortType != null) {
                for (PortType pt : aspc.getPortTypeList()) {
                    if (!pt.getNome().equals(nomePortType)) continue;
                    for (Operation op : pt.getAzioneList()) {
                        if (!op.getNome().equals(azione)) continue;
                        actionProperty = AS4PropertiesUtils.getRequiredStringValue(op.getProtocolPropertyList(), "ebmsUserMessageCollaborationInfoAction");
                        payloadProfile = AS4PropertiesUtils.getOptionalStringValue(op.getProtocolPropertyList(), "ebmsActionPayloadProfile");
                        propertySet = AS4PropertiesUtils.getOptionalStringValue(op.getProtocolPropertyList(), "ebmsActionPropertySet");
                        break block11;
                    }
                    break;
                }
            } else {
                for (Azione azioneAccordo : aspc.getAzioneList()) {
                    if (!azioneAccordo.getNome().equals(azione)) continue;
                    actionProperty = AS4PropertiesUtils.getRequiredStringValue(azioneAccordo.getProtocolPropertyList(), "ebmsUserMessageCollaborationInfoAction");
                    payloadProfile = AS4PropertiesUtils.getOptionalStringValue(azioneAccordo.getProtocolPropertyList(), "ebmsActionPayloadProfile");
                    propertySet = AS4PropertiesUtils.getOptionalStringValue(azioneAccordo.getProtocolPropertyList(), "ebmsActionPropertySet");
                    break;
                }
            }
        }
        if ("ebmsUserMessageCollaborationInfoAction".equals(propertyName)) {
            return actionProperty;
        }
        if ("ebmsActionPayloadProfile".equals(propertyName)) {
            return payloadProfile;
        }
        if ("ebmsActionPropertySet".equals(propertyName)) {
            return propertySet;
        }
        return null;
    }

    public static PayloadProfiles readPayloadProfiles(TranslatorPayloadProfilesDefault t, AccordoServizioParteComune as, IDAccordo id, boolean loadDefault) throws ProtocolException {
        byte[] profilesBytes = null;
        try {
            for (ProtocolProperty pp : as.getProtocolPropertyList()) {
                if (!"ebmsServicePayloadProfile".equals(pp.getName())) continue;
                profilesBytes = pp.getByteFile();
                break;
            }
        }
        catch (Exception e) {
            throw new ProtocolException("Impossibile recuperare la configurazione del payloadProfile dall'accordo con id [" + id + "]: " + e.getMessage(), (Throwable)e);
        }
        return AS4BuilderUtils.readPayloadProfiles(t, profilesBytes, id, loadDefault);
    }

    public static PayloadProfiles readPayloadProfiles(TranslatorPayloadProfilesDefault t, byte[] profilesBytes, IDAccordo id, boolean loadDefault) throws ProtocolException {
        PayloadProfiles pps = null;
        try {
            if (profilesBytes != null) {
                String profiles = new String(profilesBytes);
                profiles = profiles.replace("<payloadProfiles>", "<ns:payloadProfiles xmlns:ns=\"" + ProjectInfo.getInstance().getProjectNamespace() + "\">");
                profiles = profiles.replace("</payloadProfiles", "</ns:payloadProfiles");
                JaxbDeserializer deserializer = new JaxbDeserializer();
                pps = deserializer.readPayloadProfiles(profiles.getBytes());
            }
        }
        catch (Exception e) {
            throw new ProtocolException("Errore durante la lettura della configurazione del payloadProfile dall'accordo con id [" + id + "]: " + e.getMessage(), (Throwable)e);
        }
        if (!loadDefault) {
            return pps;
        }
        if (pps == null) {
            pps = new PayloadProfiles();
        }
        ArrayList<Payload> original = new ArrayList<Payload>();
        for (Payload payload : pps.getPayloadList()) {
            original.add(payload);
        }
        List<Payload> payloadsDefault = t.getListPayloadDefault();
        for (Payload payload : payloadsDefault) {
            boolean found = false;
            for (Payload payload2 : original) {
                if (!payload.getName().equals(payload2.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            pps.addPayload(payload);
        }
        ArrayList<PayloadProfile> arrayList = new ArrayList<PayloadProfile>();
        for (PayloadProfile payloadProfile : pps.getPayloadProfileList()) {
            arrayList.add(payloadProfile);
        }
        List<PayloadProfile> list = t.getListPayloadProfileDefault();
        for (PayloadProfile payloadProfileDefault : list) {
            boolean found = false;
            for (PayloadProfile payloadProfile : arrayList) {
                if (!payloadProfileDefault.getName().equals(payloadProfile.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            pps.addPayloadProfile(payloadProfileDefault);
        }
        return pps;
    }

    public static Properties readProperties(TranslatorPropertiesDefault t, AccordoServizioParteComune as, IDAccordo id, boolean loadDefault) throws ProtocolException {
        byte[] profilesBytes = null;
        try {
            for (ProtocolProperty pp : as.getProtocolPropertyList()) {
                if (!"ebmsServiceProperties".equals(pp.getName())) continue;
                profilesBytes = pp.getByteFile();
                break;
            }
        }
        catch (Exception e) {
            throw new ProtocolException("Impossibile recuperare la configurazione delle propriet\u00e0 dall'accordo con id [" + id + "]: " + e.getMessage(), (Throwable)e);
        }
        return AS4BuilderUtils.readProperties(t, profilesBytes, id, loadDefault);
    }

    public static Properties readProperties(TranslatorPropertiesDefault t, byte[] profilesBytes, IDAccordo id, boolean loadDefault) throws ProtocolException {
        Properties pps = null;
        try {
            if (profilesBytes != null) {
                String profiles = new String(profilesBytes);
                profiles = profiles.replace("<properties>", "<ns:properties xmlns:ns=\"" + ProjectInfo.getInstance().getProjectNamespace() + "\">");
                profiles = profiles.replace("</properties", "</ns:properties");
                JaxbDeserializer deserializer = new JaxbDeserializer();
                pps = deserializer.readProperties(profiles.getBytes());
            }
        }
        catch (Exception e) {
            throw new ProtocolException("Errore durante la lettura della configurazione delle propriet\u00e0 dall'accordo con id [" + id + "]: " + e.getMessage(), (Throwable)e);
        }
        if (!loadDefault) {
            return pps;
        }
        if (pps == null) {
            pps = new Properties();
        }
        ArrayList<Property> original = new ArrayList<Property>();
        for (Property property : pps.getPropertyList()) {
            original.add(property);
        }
        List<Property> propertyDefault = t.getListPropertyDefault();
        for (Property property : propertyDefault) {
            boolean found = false;
            for (Property payload : original) {
                if (!property.getName().equals(payload.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            pps.addProperty(property);
        }
        ArrayList<PropertySet> arrayList = new ArrayList<PropertySet>();
        for (PropertySet p : pps.getPropertySetList()) {
            arrayList.add(p);
        }
        List<PropertySet> list = t.getListPropertySetDefault();
        for (PropertySet psDefault : list) {
            boolean found = false;
            for (PropertySet payloadProfile : arrayList) {
                if (!psDefault.getName().equals(payloadProfile.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            pps.addPropertySet(psDefault);
        }
        return pps;
    }
}

