/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.builder;

import java.util.Date;
import javax.xml.soap.SOAPElement;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.config.ServiceBindingConfiguration;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.as4.builder.AS4Imbustamento;
import org.openspcoop2.protocol.as4.builder.AS4Sbustamento;
import org.openspcoop2.protocol.as4.config.AS4Properties;
import org.openspcoop2.protocol.basic.builder.BustaBuilder;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.ProtocolMessage;
import org.openspcoop2.protocol.sdk.builder.ProprietaManifestAttachments;
import org.openspcoop2.protocol.sdk.constants.FaseImbustamento;
import org.openspcoop2.protocol.sdk.constants.FaseSbustamento;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;

public class AS4BustaBuilder
extends BustaBuilder<SOAPElement> {
    private AS4Properties as4Properties = AS4Properties.getInstance();

    public AS4BustaBuilder(IProtocolFactory<?> factory, IState state) throws ProtocolException {
        super(factory, state);
    }

    public ProtocolMessage imbustamento(OpenSPCoop2Message msg, Context context, Busta busta, Busta bustaRichiesta, RuoloMessaggio ruoloMessaggio, ProprietaManifestAttachments proprietaManifestAttachments, FaseImbustamento faseImbustamento) throws ProtocolException {
        if (FaseImbustamento.DOPO_SICUREZZA_MESSAGGIO.equals((Object)faseImbustamento)) {
            ProtocolMessage protocolMessage = new ProtocolMessage();
            protocolMessage.setPhaseUnsupported(true);
            return protocolMessage;
        }
        if (RuoloMessaggio.RICHIESTA.equals((Object)ruoloMessaggio)) {
            AS4Imbustamento imbustamento = new AS4Imbustamento();
            RequestInfo requestInfo = null;
            if (context != null && context.containsKey(Costanti.REQUEST_INFO)) {
                requestInfo = (RequestInfo)context.getObject(Costanti.REQUEST_INFO);
            }
            return imbustamento.buildASMessage(msg, busta, ruoloMessaggio, proprietaManifestAttachments, this.getProtocolFactory().getCachedRegistryReader(this.state, requestInfo), this.getProtocolFactory());
        }
        ProtocolMessage protocolMessage = new ProtocolMessage();
        protocolMessage.setPhaseUnsupported(true);
        return protocolMessage;
    }

    public String newID(IDSoggetto idSoggetto, String idTransazione, RuoloMessaggio ruoloMessaggio) throws ProtocolException {
        Object id = super.newID(idSoggetto, idTransazione, ruoloMessaggio, this.as4Properties.generateIDasUUID().booleanValue());
        id = (String)id + "@openspcoop.org";
        return id;
    }

    public Date extractDateFromID(String id) throws ProtocolException {
        return this.extractDateFromID(id, this.as4Properties.generateIDasUUID());
    }

    public ProtocolMessage sbustamento(OpenSPCoop2Message msg, Context context, Busta busta, RuoloMessaggio ruoloMessaggio, ProprietaManifestAttachments proprietaManifestAttachments, FaseSbustamento faseSbustamento, ServiceBinding integrationServiceBinding, ServiceBindingConfiguration serviceBindingConfiguration) throws ProtocolException {
        if (FaseSbustamento.POST_VALIDAZIONE_SEMANTICA_RICHIESTA.equals((Object)faseSbustamento)) {
            AS4Sbustamento sbustamento = new AS4Sbustamento();
            RequestInfo requestInfo = null;
            if (context != null && context.containsKey(Costanti.REQUEST_INFO)) {
                requestInfo = (RequestInfo)context.getObject(Costanti.REQUEST_INFO);
            }
            IRegistryReader registryReader = this.protocolFactory.getCachedRegistryReader(this.state, requestInfo);
            return sbustamento.buildMessage(this.state, msg, busta, ruoloMessaggio, proprietaManifestAttachments, faseSbustamento, integrationServiceBinding, serviceBindingConfiguration, registryReader, this.protocolFactory);
        }
        return super.sbustamento(msg, context, busta, ruoloMessaggio, proprietaManifestAttachments, faseSbustamento, integrationServiceBinding, serviceBindingConfiguration);
    }
}

