/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.builder;

import eu.domibus.configuration.Payload;
import eu.domibus.configuration.PayloadProfile;
import eu.domibus.configuration.PayloadProfiles;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.BodyPart;
import javax.mail.internet.InternetHeaders;
import javax.xml.soap.AttachmentPart;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PartInfo;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.Property;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.UserMessage;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.constants.HttpMethod;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.registry.wsdl.AccordoServizioWrapper;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.config.ServiceBindingConfiguration;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.protocol.as4.builder.AS4BuilderUtils;
import org.openspcoop2.protocol.as4.constants.AS4Costanti;
import org.openspcoop2.protocol.as4.pmode.TranslatorPayloadProfilesDefault;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.ProtocolMessage;
import org.openspcoop2.protocol.sdk.builder.ProprietaManifestAttachments;
import org.openspcoop2.protocol.sdk.constants.FaseSbustamento;
import org.openspcoop2.protocol.sdk.constants.InformationApiSource;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.utils.mime.MimeMultipart;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.TransportUtils;
import org.w3c.dom.Element;

public class AS4Sbustamento {
    public ProtocolMessage buildMessage(IState state, OpenSPCoop2Message msg, Busta busta, RuoloMessaggio ruoloMessaggio, ProprietaManifestAttachments proprietaManifestAttachments, FaseSbustamento faseSbustamento, ServiceBinding integrationServiceBinding, ServiceBindingConfiguration serviceBindingConfiguration, IRegistryReader registryReader, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        try {
            OpenSPCoop2MessageFactory messageFactory;
            OpenSPCoop2MessageFactory openSPCoop2MessageFactory = messageFactory = msg != null ? msg.getFactory() : OpenSPCoop2MessageFactory.getDefaultMessageFactory();
            if (msg == null) {
                throw new Exception("Message is null");
            }
            Object o = msg.getContextProperty(AS4Costanti.AS4_CONTEXT_USER_MESSAGE);
            if (o == null) {
                throw new ProtocolException("UserMessage not found in context");
            }
            if (!(o instanceof UserMessage)) {
                throw new ProtocolException("UserMessage in context message with wrong type (expected:" + UserMessage.class.getName() + " founded:" + o.getClass().getName() + ")");
            }
            UserMessage userMessage = (UserMessage)o;
            Object oContent = msg.getContextProperty(AS4Costanti.AS4_CONTEXT_CONTENT);
            if (oContent == null) {
                throw new ProtocolException("Contenuti non trovati in context");
            }
            if (!(oContent instanceof HashMap)) {
                throw new ProtocolException("Contenuti in context message with wrong type (expected:" + HashMap.class.getName() + " founded:" + oContent.getClass().getName() + ")");
            }
            HashMap content = (HashMap)oContent;
            boolean multipart = userMessage.getPayloadInfo().sizePartInfoList() > 1;
            List<Object> listPartInfo = new ArrayList();
            IDSoggetto idSoggettoMittente = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
            IDSoggetto idSoggettoDestinatario = new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
            IDSoggetto idSoggettoErogatore = null;
            idSoggettoErogatore = RuoloMessaggio.RICHIESTA.equals((Object)ruoloMessaggio) ? idSoggettoDestinatario : idSoggettoMittente;
            IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(busta.getTipoServizio(), busta.getServizio(), idSoggettoErogatore, busta.getVersioneServizio().intValue());
            AccordoServizioParteSpecifica asps = registryReader.getAccordoServizioParteSpecifica(idServizio);
            IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune());
            AccordoServizioParteComune aspc = registryReader.getAccordoServizioParteComune(idAccordo);
            String azione = busta.getAzione();
            String nomePortType = asps.getPortType();
            if (!multipart) {
                listPartInfo = userMessage.getPayloadInfo().getPartInfoList();
            } else {
                TranslatorPayloadProfilesDefault t = TranslatorPayloadProfilesDefault.getTranslator();
                String actionProperty = AS4BuilderUtils.readPropertyInfoAction(aspc, nomePortType, azione);
                String payloadProfile = AS4BuilderUtils.readPropertyPayloadProfile(aspc, nomePortType, azione);
                if (actionProperty == null) {
                    throw new ProtocolException("Action '" + azione + "' not found");
                }
                if (payloadProfile == null) {
                    payloadProfile = t.getListPayloadProfileDefault().get(0).getName();
                }
                PayloadProfiles pps = AS4BuilderUtils.readPayloadProfiles(t, aspc, idAccordo, true);
                String payLoadRootMessageName = null;
                for (PayloadProfile payloadProfile2 : pps.getPayloadProfileList()) {
                    if (!payloadProfile2.getName().equals(payloadProfile)) continue;
                    payLoadRootMessageName = payloadProfile2.getAttachment(0).getName();
                    break;
                }
                if (payLoadRootMessageName == null) {
                    throw new ProtocolException("Action '" + azione + "' with payload profile '" + payloadProfile + "' unknown (search payload name failed)");
                }
                String cidRootMessage = null;
                for (Payload p : pps.getPayloadList()) {
                    if (!p.getName().equals(payLoadRootMessageName)) continue;
                    cidRootMessage = p.getCid();
                    break;
                }
                if (cidRootMessage == null) {
                    throw new ProtocolException("Action '" + azione + "' with payload profile '" + payloadProfile + "' with payload '" + payLoadRootMessageName + "' unknown");
                }
                for (PartInfo partInfo : userMessage.getPayloadInfo().getPartInfoList()) {
                    if (!partInfo.getHref().equals(cidRootMessage)) continue;
                    listPartInfo.add(partInfo);
                    break;
                }
                for (PartInfo partInfo : userMessage.getPayloadInfo().getPartInfoList()) {
                    if (partInfo.getHref().equals(cidRootMessage)) continue;
                    listPartInfo.add(partInfo);
                }
            }
            PartInfo partInfoRoot = (PartInfo)listPartInfo.get(0);
            String mimeTypeRoot = this.getMimeType(partInfoRoot);
            byte[] contentRoot = (byte[])content.get(partInfoRoot.getHref());
            String contentIdRoot = partInfoRoot.getHref();
            if (contentIdRoot.startsWith("cid:")) {
                contentIdRoot = contentIdRoot.substring("cid:".length());
            }
            OpenSPCoop2Message newMessage = null;
            MessageType messageType = serviceBindingConfiguration.getMessageType(integrationServiceBinding, MessageRole.REQUEST, msg.getTransportRequestContext(), mimeTypeRoot, null);
            if (ServiceBinding.SOAP.equals((Object)integrationServiceBinding)) {
                Element element;
                Object var33_38 = null;
                try {
                    element = MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)messageFactory).newElement(contentRoot);
                }
                catch (Throwable e) {
                    String s = "";
                    try {
                        s = new String(contentRoot);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw new Exception("ContentRoot (cid:" + contentIdRoot + ") non \u00e8 un xml valido (Envelope): " + s, e);
                }
                String namespace = element.getNamespaceURI();
                if ("http://www.w3.org/2003/05/soap-envelope".equals(namespace)) {
                    messageType = MessageType.SOAP_12;
                    mimeTypeRoot = "application/soap+xml";
                } else if ("http://schemas.xmlsoap.org/soap/envelope/".equals(namespace)) {
                    messageType = MessageType.SOAP_11;
                    mimeTypeRoot = "text/xml";
                } else {
                    throw new Exception("Namespace [" + namespace + "] sconosciuto per integrazione SOAP");
                }
            }
            TransportRequestContext transportRequestContext = msg.getTransportRequestContext();
            transportRequestContext.setFunction("PA");
            if (ServiceBinding.REST.equals((Object)integrationServiceBinding)) {
                if (multipart) {
                    messageType = MessageType.MIME_MULTIPART;
                }
                Resource resourceInvoke = null;
                for (Resource r : aspc.getResourceList()) {
                    if (!r.getNome().equals(azione)) continue;
                    resourceInvoke = r;
                    break;
                }
                if (resourceInvoke == null) {
                    throw new Exception("Risorsa [" + azione + "] sconosciuta per integrazione REST");
                }
                String interfaceName = transportRequestContext.getInterfaceName();
                if (resourceInvoke.getPath() != null) {
                    Object p = interfaceName;
                    if (interfaceName.endsWith("/")) {
                        p = interfaceName.substring(0, interfaceName.length() - 1);
                    }
                    if (!resourceInvoke.getPath().startsWith("/")) {
                        p = (String)p + "/";
                    }
                    p = resourceInvoke.getPath();
                    transportRequestContext.setFunctionParameters((String)p);
                } else {
                    transportRequestContext.setFunctionParameters(interfaceName);
                }
                if (resourceInvoke.getMethod() == null) {
                    transportRequestContext.setRequestType(HttpMethod.POST.getValue());
                } else {
                    transportRequestContext.setRequestType(resourceInvoke.getMethod().getValue());
                }
            }
            if (transportRequestContext.getHeaders() == null) {
                transportRequestContext.setHeaders(new HashMap());
            }
            transportRequestContext.getHeaders().remove("Content-Type");
            TransportUtils.addHeader((Map)transportRequestContext.getHeaders(), (String)"Content-Type", (String)mimeTypeRoot);
            OpenSPCoop2MessageParseResult result = null;
            if (!MessageType.MIME_MULTIPART.equals((Object)messageType)) {
                result = messageFactory.createMessage(messageType, transportRequestContext, contentRoot);
                try {
                    newMessage = result.getMessage_throwParseThrowable();
                }
                catch (Throwable t) {
                    String s = "";
                    try {
                        s = new String(contentRoot);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw new Exception("ContentRoot (messageType:" + messageType + ") non \u00e8 un contenuto valido: " + s, t);
                }
            }
            if (ServiceBinding.SOAP.equals((Object)integrationServiceBinding)) {
                PortType pt;
                AccordoServizioWrapper asWrapper;
                String soapAction = "GovWay";
                if (azione != null && nomePortType != null && (asWrapper = registryReader.getAccordoServizioParteComuneSoap(idServizio, InformationApiSource.SAFE_SPECIFIC_REGISTRY, false, false)) != null && (pt = asWrapper.getPortType(asps.getPortType())) != null) {
                    for (Operation op : pt.getAzioneList()) {
                        if (!op.getNome().equals(busta.getAzione())) continue;
                        soapAction = op.getSoapAction();
                        if (soapAction != null) break;
                        soapAction = "";
                        break;
                    }
                }
                if (newMessage != null) {
                    newMessage.castAsSoap().setSoapAction(soapAction);
                }
            }
            if (multipart) {
                MimeMultipart mm = null;
                if (MessageType.MIME_MULTIPART.equals((Object)messageType)) {
                    mm = new MimeMultipart("mixed");
                    InternetHeaders headers = new InternetHeaders();
                    headers.addHeader("Content-ID", "<" + contentIdRoot + ">");
                    headers.addHeader("Content-Type", mimeTypeRoot);
                    BodyPart bodyPart = mm.createBodyPart(headers, contentRoot);
                    mm.addBodyPart(bodyPart);
                }
                for (int i = 1; i < listPartInfo.size(); ++i) {
                    PartInfo partInfoAttach = (PartInfo)listPartInfo.get(i);
                    byte[] c = (byte[])content.get(partInfoAttach.getHref());
                    String mimeType = this.getMimeType(partInfoAttach);
                    Object contentId = partInfoAttach.getHref();
                    if (((String)contentId).startsWith("cid:")) {
                        contentId = ((String)contentId).substring("cid:".length());
                    }
                    contentId = "<" + (String)contentId + ">";
                    if (ServiceBinding.SOAP.equals((Object)integrationServiceBinding)) {
                        OpenSPCoop2SoapMessage soapMsg = newMessage.castAsSoap();
                        AttachmentPart ap = soapMsg.createAttachmentPart();
                        ap.setRawContentBytes(c, 0, c.length, mimeType);
                        ap.setContentId((String)contentId);
                        soapMsg.addAttachmentPart(ap);
                        continue;
                    }
                    InternetHeaders headers = new InternetHeaders();
                    headers.addHeader("Content-ID", (String)contentId);
                    headers.addHeader("Content-Type", mimeType);
                    BodyPart bodyPart = mm.createBodyPart(headers, c);
                    mm.addBodyPart(bodyPart);
                }
                if (MessageType.MIME_MULTIPART.equals((Object)messageType)) {
                    transportRequestContext.getHeaders().remove("Content-Type");
                    TransportUtils.addHeader((Map)transportRequestContext.getHeaders(), (String)"Content-Type", (String)mm.getContentType());
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    mm.writeTo((OutputStream)bout);
                    bout.flush();
                    bout.close();
                    result = messageFactory.createMessage(messageType, transportRequestContext, bout.toByteArray());
                    newMessage = result.getMessage_throwParseThrowable();
                }
                if (ServiceBinding.SOAP.equals((Object)integrationServiceBinding)) {
                    OpenSPCoop2SoapMessage soapMsg = newMessage.castAsSoap();
                    soapMsg.getSOAPPart().addMimeHeader("Content-ID", "<" + contentIdRoot + ">");
                }
            }
            ProtocolMessage protocolMessage = new ProtocolMessage();
            protocolMessage.setMessage(newMessage);
            protocolMessage.setUseBustaRawContentReadByValidation(true);
            return protocolMessage;
        }
        catch (Throwable e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    private String getMimeType(PartInfo partInfo) throws ProtocolException {
        for (Property property : partInfo.getPartProperties().getPropertyList()) {
            if (!"MimeType".equals(property.getName())) continue;
            return property.getBase();
        }
        throw new ProtocolException("MimeType not found in part info [" + partInfo.getHref() + "]");
    }
}

