/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.pmode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneSoggetto;
import org.openspcoop2.core.config.constants.TipoAutorizzazione;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.protocol.as4.config.AS4Properties;
import org.openspcoop2.protocol.as4.pmode.beans.APC;
import org.openspcoop2.protocol.as4.pmode.beans.API;
import org.openspcoop2.protocol.as4.pmode.beans.Index;
import org.openspcoop2.protocol.as4.pmode.beans.PayloadProfiles;
import org.openspcoop2.protocol.as4.pmode.beans.Policy;
import org.openspcoop2.protocol.as4.pmode.beans.Properties;
import org.openspcoop2.protocol.as4.pmode.beans.Soggetto;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaAccordi;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaPorteApplicative;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaServizi;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaSoggetti;
import org.openspcoop2.protocol.sdk.registry.RegistryNotFound;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;

public class PModeRegistryReader {
    private IRegistryReader registryReader;
    private IConfigIntegrationReader configIntergrationReader;
    private String tipo;
    private Logger log;
    private AS4Properties as4Properties;

    public PModeRegistryReader(IRegistryReader registryReader, IConfigIntegrationReader configIntergrationReader, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        this.registryReader = registryReader;
        this.configIntergrationReader = configIntergrationReader;
        this.tipo = protocolFactory.createProtocolConfiguration().getTipoSoggettoDefault();
        this.log = LoggerWrapperFactory.getLogger(PModeRegistryReader.class);
        this.as4Properties = AS4Properties.getInstance();
    }

    public List<APC> findAllAPC() throws Exception {
        ArrayList<APC> apcList = new ArrayList<APC>();
        ProtocolFiltroRicercaAccordi filtroRicerca = new ProtocolFiltroRicercaAccordi();
        filtroRicerca.setSoggetto(new IDSoggetto(this.tipo, null));
        List allIdAccordiServizioParteComune = this.registryReader.findIdAccordiServizioParteComune(filtroRicerca);
        int index = 1;
        for (IDAccordo idAccordo : allIdAccordiServizioParteComune) {
            AccordoServizioParteComune accordoServizioParteComune = this.registryReader.getAccordoServizioParteComune(idAccordo);
            apcList.add(new APC(this.log, accordoServizioParteComune, index++));
        }
        return apcList;
    }

    public PayloadProfiles findPayloadProfile(List<APC> apcList) throws Exception {
        ArrayList<byte[]> contents = new ArrayList<byte[]>();
        for (APC apc : apcList) {
            if (apc.getEbmsServicePayloadProfile() == null) continue;
            contents.add(apc.getEbmsServicePayloadProfile());
        }
        return new PayloadProfiles(contents);
    }

    public Properties findProperties(List<APC> apcList) throws Exception {
        ArrayList<byte[]> contents = new ArrayList<byte[]>();
        for (APC apc : apcList) {
            if (apc.getEbmsServiceProperties() == null) continue;
            contents.add(apc.getEbmsServiceProperties());
        }
        return new Properties(contents);
    }

    public List<Policy> findAllPolicies() throws Exception {
        ArrayList<Policy> policies = new ArrayList<Policy>();
        String[] list = this.as4Properties.getSecurityPoliciesFolder().list();
        if (list != null) {
            for (String file : list) {
                Policy policy = new Policy();
                int lastIndexOf = file.lastIndexOf(".");
                String fileWithoutExt = lastIndexOf > 0 ? file.substring(0, lastIndexOf) : file;
                policy.setName(fileWithoutExt);
                policy.setPolicy(file);
                policies.add(policy);
            }
        }
        return policies;
    }

    public List<Soggetto> findAllSoggetti(Map<IDAccordo, API> accordi) throws Exception {
        ProtocolFiltroRicercaSoggetti filtroRicercaSoggetti = new ProtocolFiltroRicercaSoggetti();
        filtroRicercaSoggetti.setTipo(this.tipo);
        List allIdSoggetti = this.registryReader.findIdSoggetti(filtroRicercaSoggetti);
        ArrayList<Soggetto> soggetti = new ArrayList<Soggetto>();
        String defaultGW = null;
        List<Object> customGW = new ArrayList();
        if (this.as4Properties.isDomibusGatewayRegistry().booleanValue()) {
            defaultGW = this.as4Properties.getDomibusGatewayRegistrySoggettoDefault();
            customGW = this.as4Properties.getDomibusGatewayRegistrySoggettoCustomList();
        }
        Index index = new Index();
        for (IDSoggetto idSoggetto : allIdSoggetti) {
            org.openspcoop2.core.registry.Soggetto soggetto = this.registryReader.getSoggetto(idSoggetto);
            if (defaultGW != null && soggetto.getNome().equals(defaultGW) || customGW != null && customGW.size() > 0 && customGW.contains(soggetto.getNome())) continue;
            if (soggetto.sizeAccordoServizioParteSpecificaList() <= 0) {
                ProtocolFiltroRicercaServizi filtroRicercaServizi = new ProtocolFiltroRicercaServizi();
                filtroRicercaServizi.setTipoServizio(this.tipo);
                filtroRicercaServizi.setSoggettoErogatore(idSoggetto);
                List listServizi = null;
                try {
                    listServizi = this.registryReader.findIdAccordiServizioParteSpecifica(filtroRicercaServizi);
                }
                catch (RegistryNotFound registryNotFound) {
                    // empty catch block
                }
                if (listServizi != null && listServizi.size() > 0) {
                    for (IDServizio idServizio : listServizi) {
                        AccordoServizioParteSpecifica asps = this.registryReader.getAccordoServizioParteSpecifica(idServizio);
                        soggetto.addAccordoServizioParteSpecifica(asps);
                    }
                }
            }
            Soggetto soggettoPM = new Soggetto(soggetto, accordi, index);
            soggetti.add(soggettoPM);
        }
        return soggetti;
    }

    public List<IDSoggetto> findSoggettoAutorizzati(AccordoServizioParteSpecifica asps) throws Exception {
        IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromAccordo(asps);
        ProtocolFiltroRicercaSoggetti filtroRicercaSoggetti = new ProtocolFiltroRicercaSoggetti();
        filtroRicercaSoggetti.setTipo(this.tipo);
        List allIdSoggettiTmp = this.registryReader.findIdSoggetti(filtroRicercaSoggetti);
        ArrayList<IDSoggetto> allIdSoggetti = new ArrayList<IDSoggetto>();
        for (IDSoggetto idSoggetto : allIdSoggettiTmp) {
            if (idSoggetto.equals((Object)idServizio.getSoggettoErogatore())) continue;
            allIdSoggetti.add(idSoggetto);
        }
        ArrayList<IDSoggetto> list = new ArrayList<IDSoggetto>();
        ProtocolFiltroRicercaPorteApplicative filtroRicerca = new ProtocolFiltroRicercaPorteApplicative();
        filtroRicerca.setTipoSoggetto(idServizio.getSoggettoErogatore().getTipo());
        filtroRicerca.setNomeSoggetto(idServizio.getSoggettoErogatore().getNome());
        filtroRicerca.setTipoServizio(idServizio.getTipo());
        filtroRicerca.setNomeServizio(idServizio.getNome());
        filtroRicerca.setVersioneServizio(idServizio.getVersione());
        List idsPA = null;
        try {
            idsPA = this.configIntergrationReader.findIdPorteApplicative(filtroRicerca);
        }
        catch (RegistryNotFound registryNotFound) {
            // empty catch block
        }
        if (idsPA != null && idsPA.size() > 0) {
            for (IDPortaApplicativa idPortaApplicativa : idsPA) {
                PortaApplicativa pa = this.configIntergrationReader.getPortaApplicativa(idPortaApplicativa);
                if (TipoAutorizzazione.AUTHENTICATED.equals(pa.getAutorizzazione())) {
                    if (pa.getSoggetti() == null || pa.getSoggetti().sizeSoggettoList() <= 0) continue;
                    for (PortaApplicativaAutorizzazioneSoggetto paAuthSoggetto : pa.getSoggetti().getSoggettoList()) {
                        IDSoggetto idSogg = new IDSoggetto(paAuthSoggetto.getTipo(), paAuthSoggetto.getNome());
                        if (list.contains(idSogg)) continue;
                        list.add(idSogg);
                    }
                    continue;
                }
                return allIdSoggetti;
            }
        }
        return list;
    }

    public String getNomeSoggettoOperativo() throws Exception {
        try {
            List allIdPorteDominio = this.registryReader.findIdPorteDominio(Boolean.valueOf(true));
            if (allIdPorteDominio.size() <= 0) {
                throw new Exception("Impossibile trovare una PdD di tipo 'operativo'");
            }
            PortaDominio portaDominio = this.registryReader.getPortaDominio((String)allIdPorteDominio.get(0));
            ProtocolFiltroRicercaSoggetti filtroRicercaSoggetti = new ProtocolFiltroRicercaSoggetti();
            filtroRicercaSoggetti.setTipo(this.tipo);
            filtroRicercaSoggetti.setNomePdd(portaDominio.getNome());
            List allIdSoggetti = this.registryReader.findIdSoggetti(filtroRicercaSoggetti);
            if (allIdSoggetti.size() <= 0) {
                throw new Exception("Impossibile trovare il soggetto relativo alla PdD [" + portaDominio.getNome() + "]");
            }
            return ((IDSoggetto)allIdSoggetti.get(0)).getNome();
        }
        catch (Exception e) {
            throw new Exception("Impossibile trovare il soggetto operativo: " + e.getMessage(), e);
        }
    }

    public Map<IDAccordo, API> findAllAccordi(PayloadProfiles findPayloadProfile, Properties findProperties) throws Exception {
        ProtocolFiltroRicercaAccordi filtroRicerca = new ProtocolFiltroRicercaAccordi();
        filtroRicerca.setSoggetto(new IDSoggetto(this.tipo, null));
        List allId = this.registryReader.findIdAccordiServizioParteComune(filtroRicerca);
        HashMap<IDAccordo, API> map = new HashMap<IDAccordo, API>();
        Index index = new Index();
        for (IDAccordo idAccordo : allId) {
            AccordoServizioParteComune apc = this.registryReader.getAccordoServizioParteComune(idAccordo);
            String nomeApc = "Servizio_" + index.getNextServiceId();
            map.put(idAccordo, new API(apc, nomeApc, index, findPayloadProfile, findProperties));
        }
        return map;
    }

    public List<ProtocolProperty> findAllPartyIdTypes(List<Soggetto> soggetti) throws Exception {
        HashMap<String, ProtocolProperty> propertiesMap = new HashMap<String, ProtocolProperty>();
        for (Soggetto soggetto : soggetti) {
            if (!propertiesMap.containsKey(soggetto.getEbmsUserMessagePartyIdTypeName())) {
                ProtocolProperty property = new ProtocolProperty();
                property.setName(soggetto.getEbmsUserMessagePartyIdTypeName());
                property.setValue(soggetto.getEbmsUserMessagePartyIdTypeValue());
                propertiesMap.put(soggetto.getEbmsUserMessagePartyIdTypeName(), property);
                continue;
            }
            ProtocolProperty protocolProperty = (ProtocolProperty)propertiesMap.get(soggetto.getEbmsUserMessagePartyIdTypeName());
            if (protocolProperty.getValue().equals(soggetto.getEbmsUserMessagePartyIdTypeValue())) continue;
            throw new Exception("Trovati getEbmsUserMessagePartyIdTypeName [" + soggetto.getEbmsUserMessagePartyIdTypeName() + "] con value in conflitto: [" + protocolProperty.getValue() + "] - [" + soggetto.getEbmsUserMessagePartyIdTypeValue() + "]");
        }
        return Arrays.asList(propertiesMap.values().toArray(new ProtocolProperty[0]));
    }
}

