/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.pmode;

import eu.domibus.configuration.Property;
import eu.domibus.configuration.PropertySet;
import eu.domibus.configuration.utils.ProjectInfo;
import eu.domibus.configuration.utils.serializer.JaxbDeserializer;
import freemarker.template.Template;
import java.io.BufferedReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openspcoop2.protocol.as4.config.AS4Properties;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.resources.TemplateUtils;

public class TranslatorPropertiesDefault {
    private static TranslatorPropertiesDefault translatorInstance;
    private byte[] propertyDefault = null;
    private Template templatePropertyDefault;
    private byte[] payloadPropertySetDefault = null;
    private Template templatePropertySetDefault;

    private static synchronized void initTranslator() throws ProtocolException {
        if (translatorInstance == null) {
            translatorInstance = new TranslatorPropertiesDefault();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TranslatorPropertiesDefault getTranslator() throws ProtocolException {
        if (translatorInstance != null) return translatorInstance;
        Class<TranslatorPropertiesDefault> clazz = TranslatorPropertiesDefault.class;
        synchronized (TranslatorPropertiesDefault.class) {
            TranslatorPropertiesDefault.initTranslator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return translatorInstance;
        }
    }

    private TranslatorPropertiesDefault() throws ProtocolException {
        try {
            AS4Properties props = AS4Properties.getInstance();
            this.propertyDefault = props.getPropertiesDefault();
            if (this.propertyDefault == null) {
                this.templatePropertyDefault = TemplateUtils.getTemplate((String)"/org/openspcoop2/protocol/as4/pmode", (String)"pmode-propertyDefault.ftl");
            }
            this.payloadPropertySetDefault = props.getPropertiesSetDefault();
            if (this.payloadPropertySetDefault == null) {
                this.templatePropertySetDefault = TemplateUtils.getTemplate((String)"/org/openspcoop2/protocol/as4/pmode", (String)"pmode-propertySetDefault.ftl");
            }
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public String getPropertyDefault(boolean deleteValue) throws ProtocolException {
        try {
            if (deleteValue) {
                List<Property> list = this.getListPropertyDefault();
                StringBuilder bf = new StringBuilder();
                if (list != null && !list.isEmpty()) {
                    for (Property property : list) {
                        bf.append("\t\t\t<property name=\"");
                        bf.append(property.getName());
                        bf.append("\"\n");
                        bf.append("\t\t\t\t\tkey=\"");
                        bf.append(property.getKey());
                        bf.append("\"\n");
                        bf.append("\t\t\t\t\tdatatype=\"");
                        bf.append(property.getDatatype());
                        bf.append("\"\n");
                        bf.append("\t\t\t\t\trequired=\"");
                        bf.append(property.getRequired());
                        bf.append("\"/>\n");
                        bf.append("\n");
                    }
                }
                return bf.toString();
            }
            if (this.propertyDefault == null) {
                HashMap map = new HashMap();
                StringWriter writer = new StringWriter();
                this.templatePropertyDefault.process(map, (Writer)writer);
                return writer.toString();
            }
            return new String(this.propertyDefault);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public List<Property> getListPropertyDefault() throws ProtocolException {
        try {
            String line;
            BufferedReader br = new BufferedReader(new StringReader(this.getPropertyDefault(false)));
            ArrayList<Property> list = new ArrayList<Property>();
            StringBuilder bf = new StringBuilder();
            while ((line = br.readLine()) != null) {
                if (bf.length() > 0) {
                    bf.append("\n");
                }
                bf.append(line);
                if (!line.contains("</property>")) continue;
                String finalString = bf.toString();
                if (finalString != null && !"".equals(finalString)) {
                    String sWithNamespace = finalString.replace("<property>", "<ns:property xmlns:ns=\"" + ProjectInfo.getInstance().getProjectNamespace() + "\">");
                    sWithNamespace = sWithNamespace.replace("<property ", "<ns:property xmlns:ns=\"" + ProjectInfo.getInstance().getProjectNamespace() + "\" ");
                    sWithNamespace = sWithNamespace.replace("</property", "</ns:property");
                    JaxbDeserializer deserializer = new JaxbDeserializer();
                    Property p = deserializer.readProperty(sWithNamespace.getBytes());
                    list.add(p);
                }
                bf = new StringBuilder();
            }
            return list;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public String getPropertySetDefault() throws ProtocolException {
        try {
            if (this.payloadPropertySetDefault == null) {
                HashMap map = new HashMap();
                StringWriter writer = new StringWriter();
                this.templatePropertySetDefault.process(map, (Writer)writer);
                return writer.toString();
            }
            return new String(this.payloadPropertySetDefault);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public List<PropertySet> getListPropertySetDefault() throws ProtocolException {
        try {
            String line;
            BufferedReader br = new BufferedReader(new StringReader(this.getPropertySetDefault()));
            ArrayList<PropertySet> list = new ArrayList<PropertySet>();
            StringBuilder bf = new StringBuilder();
            while ((line = br.readLine()) != null) {
                if (bf.length() > 0) {
                    bf.append("\n");
                }
                bf.append(line);
                if (!line.contains("</propertySet>")) continue;
                String finalString = bf.toString();
                if (finalString != null && !"".equals(finalString)) {
                    String sWithNamespace = finalString.replace("<propertySet>", "<ns:propertySet xmlns:ns=\"" + ProjectInfo.getInstance().getProjectNamespace() + "\">");
                    sWithNamespace = sWithNamespace.replace("<propertySet ", "<ns:propertySet xmlns:ns=\"" + ProjectInfo.getInstance().getProjectNamespace() + "\" ");
                    sWithNamespace = sWithNamespace.replace("</propertySet", "</ns:propertySet");
                    JaxbDeserializer deserializer = new JaxbDeserializer();
                    PropertySet p = deserializer.readPropertySet(sWithNamespace.getBytes());
                    list.add(p);
                }
                bf = new StringBuilder();
            }
            return list;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public String getAsStringPropertiesDefaultAsCompleteXml(boolean deleteValue) throws ProtocolException {
        StringBuilder bf = new StringBuilder();
        bf.append("\t<properties>\n\n");
        bf.append(this.getPropertyDefault(deleteValue));
        bf.append("\n\n");
        bf.append(this.getPropertySetDefault());
        bf.append("\n\n");
        bf.append("\t</properties>");
        return bf.toString();
    }

    public byte[] getPropertiesDefaultAsCompleteXml(boolean deleteValue) throws ProtocolException {
        try {
            return this.getAsStringPropertiesDefaultAsCompleteXml(deleteValue).getBytes();
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }
}

