/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.pmode.beans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.protocol.as4.pmode.TranslatorPayloadProfilesDefault;
import org.openspcoop2.protocol.as4.pmode.beans.Payload;
import org.openspcoop2.protocol.as4.pmode.beans.PayloadProfile;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PayloadProfiles {
    private String payloadDefault;
    private List<Payload> payloads;
    private String payloadProfileDefault;
    private List<PayloadProfile> payloadProfiles;

    public PayloadProfiles(List<byte[]> contents) throws Exception {
        TranslatorPayloadProfilesDefault translator = TranslatorPayloadProfilesDefault.getTranslator();
        this.payloadDefault = translator.getPayloadDefault();
        this.payloadProfileDefault = translator.getPayloadProfileDefault();
        this.payloads = new ArrayList<Payload>();
        this.payloadProfiles = new ArrayList<PayloadProfile>();
        List<eu.domibus.configuration.Payload> listPayloadDefault = translator.getListPayloadDefault();
        List<eu.domibus.configuration.PayloadProfile> listPayloadProfileDefault = translator.getListPayloadProfileDefault();
        HashMap<String, Payload> payloadsMap = new HashMap<String, Payload>();
        HashMap<String, PayloadProfile> payloadProfilesMap = new HashMap<String, PayloadProfile>();
        for (byte[] content : contents) {
            Document doc = MessageXMLUtils.DEFAULT.newDocument(content);
            doc.getDocumentElement().normalize();
            NodeList payloadList = doc.getElementsByTagName("payload");
            for (int temp = 0; temp < payloadList.getLength(); ++temp) {
                Node node = payloadList.item(temp);
                Payload payload = new Payload(node);
                if (listPayloadDefault != null && listPayloadDefault.size() > 0) {
                    for (eu.domibus.configuration.Payload payloadDefault : listPayloadDefault) {
                        if (!payloadDefault.getName().equals(payload.getName())) continue;
                        throw new Exception("Il payload con nome [" + payload.getName() + "] \u00e8 gi\u00e0 presente nella configurazione di default; modificare il nome");
                    }
                }
                if (payloadsMap.containsKey(payload.getName()) && !((Payload)payloadsMap.get(payload.getName())).equals(payload)) {
                    throw new Exception("Payload con nome [" + payload.getName() + "] risulta utilizzato su pi\u00f9 accordi");
                }
                payloadsMap.put(payload.getName(), payload);
            }
            NodeList payloadProfileList = doc.getElementsByTagName("payloadProfile");
            for (int temp = 0; temp < payloadProfileList.getLength(); ++temp) {
                Node node = payloadProfileList.item(temp);
                PayloadProfile payloadProfile = new PayloadProfile(node);
                if (listPayloadProfileDefault != null && listPayloadProfileDefault.size() > 0) {
                    for (eu.domibus.configuration.PayloadProfile payloadProfileDefault : listPayloadProfileDefault) {
                        if (!payloadProfileDefault.getName().equals(payloadProfile.getName())) continue;
                        throw new Exception("Il payload-profile con nome [" + payloadProfile.getName() + "] \u00e8 gi\u00e0 presente nella configurazione di default; modificare il nome");
                    }
                }
                if (payloadProfilesMap.containsKey(payloadProfile.getName()) && !((PayloadProfile)payloadProfilesMap.get(payloadProfile.getName())).equals(payloadProfile)) {
                    throw new Exception("Payload-profile con nome [" + payloadProfile.getName() + "] risulta utilizzato su pi\u00f9 accordi");
                }
                payloadProfilesMap.put(payloadProfile.getName(), payloadProfile);
            }
        }
        this.payloads.addAll(payloadsMap.values());
        this.payloadProfiles.addAll(payloadProfilesMap.values());
    }

    public List<Payload> getPayloads() {
        return this.payloads;
    }

    public void setPayloads(List<Payload> payloads) {
        this.payloads = payloads;
    }

    public List<PayloadProfile> getPayloadProfiles() {
        return this.payloadProfiles;
    }

    public void setPayloadProfiles(List<PayloadProfile> payloadProfiles) {
        this.payloadProfiles = payloadProfiles;
    }

    public String getPayloadDefault() {
        return this.payloadDefault;
    }

    public void setPayloadDefault(String payloadDefault) {
        this.payloadDefault = payloadDefault;
    }

    public String getPayloadProfileDefault() {
        return this.payloadProfileDefault;
    }

    public void setPayloadProfileDefault(String payloadProfileDefault) {
        this.payloadProfileDefault = payloadProfileDefault;
    }
}

