/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.pmode.beans;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.utils.xml.XMLUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertySet {
    private String name;
    private List<String> propertyRef;

    public PropertySet(Node node) throws Exception {
        this.name = node.getAttributes().getNamedItem("name").getNodeValue();
        NodeList pRef = XMLUtils.getInstance().getAsDocument(node).getElementsByTagName("propertyRef");
        this.propertyRef = new ArrayList<String>();
        for (int i = 0; i < pRef.getLength(); ++i) {
            Node item = pRef.item(i);
            Node namedItem = item.getAttributes().getNamedItem("property");
            this.propertyRef.add(namedItem.getNodeValue());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getPropertyRef() {
        return this.propertyRef;
    }

    public void setPropertyRef(List<String> propertyRef) {
        this.propertyRef = propertyRef;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertySet)) {
            return false;
        }
        PropertySet p = (PropertySet)obj;
        if (!this.name.equals(p.getName())) {
            return false;
        }
        if (this.propertyRef.size() != p.getPropertyRef().size()) {
            return false;
        }
        for (String ref : this.propertyRef) {
            if (p.getPropertyRef().contains(ref)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder bf = new StringBuilder();
        if (this.name != null) {
            bf.append("name");
            bf.append(":");
            bf.append(this.name);
        }
        if (this.propertyRef != null) {
            if (bf.length() > 0) {
                bf.append("\n");
            }
            bf.append("propertyRef");
            bf.append(":");
            bf.append(this.propertyRef.size());
        }
        return bf.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

