/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.services;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.threads.RunnableLogger;

public class BaseConnettoreUtils {
    protected RunnableLogger log;

    public BaseConnettoreUtils(RunnableLogger log) {
        this.log = log;
    }

    public void debug(Message mapParam) throws Exception {
        MapMessage map;
        if (mapParam instanceof MapMessage) {
            map = (MapMessage)mapParam;
            Enumeration mapNames = map.getMapNames();
            while (mapNames.hasMoreElements()) {
                Object name = mapNames.nextElement();
                if (name instanceof String) {
                    String key = (String)name;
                    Object value = map.getObjectProperty(key);
                    if (value != null) {
                        this.log.debug("\t-Map[" + key + "](" + value.getClass().getName() + "): " + value);
                        continue;
                    }
                    byte[] bytes = map.getBytes(key);
                    if (bytes != null) {
                        File f = FileSystemUtilities.createTempFile((String)"content", (String)".bin");
                        try (FileOutputStream fos = new FileOutputStream(f);){
                            fos.write(bytes);
                            fos.flush();
                        }
                        this.log.debug("\t-Map[" + key + "] scritto in " + f.getAbsolutePath());
                        continue;
                    }
                    this.log.debug("\t-Map[" + key + "]: " + value);
                    continue;
                }
                this.log.debug("\t-Map con key diverso dal tipo String: " + name);
            }
        } else if (mapParam instanceof TextMessage) {
            map = (TextMessage)mapParam;
            String text = map.getText();
            this.log.debug("Ricevuto text: " + text);
        }
        this.log.debug("Ricevuto msg: " + mapParam.getJMSMessageID());
        this.log.debug("Ricevuto msg: " + mapParam.getClass().getName());
        Enumeration en = mapParam.getPropertyNames();
        while (en.hasMoreElements()) {
            Object name = en.nextElement();
            if (name instanceof String) {
                String key = (String)name;
                Object value = mapParam.getObjectProperty(key);
                if (value != null) {
                    this.log.debug("\t-Property[" + key + "](" + value.getClass().getName() + "): " + value);
                    continue;
                }
                this.log.debug("\t-Property[" + key + "]: " + value);
                continue;
            }
            this.log.debug("\t-Property con key diverso dal tipo String: " + name);
        }
    }

    protected String getPropertyJms(Message map, String property, boolean required) throws Exception {
        Object value = map.getObjectProperty(property);
        if (value == null) {
            if (required) {
                throw new Exception("Property '" + property + "' not found");
            }
            return null;
        }
        if (!(value instanceof String)) {
            throw new Exception("Property '" + property + "' with wrong type (expected:String found:" + value.getClass().getName() + ")");
        }
        return (String)value;
    }

    protected Integer getIntPropertyJms(Message map, String property, boolean required) throws Exception {
        Object value = map.getObjectProperty(property);
        if (value == null) {
            if (required) {
                throw new Exception("Property '" + property + "' not found");
            }
            return null;
        }
        if (!(value instanceof Integer)) {
            throw new Exception("Property '" + property + "' with wrong type (expected:Integer found:" + value.getClass().getName() + ")");
        }
        return (Integer)value;
    }
}

