/*
 * Decompiled with CFR 0.152.
 */
package it.cnipa.collprofiles.utils.serializer;

import it.cnipa.collprofiles.EgovDecllElement;
import it.cnipa.collprofiles.OperationListType;
import it.cnipa.collprofiles.OperationType;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import javax.xml.bind.JAXBElement;
import org.openspcoop2.generic_project.exception.SerializerException;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.xml.JaxbUtils;

public abstract class AbstractSerializer {
    protected abstract WriteToSerializerType getType();

    protected void _objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws Exception {
        if (object instanceof JAXBElement) {
            JaxbUtils.objToXml((OutputStream)out, c, (Object)object, (boolean)prettyPrint);
        } else {
            Method m = c.getMethod("writeTo", OutputStream.class, WriteToSerializerType.class);
            m.invoke(object, out, this.getType());
        }
    }

    protected void objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this._objToXml(out, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                out.flush();
            }
            catch (Exception exception) {}
        }
    }

    protected void objToXml(String fileName, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this.objToXml(new File(fileName), c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
    }

    protected void objToXml(File file, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            this._objToXml(fout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected ByteArrayOutputStream objToXml(Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            this._objToXml(bout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (bout != null) {
                    bout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Exception exception) {}
        }
        return bout;
    }

    public void write(String fileName, OperationType operationType) throws SerializerException {
        this.objToXml(fileName, OperationType.class, (Object)operationType, false);
    }

    public void write(String fileName, OperationType operationType, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, OperationType.class, (Object)operationType, prettyPrint);
    }

    public void write(File file, OperationType operationType) throws SerializerException {
        this.objToXml(file, OperationType.class, (Object)operationType, false);
    }

    public void write(File file, OperationType operationType, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, OperationType.class, (Object)operationType, prettyPrint);
    }

    public void write(OutputStream out, OperationType operationType) throws SerializerException {
        this.objToXml(out, OperationType.class, (Object)operationType, false);
    }

    public void write(OutputStream out, OperationType operationType, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, OperationType.class, (Object)operationType, prettyPrint);
    }

    public byte[] toByteArray(OperationType operationType) throws SerializerException {
        return this.objToXml(OperationType.class, operationType, false).toByteArray();
    }

    public byte[] toByteArray(OperationType operationType, boolean prettyPrint) throws SerializerException {
        return this.objToXml(OperationType.class, operationType, prettyPrint).toByteArray();
    }

    public String toString(OperationType operationType) throws SerializerException {
        return this.objToXml(OperationType.class, operationType, false).toString();
    }

    public String toString(OperationType operationType, boolean prettyPrint) throws SerializerException {
        return this.objToXml(OperationType.class, operationType, prettyPrint).toString();
    }

    public void write(String fileName, OperationListType operationListType) throws SerializerException {
        this.objToXml(fileName, OperationListType.class, (Object)operationListType, false);
    }

    public void write(String fileName, OperationListType operationListType, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, OperationListType.class, (Object)operationListType, prettyPrint);
    }

    public void write(File file, OperationListType operationListType) throws SerializerException {
        this.objToXml(file, OperationListType.class, (Object)operationListType, false);
    }

    public void write(File file, OperationListType operationListType, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, OperationListType.class, (Object)operationListType, prettyPrint);
    }

    public void write(OutputStream out, OperationListType operationListType) throws SerializerException {
        this.objToXml(out, OperationListType.class, (Object)operationListType, false);
    }

    public void write(OutputStream out, OperationListType operationListType, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, OperationListType.class, (Object)operationListType, prettyPrint);
    }

    public byte[] toByteArray(OperationListType operationListType) throws SerializerException {
        return this.objToXml(OperationListType.class, operationListType, false).toByteArray();
    }

    public byte[] toByteArray(OperationListType operationListType, boolean prettyPrint) throws SerializerException {
        return this.objToXml(OperationListType.class, operationListType, prettyPrint).toByteArray();
    }

    public String toString(OperationListType operationListType) throws SerializerException {
        return this.objToXml(OperationListType.class, operationListType, false).toString();
    }

    public String toString(OperationListType operationListType, boolean prettyPrint) throws SerializerException {
        return this.objToXml(OperationListType.class, operationListType, prettyPrint).toString();
    }

    public void write(String fileName, EgovDecllElement egovDecllElement) throws SerializerException {
        this.objToXml(fileName, EgovDecllElement.class, (Object)egovDecllElement, false);
    }

    public void write(String fileName, EgovDecllElement egovDecllElement, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, EgovDecllElement.class, (Object)egovDecllElement, prettyPrint);
    }

    public void write(File file, EgovDecllElement egovDecllElement) throws SerializerException {
        this.objToXml(file, EgovDecllElement.class, (Object)egovDecllElement, false);
    }

    public void write(File file, EgovDecllElement egovDecllElement, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, EgovDecllElement.class, (Object)egovDecllElement, prettyPrint);
    }

    public void write(OutputStream out, EgovDecllElement egovDecllElement) throws SerializerException {
        this.objToXml(out, EgovDecllElement.class, (Object)egovDecllElement, false);
    }

    public void write(OutputStream out, EgovDecllElement egovDecllElement, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, EgovDecllElement.class, (Object)egovDecllElement, prettyPrint);
    }

    public byte[] toByteArray(EgovDecllElement egovDecllElement) throws SerializerException {
        return this.objToXml(EgovDecllElement.class, egovDecllElement, false).toByteArray();
    }

    public byte[] toByteArray(EgovDecllElement egovDecllElement, boolean prettyPrint) throws SerializerException {
        return this.objToXml(EgovDecllElement.class, egovDecllElement, prettyPrint).toByteArray();
    }

    public String toString(EgovDecllElement egovDecllElement) throws SerializerException {
        return this.objToXml(EgovDecllElement.class, egovDecllElement, false).toString();
    }

    public String toString(EgovDecllElement egovDecllElement, boolean prettyPrint) throws SerializerException {
        return this.objToXml(EgovDecllElement.class, egovDecllElement, prettyPrint).toString();
    }
}

