/*
 * Decompiled with CFR 0.152.
 */
package it.gov.spcoop.sica.dao.driver;

import it.gov.spcoop.sica.dao.AccordoCooperazione;
import it.gov.spcoop.sica.dao.AccordoServizioComposto;
import it.gov.spcoop.sica.dao.AccordoServizioParteComune;
import it.gov.spcoop.sica.dao.AccordoServizioParteSpecifica;
import it.gov.spcoop.sica.dao.Documento;
import it.gov.spcoop.sica.firma.Firma;
import it.gov.spcoop.sica.manifest.AccordoServizio;
import it.gov.spcoop.sica.manifest.ServizioComposto;
import it.gov.spcoop.sica.manifest.SpecificaConversazione;
import it.gov.spcoop.sica.manifest.SpecificaInterfaccia;
import it.gov.spcoop.sica.manifest.SpecificaPortiAccesso;
import it.gov.spcoop.sica.manifest.driver.XMLUtilsException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.activation.FileDataSource;
import org.openspcoop2.protocol.spcoop.sica.SICAtoOpenSPCoopContext;
import org.openspcoop2.utils.io.ZipUtilities;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.slf4j.Logger;

public class XMLUtils {
    private SICAtoOpenSPCoopContext sicaToOpenSPCoopContext = null;
    private Logger log = null;

    public XMLUtils(SICAtoOpenSPCoopContext sContext, Logger log) {
        this.sicaToOpenSPCoopContext = sContext;
        this.log = log;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccordoServizioParteComune getAccordoServizioParteComune(byte[] zip) throws XMLUtilsException {
        File tmp = null;
        FileOutputStream fout = null;
        try {
            tmp = FileSystemUtilities.createTempFile((String)"sica", (String)"apc");
            fout = new FileOutputStream(tmp);
            fout.write(zip);
            fout.flush();
            fout.close();
            AccordoServizioParteComune accordoServizioParteComune = this.getAccordoServizioParteComune(tmp);
            return accordoServizioParteComune;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (tmp != null && tmp.delete()) {
                    // empty if block
                }
            }
            catch (Exception exception) {}
        }
    }

    public AccordoServizioParteComune getAccordoServizioParteComune(String fileName) throws XMLUtilsException {
        return this.getAccordoServizioParteComune(new File(fileName));
    }

    public AccordoServizioParteComune getAccordoServizioParteComune(File zip) throws XMLUtilsException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zip);
            AccordoServizioParteComune accordoServizioParteComune = this.getAccordoServizioParteComune(zipFile);
            return accordoServizioParteComune;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public AccordoServizioParteComune getAccordoServizioParteComune(InputStream m) throws XMLUtilsException {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            byte[] read = new byte[1024];
            int letti = 0;
            while ((letti = m.read(read)) >= 0) {
                bout.write(read, 0, letti);
            }
            bout.flush();
            bout.close();
            m.close();
            AccordoServizioParteComune accordoServizioParteComune = this.getAccordoServizioParteComune(bout.toByteArray());
            return accordoServizioParteComune;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public AccordoServizioParteComune getAccordoServizioParteComune(ZipFile zip) throws XMLUtilsException {
        try {
            AccordoServizioParteComune archivio = new AccordoServizioParteComune();
            String rootDir = null;
            it.gov.spcoop.sica.manifest.AccordoServizioParteComune parteComune = null;
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry zipEntry = e.nextElement();
                String entryName = ZipUtilities.operativeSystemConversion((String)zipEntry.getName());
                if (rootDir == null) {
                    rootDir = ZipUtilities.getRootDir((String)entryName);
                }
                if (zipEntry.isDirectory()) continue;
                FileDataSource fds = new FileDataSource(entryName);
                String nome = fds.getName();
                String tipo = nome.substring(nome.lastIndexOf(".") + 1, nome.length());
                tipo = tipo.toUpperCase();
                if (!(rootDir + "manifesto.xml").equals(entryName)) continue;
                InputStream inputStream = zip.getInputStream(zipEntry);
                AccordoServizio manifesto = it.gov.spcoop.sica.manifest.driver.XMLUtils.getManifestoAS(this.log, inputStream);
                parteComune = manifesto.getParteComune();
                if (parteComune == null) {
                    throw new Exception("Manifest Parte Comune non presente");
                }
                inputStream.close();
                archivio.setManifesto(manifesto);
                break;
            }
            if (parteComune == null) {
                throw new Exception("Manifest Parte Comune non presente");
            }
            String interfacciaConcettuale = "InterfacciaConcettuale.wsdl";
            String interfaccialogicoErogatore = "InterfacciaLogicaErogatore.wsdl";
            String interfaccialogicoFruitore = "InterfacciaLogicaFruitore.wsdl";
            String conversazioneConcettuale = "ConversazioneConcettuale.wsbl";
            String conversazionelogicoErogatore = "ConversazioneLogicaLatoErogatore.wsbl";
            String conversazionelogicoFruitore = "ConversazioneLogicaLatoFruitore.wsbl";
            if (parteComune.getSpecificaInterfaccia() != null) {
                SpecificaInterfaccia interfaccia = parteComune.getSpecificaInterfaccia();
                if (interfaccia.getInterfacciaConcettuale() != null) {
                    interfacciaConcettuale = ZipUtilities.getBaseName((String)interfaccia.getInterfacciaConcettuale().getBase());
                }
                if (interfaccia.getInterfacciaLogicaLatoErogatore() != null) {
                    interfaccialogicoErogatore = ZipUtilities.getBaseName((String)interfaccia.getInterfacciaLogicaLatoErogatore().getBase());
                }
                if (interfaccia.getInterfacciaLogicaLatoFruitore() != null) {
                    interfaccialogicoFruitore = ZipUtilities.getBaseName((String)interfaccia.getInterfacciaLogicaLatoFruitore().getBase());
                }
            }
            if (parteComune.getSpecificaConversazione() != null) {
                SpecificaConversazione conversazione = parteComune.getSpecificaConversazione();
                if (conversazione.getConversazioneConcettuale() != null) {
                    conversazioneConcettuale = ZipUtilities.getBaseName((String)conversazione.getConversazioneConcettuale().getBase());
                }
                if (conversazione.getConversazioneLogicaLatoErogatore() != null) {
                    conversazionelogicoErogatore = ZipUtilities.getBaseName((String)conversazione.getConversazioneLogicaLatoErogatore().getBase());
                }
                if (conversazione.getConversazioneLogicaLatoFruitore() != null) {
                    conversazionelogicoFruitore = ZipUtilities.getBaseName((String)conversazione.getConversazioneLogicaLatoFruitore().getBase());
                }
            }
            e = zip.entries();
            while (e.hasMoreElements()) {
                String dir;
                Documento d;
                InputStream inputStream;
                ZipEntry zipEntry = e.nextElement();
                String entryName = ZipUtilities.operativeSystemConversion((String)zipEntry.getName());
                if (rootDir == null) {
                    rootDir = ZipUtilities.getRootDir((String)entryName);
                }
                if (zipEntry.isDirectory()) continue;
                FileDataSource fds = new FileDataSource(entryName);
                String nome = fds.getName();
                String tipo = nome.substring(nome.lastIndexOf(".") + 1, nome.length());
                tipo = tipo.toUpperCase();
                if ((rootDir + ".project").equals(entryName)) continue;
                if ((rootDir + "firma.xml").equals(entryName)) {
                    Firma firma = new Firma();
                    archivio.setFirma(firma);
                    continue;
                }
                if ((rootDir + "manifesto.xml").equals(entryName)) continue;
                if (entryName.startsWith(rootDir + "specificaConversazione")) {
                    inputStream = zip.getInputStream(zipEntry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    dir = rootDir + "specificaConversazione" + File.separatorChar;
                    if ((dir + conversazioneConcettuale).equals(entryName)) {
                        archivio.setConversazioneConcettuale(d);
                        continue;
                    }
                    if ((dir + conversazionelogicoErogatore).equals(entryName)) {
                        archivio.setConversazioneLogicaErogatore(d);
                        continue;
                    }
                    if (!(dir + conversazionelogicoFruitore).equals(entryName)) continue;
                    archivio.setConversazioneLogicaFruitore(d);
                    continue;
                }
                if (entryName.startsWith(rootDir + "specificaInterfaccia")) {
                    inputStream = zip.getInputStream(zipEntry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    dir = rootDir + "specificaInterfaccia" + File.separatorChar;
                    if ((dir + interfacciaConcettuale).equals(entryName)) {
                        archivio.setInterfacciaConcettuale(d);
                        continue;
                    }
                    if ((dir + interfaccialogicoErogatore).equals(entryName)) {
                        archivio.setInterfacciaLogicaLatoErogatore(d);
                        continue;
                    }
                    if (!(dir + interfaccialogicoFruitore).equals(entryName)) continue;
                    archivio.setInterfacciaLogicaLatoFruitore(d);
                    continue;
                }
                if (entryName.startsWith(rootDir + "allegati")) {
                    inputStream = zip.getInputStream(zipEntry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    archivio.addAllegato(d);
                    if (it.cnipa.collprofiles.driver.XMLUtils.isProfiloCollaborazioneEGOV(d.getContenuto())) {
                        it.cnipa.collprofiles.driver.XMLUtils.getDichiarazioneEGov(this.log, d.getContenuto(), this.sicaToOpenSPCoopContext.isInformazioniEGov_wscpDisabled_childUnqualified());
                        continue;
                    }
                    if (!it.gov.spcoop.sica.wscp.driver.XMLUtils.isProfiloCollaborazioneEGOV(d.getContenuto())) continue;
                    it.gov.spcoop.sica.wscp.driver.XMLUtils.getDichiarazioneEGov(this.log, d.getContenuto(), this.sicaToOpenSPCoopContext.isInformazioniEGov_wscpEnabled_childUnqualified());
                    continue;
                }
                if (!entryName.startsWith(rootDir + "specificaSemiformale")) continue;
                inputStream = zip.getInputStream(zipEntry);
                d = new Documento(nome, tipo, inputStream);
                inputStream.close();
                archivio.addSpecificaSemiformale(d);
                if (it.cnipa.collprofiles.driver.XMLUtils.isProfiloCollaborazioneEGOV(d.getContenuto())) {
                    it.cnipa.collprofiles.driver.XMLUtils.getDichiarazioneEGov(this.log, d.getContenuto(), this.sicaToOpenSPCoopContext.isInformazioniEGov_wscpDisabled_childUnqualified());
                    continue;
                }
                if (!it.gov.spcoop.sica.wscp.driver.XMLUtils.isProfiloCollaborazioneEGOV(d.getContenuto())) continue;
                it.gov.spcoop.sica.wscp.driver.XMLUtils.getDichiarazioneEGov(this.log, d.getContenuto(), this.sicaToOpenSPCoopContext.isInformazioniEGov_wscpEnabled_childUnqualified());
            }
            if (archivio.getManifesto() == null) {
                throw new Exception("Manifesto non presente");
            }
            if (archivio.getManifesto().getSpecificaSemiformale() != null) {
                for (int i = 0; i < archivio.getManifesto().getSpecificaSemiformale().sizeDocumentoSemiformaleList(); ++i) {
                    String fileName = archivio.getManifesto().getSpecificaSemiformale().getDocumentoSemiformale(i).getBase();
                    String tipo = archivio.getManifesto().getSpecificaSemiformale().getDocumentoSemiformale(i).getTipo();
                    for (int j = 0; j < archivio.sizeSpecificheSemiformali(); ++j) {
                        if (!fileName.equals(archivio.getSpecificaSemiformale(j).getNome())) continue;
                        archivio.getSpecificaSemiformale(j).setTipo(tipo);
                    }
                }
            }
            return archivio;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public void generateAccordoServizioParteComune(AccordoServizioParteComune manifesto, File file) throws XMLUtilsException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            this.generateAccordoServizioParteComune(manifesto, fout);
            fout.flush();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void generateAccordoServizioParteComune(AccordoServizioParteComune manifesto, String fileName) throws XMLUtilsException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(fileName);
            this.generateAccordoServizioParteComune(manifesto, fout);
            fout.flush();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public byte[] generateAccordoServizioParteComune(AccordoServizioParteComune manifesto) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.generateAccordoServizioParteComune(manifesto, bout);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public void generateAccordoServizioParteComune(AccordoServizioParteComune manifesto, OutputStream out) throws XMLUtilsException {
        boolean generaSICAClientProjectFile = this.sicaToOpenSPCoopContext.isSICAClient_generaProject();
        boolean includiInfoRegistroGenerale = this.sicaToOpenSPCoopContext.isSICAClient_includiInfoRegistroGenerale();
        boolean lunghezzaNomeAccordoLimitata = this.sicaToOpenSPCoopContext.isSICAClient_nomeAccordo_32CaratteriMax();
        ZipOutputStream zipOut = null;
        try {
            zipOut = new ZipOutputStream(out);
            Object rootDir = "";
            rootDir = manifesto.getManifesto().getNome() + File.separatorChar;
            if (generaSICAClientProjectFile) {
                String nomeProgettoEclipse = manifesto.getManifesto().getNome() + "_apc";
                String projectContenuto = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n        <name>@NOME@</name>\n        <comment>Package generato tramite OpenSPCoop v2 (www.openspcoop2.org)</comment>\n        <projects>\n        </projects>\n        <buildSpec>\n                <buildCommand>\n                        <name>com.ibm.rst.sica.workbench.agreementValidator</name>\n                        <arguments>\n                        </arguments>\n                </buildCommand>\n        </buildSpec>\n        <natures>\n                <nature>com.ibm.rst.sica.workbench.natures.commonPart</nature>\n                <nature>com.ibm.rst.sica.workbench.natures.agreementProject</nature>\n        </natures>\n</projectDescription>".replace("@NOME@", nomeProgettoEclipse);
                zipOut.putNextEntry(new ZipEntry((String)rootDir + ".project"));
                zipOut.write(projectContenuto.getBytes());
            }
            if (manifesto.getFirma() != null) {
                byte[] firma = manifesto.getFirma().getBytes();
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "firma.xml"));
                zipOut.write(firma);
            }
            byte[] manifestoBytes = it.gov.spcoop.sica.manifest.driver.XMLUtils.generateManifestoAS(manifesto.getManifesto(), includiInfoRegistroGenerale, lunghezzaNomeAccordoLimitata);
            zipOut.putNextEntry(new ZipEntry((String)rootDir + "manifesto.xml"));
            zipOut.write(manifestoBytes);
            boolean specificaInterfaccia = false;
            if (manifesto.getInterfacciaConcettuale() != null) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaInterfaccia" + File.separatorChar + "InterfacciaConcettuale.wsdl"));
                zipOut.write(manifesto.getInterfacciaConcettuale().getContenuto());
                specificaInterfaccia = true;
            }
            if (manifesto.getInterfacciaLogicaLatoErogatore() != null) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaInterfaccia" + File.separatorChar + "InterfacciaLogicaErogatore.wsdl"));
                zipOut.write(manifesto.getInterfacciaLogicaLatoErogatore().getContenuto());
                specificaInterfaccia = true;
            }
            if (manifesto.getInterfacciaLogicaLatoFruitore() != null) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaInterfaccia" + File.separatorChar + "InterfacciaLogicaFruitore.wsdl"));
                zipOut.write(manifesto.getInterfacciaLogicaLatoFruitore().getContenuto());
                specificaInterfaccia = true;
            }
            if (!specificaInterfaccia) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaInterfaccia" + File.separatorChar));
            }
            boolean specificaConversazione = false;
            if (manifesto.getConversazioneConcettuale() != null) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaConversazione" + File.separatorChar + "ConversazioneConcettuale.wsbl"));
                zipOut.write(manifesto.getConversazioneConcettuale().getContenuto());
                specificaConversazione = true;
            }
            if (manifesto.getConversazioneLogicaErogatore() != null) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaConversazione" + File.separatorChar + "ConversazioneLogicaLatoErogatore.wsbl"));
                zipOut.write(manifesto.getConversazioneLogicaErogatore().getContenuto());
                specificaConversazione = true;
            }
            if (manifesto.getConversazioneLogicaFruitore() != null) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaConversazione" + File.separatorChar + "ConversazioneLogicaLatoFruitore.wsbl"));
                zipOut.write(manifesto.getConversazioneLogicaFruitore().getContenuto());
                specificaConversazione = true;
            }
            if (!specificaConversazione) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaConversazione" + File.separatorChar));
            }
            boolean allegati = manifesto.sizeAllegati() > 0;
            for (int i = 0; i < manifesto.sizeAllegati(); ++i) {
                Documento allegato = manifesto.getAllegato(i);
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "allegati" + File.separatorChar + allegato.getNome()));
                zipOut.write(allegato.getContenuto());
            }
            if (!allegati) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "allegati" + File.separatorChar));
            }
            boolean specificheSemiformali = manifesto.sizeSpecificheSemiformali() > 0;
            for (int i = 0; i < manifesto.sizeSpecificheSemiformali(); ++i) {
                Documento doc = manifesto.getSpecificaSemiformale(i);
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaSemiformale" + File.separatorChar + doc.getNome()));
                zipOut.write(doc.getContenuto());
            }
            if (!specificheSemiformali) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaSemiformale" + File.separatorChar));
            }
            zipOut.flush();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (zipOut != null) {
                    zipOut.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(byte[] zip) throws XMLUtilsException {
        File tmp = null;
        FileOutputStream fout = null;
        try {
            tmp = FileSystemUtilities.createTempFile((String)"sica", (String)"aps");
            fout = new FileOutputStream(tmp);
            fout.write(zip);
            fout.flush();
            fout.close();
            AccordoServizioParteSpecifica accordoServizioParteSpecifica = this.getAccordoServizioParteSpecifica(tmp);
            return accordoServizioParteSpecifica;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (tmp != null && tmp.delete()) {
                    // empty if block
                }
            }
            catch (Exception exception) {}
        }
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(String fileName) throws XMLUtilsException {
        return this.getAccordoServizioParteSpecifica(new File(fileName));
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(File zip) throws XMLUtilsException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zip);
            AccordoServizioParteSpecifica accordoServizioParteSpecifica = this.getAccordoServizioParteSpecifica(zipFile);
            return accordoServizioParteSpecifica;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(InputStream m) throws XMLUtilsException {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            byte[] read = new byte[1024];
            int letti = 0;
            while ((letti = m.read(read)) >= 0) {
                bout.write(read, 0, letti);
            }
            bout.flush();
            bout.close();
            m.close();
            AccordoServizioParteSpecifica accordoServizioParteSpecifica = this.getAccordoServizioParteSpecifica(bout.toByteArray());
            return accordoServizioParteSpecifica;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(ZipFile zip) throws XMLUtilsException {
        try {
            String fileName;
            String tipo;
            AccordoServizioParteSpecifica archivio = new AccordoServizioParteSpecifica();
            String rootDir = null;
            it.gov.spcoop.sica.manifest.AccordoServizioParteSpecifica parteSpecifica = null;
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry zipEntry = e.nextElement();
                String entryName = ZipUtilities.operativeSystemConversion((String)zipEntry.getName());
                if (rootDir == null) {
                    rootDir = ZipUtilities.getRootDir((String)entryName);
                }
                if (zipEntry.isDirectory()) continue;
                FileDataSource fds = new FileDataSource(entryName);
                String nome = fds.getName();
                tipo = nome.substring(nome.lastIndexOf(".") + 1, nome.length());
                tipo = tipo.toUpperCase();
                if (!(rootDir + "manifesto.xml").equals(entryName)) continue;
                InputStream inputStream = zip.getInputStream(zipEntry);
                AccordoServizio manifesto = it.gov.spcoop.sica.manifest.driver.XMLUtils.getManifestoAS(this.log, inputStream);
                parteSpecifica = manifesto.getParteSpecifica();
                if (parteSpecifica == null) {
                    throw new Exception("Manifest Parte Specifica non presente");
                }
                inputStream.close();
                archivio.setManifesto(manifesto);
                break;
            }
            if (parteSpecifica == null) {
                throw new Exception("Manifest Parte Specifica non presente");
            }
            String interfacciaPortiAccessoErogatore = "PortiAccessoErogatore.wsdl";
            String interfacciaPortiAccessoFruitore = "PortiAccessoFruitore.wsdl";
            if (parteSpecifica.getSpecificaPortiAccesso() != null) {
                SpecificaPortiAccesso portiAccesso = parteSpecifica.getSpecificaPortiAccesso();
                if (portiAccesso.getPortiAccessoErogatore() != null) {
                    interfacciaPortiAccessoErogatore = ZipUtilities.getBaseName((String)portiAccesso.getPortiAccessoErogatore().getBase());
                }
                if (portiAccesso.getPortiAccessoFruitore() != null) {
                    interfacciaPortiAccessoFruitore = ZipUtilities.getBaseName((String)portiAccesso.getPortiAccessoFruitore().getBase());
                }
            }
            e = zip.entries();
            while (e.hasMoreElements()) {
                Documento d;
                InputStream inputStream;
                ZipEntry zipEntry = e.nextElement();
                String entryName = ZipUtilities.operativeSystemConversion((String)zipEntry.getName());
                if (rootDir == null) {
                    rootDir = ZipUtilities.getRootDir((String)entryName);
                }
                if (zipEntry.isDirectory()) continue;
                FileDataSource fds = new FileDataSource(entryName);
                String nome = fds.getName();
                String tipo2 = nome.substring(nome.lastIndexOf(".") + 1, nome.length());
                tipo2 = tipo2.toUpperCase();
                if ((rootDir + ".project").equals(entryName)) continue;
                if ((rootDir + "firma.xml").equals(entryName)) {
                    Firma firma = new Firma();
                    archivio.setFirma(firma);
                    continue;
                }
                if ((rootDir + "manifesto.xml").equals(entryName)) continue;
                if (entryName.startsWith(rootDir + "specificaPortiAccesso")) {
                    inputStream = zip.getInputStream(zipEntry);
                    d = new Documento(nome, tipo2, inputStream);
                    inputStream.close();
                    String dir = rootDir + "specificaPortiAccesso" + File.separatorChar;
                    if ((dir + interfacciaPortiAccessoErogatore).equals(entryName)) {
                        archivio.setPortiAccessoErogatore(d);
                        continue;
                    }
                    if (!(dir + interfacciaPortiAccessoFruitore).equals(entryName)) continue;
                    archivio.setPortiAccessoFruitore(d);
                    continue;
                }
                if (entryName.startsWith(rootDir + "allegati")) {
                    inputStream = zip.getInputStream(zipEntry);
                    d = new Documento(nome, tipo2, inputStream);
                    inputStream.close();
                    archivio.addAllegato(d);
                    continue;
                }
                if (entryName.startsWith(rootDir + "specificaSemiformale")) {
                    inputStream = zip.getInputStream(zipEntry);
                    d = new Documento(nome, tipo2, inputStream);
                    inputStream.close();
                    archivio.addSpecificaSemiformale(d);
                    continue;
                }
                if (entryName.startsWith(rootDir + "specificaLivelliServizio")) {
                    inputStream = zip.getInputStream(zipEntry);
                    d = new Documento(nome, tipo2, inputStream);
                    inputStream.close();
                    archivio.addSpecificaLivelloServizio(d);
                    continue;
                }
                if (!entryName.startsWith(rootDir + "specificaSicurezza")) continue;
                inputStream = zip.getInputStream(zipEntry);
                d = new Documento(nome, tipo2, inputStream);
                inputStream.close();
                archivio.addSpecificaSicurezza(d);
            }
            if (archivio.getManifesto() == null) {
                throw new Exception("Manifesto non presente");
            }
            if (archivio.getManifesto().getSpecificaSemiformale() != null) {
                for (int i = 0; i < archivio.getManifesto().getSpecificaSemiformale().sizeDocumentoSemiformaleList(); ++i) {
                    fileName = archivio.getManifesto().getSpecificaSemiformale().getDocumentoSemiformale(i).getBase();
                    tipo = archivio.getManifesto().getSpecificaSemiformale().getDocumentoSemiformale(i).getTipo();
                    for (int j = 0; j < archivio.sizeSpecificheSemiformali(); ++j) {
                        if (!fileName.equals(archivio.getSpecificaSemiformale(j).getNome())) continue;
                        archivio.getSpecificaSemiformale(j).setTipo(tipo);
                    }
                }
            }
            if (archivio.getManifesto().getParteSpecifica().getSpecificaLivelliServizio() != null) {
                for (int i = 0; i < archivio.getManifesto().getParteSpecifica().getSpecificaLivelliServizio().sizeDocumentoLivelloServizioList(); ++i) {
                    fileName = archivio.getManifesto().getParteSpecifica().getSpecificaLivelliServizio().getDocumentoLivelloServizio(i).getBase();
                    tipo = archivio.getManifesto().getParteSpecifica().getSpecificaLivelliServizio().getDocumentoLivelloServizio(i).getTipo();
                    for (int j = 0; j < archivio.sizeSpecificheLivelliServizio(); ++j) {
                        if (!fileName.equals(archivio.getSpecificaLivelloServizio(j).getNome())) continue;
                        archivio.getSpecificaLivelloServizio(j).setTipo(tipo);
                    }
                }
            }
            if (archivio.getManifesto().getParteSpecifica().getSpecificaSicurezza() != null) {
                for (int i = 0; i < archivio.getManifesto().getParteSpecifica().getSpecificaSicurezza().sizeDocumentoSicurezzaList(); ++i) {
                    fileName = archivio.getManifesto().getParteSpecifica().getSpecificaSicurezza().getDocumentoSicurezza(i).getBase();
                    tipo = archivio.getManifesto().getParteSpecifica().getSpecificaSicurezza().getDocumentoSicurezza(i).getTipo();
                    for (int j = 0; j < archivio.sizeSpecificheSicurezza(); ++j) {
                        if (!fileName.equals(archivio.getSpecificaSicurezza(j).getNome())) continue;
                        archivio.getSpecificaSicurezza(j).setTipo(tipo);
                    }
                }
            }
            return archivio;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public void generateAccordoServizioParteSpecifica(AccordoServizioParteSpecifica manifesto, File file) throws XMLUtilsException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            this.generateAccordoServizioParteSpecifica(manifesto, fout);
            fout.flush();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void generateAccordoServizioParteSpecifica(AccordoServizioParteSpecifica manifesto, String fileName) throws XMLUtilsException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(fileName);
            this.generateAccordoServizioParteSpecifica(manifesto, fout);
            fout.flush();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public byte[] generateAccordoServizioParteSpecifica(AccordoServizioParteSpecifica manifesto) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.generateAccordoServizioParteSpecifica(manifesto, bout);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public void generateAccordoServizioParteSpecifica(AccordoServizioParteSpecifica manifesto, OutputStream out) throws XMLUtilsException {
        boolean generaSICAClientProjectFile = this.sicaToOpenSPCoopContext.isSICAClient_generaProject();
        boolean includiInfoRegistroGenerale = this.sicaToOpenSPCoopContext.isSICAClient_includiInfoRegistroGenerale();
        boolean lunghezzaNomeAccordoLimitata = this.sicaToOpenSPCoopContext.isSICAClient_nomeAccordo_32CaratteriMax();
        ZipOutputStream zipOut = null;
        try {
            zipOut = new ZipOutputStream(out);
            Object rootDir = "";
            rootDir = manifesto.getManifesto().getNome() + File.separatorChar;
            if (generaSICAClientProjectFile) {
                String nomeProgettoEclipse = manifesto.getManifesto().getNome() + "_aps";
                String projectContenuto = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n        <name>@NOME@</name>\n        <comment>Package generato tramite OpenSPCoop v2 (www.openspcoop2.org)</comment>\n        <projects>\n        </projects>\n        <buildSpec>\n                <buildCommand>\n                        <name>com.ibm.rst.sica.workbench.agreementValidator</name>\n                        <arguments>\n                        </arguments>\n                </buildCommand>\n        </buildSpec>\n        <natures>\n                <nature>com.ibm.rst.sica.workbench.natures.commonPart</nature>\n                <nature>com.ibm.rst.sica.workbench.natures.agreementProject</nature>\n        </natures>\n</projectDescription>".replace("@NOME@", nomeProgettoEclipse);
                zipOut.putNextEntry(new ZipEntry((String)rootDir + ".project"));
                zipOut.write(projectContenuto.getBytes());
            }
            if (manifesto.getFirma() != null) {
                byte[] firma = manifesto.getFirma().getBytes();
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "firma.xml"));
                zipOut.write(firma);
            }
            byte[] manifestoBytes = it.gov.spcoop.sica.manifest.driver.XMLUtils.generateManifestoAS(manifesto.getManifesto(), includiInfoRegistroGenerale, lunghezzaNomeAccordoLimitata);
            zipOut.putNextEntry(new ZipEntry((String)rootDir + "manifesto.xml"));
            zipOut.write(manifestoBytes);
            boolean specificaPortiAccesso = false;
            if (manifesto.getPortiAccessoErogatore() != null) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaPortiAccesso" + File.separatorChar + "PortiAccessoErogatore.wsdl"));
                zipOut.write(manifesto.getPortiAccessoErogatore().getContenuto());
                specificaPortiAccesso = true;
            }
            if (manifesto.getPortiAccessoFruitore() != null) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaPortiAccesso" + File.separatorChar + "PortiAccessoFruitore.wsdl"));
                zipOut.write(manifesto.getPortiAccessoFruitore().getContenuto());
                specificaPortiAccesso = true;
            }
            if (!specificaPortiAccesso) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaPortiAccesso" + File.separatorChar));
            }
            boolean allegati = manifesto.sizeAllegati() > 0;
            for (int i = 0; i < manifesto.sizeAllegati(); ++i) {
                Documento allegato = manifesto.getAllegato(i);
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "allegati" + File.separatorChar + allegato.getNome()));
                zipOut.write(allegato.getContenuto());
            }
            if (!allegati) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "allegati" + File.separatorChar));
            }
            boolean specificheLivelliServizio = manifesto.sizeSpecificheLivelliServizio() > 0;
            for (int i = 0; i < manifesto.sizeSpecificheLivelliServizio(); ++i) {
                Documento doc = manifesto.getSpecificaLivelloServizio(i);
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaLivelliServizio" + File.separatorChar + doc.getNome()));
                zipOut.write(doc.getContenuto());
            }
            if (!specificheLivelliServizio) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaLivelliServizio" + File.separatorChar));
            }
            boolean specificheSemiformali = manifesto.sizeSpecificheSemiformali() > 0;
            for (int i = 0; i < manifesto.sizeSpecificheSemiformali(); ++i) {
                Documento doc = manifesto.getSpecificaSemiformale(i);
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaSemiformale" + File.separatorChar + doc.getNome()));
                zipOut.write(doc.getContenuto());
            }
            if (!specificheSemiformali) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaSemiformale" + File.separatorChar));
            }
            boolean specificheSicurezza = manifesto.sizeSpecificheSicurezza() > 0;
            for (int i = 0; i < manifesto.sizeSpecificheSicurezza(); ++i) {
                Documento doc = manifesto.getSpecificaSicurezza(i);
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaSicurezza" + File.separatorChar + doc.getNome()));
                zipOut.write(doc.getContenuto());
            }
            if (!specificheSicurezza) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaSicurezza" + File.separatorChar));
            }
            zipOut.flush();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (zipOut != null) {
                    zipOut.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccordoCooperazione getAccordoCooperazione(byte[] zip) throws XMLUtilsException {
        File tmp = null;
        FileOutputStream fout = null;
        try {
            tmp = FileSystemUtilities.createTempFile((String)"sica", (String)"adc");
            fout = new FileOutputStream(tmp);
            fout.write(zip);
            fout.flush();
            fout.close();
            AccordoCooperazione accordoCooperazione = this.getAccordoCooperazione(tmp);
            return accordoCooperazione;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (tmp != null && tmp.delete()) {
                    // empty if block
                }
            }
            catch (Exception exception) {}
        }
    }

    public AccordoCooperazione getAccordoCooperazione(String fileName) throws XMLUtilsException {
        return this.getAccordoCooperazione(new File(fileName));
    }

    public AccordoCooperazione getAccordoCooperazione(File zip) throws XMLUtilsException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zip);
            AccordoCooperazione accordoCooperazione = this.getAccordoCooperazione(zipFile);
            return accordoCooperazione;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public AccordoCooperazione getAccordoCooperazione(InputStream m) throws XMLUtilsException {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            byte[] read = new byte[1024];
            int letti = 0;
            while ((letti = m.read(read)) >= 0) {
                bout.write(read, 0, letti);
            }
            bout.flush();
            bout.close();
            m.close();
            AccordoCooperazione accordoCooperazione = this.getAccordoCooperazione(bout.toByteArray());
            return accordoCooperazione;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public AccordoCooperazione getAccordoCooperazione(ZipFile zip) throws XMLUtilsException {
        try {
            AccordoCooperazione archivio = new AccordoCooperazione();
            String rootDir = null;
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                Documento d;
                InputStream inputStream;
                ZipEntry zipEntry = e.nextElement();
                String entryName = ZipUtilities.operativeSystemConversion((String)zipEntry.getName());
                if (rootDir == null) {
                    rootDir = ZipUtilities.getRootDir((String)entryName);
                }
                if (zipEntry.isDirectory()) continue;
                FileDataSource fds = new FileDataSource(entryName);
                String nome = fds.getName();
                String tipo = nome.substring(nome.lastIndexOf(".") + 1, nome.length());
                tipo = tipo.toUpperCase();
                if ((rootDir + ".project").equals(entryName)) continue;
                if ((rootDir + "firma.xml").equals(entryName)) {
                    Firma firma = new Firma();
                    archivio.setFirma(firma);
                    continue;
                }
                if ((rootDir + "manifesto.xml").equals(entryName)) {
                    inputStream = zip.getInputStream(zipEntry);
                    it.gov.spcoop.sica.manifest.AccordoCooperazione manifesto = it.gov.spcoop.sica.manifest.driver.XMLUtils.getManifestoAC(this.log, inputStream);
                    inputStream.close();
                    archivio.setManifesto(manifesto);
                    continue;
                }
                if (entryName.startsWith(rootDir + "allegati")) {
                    inputStream = zip.getInputStream(zipEntry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    archivio.addAllegato(d);
                    continue;
                }
                if (!entryName.startsWith(rootDir + "specificaSemiformale")) continue;
                inputStream = zip.getInputStream(zipEntry);
                d = new Documento(nome, tipo, inputStream);
                inputStream.close();
                archivio.addSpecificaSemiformale(d);
            }
            if (archivio.getManifesto() == null) {
                throw new Exception("Manifesto non presente");
            }
            if (archivio.getManifesto().getSpecificaSemiformale() != null) {
                for (int i = 0; i < archivio.getManifesto().getSpecificaSemiformale().sizeDocumentoSemiformaleList(); ++i) {
                    String fileName = archivio.getManifesto().getSpecificaSemiformale().getDocumentoSemiformale(i).getBase();
                    String tipo = archivio.getManifesto().getSpecificaSemiformale().getDocumentoSemiformale(i).getTipo();
                    for (int j = 0; j < archivio.sizeSpecificheSemiformali(); ++j) {
                        if (!fileName.equals(archivio.getSpecificaSemiformale(j).getNome())) continue;
                        archivio.getSpecificaSemiformale(j).setTipo(tipo);
                    }
                }
            }
            return archivio;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public void generateAccordoCooperazione(AccordoCooperazione manifesto, File file) throws XMLUtilsException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            this.generateAccordoCooperazione(manifesto, fout);
            fout.flush();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void generateAccordoCooperazione(AccordoCooperazione manifesto, String fileName) throws XMLUtilsException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(fileName);
            this.generateAccordoCooperazione(manifesto, fout);
            fout.flush();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public byte[] generateAccordoCooperazione(AccordoCooperazione manifesto) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.generateAccordoCooperazione(manifesto, bout);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public void generateAccordoCooperazione(AccordoCooperazione manifesto, OutputStream out) throws XMLUtilsException {
        boolean generaSICAClientProjectFile = this.sicaToOpenSPCoopContext.isSICAClient_generaProject();
        boolean includiInfoRegistroGenerale = this.sicaToOpenSPCoopContext.isSICAClient_includiInfoRegistroGenerale();
        boolean lunghezzaNomeAccordoLimitata = this.sicaToOpenSPCoopContext.isSICAClient_nomeAccordo_32CaratteriMax();
        ZipOutputStream zipOut = null;
        try {
            zipOut = new ZipOutputStream(out);
            Object rootDir = "";
            rootDir = manifesto.getManifesto().getNome() + File.separatorChar;
            if (generaSICAClientProjectFile) {
                String nomeProgettoEclipse = manifesto.getManifesto().getNome() + "_adc";
                String projectContenuto = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n        <name>@NOME@</name>\n        <comment>Package generato tramite OpenSPCoop v2 (www.openspcoop2.org)</comment>\n        <projects>\n        </projects>\n        <buildSpec>\n                <buildCommand>\n                        <name>com.ibm.rst.sica.workbench.agreementValidator</name>\n                        <arguments>\n                        </arguments>\n                </buildCommand>\n        </buildSpec>\n        <natures>\n                <nature>com.ibm.rst.sica.workbench.natures.commonPart</nature>\n                <nature>com.ibm.rst.sica.workbench.natures.agreementProject</nature>\n        </natures>\n</projectDescription>".replace("@NOME@", nomeProgettoEclipse);
                zipOut.putNextEntry(new ZipEntry((String)rootDir + ".project"));
                zipOut.write(projectContenuto.getBytes());
            }
            if (manifesto.getFirma() != null) {
                byte[] firma = manifesto.getFirma().getBytes();
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "firma.xml"));
                zipOut.write(firma);
            }
            byte[] manifestoBytes = it.gov.spcoop.sica.manifest.driver.XMLUtils.generateManifestoAC(manifesto.getManifesto(), includiInfoRegistroGenerale, lunghezzaNomeAccordoLimitata);
            zipOut.putNextEntry(new ZipEntry((String)rootDir + "manifesto.xml"));
            zipOut.write(manifestoBytes);
            boolean allegati = manifesto.sizeAllegati() > 0;
            for (int i = 0; i < manifesto.sizeAllegati(); ++i) {
                Documento allegato = manifesto.getAllegato(i);
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "allegati" + File.separatorChar + allegato.getNome()));
                zipOut.write(allegato.getContenuto());
            }
            if (!allegati) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "allegati" + File.separatorChar));
            }
            boolean specificheSemiformali = manifesto.sizeSpecificheSemiformali() > 0;
            for (int i = 0; i < manifesto.sizeSpecificheSemiformali(); ++i) {
                Documento doc = manifesto.getSpecificaSemiformale(i);
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaSemiformale" + File.separatorChar + doc.getNome()));
                zipOut.write(doc.getContenuto());
            }
            if (!specificheSemiformali) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaSemiformale" + File.separatorChar));
            }
            zipOut.flush();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (zipOut != null) {
                    zipOut.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccordoServizioComposto getAccordoServizioComposto(byte[] zip) throws XMLUtilsException {
        File tmp = null;
        FileOutputStream fout = null;
        try {
            tmp = FileSystemUtilities.createTempFile((String)"sica", (String)"asc");
            fout = new FileOutputStream(tmp);
            fout.write(zip);
            fout.flush();
            fout.close();
            AccordoServizioComposto accordoServizioComposto = this.getAccordoServizioComposto(tmp);
            return accordoServizioComposto;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (tmp != null && tmp.delete()) {
                    // empty if block
                }
            }
            catch (Exception exception) {}
        }
    }

    public AccordoServizioComposto getAccordoServizioComposto(String fileName) throws XMLUtilsException {
        return this.getAccordoServizioComposto(new File(fileName));
    }

    public AccordoServizioComposto getAccordoServizioComposto(File zip) throws XMLUtilsException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zip);
            AccordoServizioComposto accordoServizioComposto = this.getAccordoServizioComposto(zipFile);
            return accordoServizioComposto;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public AccordoServizioComposto getAccordoServizioComposto(InputStream m) throws XMLUtilsException {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            byte[] read = new byte[1024];
            int letti = 0;
            while ((letti = m.read(read)) >= 0) {
                bout.write(read, 0, letti);
            }
            bout.flush();
            bout.close();
            m.close();
            AccordoServizioComposto accordoServizioComposto = this.getAccordoServizioComposto(bout.toByteArray());
            return accordoServizioComposto;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public AccordoServizioComposto getAccordoServizioComposto(ZipFile zip) throws XMLUtilsException {
        try {
            String tipo;
            String fileName;
            AccordoServizioComposto archivio = new AccordoServizioComposto();
            String rootDir = null;
            ServizioComposto manifesto = null;
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry zipEntry = e.nextElement();
                String entryName = ZipUtilities.operativeSystemConversion((String)zipEntry.getName());
                if (rootDir == null) {
                    rootDir = ZipUtilities.getRootDir((String)entryName);
                }
                if (zipEntry.isDirectory()) continue;
                FileDataSource fds = new FileDataSource(entryName);
                String nome = fds.getName();
                String tipo2 = nome.substring(nome.lastIndexOf(".") + 1, nome.length());
                tipo2 = tipo2.toUpperCase();
                if (!(rootDir + "manifesto.xml").equals(entryName)) continue;
                InputStream inputStream = zip.getInputStream(zipEntry);
                manifesto = it.gov.spcoop.sica.manifest.driver.XMLUtils.getManifestoSC(this.log, inputStream);
                inputStream.close();
                archivio.setManifesto(manifesto);
                break;
            }
            if (manifesto == null) {
                throw new Exception("Manifest ServizioComposto non presente");
            }
            String interfacciaConcettuale = "InterfacciaConcettuale.wsdl";
            String interfaccialogicoErogatore = "InterfacciaLogicaErogatore.wsdl";
            String interfaccialogicoFruitore = "InterfacciaLogicaFruitore.wsdl";
            String conversazioneConcettuale = "ConversazioneConcettuale.wsbl";
            String conversazionelogicoErogatore = "ConversazioneLogicaLatoErogatore.wsbl";
            String conversazionelogicoFruitore = "ConversazioneLogicaLatoFruitore.wsbl";
            if (manifesto.getSpecificaInterfaccia() != null) {
                SpecificaInterfaccia interfaccia = manifesto.getSpecificaInterfaccia();
                if (interfaccia.getInterfacciaConcettuale() != null) {
                    interfacciaConcettuale = ZipUtilities.getBaseName((String)interfaccia.getInterfacciaConcettuale().getBase());
                }
                if (interfaccia.getInterfacciaLogicaLatoErogatore() != null) {
                    interfaccialogicoErogatore = ZipUtilities.getBaseName((String)interfaccia.getInterfacciaLogicaLatoErogatore().getBase());
                }
                if (interfaccia.getInterfacciaLogicaLatoFruitore() != null) {
                    interfaccialogicoFruitore = ZipUtilities.getBaseName((String)interfaccia.getInterfacciaLogicaLatoFruitore().getBase());
                }
            }
            if (manifesto.getSpecificaConversazione() != null) {
                SpecificaConversazione conversazione = manifesto.getSpecificaConversazione();
                if (conversazione.getConversazioneConcettuale() != null) {
                    conversazioneConcettuale = ZipUtilities.getBaseName((String)conversazione.getConversazioneConcettuale().getBase());
                }
                if (conversazione.getConversazioneLogicaLatoErogatore() != null) {
                    conversazionelogicoErogatore = ZipUtilities.getBaseName((String)conversazione.getConversazioneLogicaLatoErogatore().getBase());
                }
                if (conversazione.getConversazioneLogicaLatoFruitore() != null) {
                    conversazionelogicoFruitore = ZipUtilities.getBaseName((String)conversazione.getConversazioneLogicaLatoFruitore().getBase());
                }
            }
            e = zip.entries();
            while (e.hasMoreElements()) {
                String dir;
                Documento d;
                InputStream inputStream;
                ZipEntry zipEntry = e.nextElement();
                String entryName = ZipUtilities.operativeSystemConversion((String)zipEntry.getName());
                if (rootDir == null) {
                    rootDir = ZipUtilities.getRootDir((String)entryName);
                }
                if (zipEntry.isDirectory()) continue;
                FileDataSource fds = new FileDataSource(entryName);
                String nome = fds.getName();
                String tipo3 = nome.substring(nome.lastIndexOf(".") + 1, nome.length());
                tipo3 = tipo3.toUpperCase();
                if ((rootDir + ".project").equals(entryName)) continue;
                if ((rootDir + "firma.xml").equals(entryName)) {
                    Firma firma = new Firma();
                    archivio.setFirma(firma);
                    continue;
                }
                if ((rootDir + "manifesto.xml").equals(entryName)) continue;
                if (entryName.startsWith(rootDir + "specificaConversazione")) {
                    inputStream = zip.getInputStream(zipEntry);
                    d = new Documento(nome, tipo3, inputStream);
                    inputStream.close();
                    dir = rootDir + "specificaConversazione" + File.separatorChar;
                    if ((dir + conversazioneConcettuale).equals(entryName)) {
                        archivio.setConversazioneConcettuale(d);
                        continue;
                    }
                    if ((dir + conversazionelogicoErogatore).equals(entryName)) {
                        archivio.setConversazioneLogicaErogatore(d);
                        continue;
                    }
                    if (!(dir + conversazionelogicoFruitore).equals(entryName)) continue;
                    archivio.setConversazioneLogicaFruitore(d);
                    continue;
                }
                if (entryName.startsWith(rootDir + "specificaInterfaccia")) {
                    inputStream = zip.getInputStream(zipEntry);
                    d = new Documento(nome, tipo3, inputStream);
                    inputStream.close();
                    dir = rootDir + "specificaInterfaccia" + File.separatorChar;
                    if ((dir + interfacciaConcettuale).equals(entryName)) {
                        archivio.setInterfacciaConcettuale(d);
                        continue;
                    }
                    if ((dir + interfaccialogicoErogatore).equals(entryName)) {
                        archivio.setInterfacciaLogicaLatoErogatore(d);
                        continue;
                    }
                    if (!(dir + interfaccialogicoFruitore).equals(entryName)) continue;
                    archivio.setInterfacciaLogicaLatoFruitore(d);
                    continue;
                }
                if (entryName.startsWith(rootDir + "specificaCoordinamento")) {
                    inputStream = zip.getInputStream(zipEntry);
                    d = new Documento(nome, tipo3, inputStream);
                    inputStream.close();
                    archivio.addSpecificaCoordinamento(d);
                    continue;
                }
                if (entryName.startsWith(rootDir + "allegati")) {
                    inputStream = zip.getInputStream(zipEntry);
                    d = new Documento(nome, tipo3, inputStream);
                    inputStream.close();
                    archivio.addAllegato(d);
                    if (it.cnipa.collprofiles.driver.XMLUtils.isProfiloCollaborazioneEGOV(d.getContenuto())) {
                        it.cnipa.collprofiles.driver.XMLUtils.getDichiarazioneEGov(this.log, d.getContenuto(), this.sicaToOpenSPCoopContext.isInformazioniEGov_wscpDisabled_childUnqualified());
                        continue;
                    }
                    if (!it.gov.spcoop.sica.wscp.driver.XMLUtils.isProfiloCollaborazioneEGOV(d.getContenuto())) continue;
                    it.gov.spcoop.sica.wscp.driver.XMLUtils.getDichiarazioneEGov(this.log, d.getContenuto(), this.sicaToOpenSPCoopContext.isInformazioniEGov_wscpEnabled_childUnqualified());
                    continue;
                }
                if (!entryName.startsWith(rootDir + "specificaSemiformale")) continue;
                inputStream = zip.getInputStream(zipEntry);
                d = new Documento(nome, tipo3, inputStream);
                inputStream.close();
                archivio.addSpecificaSemiformale(d);
                if (it.cnipa.collprofiles.driver.XMLUtils.isProfiloCollaborazioneEGOV(d.getContenuto())) {
                    it.cnipa.collprofiles.driver.XMLUtils.getDichiarazioneEGov(this.log, d.getContenuto(), this.sicaToOpenSPCoopContext.isInformazioniEGov_wscpDisabled_childUnqualified());
                    continue;
                }
                if (!it.gov.spcoop.sica.wscp.driver.XMLUtils.isProfiloCollaborazioneEGOV(d.getContenuto())) continue;
                it.gov.spcoop.sica.wscp.driver.XMLUtils.getDichiarazioneEGov(this.log, d.getContenuto(), this.sicaToOpenSPCoopContext.isInformazioniEGov_wscpEnabled_childUnqualified());
            }
            if (archivio.getManifesto() == null) {
                throw new Exception("Manifesto non presente");
            }
            if (archivio.getManifesto().getSpecificaSemiformale() != null) {
                for (int i = 0; i < archivio.getManifesto().getSpecificaSemiformale().sizeDocumentoSemiformaleList(); ++i) {
                    fileName = archivio.getManifesto().getSpecificaSemiformale().getDocumentoSemiformale(i).getBase();
                    tipo = archivio.getManifesto().getSpecificaSemiformale().getDocumentoSemiformale(i).getTipo();
                    for (int j = 0; j < archivio.sizeSpecificheSemiformali(); ++j) {
                        if (!fileName.equals(archivio.getSpecificaSemiformale(j).getNome())) continue;
                        archivio.getSpecificaSemiformale(j).setTipo(tipo);
                    }
                }
            }
            if (archivio.getManifesto().getSpecificaCoordinamento() != null) {
                for (int i = 0; i < archivio.getManifesto().getSpecificaCoordinamento().sizeDocumentoCoordinamentoList(); ++i) {
                    fileName = archivio.getManifesto().getSpecificaCoordinamento().getDocumentoCoordinamento(i).getBase();
                    tipo = archivio.getManifesto().getSpecificaCoordinamento().getDocumentoCoordinamento(i).getTipo();
                    for (int j = 0; j < archivio.sizeSpecificheCoordinamento(); ++j) {
                        if (!fileName.equals(archivio.getSpecificaCoordinamento(j).getNome())) continue;
                        archivio.getSpecificaCoordinamento(j).setTipo(tipo);
                    }
                }
            }
            return archivio;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public void generateAccordoServizioComposto(AccordoServizioComposto manifesto, File file) throws XMLUtilsException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            this.generateAccordoServizioComposto(manifesto, fout);
            fout.flush();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void generateAccordoServizioComposto(AccordoServizioComposto manifesto, String fileName) throws XMLUtilsException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(fileName);
            this.generateAccordoServizioComposto(manifesto, fout);
            fout.flush();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public byte[] generateAccordoServizioComposto(AccordoServizioComposto manifesto) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.generateAccordoServizioComposto(manifesto, bout);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public void generateAccordoServizioComposto(AccordoServizioComposto manifesto, OutputStream out) throws XMLUtilsException {
        boolean generaSICAClientProjectFile = this.sicaToOpenSPCoopContext.isSICAClient_generaProject();
        boolean includiInfoRegistroGenerale = this.sicaToOpenSPCoopContext.isSICAClient_includiInfoRegistroGenerale();
        boolean lunghezzaNomeAccordoLimitata = this.sicaToOpenSPCoopContext.isSICAClient_nomeAccordo_32CaratteriMax();
        ZipOutputStream zipOut = null;
        try {
            zipOut = new ZipOutputStream(out);
            Object rootDir = "";
            rootDir = manifesto.getManifesto().getNome() + File.separatorChar;
            if (generaSICAClientProjectFile) {
                String nomeProgettoEclipse = manifesto.getManifesto().getNome() + "_asc";
                String projectContenuto = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n        <name>@NOME@</name>\n        <comment>Package generato tramite OpenSPCoop v2 (www.openspcoop2.org)</comment>\n        <projects>\n        </projects>\n        <buildSpec>\n                <buildCommand>\n                        <name>com.ibm.rst.sica.workbench.agreementValidator</name>\n                        <arguments>\n                        </arguments>\n                </buildCommand>\n        </buildSpec>\n        <natures>\n                <nature>com.ibm.rst.sica.workbench.natures.commonPart</nature>\n                <nature>com.ibm.rst.sica.workbench.natures.agreementProject</nature>\n        </natures>\n</projectDescription>".replace("@NOME@", nomeProgettoEclipse);
                zipOut.putNextEntry(new ZipEntry((String)rootDir + ".project"));
                zipOut.write(projectContenuto.getBytes());
            }
            if (manifesto.getFirma() != null) {
                byte[] firma = manifesto.getFirma().getBytes();
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "firma.xml"));
                zipOut.write(firma);
            }
            byte[] manifestoBytes = it.gov.spcoop.sica.manifest.driver.XMLUtils.generateManifestoSC(manifesto.getManifesto(), includiInfoRegistroGenerale, lunghezzaNomeAccordoLimitata);
            zipOut.putNextEntry(new ZipEntry((String)rootDir + "manifesto.xml"));
            zipOut.write(manifestoBytes);
            boolean specificaInterfaccia = false;
            if (manifesto.getInterfacciaConcettuale() != null) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaInterfaccia" + File.separatorChar + "InterfacciaConcettuale.wsdl"));
                zipOut.write(manifesto.getInterfacciaConcettuale().getContenuto());
                specificaInterfaccia = true;
            }
            if (manifesto.getInterfacciaLogicaLatoErogatore() != null) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaInterfaccia" + File.separatorChar + "InterfacciaLogicaErogatore.wsdl"));
                zipOut.write(manifesto.getInterfacciaLogicaLatoErogatore().getContenuto());
                specificaInterfaccia = true;
            }
            if (manifesto.getInterfacciaLogicaLatoFruitore() != null) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaInterfaccia" + File.separatorChar + "InterfacciaLogicaFruitore.wsdl"));
                zipOut.write(manifesto.getInterfacciaLogicaLatoFruitore().getContenuto());
                specificaInterfaccia = true;
            }
            if (!specificaInterfaccia) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaInterfaccia" + File.separatorChar));
            }
            boolean specificaConversazioni = false;
            if (manifesto.getConversazioneConcettuale() != null) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaConversazione" + File.separatorChar + "ConversazioneConcettuale.wsbl"));
                zipOut.write(manifesto.getConversazioneConcettuale().getContenuto());
                specificaConversazioni = true;
            }
            if (manifesto.getConversazioneLogicaErogatore() != null) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaConversazione" + File.separatorChar + "ConversazioneLogicaLatoErogatore.wsbl"));
                zipOut.write(manifesto.getConversazioneLogicaErogatore().getContenuto());
                specificaConversazioni = true;
            }
            if (manifesto.getConversazioneLogicaFruitore() != null) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaConversazione" + File.separatorChar + "ConversazioneLogicaLatoFruitore.wsbl"));
                zipOut.write(manifesto.getConversazioneLogicaFruitore().getContenuto());
                specificaConversazioni = true;
            }
            if (!specificaConversazioni) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaConversazione" + File.separatorChar));
            }
            boolean specificheCoordinameno = manifesto.sizeSpecificheCoordinamento() > 0;
            for (int i = 0; i < manifesto.sizeSpecificheCoordinamento(); ++i) {
                Documento doc = manifesto.getSpecificaCoordinamento(i);
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaCoordinamento" + File.separatorChar + doc.getNome()));
                zipOut.write(doc.getContenuto());
            }
            if (!specificheCoordinameno) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaCoordinamento" + File.separatorChar));
            }
            boolean allegati = manifesto.sizeAllegati() > 0;
            for (int i = 0; i < manifesto.sizeAllegati(); ++i) {
                Documento allegato = manifesto.getAllegato(i);
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "allegati" + File.separatorChar + allegato.getNome()));
                zipOut.write(allegato.getContenuto());
            }
            if (!allegati) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "allegati" + File.separatorChar));
            }
            boolean specificheSemiformali = manifesto.sizeSpecificheSemiformali() > 0;
            for (int i = 0; i < manifesto.sizeSpecificheSemiformali(); ++i) {
                Documento doc = manifesto.getSpecificaSemiformale(i);
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaSemiformale" + File.separatorChar + doc.getNome()));
                zipOut.write(doc.getContenuto());
            }
            if (!specificheSemiformali) {
                zipOut.putNextEntry(new ZipEntry((String)rootDir + "specificaSemiformale" + File.separatorChar));
            }
            zipOut.flush();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (zipOut != null) {
                    zipOut.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

