/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.spcoop.builder;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.soap.SOAPHeaderElement;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.config.ServiceBindingConfiguration;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.basic.BasicStateComponentFactory;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.BustaRawContent;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.ProtocolMessage;
import org.openspcoop2.protocol.sdk.Trasmissione;
import org.openspcoop2.protocol.sdk.builder.IBustaBuilder;
import org.openspcoop2.protocol.sdk.builder.ProprietaManifestAttachments;
import org.openspcoop2.protocol.sdk.constants.FaseImbustamento;
import org.openspcoop2.protocol.sdk.constants.FaseSbustamento;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.spcoop.SPCoopBustaRawContent;
import org.openspcoop2.protocol.spcoop.builder.SPCoopImbustamento;
import org.openspcoop2.protocol.spcoop.builder.SPCoopSbustamento;
import org.openspcoop2.utils.date.DateUtils;

public class SPCoopBustaBuilder
extends BasicStateComponentFactory
implements IBustaBuilder<SOAPHeaderElement> {
    private SPCoopImbustamento spcoopImbustamento = null;
    private SPCoopSbustamento spcoopSbustamento = null;

    public SPCoopBustaBuilder(IProtocolFactory<SOAPHeaderElement> factory, IState state) throws ProtocolException {
        super(factory, state);
        this.spcoopImbustamento = new SPCoopImbustamento(factory, this.state);
        this.spcoopSbustamento = new SPCoopSbustamento(factory, this.state);
        this.log = factory.getLogger();
    }

    public String newID(IDSoggetto idSoggetto, String idTransazione, RuoloMessaggio ruoloMessaggio) throws ProtocolException {
        return this.spcoopImbustamento.buildID(idSoggetto, idTransazione, ruoloMessaggio);
    }

    public Date extractDateFromID(String id) throws ProtocolException {
        try {
            if (id == null) {
                return null;
            }
            String[] split = id.split("_");
            if (split.length != 5) {
                return null;
            }
            SimpleDateFormat dateformat = DateUtils.getSimpleDateFormatMinute();
            String tmp = split[3] + "_" + split[4];
            Date d = dateformat.parse(tmp);
            return d;
        }
        catch (Exception e) {
            throw new ProtocolException("Errore durante l'estrazione della data dall'identificativo [" + id + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    public ProtocolMessage imbustamento(OpenSPCoop2Message msg, Context context, Busta busta, Busta bustaRichiesta, RuoloMessaggio ruoloMessaggio, ProprietaManifestAttachments proprietaManifestAttachments, FaseImbustamento faseImbustamento) throws ProtocolException {
        if (FaseImbustamento.DOPO_SICUREZZA_MESSAGGIO.equals((Object)faseImbustamento)) {
            ProtocolMessage protocolMessage = new ProtocolMessage();
            protocolMessage.setPhaseUnsupported(true);
            return protocolMessage;
        }
        SOAPHeaderElement element = this.spcoopImbustamento.imbustamento(msg, busta, ruoloMessaggio, proprietaManifestAttachments);
        ProtocolMessage protocolMessage = new ProtocolMessage();
        protocolMessage.setBustaRawContent((BustaRawContent)new SPCoopBustaRawContent(element));
        protocolMessage.setMessage(msg);
        return protocolMessage;
    }

    public ProtocolMessage addTrasmissione(OpenSPCoop2Message message, Trasmissione trasmissione, FaseImbustamento faseImbustamento) throws ProtocolException {
        if (FaseImbustamento.DOPO_SICUREZZA_MESSAGGIO.equals((Object)faseImbustamento)) {
            ProtocolMessage protocolMessage = new ProtocolMessage();
            protocolMessage.setPhaseUnsupported(true);
            return protocolMessage;
        }
        SOAPHeaderElement element = this.spcoopImbustamento.addTrasmissione(message, trasmissione);
        ProtocolMessage protocolMessage = new ProtocolMessage();
        protocolMessage.setBustaRawContent((BustaRawContent)new SPCoopBustaRawContent(element));
        protocolMessage.setMessage(message);
        return protocolMessage;
    }

    public ProtocolMessage sbustamento(OpenSPCoop2Message msg, Context context, Busta busta, RuoloMessaggio ruoloMessaggio, ProprietaManifestAttachments proprietaManifestAttachments, FaseSbustamento faseSbustamento, ServiceBinding integrationServiceBinding, ServiceBindingConfiguration serviceBindingConfiguration) throws ProtocolException {
        ProtocolMessage protocolMessage = new ProtocolMessage();
        protocolMessage.setMessage(msg);
        if (!FaseSbustamento.POST_VALIDAZIONE_SEMANTICA_RICHIESTA.equals((Object)faseSbustamento) && !FaseSbustamento.POST_VALIDAZIONE_SEMANTICA_RISPOSTA.equals((Object)faseSbustamento)) {
            SOAPHeaderElement element = this.spcoopSbustamento.sbustamento(msg, proprietaManifestAttachments);
            protocolMessage.setBustaRawContent((BustaRawContent)new SPCoopBustaRawContent(element));
            protocolMessage.setMessage(msg);
        }
        protocolMessage.setUseBustaRawContentReadByValidation(true);
        return protocolMessage;
    }
}

