/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.spcoop.config;

import java.io.InputStream;
import java.util.Properties;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.protocol.basic.BasicStaticInstanceConfig;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.CostantiProtocollo;
import org.openspcoop2.protocol.spcoop.config.SPCoopInstanceProperties;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class SPCoopProperties {
    private Logger log = null;
    private static SPCoopProperties spcoopProperties = null;
    private SPCoopInstanceProperties reader;
    private String tipoSeriale_IdentificativoBusta = null;
    private Boolean isHttpEmptyResponseOneWay = null;
    private Integer getHttpReturnCodeEmptyResponseOneWay = null;
    private Boolean isHttpOneWay_PD_HTTPEmptyResponse = null;
    private Boolean isResponseMessageWithTransportCodeError_blockedTransaction = null;
    private Boolean isGenerazioneBustaErrore_strutturaMalformataHeaderBusta = null;
    private Boolean isGenerazioneBustaErrore_actorScorretto = null;
    private Long intervalloScadenzaBuste = null;
    private Integer dateFutureIntervalloTolleranza = null;
    private Boolean repositoryBusteFiltraBusteScaduteRispettoOraRegistrazione = null;
    private String getKeywordTipoMittenteSconosciuto = null;
    private String getKeywordMittenteSconosciuto = null;
    private String getSchemaXSDValidazioneXSDBusta = null;
    private String[] schemiImportatiValidazioneXSDBusta = null;
    private Boolean isGenerazioneElementiNonValidabiliRispettoXSD = null;
    private Boolean isBustaErrore_EccezioniNonGravi = null;
    private Boolean isGenerazioneListaEccezioniErroreProcessamento = null;
    private String roleRichiestaManifest = null;
    private String roleRispostaManifest = null;
    private String roleAllegatoManifest = null;
    private Boolean generateManifestAttachmentsIdWithBrackets = null;
    private Boolean isGenerazioneDetailsSOAPFaultProtocolValidazione = null;
    private Boolean isGenerazioneDetailsSOAPFaultProtocolProcessamento = null;
    private Boolean isGenerazioneDetailsSOAPFaultProtocolWithStackTrace = null;
    private Boolean isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche = null;
    private Boolean isGenerazioneDetailsSOAPFaultIntegrationServerError = null;
    private Boolean isGenerazioneDetailsSOAPFaultIntegrationClientError = null;
    private Boolean isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace = null;
    private Boolean isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche = null;
    private Boolean isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGenericheRead = null;
    private BooleanNullable isAggiungiDetailErroreApplicativo_SoapFaultApplicativo = null;
    private Boolean isAggiungiDetailErroreApplicativo_SoapFaultApplicativoRead = null;
    private BooleanNullable isAggiungiDetailErroreApplicativo_SoapFaultPdD = null;
    private Boolean isAggiungiDetailErroreApplicativo_SoapFaultPdDRead = null;
    private Boolean isGestionePackageSICA = null;
    private Boolean isAddPrefixSOAPENV = null;
    private Boolean useConfigStaticInstance = null;
    private Boolean useErroreApplicativoStaticInstance = null;
    private Boolean useEsitoStaticInstance = null;
    private BasicStaticInstanceConfig staticInstanceConfig = null;

    private SPCoopProperties(String confDir, Logger log) throws ProtocolException {
        this.log = log != null ? log : LoggerWrapperFactory.getLogger((String)"SPCoopProperties");
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = SPCoopProperties.class.getResourceAsStream("/spcoop.properties");
            if (properties == null) {
                throw new Exception("File '/spcoop.properties' not found");
            }
            propertiesReader.load(properties);
        }
        catch (Exception e) {
            this.log.error("Riscontrato errore durante la lettura del file 'spcoop.properties': " + e.getMessage());
            throw new ProtocolException("SPCoopProperties initialize error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Throwable throwable) {}
        }
        try {
            this.reader = new SPCoopInstanceProperties(confDir, propertiesReader, this.log);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static synchronized void initialize(String confDir, Logger log) throws ProtocolException {
        if (spcoopProperties == null) {
            spcoopProperties = new SPCoopProperties(confDir, log);
        }
    }

    public static SPCoopProperties getInstance(Logger log) throws ProtocolException {
        if (spcoopProperties == null) {
            Class<SPCoopProperties> clazz = SPCoopProperties.class;
            synchronized (SPCoopProperties.class) {
                throw new ProtocolException("SPCoopProperties not initialized (use init method in factory)");
            }
        }
        return spcoopProperties;
    }

    public void validaConfigurazione(Loader loader) throws ProtocolException {
        try {
            OpenSPCoop2Properties op2Properties;
            String tipo = this.getTipoSeriale_IdentificativoBusta();
            if (!("db".equals(tipo) || CostantiProtocollo.IDENTIFICATIVO_SERIALE_MYSQL.equals(tipo) || "static".equals(tipo) || "dynamic".equals(tipo))) {
                String msg = "Riscontrato errore durante la lettura della proprieta': 'org.openspcoop2.protocol.spcoop.id.tipo': tipo non gestito";
                this.log.error(msg);
                throw new ProtocolException(msg);
            }
            if ("static".equals(tipo)) {
                Integer prefix;
                OpenSPCoop2Properties op2Properties2 = OpenSPCoop2Properties.getInstance();
                Integer n = op2Properties2 != null ? (op2Properties2.getClusterIdNumerico() != null ? Integer.valueOf(op2Properties2.getClusterIdNumerico()) : null) : (prefix = null);
                if (prefix != null && (prefix < 0 || prefix > 99)) {
                    String msg = "La generazione dell'identificativo eGov richiede un identificativo del cluster compreso tra 0 e 99";
                    this.log.error(msg);
                    throw new ProtocolException(msg);
                }
            } else if ("dynamic".equals(tipo) && (op2Properties = OpenSPCoop2Properties.getInstance()) != null && !op2Properties.isClusterDinamico()) {
                String msg = "La generazione dell'identificativo eGov richiede un identificativo del cluster dinamico";
                this.log.error(msg);
                throw new ProtocolException(msg);
            }
            this.isHttpEmptyResponseOneWay();
            this.getHttpReturnCodeEmptyResponseOneWay();
            this.isHttpOneWay_PD_HTTPEmptyResponse();
            this.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo();
            this.isGenerazioneBustaErrore_actorScorretto();
            this.getIntervalloScadenzaBuste();
            this.isRepositoryBusteFiltraBusteScaduteRispettoOraRegistrazione();
            this.getIntervalloMinutiTolleranzaDateFuture();
            this.getKeywordTipoMittenteSconosciuto();
            this.getKeywordMittenteSconosciuto();
            this.getSchemaXSDValidazioneXSDBusta();
            this.getSchemiXSDImportatiValidazioneXSDBusta();
            this.isGenerazioneElementiNonValidabiliRispettoXSD();
            this.isIgnoraEccezioniNonGravi();
            this.isGenerazioneListaEccezioniErroreProcessamento();
            this.getRoleRichiestaManifest();
            this.getRoleRispostaManifest();
            this.getRoleAllegatoManifest();
            this.isGenerazioneDetailsSOAPFaultProtocolValidazione();
            this.isGenerazioneDetailsSOAPFaultProtocolProcessamento();
            this.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace();
            this.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche();
            this.isGenerazioneDetailsSOAPFaultIntegrationServerError();
            this.isGenerazioneDetailsSOAPFaultIntegrationClientError();
            this.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace();
            this.isGenerazioneDetailsSOAPFaultIntegrazionConInformazioniGeneriche();
            this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativo();
            this.isAggiungiDetailErroreApplicativo_SoapFaultPdD();
            this.isGestionePackageSICA();
            this.isAddPrefixSOAPENV();
            this.useConfigStaticInstance();
            this.useErroreApplicativoStaticInstance();
            this.useEsitoStaticInstance();
            this.getStaticInstanceConfig();
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante la validazione della proprieta' del protocollo SPCoop, " + e.getMessage();
            this.log.error(msg, (Throwable)e);
            throw new ProtocolException(msg, (Throwable)e);
        }
    }

    public String getTipoSeriale_IdentificativoBusta() throws ProtocolException {
        if (this.tipoSeriale_IdentificativoBusta == null) {
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.id.tipo");
                if (name == null) {
                    throw new Exception("proprieta non definita");
                }
                this.tipoSeriale_IdentificativoBusta = name.trim();
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.id.tipo': " + e.getMessage();
                this.log.error(msg, (Throwable)e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.tipoSeriale_IdentificativoBusta;
    }

    public boolean isHttpEmptyResponseOneWay() {
        if (this.isHttpEmptyResponseOneWay == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.oneway.httpEmptyResponse");
                if (value != null) {
                    value = value.trim();
                    this.isHttpEmptyResponseOneWay = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.oneway.httpEmptyResponse' non impostata, viene utilizzato il default=true");
                    this.isHttpEmptyResponseOneWay = true;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.oneway.httpEmptyResponse' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                this.isHttpEmptyResponseOneWay = true;
            }
        }
        return this.isHttpEmptyResponseOneWay;
    }

    public Integer getHttpReturnCodeEmptyResponseOneWay() {
        if (this.getHttpReturnCodeEmptyResponseOneWay == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.oneway.httpEmptyResponse.returnCode");
                if (value != null) {
                    value = value.trim();
                    this.getHttpReturnCodeEmptyResponseOneWay = Integer.parseInt(value);
                    if (this.getHttpReturnCodeEmptyResponseOneWay != 200 && this.getHttpReturnCodeEmptyResponseOneWay != 202) {
                        throw new Exception("Unici valori ammessi sono 200 o 202, trovato [" + this.getHttpReturnCodeEmptyResponseOneWay + "]");
                    }
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.oneway.httpEmptyResponse.returnCode' non impostata, viene utilizzato il default=200");
                    this.getHttpReturnCodeEmptyResponseOneWay = 200;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.oneway.httpEmptyResponse.returnCode' non impostata, viene utilizzato il default=200, errore: " + e.getMessage());
                this.getHttpReturnCodeEmptyResponseOneWay = 200;
            }
        }
        return this.getHttpReturnCodeEmptyResponseOneWay;
    }

    public boolean isHttpOneWay_PD_HTTPEmptyResponse() {
        if (this.isHttpOneWay_PD_HTTPEmptyResponse == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.oneway.httpEmptyResponse.bodyEmptyWithHeader.enable");
                if (value != null) {
                    value = value.trim();
                    this.isHttpOneWay_PD_HTTPEmptyResponse = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.oneway.httpEmptyResponse.bodyEmptyWithHeader.enable' non impostata, viene utilizzato il default=true");
                    this.isHttpOneWay_PD_HTTPEmptyResponse = true;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.oneway.httpEmptyResponse.bodyEmptyWithHeader.enable' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                this.isHttpOneWay_PD_HTTPEmptyResponse = true;
            }
        }
        return this.isHttpOneWay_PD_HTTPEmptyResponse;
    }

    public boolean isResponseMessageWithTransportCodeError_blockedTransaction() {
        if (this.isResponseMessageWithTransportCodeError_blockedTransaction == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.responseMessageWithTransportCodeError.blockedTransaction");
                if (value != null) {
                    value = value.trim();
                    this.isResponseMessageWithTransportCodeError_blockedTransaction = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.responseMessageWithTransportCodeError.blockedTransaction' non impostata, viene utilizzato il default=true");
                    this.isResponseMessageWithTransportCodeError_blockedTransaction = true;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.responseMessageWithTransportCodeError.blockedTransaction' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                this.isResponseMessageWithTransportCodeError_blockedTransaction = true;
            }
        }
        return this.isResponseMessageWithTransportCodeError_blockedTransaction;
    }

    public boolean isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo() {
        if (this.isGenerazioneBustaErrore_strutturaMalformataHeaderBusta == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.strutturaHeaderNonCorretta.generazioneBustaRisposta");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneBustaErrore_strutturaMalformataHeaderBusta = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.strutturaHeaderNonCorretta.generazioneBustaRisposta' non impostata, viene utilizzato il default=false");
                    this.isGenerazioneBustaErrore_strutturaMalformataHeaderBusta = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.strutturaHeaderNonCorretta.generazioneBustaRisposta' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                this.isGenerazioneBustaErrore_strutturaMalformataHeaderBusta = false;
            }
        }
        return this.isGenerazioneBustaErrore_strutturaMalformataHeaderBusta;
    }

    public boolean isGenerazioneBustaErrore_actorScorretto() {
        if (this.isGenerazioneBustaErrore_actorScorretto == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.strutturaHeaderNonCorretta.actorNonCorretto.generazioneBustaRisposta");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneBustaErrore_actorScorretto = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.strutturaHeaderNonCorretta.actorNonCorretto.generazioneBustaRisposta' non impostata, viene utilizzato il default=true");
                    this.isGenerazioneBustaErrore_actorScorretto = true;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.strutturaHeaderNonCorretta.actorNonCorretto.generazioneBustaRisposta' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                this.isGenerazioneBustaErrore_actorScorretto = true;
            }
        }
        return this.isGenerazioneBustaErrore_actorScorretto;
    }

    public long getIntervalloScadenzaBuste() throws ProtocolException {
        if (this.intervalloScadenzaBuste == null) {
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.scadenzaMessaggio");
                if (name == null) {
                    throw new Exception("non definita");
                }
                name = name.trim();
                this.intervalloScadenzaBuste = Long.parseLong(name);
                if (this.intervalloScadenzaBuste <= 0L && this.intervalloScadenzaBuste != -1L) {
                    throw new Exception("Valore non valido [" + this.intervalloScadenzaBuste + "].");
                }
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.scadenzaMessaggio': " + e.getMessage();
                this.log.error(msg, (Throwable)e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return this.intervalloScadenzaBuste;
    }

    public int getIntervalloMinutiTolleranzaDateFuture() {
        if (this.dateFutureIntervalloTolleranza == null) {
            try {
                String name = null;
                name = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.date.intervalloTolleranza");
                if (name != null) {
                    name = name.trim();
                    this.dateFutureIntervalloTolleranza = Integer.parseInt(name);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.date.intervalloTolleranza' non impostata, viene utilizzato il default=-1 (accettate qualsiasi date future)");
                    this.dateFutureIntervalloTolleranza = -1;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.date.intervalloTolleranza' non impostata, viene utilizzato il default=-1 (accettate qualsiasi date future): " + e.getMessage());
                this.dateFutureIntervalloTolleranza = -1;
            }
        }
        return this.dateFutureIntervalloTolleranza;
    }

    public boolean isCheckTolleranzaDateFutureAttivo() {
        return this.getIntervalloMinutiTolleranzaDateFuture() > 0;
    }

    public boolean isRepositoryBusteFiltraBusteScaduteRispettoOraRegistrazione() {
        if (this.repositoryBusteFiltraBusteScaduteRispettoOraRegistrazione == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.scadenzaMessaggio.filtraBusteScaduteRispettoOraRegistrazione");
                if (value == null) {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.scadenzaMessaggio.filtraBusteScaduteRispettoOraRegistrazione' non definita (Viene utilizzato il default:true)");
                    this.repositoryBusteFiltraBusteScaduteRispettoOraRegistrazione = true;
                } else {
                    this.repositoryBusteFiltraBusteScaduteRispettoOraRegistrazione = Boolean.parseBoolean(value);
                }
            }
            catch (Exception e) {
                this.log.warn("Riscontrato errore durante la lettura della proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.scadenzaMessaggio.filtraBusteScaduteRispettoOraRegistrazione' (Viene utilizzato il default:true): " + e.getMessage());
                this.repositoryBusteFiltraBusteScaduteRispettoOraRegistrazione = true;
            }
        }
        return this.repositoryBusteFiltraBusteScaduteRispettoOraRegistrazione;
    }

    public String getKeywordTipoMittenteSconosciuto() {
        if (this.getKeywordTipoMittenteSconosciuto == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.mittenteSconosciuto.tipo");
                if (value != null) {
                    this.getKeywordTipoMittenteSconosciuto = value = value.trim();
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.mittenteSconosciuto.tipo' non impostata, viene utilizzato il default=Sconosciuto");
                    this.getKeywordTipoMittenteSconosciuto = "Sconosciuto";
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.mittenteSconosciuto.tipo' non impostata, viene utilizzato il default=Sconosciuto, errore:" + e.getMessage());
                this.getKeywordTipoMittenteSconosciuto = "Sconosciuto";
            }
        }
        return this.getKeywordTipoMittenteSconosciuto;
    }

    public String getKeywordMittenteSconosciuto() {
        if (this.getKeywordMittenteSconosciuto == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.mittenteSconosciuto.nome");
                if (value != null) {
                    this.getKeywordMittenteSconosciuto = value = value.trim();
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.mittenteSconosciuto.nome' non impostata, viene utilizzato il default=Sconosciuto");
                    this.getKeywordMittenteSconosciuto = "Sconosciuto";
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.mittenteSconosciuto.nome' non impostata, viene utilizzato il default=Sconosciuto, errore:" + e.getMessage());
                this.getKeywordMittenteSconosciuto = "Sconosciuto";
            }
        }
        return this.getKeywordMittenteSconosciuto;
    }

    public String getSchemaXSDValidazioneXSDBusta() {
        if (this.getSchemaXSDValidazioneXSDBusta == null) {
            String defaultSchema = "Busta.xsd";
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.validazione_xsd.schema");
                if (value != null) {
                    this.getSchemaXSDValidazioneXSDBusta = value = value.trim();
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.validazione_xsd.schema' non impostata, viene utilizzato il default=[" + defaultSchema + "]");
                    this.getSchemaXSDValidazioneXSDBusta = defaultSchema;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.validazione_xsd.schema' non impostata, viene utilizzato il default=[" + defaultSchema + "], errore:" + e.getMessage());
                this.getSchemaXSDValidazioneXSDBusta = defaultSchema;
            }
        }
        return this.getSchemaXSDValidazioneXSDBusta;
    }

    public String[] getSchemiXSDImportatiValidazioneXSDBusta() {
        String defaults = "soapEnvelope.xsd,wssecurityUtility.xsd";
        String[] arrayDefault = new String[]{"soapEnvelope.xsd", "wssecurityUtility.xsd"};
        if (this.schemiImportatiValidazioneXSDBusta == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.validazione_xsd.schemiImportati");
                if (value != null) {
                    value = value.trim();
                    this.schemiImportatiValidazioneXSDBusta = value.split(",");
                    if (this.schemiImportatiValidazioneXSDBusta == null || this.schemiImportatiValidazioneXSDBusta.length <= 0) {
                        throw new Exception("schemi non definiti");
                    }
                    for (int i = 0; i < this.schemiImportatiValidazioneXSDBusta.length; ++i) {
                        this.schemiImportatiValidazioneXSDBusta[i] = this.schemiImportatiValidazioneXSDBusta[i].trim();
                    }
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.validazione_xsd.schemiImportati' non impostata, viene utilizzato il default=" + defaults);
                    this.schemiImportatiValidazioneXSDBusta = arrayDefault;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.validazione_xsd.schemiImportati' non impostata, viene utilizzato il default=" + defaults + ", errore:" + e.getMessage());
                this.schemiImportatiValidazioneXSDBusta = arrayDefault;
            }
        }
        return this.schemiImportatiValidazioneXSDBusta;
    }

    public boolean isGenerazioneElementiNonValidabiliRispettoXSD() {
        if (this.isGenerazioneElementiNonValidabiliRispettoXSD == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.generazioneElementiNonValidabiliRispettoXSD");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneElementiNonValidabiliRispettoXSD = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.generazioneElementiNonValidabiliRispettoXSD' non impostata, viene utilizzato il default=false");
                    this.isGenerazioneElementiNonValidabiliRispettoXSD = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.generazioneElementiNonValidabiliRispettoXSD' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                this.isGenerazioneElementiNonValidabiliRispettoXSD = false;
            }
        }
        return this.isGenerazioneElementiNonValidabiliRispettoXSD;
    }

    public boolean isIgnoraEccezioniNonGravi() {
        if (this.isBustaErrore_EccezioniNonGravi == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.bustaErrore.ignoraEccezioniNonGravi.enable");
                if (value != null) {
                    value = value.trim();
                    this.isBustaErrore_EccezioniNonGravi = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.bustaErrore.ignoraEccezioniNonGravi.enable' non impostata, viene utilizzato il default=false");
                    this.isBustaErrore_EccezioniNonGravi = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.bustaErrore.ignoraEccezioniNonGravi.enable' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                this.isBustaErrore_EccezioniNonGravi = false;
            }
        }
        return this.isBustaErrore_EccezioniNonGravi;
    }

    public boolean isGenerazioneListaEccezioniErroreProcessamento() {
        if (this.isGenerazioneListaEccezioniErroreProcessamento == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.eccezioneProcessamento.generazioneListaEccezioni");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneListaEccezioniErroreProcessamento = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.eccezioneProcessamento.generazioneListaEccezioni' non impostata, viene utilizzato il default=false");
                    this.isGenerazioneListaEccezioniErroreProcessamento = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.eccezioneProcessamento.generazioneListaEccezioni' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                this.isGenerazioneListaEccezioniErroreProcessamento = false;
            }
        }
        return this.isGenerazioneListaEccezioniErroreProcessamento;
    }

    public String getRoleRichiestaManifest() {
        if (this.roleRichiestaManifest == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.manifestAttachments.role.richiesta");
                if (value != null) {
                    this.roleRichiestaManifest = value = value.trim();
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.manifestAttachments.role.richiesta' non impostata, viene utilizzato il default=Richiesta");
                    this.roleRichiestaManifest = "Richiesta";
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.manifestAttachments.role.richiesta' non impostata, viene utilizzato il default=Richiesta, errore:" + e.getMessage());
                this.roleRichiestaManifest = "Richiesta";
            }
        }
        return this.roleRichiestaManifest;
    }

    public String getRoleRispostaManifest() {
        if (this.roleRispostaManifest == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.manifestAttachments.role.risposta");
                if (value != null) {
                    this.roleRispostaManifest = value = value.trim();
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.manifestAttachments.role.risposta' non impostata, viene utilizzato il default=Risposta");
                    this.roleRispostaManifest = "Risposta";
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.manifestAttachments.role.risposta' non impostata, viene utilizzato il default=Risposta, errore:" + e.getMessage());
                this.roleRispostaManifest = "Risposta";
            }
        }
        return this.roleRispostaManifest;
    }

    public String getRoleAllegatoManifest() {
        if (this.roleAllegatoManifest == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.manifestAttachments.role.allegato");
                if (value != null) {
                    this.roleAllegatoManifest = value = value.trim();
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.manifestAttachments.role.richiesta' non impostata, viene utilizzato il default=Allegato");
                    this.roleAllegatoManifest = "Allegato";
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.manifestAttachments.role.richiesta' non impostata, viene utilizzato il default=Allegato, errore:" + e.getMessage());
                this.roleAllegatoManifest = "Allegato";
            }
        }
        return this.roleAllegatoManifest;
    }

    public boolean isGenerateManifestAttachmentsIdWithBrackets() {
        if (this.generateManifestAttachmentsIdWithBrackets == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.manifestAttachments.id.brackets");
                if (value != null) {
                    value = value.trim();
                    this.generateManifestAttachmentsIdWithBrackets = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.manifestAttachments.id.brackets' non impostata, viene utilizzato il default=false");
                    this.generateManifestAttachmentsIdWithBrackets = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.manifestAttachments.id.brackets' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                this.generateManifestAttachmentsIdWithBrackets = false;
            }
        }
        return this.generateManifestAttachmentsIdWithBrackets;
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocolValidazione() {
        if (this.isGenerazioneDetailsSOAPFaultProtocolValidazione == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.generazioneDetailsSoapFault.protocol.eccezioneIntestazione");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultProtocolValidazione = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.generazioneDetailsSoapFault.protocol.eccezioneIntestazione' non impostata, viene utilizzato il default=false");
                    this.isGenerazioneDetailsSOAPFaultProtocolValidazione = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.generazioneDetailsSoapFault.protocol.eccezioneIntestazione' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultProtocolValidazione = false;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultProtocolValidazione;
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocolProcessamento() {
        if (this.isGenerazioneDetailsSOAPFaultProtocolProcessamento == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.generazioneDetailsSoapFault.protocol.eccezioneProcessamento");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultProtocolProcessamento = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.generazioneDetailsSoapFault.protocol.eccezioneProcessamento' non impostata, viene utilizzato il default=true");
                    this.isGenerazioneDetailsSOAPFaultProtocolProcessamento = true;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.generazioneDetailsSoapFault.protocol.eccezioneProcessamento' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultProtocolProcessamento = true;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultProtocolProcessamento;
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocolWithStackTrace() {
        if (this.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.generazioneDetailsSoapFault.protocol.stackTrace");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.generazioneDetailsSoapFault.protocol.stackTrace' non impostata, viene utilizzato il default=false");
                    this.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.generazioneDetailsSoapFault.protocol.stackTrace' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace = false;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace;
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche() {
        if (this.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.generazioneDetailsSoapFault.protocol.informazioniGeneriche");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.generazioneDetailsSoapFault.protocol.informazioniGeneriche' non impostata, viene utilizzato il default=true");
                    this.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche = true;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.generazioneDetailsSoapFault.protocol.informazioniGeneriche' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche = true;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche;
    }

    public boolean isGenerazioneDetailsSOAPFaultIntegrationServerError() {
        if (this.isGenerazioneDetailsSOAPFaultIntegrationServerError == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.generazioneDetailsSoapFault.integration.serverError");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultIntegrationServerError = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.generazioneDetailsSoapFault.integration.serverError' non impostata, viene utilizzato il default=true");
                    this.isGenerazioneDetailsSOAPFaultIntegrationServerError = true;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.generazioneDetailsSoapFault.integration.serverError' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultIntegrationServerError = true;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultIntegrationServerError;
    }

    public boolean isGenerazioneDetailsSOAPFaultIntegrationClientError() {
        if (this.isGenerazioneDetailsSOAPFaultIntegrationClientError == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.generazioneDetailsSoapFault.integration.clientError");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultIntegrationClientError = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.generazioneDetailsSoapFault.integration.clientError' non impostata, viene utilizzato il default=false");
                    this.isGenerazioneDetailsSOAPFaultIntegrationClientError = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.generazioneDetailsSoapFault.integration.clientError' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultIntegrationClientError = false;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultIntegrationClientError;
    }

    public boolean isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace() {
        if (this.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.generazioneDetailsSoapFault.integration.stackTrace");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.generazioneDetailsSoapFault.integration.stackTrace' non impostata, viene utilizzato il default=false");
                    this.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.generazioneDetailsSoapFault.integration.stackTrace' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace = false;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace;
    }

    public Boolean isGenerazioneDetailsSOAPFaultIntegrazionConInformazioniGeneriche() {
        if (this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGenericheRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.generazioneDetailsSoapFault.integration.informazioniGeneriche");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.generazioneDetailsSoapFault.integration.informazioniGeneriche' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultAsGenericCode)");
                    this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche = null;
                }
                this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGenericheRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.generazioneDetailsSoapFault.integration.informazioniGeneriche' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultAsGenericCode), errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche = null;
                this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGenericheRead = true;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche;
    }

    public BooleanNullable isAggiungiDetailErroreApplicativo_SoapFaultApplicativo() {
        if (this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativoRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.erroreApplicativo.faultApplicativo.enrichDetails");
                if (value != null) {
                    Boolean b = Boolean.parseBoolean(value = value.trim());
                    this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativo = b != false ? BooleanNullable.TRUE() : BooleanNullable.FALSE();
                } else {
                    this.log.debug("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.erroreApplicativo.faultApplicativo.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails)");
                    this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativo = BooleanNullable.NULL();
                }
                this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativoRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.erroreApplicativo.faultApplicativo.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails), errore:" + e.getMessage());
                this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativo = BooleanNullable.NULL();
                this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativoRead = true;
            }
        }
        return this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativo;
    }

    public BooleanNullable isAggiungiDetailErroreApplicativo_SoapFaultPdD() {
        if (this.isAggiungiDetailErroreApplicativo_SoapFaultPdDRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.erroreApplicativo.faultPdD.enrichDetails");
                if (value != null) {
                    Boolean b = Boolean.parseBoolean(value = value.trim());
                    this.isAggiungiDetailErroreApplicativo_SoapFaultPdD = b != false ? BooleanNullable.TRUE() : BooleanNullable.FALSE();
                } else {
                    this.log.debug("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.erroreApplicativo.faultPdD.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultPdD.enrichDetails)");
                    this.isAggiungiDetailErroreApplicativo_SoapFaultPdD = BooleanNullable.NULL();
                }
                this.isAggiungiDetailErroreApplicativo_SoapFaultPdDRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.erroreApplicativo.faultPdD.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultPdD.enrichDetails), errore:" + e.getMessage());
                this.isAggiungiDetailErroreApplicativo_SoapFaultPdD = BooleanNullable.NULL();
                this.isAggiungiDetailErroreApplicativo_SoapFaultPdDRead = true;
            }
        }
        return this.isAggiungiDetailErroreApplicativo_SoapFaultPdD;
    }

    public Boolean isGestionePackageSICA() {
        if (this.isGestionePackageSICA == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.spcoop.packageSICA");
                if (value != null) {
                    value = value.trim();
                    this.isGestionePackageSICA = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.packageSICA' non impostata, viene utilizzato il default=false");
                    this.isGestionePackageSICA = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.spcoop.packageSICA' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                this.isGestionePackageSICA = false;
            }
        }
        return this.isGestionePackageSICA;
    }

    public Boolean isAddPrefixSOAPENV() {
        if (this.isAddPrefixSOAPENV == null) {
            String pName = "org.openspcoop2.protocol.spcoop.addPrefixSOAP_ENV";
            try {
                String value = this.reader.getValueConvertEnvProperties(pName);
                if (value != null) {
                    value = value.trim();
                    this.isAddPrefixSOAPENV = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop '" + pName + "' non impostata, viene utilizzato il default=false");
                    this.isAddPrefixSOAPENV = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop '" + pName + "' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                this.isAddPrefixSOAPENV = false;
            }
        }
        return this.isAddPrefixSOAPENV;
    }

    private Boolean useConfigStaticInstance() {
        if (this.useConfigStaticInstance == null) {
            Boolean defaultValue = true;
            String propertyName = "org.openspcoop2.protocol.spcoop.factory.config.staticInstance";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.useConfigStaticInstance = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue);
                    this.useConfigStaticInstance = defaultValue;
                }
            }
            catch (Exception e) {
                this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue + ", errore:" + e.getMessage());
                this.useConfigStaticInstance = defaultValue;
            }
        }
        return this.useConfigStaticInstance;
    }

    private Boolean useErroreApplicativoStaticInstance() {
        if (this.useErroreApplicativoStaticInstance == null) {
            Boolean defaultValue = true;
            String propertyName = "org.openspcoop2.protocol.spcoop.factory.erroreApplicativo.staticInstance";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.useErroreApplicativoStaticInstance = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue);
                    this.useErroreApplicativoStaticInstance = defaultValue;
                }
            }
            catch (Exception e) {
                this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue + ", errore:" + e.getMessage());
                this.useErroreApplicativoStaticInstance = defaultValue;
            }
        }
        return this.useErroreApplicativoStaticInstance;
    }

    private Boolean useEsitoStaticInstance() {
        if (this.useEsitoStaticInstance == null) {
            Boolean defaultValue = true;
            String propertyName = "org.openspcoop2.protocol.spcoop.factory.esito.staticInstance";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.useEsitoStaticInstance = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue);
                    this.useEsitoStaticInstance = defaultValue;
                }
            }
            catch (Exception e) {
                this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue + ", errore:" + e.getMessage());
                this.useEsitoStaticInstance = defaultValue;
            }
        }
        return this.useEsitoStaticInstance;
    }

    public BasicStaticInstanceConfig getStaticInstanceConfig() {
        if (this.staticInstanceConfig == null) {
            this.staticInstanceConfig = new BasicStaticInstanceConfig();
            if (this.useConfigStaticInstance() != null) {
                this.staticInstanceConfig.setStaticConfig(this.useConfigStaticInstance().booleanValue());
            }
            if (this.useErroreApplicativoStaticInstance() != null) {
                this.staticInstanceConfig.setStaticErrorBuilder(this.useErroreApplicativoStaticInstance().booleanValue());
            }
            if (this.useEsitoStaticInstance() != null) {
                this.staticInstanceConfig.setStaticEsitoBuilder(this.useEsitoStaticInstance().booleanValue());
            }
        }
        return this.staticInstanceConfig;
    }
}

