/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.spcoop.config;

import java.util.Map;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.basic.BasicComponentFactory;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.protocol.sdk.constants.FaultIntegrationGenericInfoMode;
import org.openspcoop2.protocol.sdk.constants.TipoIntegrazione;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.spcoop.config.SPCoopProperties;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.TransportResponseContext;

public class SPCoopProtocolManager
extends BasicComponentFactory
implements IProtocolManager {
    protected SPCoopProperties spcoopProperties = SPCoopProperties.getInstance(this.log);

    public SPCoopProtocolManager(IProtocolFactory<?> protocolFactory) throws ProtocolException {
        super(protocolFactory);
    }

    public IProtocolFactory<?> getProtocolFactory() {
        return this.protocolFactory;
    }

    public boolean isBustaServizio(Busta busta) {
        return busta.getServizio() == null && busta.getRiferimentoMessaggio() == null;
    }

    public String getKeywordTipoMittenteSconosciuto() {
        return this.spcoopProperties.getKeywordTipoMittenteSconosciuto();
    }

    public String getKeywordMittenteSconosciuto() {
        return this.spcoopProperties.getKeywordMittenteSconosciuto();
    }

    public long getIntervalloScadenzaBuste() {
        try {
            return this.spcoopProperties.getIntervalloScadenzaBuste();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public boolean isGenerazioneElementiNonValidabiliRispettoXSD() {
        return this.spcoopProperties.isGenerazioneElementiNonValidabiliRispettoXSD();
    }

    public boolean isIgnoraEccezioniNonGravi() {
        return this.spcoopProperties.isIgnoraEccezioniNonGravi();
    }

    public boolean isGenerazioneListaEccezioniErroreProcessamento() {
        return this.spcoopProperties.isGenerazioneListaEccezioniErroreProcessamento();
    }

    public boolean isGenerazioneDetailsFaultProtocollo_EccezioneValidazione() {
        return this.spcoopProperties.isGenerazioneDetailsSOAPFaultProtocolValidazione();
    }

    public boolean isGenerazioneDetailsFaultProtocollo_EccezioneProcessamento() {
        return this.spcoopProperties.isGenerazioneDetailsSOAPFaultProtocolProcessamento();
    }

    public boolean isGenerazioneDetailsFaultProtocolloConStackTrace() {
        return this.spcoopProperties.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace();
    }

    public boolean isGenerazioneDetailsFaultProtocolloConInformazioniGeneriche() {
        return this.spcoopProperties.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche();
    }

    public boolean isGenerazioneDetailsFaultIntegratione_erroreServer() {
        return this.spcoopProperties.isGenerazioneDetailsSOAPFaultIntegrationServerError();
    }

    public boolean isGenerazioneDetailsFaultIntegratione_erroreClient() {
        return this.spcoopProperties.isGenerazioneDetailsSOAPFaultIntegrationClientError();
    }

    public boolean isGenerazioneDetailsFaultIntegrationeConStackTrace() {
        return this.spcoopProperties.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace();
    }

    public FaultIntegrationGenericInfoMode getModalitaGenerazioneInformazioniGeneriche_DetailsFaultIntegrazione() {
        Boolean value = this.spcoopProperties.isGenerazioneDetailsSOAPFaultIntegrazionConInformazioniGeneriche();
        if (value == null) {
            return FaultIntegrationGenericInfoMode.SERVIZIO_APPLICATIVO;
        }
        if (value.booleanValue()) {
            return FaultIntegrationGenericInfoMode.ABILITATO;
        }
        return FaultIntegrationGenericInfoMode.DISABILITATO;
    }

    public BooleanNullable isAggiungiDetailErroreApplicativo_FaultApplicativo() {
        return this.spcoopProperties.isAggiungiDetailErroreApplicativo_SoapFaultApplicativo();
    }

    public BooleanNullable isAggiungiDetailErroreApplicativo_FaultPdD() {
        return this.spcoopProperties.isAggiungiDetailErroreApplicativo_SoapFaultPdD();
    }

    public Map<String, String> buildIntegrationProperties(Busta busta, boolean isRichiesta, TipoIntegrazione tipoIntegrazione) throws ProtocolException {
        return null;
    }

    public OpenSPCoop2Message updateOpenSPCoop2MessageRequest(OpenSPCoop2Message msg, Busta busta, IRegistryReader registryReader) throws ProtocolException {
        return msg;
    }

    public OpenSPCoop2Message updateOpenSPCoop2MessageResponse(OpenSPCoop2Message msg, Busta busta, NotifierInputStreamParams notifierInputStreamParams, TransportRequestContext transportRequestContext, TransportResponseContext transportResponseContext, IRegistryReader registryReader, boolean integration) throws ProtocolException {
        return msg;
    }

    public boolean isStaticRoute() throws ProtocolException {
        return false;
    }

    public Connettore getStaticRoute(IDSoggetto idSoggettoMittente, IDServizio idServizio, IRegistryReader registryReader) throws ProtocolException {
        return null;
    }

    public boolean isSuccessfulHttpRedirectStatusCode(ServiceBinding serviceBinding) throws ProtocolException {
        return false;
    }

    public boolean isHttpEmptyResponseOneWay() {
        return this.spcoopProperties.isHttpEmptyResponseOneWay();
    }

    public Integer getHttpReturnCodeEmptyResponseOneWay() {
        return this.spcoopProperties.getHttpReturnCodeEmptyResponseOneWay();
    }

    public boolean isHttpOneWay_PD_HTTPEmptyResponse() {
        return this.spcoopProperties.isHttpOneWay_PD_HTTPEmptyResponse();
    }

    public boolean isBlockedTransaction_responseMessageWithTransportCodeError() {
        return this.spcoopProperties.isResponseMessageWithTransportCodeError_blockedTransaction();
    }
}

