/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl.nearcache;

import com.hazelcast.cache.CacheStatistics;
import com.hazelcast.client.cache.impl.ClientCacheProxy;
import com.hazelcast.client.cache.impl.ClientCacheStatisticsImpl;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheAddNearCacheInvalidationListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveEntryListenerCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.ListenerMessageCodec;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.internal.adapter.ICacheDataStructureAdapter;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.impl.RemoteCallHook;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingHandler;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingTask;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CompletionListener;

public class NearCachedClientCacheProxy<K, V>
extends ClientCacheProxy<K, V> {
    private boolean useObjectKey;
    private boolean useObjectValue;
    private boolean cacheOnUpdate;
    private boolean invalidateOnChange;
    private UUID invalidationListenerId;
    private NearCacheManager nearCacheManager;
    private NearCache<Object, Object> nearCache;

    public NearCachedClientCacheProxy(CacheConfig<K, V> cacheConfig, ClientContext context) {
        super(cacheConfig, context);
    }

    public NearCache getNearCache() {
        return this.nearCache;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        ClientConfig clientConfig = this.getContext().getClientConfig();
        NearCacheConfig nearCacheConfig = NearCachedClientCacheProxy.checkNearCacheConfig(clientConfig.getNearCacheConfig(this.name), clientConfig.getNativeMemoryConfig());
        this.cacheOnUpdate = nearCacheConfig.getLocalUpdatePolicy() == NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE;
        this.invalidateOnChange = nearCacheConfig.isInvalidateOnChange();
        this.useObjectKey = !nearCacheConfig.isSerializeKeys();
        this.useObjectValue = nearCacheConfig.getInMemoryFormat() == InMemoryFormat.OBJECT;
        this.nearCacheManager = this.getContext().getNearCacheManager(this.getServiceName());
        this.nearCache = this.nearCacheManager.getOrCreateNearCache(this.nameWithPrefix, nearCacheConfig);
        CacheStatistics localCacheStatistics = super.getLocalCacheStatistics();
        ((ClientCacheStatisticsImpl)localCacheStatistics).setNearCacheStats(this.nearCache.getNearCacheStats());
        this.registerInvalidationListener();
        if (nearCacheConfig.getPreloaderConfig().isEnabled()) {
            this.nearCacheManager.startPreloading(this.nearCache, new ICacheDataStructureAdapter(this));
        }
    }

    private static NearCacheConfig checkNearCacheConfig(NearCacheConfig nearCacheConfig, NativeMemoryConfig nativeMemoryConfig) {
        InMemoryFormat inMemoryFormat = nearCacheConfig.getInMemoryFormat();
        if (inMemoryFormat != InMemoryFormat.NATIVE) {
            return nearCacheConfig;
        }
        Preconditions.checkTrue(nativeMemoryConfig.isEnabled(), "Enable native memory config to use NATIVE in-memory-format for Near Cache");
        return nearCacheConfig;
    }

    @Override
    protected V callGetSync(Object key, ExpiryPolicy expiryPolicy) {
        Object nearCacheKey = this.useObjectKey ? key : this.toData(key);
        Object value = this.getCachedValue(nearCacheKey, true);
        if (value != NearCache.NOT_CACHED) {
            return (V)value;
        }
        try {
            Data keyData = this.toData(nearCacheKey);
            long reservationId = this.nearCache.tryReserveForUpdate(nearCacheKey, keyData, NearCache.UpdateSemantic.READ_UPDATE);
            value = super.callGetSync(keyData, expiryPolicy);
            if (reservationId != -1L) {
                value = this.tryPublishReserved(nearCacheKey, value, reservationId);
            }
            return (V)value;
        }
        catch (Throwable throwable) {
            this.invalidateNearCache(nearCacheKey);
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    @Nonnull
    protected CompletableFuture<V> callGetAsync(Object key, ExpiryPolicy expiryPolicy, BiConsumer<V, Throwable> statsCallback) {
        Object nearCacheKey = this.useObjectKey ? key : this.toData(key);
        Object value = this.getCachedValue(nearCacheKey, false);
        if (value != NearCache.NOT_CACHED) {
            return CompletableFuture.completedFuture(value);
        }
        try {
            Data dataKey = this.toData(nearCacheKey);
            long reservationId = this.nearCache.tryReserveForUpdate(nearCacheKey, dataKey, NearCache.UpdateSemantic.READ_UPDATE);
            BiConsumer<V, Throwable> consumer = reservationId == -1L ? statsCallback : (valueData, throwable) -> {
                try {
                    if (statsCallback != null) {
                        statsCallback.accept((V)valueData, (Throwable)throwable);
                    }
                }
                finally {
                    if (throwable != null) {
                        this.invalidateNearCache(nearCacheKey);
                    } else {
                        this.tryPublishReserved(nearCacheKey, valueData, reservationId, false);
                    }
                }
            };
            return super.callGetAsync(dataKey, expiryPolicy, consumer);
        }
        catch (Throwable t) {
            this.invalidateNearCache(nearCacheKey);
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    protected V callPutSync(K key, Data keyData, V value, Data valueData, Data expiryPolicyData, boolean isGet) {
        Supplier<Object> remoteCallSupplier = () -> {
            try {
                return NearCachedClientCacheProxy.super.callPutSync(key, keyData, value, valueData, expiryPolicyData, isGet);
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        };
        return (V)this.byUpdatingNearCache(remoteCallSupplier, key, keyData, value, valueData, false);
    }

    @Override
    protected CompletableFuture<V> callPutAsync(K key, Data keyData, V value, Data valueData, Data expiryPolicyData, boolean isGet, boolean withCompletionEvent, BiConsumer<V, Throwable> statsCallback) {
        Supplier remoteCallSupplier = () -> NearCachedClientCacheProxy.super.callPutAsync(key, keyData, value, valueData, expiryPolicyData, isGet, withCompletionEvent, null);
        return this.byUpdatingNearCacheAsync(remoteCallSupplier, key, keyData, value, valueData, statsCallback, false);
    }

    @Override
    protected Boolean callPutIfAbsentSync(K key, Data keyData, V value, Data valueData, Data expiryPolicyData, boolean withCompletionEvent) {
        Supplier<Boolean> remoteCallSupplier = () -> {
            try {
                return NearCachedClientCacheProxy.super.callPutIfAbsentSync(key, keyData, value, valueData, expiryPolicyData, withCompletionEvent);
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        };
        return this.byUpdatingNearCache(remoteCallSupplier, key, keyData, value, valueData, true);
    }

    @Override
    protected CompletableFuture<Boolean> callPutIfAbsentAsync(K key, Data keyData, V value, Data valueData, Data expiryPolicyData, boolean withCompletionEvent, BiConsumer<Boolean, Throwable> statsCallback) {
        Supplier remoteCallSupplier = () -> NearCachedClientCacheProxy.super.callPutIfAbsentAsync(key, keyData, value, valueData, expiryPolicyData, withCompletionEvent, null);
        return this.byUpdatingNearCacheAsync(remoteCallSupplier, key, keyData, value, valueData, statsCallback, true);
    }

    @Override
    protected boolean callReplaceSync(K key, Data keyData, V newValue, Data newValueData, Data oldValueData, Data expiryPolicyData) {
        Supplier<Boolean> remoteCallSupplier = () -> {
            try {
                return NearCachedClientCacheProxy.super.callReplaceSync(key, keyData, newValue, newValueData, oldValueData, expiryPolicyData);
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        };
        return this.byUpdatingNearCache(remoteCallSupplier, key, keyData, newValue, newValueData, true);
    }

    @Override
    protected CompletableFuture<Boolean> callReplaceAsync(K key, Data keyData, V newValue, Data newValueData, Data oldValueData, Data expiryPolicyData, boolean withCompletionEvent, BiConsumer<Boolean, Throwable> statsCallback) {
        Supplier remoteCallSupplier = () -> NearCachedClientCacheProxy.super.callReplaceAsync(key, keyData, newValue, newValueData, oldValueData, expiryPolicyData, withCompletionEvent, null);
        return this.byUpdatingNearCacheAsync(remoteCallSupplier, key, keyData, newValue, newValueData, statsCallback, true);
    }

    @Override
    protected V callGetAndReplaceSync(K key, Data keyData, V newValue, Data newValueData, Data expiryPolicyData, boolean withCompletionEvent) {
        Supplier<Object> remoteCallSupplier = () -> {
            try {
                return NearCachedClientCacheProxy.super.callGetAndReplaceSync(key, keyData, newValue, newValueData, expiryPolicyData, withCompletionEvent);
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        };
        return (V)this.byUpdatingNearCache(remoteCallSupplier, key, keyData, newValue, newValueData, false);
    }

    @Override
    protected <T> CompletableFuture<T> callGetAndReplaceAsync(K key, Data keyData, V newValue, Data newValueData, Data expiryPolicyData, boolean withCompletionEvent, BiConsumer<T, Throwable> statsCallback) {
        Supplier<CompletableFuture<T>> remoteCallSupplier = () -> NearCachedClientCacheProxy.super.callGetAndReplaceAsync(key, keyData, newValue, newValueData, expiryPolicyData, withCompletionEvent, null);
        return this.byUpdatingNearCacheAsync(remoteCallSupplier, key, keyData, newValue, newValueData, statsCallback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean callRemoveSync(K key, Data keyData, Data oldValueData, boolean withCompletionEvent) {
        try {
            boolean bl = super.callRemoveSync(key, keyData, oldValueData, withCompletionEvent);
            return bl;
        }
        finally {
            this.invalidateNearCache(this.toNearCacheKey(key, keyData));
        }
    }

    @Override
    protected CompletableFuture<Boolean> callRemoveAsync(K key, Data keyData, Data oldValueData, boolean withCompletionEvent, BiConsumer<Boolean, Throwable> statsCallback) {
        CompletableFuture<Boolean> future = super.callRemoveAsync(key, keyData, oldValueData, withCompletionEvent, null);
        return future.whenCompleteAsync((removed, throwable) -> {
            try {
                if (statsCallback != null) {
                    statsCallback.accept((Boolean)removed, (Throwable)throwable);
                }
            }
            finally {
                this.invalidateNearCache(this.toNearCacheKey(key, keyData));
            }
        }, ConcurrencyUtil.getDefaultAsyncExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    protected V callGetAndRemoveSync(K key, Data keyData) {
        try {
            Object v = super.callGetAndRemoveSync(key, keyData);
            return v;
        }
        finally {
            this.invalidateNearCache(this.toNearCacheKey(key, keyData));
        }
    }

    @Override
    @Nonnull
    protected <T> CompletableFuture<T> callGetAndRemoveAsync(K key, Data keyData, BiConsumer<T, Throwable> statsCallback) {
        CompletableFuture future = super.callGetAndRemoveAsync(key, keyData, null);
        return future.whenCompleteAsync((t, throwable) -> {
            if (statsCallback != null) {
                statsCallback.accept((Object)t, (Throwable)throwable);
            }
            this.invalidateNearCache(this.toNearCacheKey(key, keyData));
        }, ConcurrencyUtil.getDefaultAsyncExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getAllInternal(Set<? extends K> keys, Collection<Data> dataKeys, ExpiryPolicy expiryPolicy, List<Object> resultingKeyValuePairs, long startNanos) {
        if (!this.useObjectKey) {
            this.toDataKeysWithReservations(keys, (Collection<Data>)dataKeys, null, null);
        }
        LinkedList<K> ncKeys = this.useObjectKey ? new LinkedList<K>(keys) : dataKeys;
        this.populateResultFromNearCache(ncKeys, resultingKeyValuePairs);
        if (ncKeys.isEmpty()) {
            return;
        }
        Map<Object, Long> reservations = MapUtil.createHashMap(ncKeys.size());
        Map<Data, Object> reverseKeyMap = null;
        if (this.useObjectKey) {
            reverseKeyMap = MapUtil.createHashMap(ncKeys.size());
            this.toDataKeysWithReservations(ncKeys, dataKeys, reservations, reverseKeyMap);
        } else {
            this.createNearCacheReservations(ncKeys, reservations);
        }
        try {
            int currentSize = resultingKeyValuePairs.size();
            super.getAllInternal(keys, dataKeys, expiryPolicy, resultingKeyValuePairs, startNanos);
            this.populateResultFromRemote(currentSize, resultingKeyValuePairs, reservations, reverseKeyMap);
        }
        finally {
            this.releaseRemainingReservedKeys(reservations);
        }
    }

    private void toDataKeysWithReservations(Collection<?> keys, Collection<Data> dataKeys, Map<Object, Long> reservations, Map<Data, Object> reverseKeyMap) {
        for (Object key : keys) {
            long reservationId;
            Data keyData = this.toData(key);
            if (reservations != null && (reservationId = this.nearCache.tryReserveForUpdate(key, keyData, NearCache.UpdateSemantic.READ_UPDATE)) != -1L) {
                reservations.put(key, reservationId);
            }
            if (reverseKeyMap != null) {
                reverseKeyMap.put(keyData, key);
            }
            dataKeys.add(keyData);
        }
    }

    private void populateResultFromNearCache(Collection<?> keys, List<Object> resultingKeyValuePairs) {
        Iterator<?> iterator = keys.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object cached = this.getCachedValue(key, true);
            if (cached == NearCache.NOT_CACHED) continue;
            resultingKeyValuePairs.add(key);
            resultingKeyValuePairs.add(cached);
            iterator.remove();
        }
    }

    private void createNearCacheReservations(Collection<Data> dataKeys, Map<Object, Long> reservations) {
        for (Data key : dataKeys) {
            long reservationId = this.nearCache.tryReserveForUpdate(key, key, NearCache.UpdateSemantic.READ_UPDATE);
            if (reservationId == -1L) continue;
            reservations.put(key, reservationId);
        }
    }

    private void populateResultFromRemote(int currentSize, List<Object> resultingKeyValuePairs, Map<Object, Long> reservations, Map<Data, Object> reverseKeyMap) {
        for (int i = currentSize; i < resultingKeyValuePairs.size(); i += 2) {
            Long reservationId;
            Data ncKey;
            Data keyData = (Data)resultingKeyValuePairs.get(i);
            Data valueData = (Data)resultingKeyValuePairs.get(i + 1);
            Data data = ncKey = this.useObjectKey ? reverseKeyMap.get(keyData) : keyData;
            if (this.useObjectKey) {
                resultingKeyValuePairs.set(i, ncKey);
            }
            if ((reservationId = reservations.get(ncKey)) == null) continue;
            Object cachedValue = this.tryPublishReserved(ncKey, valueData, reservationId);
            resultingKeyValuePairs.set(i + 1, cachedValue);
            reservations.remove(ncKey);
        }
    }

    @Override
    public void setExpiryPolicyInternal(Set<? extends K> keys, ExpiryPolicy expiryPolicy) {
        HashSet<Data> serializedKeys = null;
        if (!this.useObjectKey) {
            serializedKeys = new HashSet<Data>(keys.size());
        }
        super.setExpiryPolicyInternal(keys, expiryPolicy, serializedKeys);
        this.invalidate(keys, serializedKeys);
    }

    @Override
    protected boolean setExpiryPolicyInternal(K key, ExpiryPolicy expiryPolicy) {
        boolean result = super.setExpiryPolicyInternal(key, expiryPolicy);
        if (this.useObjectKey) {
            this.invalidateNearCache(key);
        } else {
            this.invalidateNearCache(this.toData(key));
        }
        return result;
    }

    @Override
    protected void callPutAllSync(List<Map.Entry<Data, Data>>[] entriesPerPartition, Data expiryPolicyData, RemoteCallHook<K, V> nearCachingHook, long startNanos) {
        try {
            super.callPutAllSync(entriesPerPartition, expiryPolicyData, nearCachingHook, startNanos);
            nearCachingHook.onRemoteCallSuccess(null);
        }
        catch (Throwable t) {
            nearCachingHook.onRemoteCallFailure();
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    protected RemoteCallHook<K, V> createPutAllNearCachingHook(int keySetSize) {
        return this.cacheOnUpdate ? new PutAllCacheOnUpdateHook(keySetSize) : new PutAllInvalidateHook(keySetSize);
    }

    private void invalidate(Set<? extends K> keys, Set<Data> keysData) {
        if (this.useObjectKey) {
            for (K key : keys) {
                this.invalidateNearCache(key);
            }
        } else {
            for (Data key : keysData) {
                this.invalidateNearCache(key);
            }
        }
    }

    @Override
    protected boolean containsKeyInternal(Object key) {
        key = this.useObjectKey ? key : this.toData(key);
        Object cached = this.getCachedValue(key, false);
        if (cached != NearCache.NOT_CACHED) {
            return cached != null;
        }
        return super.containsKeyInternal(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadAllInternal(Set<? extends K> keys, List<Data> dataKeys, boolean replaceExistingValues, CompletionListener completionListener) {
        try {
            super.loadAllInternal(keys, dataKeys, replaceExistingValues, completionListener);
        }
        finally {
            if (this.useObjectKey) {
                for (K key : keys) {
                    this.invalidateNearCache(key);
                }
            } else {
                for (Data dataKey : dataKeys) {
                    this.invalidateNearCache(dataKey);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeAllKeysInternal(Set<? extends K> keys, Collection<Data> dataKeys, long startNanos) {
        try {
            super.removeAllKeysInternal(keys, dataKeys, startNanos);
        }
        finally {
            if (this.useObjectKey) {
                for (K key : keys) {
                    this.invalidateNearCache(key);
                }
            } else {
                for (Data dataKey : dataKeys) {
                    this.invalidateNearCache(dataKey);
                }
            }
        }
    }

    @Override
    public void removeAll() {
        try {
            super.removeAll();
        }
        finally {
            this.nearCache.clear();
        }
    }

    @Override
    public void clear() {
        try {
            super.clear();
        }
        finally {
            this.nearCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object invokeInternal(Object key, Data epData, Object[] arguments) {
        key = this.useObjectKey ? key : this.toData(key);
        try {
            Object object = super.invokeInternal(key, epData, arguments);
            return object;
        }
        finally {
            this.invalidateNearCache(key);
        }
    }

    @Override
    public void close() {
        try {
            this.removeInvalidationListener();
            this.nearCacheManager.clearNearCache(this.nearCache.getName());
        }
        finally {
            super.close();
        }
    }

    @Override
    protected void postDestroy() {
        try {
            this.destroyNearCache();
        }
        finally {
            super.postDestroy();
        }
    }

    @Override
    protected void onShutdown() {
        try {
            this.destroyNearCache();
        }
        finally {
            super.onShutdown();
        }
    }

    private void destroyNearCache() {
        this.removeInvalidationListener();
        this.nearCacheManager.destroyNearCache(this.nearCache.getName());
    }

    private Object getCachedValue(Object key, boolean deserializeValue) {
        Object cached = this.nearCache.get(key);
        assert (cached != NearCache.CACHED_AS_NULL);
        if (cached == null) {
            return NearCache.NOT_CACHED;
        }
        return deserializeValue ? this.toObject(cached) : cached;
    }

    private void invalidateNearCache(Object key) {
        assert (key != null);
        this.nearCache.invalidate(key);
    }

    private Object tryPublishReserved(Object key, Object remoteValue, long reservationId, boolean deserializeReturnedValue) {
        assert (remoteValue != NearCache.NOT_CACHED);
        if (remoteValue == null) {
            this.invalidateNearCache(key);
            return null;
        }
        Object cachedValue = null;
        if (reservationId != -1L) {
            cachedValue = this.nearCache.tryPublishReserved(key, remoteValue, reservationId, deserializeReturnedValue);
        }
        return cachedValue == null ? remoteValue : cachedValue;
    }

    private Object tryPublishReserved(Object key, Object remoteValue, long reservationId) {
        return this.tryPublishReserved(key, remoteValue, reservationId, true);
    }

    private void releaseRemainingReservedKeys(Map<Object, Long> reservedKeys) {
        for (Object key : reservedKeys.keySet()) {
            this.nearCache.invalidate(key);
        }
    }

    UUID addNearCacheInvalidationListener(EventHandler eventHandler) {
        return this.registerListener(this.createNearCacheInvalidationListenerCodec(), eventHandler);
    }

    private ListenerMessageCodec createNearCacheInvalidationListenerCodec() {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return CacheAddNearCacheInvalidationListenerCodec.encodeRequest(NearCachedClientCacheProxy.this.nameWithPrefix, localOnly);
            }

            @Override
            public UUID decodeAddResponse(ClientMessage clientMessage) {
                return CacheAddNearCacheInvalidationListenerCodec.decodeResponse(clientMessage);
            }

            @Override
            public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
                return CacheRemoveEntryListenerCodec.encodeRequest(NearCachedClientCacheProxy.this.nameWithPrefix, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return CacheRemoveEntryListenerCodec.decodeResponse(clientMessage);
            }
        };
    }

    private void registerInvalidationListener() {
        if (!this.invalidateOnChange) {
            return;
        }
        NearCacheInvalidationEventHandler eventHandler = new NearCacheInvalidationEventHandler();
        this.invalidationListenerId = this.addNearCacheInvalidationListener(eventHandler);
    }

    private void removeInvalidationListener() {
        if (!this.invalidateOnChange) {
            return;
        }
        UUID registrationId = this.invalidationListenerId;
        if (registrationId != null) {
            this.getContext().getRepairingTask(this.getServiceName()).deregisterHandler(this.nameWithPrefix);
            this.getContext().getListenerService().deregisterListener(registrationId);
        }
    }

    private <T> T byUpdatingNearCache(Supplier<T> remoteCallSupplier, K key, Data keyData, V value, Data valueData, boolean calledByBooleanMethod) {
        Object nearCacheKey = this.toNearCacheKey(key, keyData);
        try {
            long reservationId = this.cacheOnUpdate ? this.nearCache.tryReserveForUpdate(nearCacheKey, keyData, NearCache.UpdateSemantic.WRITE_UPDATE) : -1L;
            T response = remoteCallSupplier.get();
            if (!(reservationId == -1L || calledByBooleanMethod && response instanceof Boolean && !((Boolean)response).booleanValue())) {
                Object nearCacheValue = this.toNearCacheValue(value, valueData);
                this.tryPublishReserved(nearCacheKey, nearCacheValue, reservationId, false);
            } else {
                this.invalidateNearCache(nearCacheKey);
            }
            return response;
        }
        catch (Throwable t) {
            this.invalidateNearCache(nearCacheKey);
            throw ExceptionUtil.rethrow(t);
        }
    }

    private <T> CompletableFuture<T> byUpdatingNearCacheAsync(Supplier<CompletableFuture<T>> remoteCallSupplier, K key, Data keyData, V value, Data valueData, BiConsumer<T, Throwable> statsCallback, boolean calledByBooleanMethod) {
        Object nearCacheKey = this.toNearCacheKey(key, keyData);
        long reservationId = this.cacheOnUpdate ? this.nearCache.tryReserveForUpdate(nearCacheKey, keyData, NearCache.UpdateSemantic.WRITE_UPDATE) : -1L;
        CompletableFuture<T> future = remoteCallSupplier.get();
        if (reservationId != -1L) {
            return future.whenCompleteAsync((response, throwable) -> {
                if (statsCallback != null) {
                    statsCallback.accept((Object)response, (Throwable)throwable);
                }
                if (throwable != null) {
                    this.invalidateNearCache(nearCacheKey);
                } else if (!calledByBooleanMethod || !(response instanceof Boolean) || ((Boolean)response).booleanValue()) {
                    Object nearCacheValue = this.toNearCacheValue(value, valueData);
                    this.tryPublishReserved(nearCacheKey, nearCacheValue, reservationId, false);
                } else {
                    this.invalidateNearCache(nearCacheKey);
                }
            }, ConcurrencyUtil.getDefaultAsyncExecutor());
        }
        return future.whenCompleteAsync((response, throwable) -> {
            if (statsCallback != null) {
                statsCallback.accept((Object)response, (Throwable)throwable);
            }
            this.invalidateNearCache(nearCacheKey);
        }, ConcurrencyUtil.getDefaultAsyncExecutor());
    }

    private Object toNearCacheKey(K key, Data keyData) {
        return this.useObjectKey ? key : keyData;
    }

    private Object toNearCacheValue(V value, Data valueData) {
        return this.useObjectValue ? value : valueData;
    }

    private final class NearCacheInvalidationEventHandler
    extends CacheAddNearCacheInvalidationListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private volatile RepairingHandler repairingHandler;

        private NearCacheInvalidationEventHandler() {
        }

        @Override
        public void beforeListenerRegister(Connection connection) {
            RepairingTask repairingTask = NearCachedClientCacheProxy.this.getContext().getRepairingTask(NearCachedClientCacheProxy.this.getServiceName());
            this.repairingHandler = repairingTask.registerAndGetHandler(NearCachedClientCacheProxy.this.nameWithPrefix, NearCachedClientCacheProxy.this.nearCache);
        }

        @Override
        public void handleCacheInvalidationEvent(String name, Data key, UUID sourceUuid, UUID partitionUuid, long sequence) {
            this.repairingHandler.handle(key, sourceUuid, partitionUuid, sequence);
        }

        @Override
        public void handleCacheBatchInvalidationEvent(String name, Collection<Data> keys, Collection<UUID> sourceUuids, Collection<UUID> partitionUuids, Collection<Long> sequences) {
            this.repairingHandler.handle(keys, sourceUuids, partitionUuids, sequences);
        }
    }

    private class PutAllInvalidateHook
    implements RemoteCallHook<K, V> {
        private final List<Object> nearCacheKeys;

        PutAllInvalidateHook(int keySetSize) {
            this.nearCacheKeys = new ArrayList<Object>(keySetSize);
        }

        @Override
        public void beforeRemoteCall(K key, Data keyData, V value, Data valueData) {
            this.nearCacheKeys.add(NearCachedClientCacheProxy.this.toNearCacheKey(key, keyData));
        }

        @Override
        public void onRemoteCallSuccess(@Nullable Operation remoteCall) {
            for (Object nearCacheKey : this.nearCacheKeys) {
                NearCachedClientCacheProxy.this.invalidateNearCache(nearCacheKey);
            }
        }

        @Override
        public void onRemoteCallFailure() {
            this.onRemoteCallSuccess(null);
        }
    }

    private class PutAllCacheOnUpdateHook
    implements RemoteCallHook<K, V> {
        private final List<Object> keyValueId;

        PutAllCacheOnUpdateHook(int keySetSize) {
            this.keyValueId = new ArrayList<Object>(keySetSize * 3);
        }

        @Override
        public void beforeRemoteCall(K key, Data keyData, V value, Data valueData) {
            this.keyValueId.add(NearCachedClientCacheProxy.this.toNearCacheKey(key, keyData));
            this.keyValueId.add(NearCachedClientCacheProxy.this.toNearCacheValue(value, valueData));
            this.keyValueId.add(NearCachedClientCacheProxy.this.nearCache.tryReserveForUpdate(NearCachedClientCacheProxy.this.toNearCacheKey(key, keyData), keyData, NearCache.UpdateSemantic.WRITE_UPDATE));
        }

        @Override
        public void onRemoteCallSuccess(Operation remoteCall) {
            for (int i = 0; i < this.keyValueId.size(); i += 3) {
                Object nearCacheKey = this.keyValueId.get(i);
                Object nearCacheValue = this.keyValueId.get(i + 1);
                long reservationId = (Long)this.keyValueId.get(i + 2);
                if (reservationId != -1L) {
                    NearCachedClientCacheProxy.this.tryPublishReserved(nearCacheKey, nearCacheValue, reservationId, false);
                    continue;
                }
                NearCachedClientCacheProxy.this.invalidateNearCache(nearCacheKey);
            }
        }

        @Override
        public void onRemoteCallFailure() {
            for (int i = 0; i < this.keyValueId.size(); i += 3) {
                NearCachedClientCacheProxy.this.invalidateNearCache(this.keyValueId.get(i));
            }
        }
    }
}

