/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAuthenticationCodec;
import com.hazelcast.client.impl.protocol.task.AuthenticationBaseMessageTask;
import com.hazelcast.cluster.Address;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.security.UsernamePasswordCredentials;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;

public class AuthenticationMessageTask
extends AuthenticationBaseMessageTask<ClientAuthenticationCodec.RequestParameters> {
    public AuthenticationMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected ClientAuthenticationCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        ClientAuthenticationCodec.RequestParameters parameters = ClientAuthenticationCodec.decodeRequest(clientMessage);
        assert (parameters.uuid != null);
        this.clientUuid = parameters.uuid;
        this.clusterName = parameters.clusterName;
        this.credentials = new UsernamePasswordCredentials(parameters.username, parameters.password);
        this.clientSerializationVersion = parameters.serializationVersion;
        this.clientVersion = parameters.clientHazelcastVersion;
        this.clientName = parameters.clientName;
        this.labels = Collections.unmodifiableSet(new HashSet<String>(parameters.labels));
        return parameters;
    }

    @Override
    protected ClientMessage encodeAuth(byte status, Address thisAddress, UUID uuid, byte serializationVersion, String serverVersion, int partitionCount, UUID clusterId, boolean clientFailoverSupported, List<Integer> tpcPorts, byte[] tpcToken) {
        return ClientAuthenticationCodec.encodeResponse(status, thisAddress, uuid, serializationVersion, serverVersion, partitionCount, clusterId, clientFailoverSupported);
    }

    @Override
    protected String getClientType() {
        return ((ClientAuthenticationCodec.RequestParameters)this.parameters).clientType;
    }
}

