/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.spi.atomic;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class RaftAtomicValueSnapshot<T>
implements IdentifiedDataSerializable {
    protected Map<String, T> values = Collections.emptyMap();
    protected Set<String> destroyed = Collections.emptySet();

    public RaftAtomicValueSnapshot() {
    }

    public RaftAtomicValueSnapshot(Map<String, T> values, Set<String> destroyed) {
        this.values = values;
        this.destroyed = destroyed;
    }

    public Iterable<Map.Entry<String, T>> getValues() {
        return this.values.entrySet();
    }

    public Set<String> getDestroyed() {
        return this.destroyed;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.values.size());
        for (Map.Entry<String, T> entry : this.values.entrySet()) {
            out.writeString(entry.getKey());
            this.writeValue(out, entry.getValue());
        }
        out.writeInt(this.destroyed.size());
        for (String name : this.destroyed) {
            out.writeString(name);
        }
    }

    protected abstract void writeValue(ObjectDataOutput var1, T var2) throws IOException;

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        String name;
        int i;
        int len = in.readInt();
        this.values = new HashMap<String, T>(len);
        for (i = 0; i < len; ++i) {
            name = in.readString();
            T value = this.readValue(in);
            this.values.put(name, value);
        }
        len = in.readInt();
        this.destroyed = new HashSet<String>(len);
        for (i = 0; i < len; ++i) {
            name = in.readString();
            this.destroyed.add(name);
        }
    }

    protected abstract T readValue(ObjectDataInput var1) throws IOException;
}

