/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.operation.unsafe;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.RaftServiceDataSerializerHook;
import com.hazelcast.cp.internal.raft.SnapshotAwareService;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.Map;

public class UnsafeSnapshotReplicationOp
extends Operation
implements IdentifiedDataSerializable {
    private Map<CPGroupId, Object> snapshots;

    public UnsafeSnapshotReplicationOp() {
    }

    public UnsafeSnapshotReplicationOp(Map<CPGroupId, Object> snapshots) {
        this.snapshots = snapshots;
    }

    @Override
    public void run() throws Exception {
        SnapshotAwareService service = (SnapshotAwareService)this.getService();
        for (Map.Entry<CPGroupId, Object> entry : this.snapshots.entrySet()) {
            CPGroupId groupId = entry.getKey();
            service.restoreSnapshot(groupId, 0L, entry.getValue());
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        SerializationUtil.writeMap(this.snapshots, out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.snapshots = SerializationUtil.readMap(in);
    }

    @Override
    public int getFactoryId() {
        return RaftServiceDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 45;
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", snapshots=").append(this.snapshots);
    }
}

