/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl.executejar;

import com.hazelcast.instance.impl.executejar.MainClassNameFinder;
import com.hazelcast.instance.impl.executejar.MainMethodFinder;
import com.hazelcast.jet.JetException;
import java.io.IOException;
import java.lang.reflect.Method;

final class ExecuteJarHelper {
    private ExecuteJarHelper() {
    }

    static String findMainClassNameForJar(String jarPath, String mainClassName) throws IOException {
        MainClassNameFinder mainClassNameFinder = new MainClassNameFinder();
        mainClassNameFinder.findMainClass(jarPath, mainClassName);
        if (mainClassNameFinder.hasError()) {
            String errorMessage = mainClassNameFinder.getErrorMessage();
            throw new JetException(errorMessage);
        }
        return mainClassNameFinder.getMainClassName();
    }

    static Method findMainMethodForJar(ClassLoader classLoader, String mainClassName) throws ClassNotFoundException {
        MainMethodFinder mainMethodFinder = new MainMethodFinder();
        mainMethodFinder.findMainMethod(classLoader, mainClassName);
        if (mainMethodFinder.hasError()) {
            String errorMessage = mainMethodFinder.getErrorMessage();
            throw new JetException(errorMessage);
        }
        return mainMethodFinder.getMainMethod();
    }
}

