/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl.executejar;

import com.hazelcast.instance.impl.HazelcastBootstrap;
import com.hazelcast.instance.impl.executejar.JarScanner;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.IOException;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class MainClassNameFinder {
    private static final ILogger LOGGER = Logger.getLogger(MainClassNameFinder.class);
    private String errorMessage;
    private String mainClassName;

    String getErrorMessage() {
        return this.errorMessage;
    }

    String getMainClassName() {
        return this.mainClassName;
    }

    boolean hasError() {
        return !StringUtil.isNullOrEmpty(this.errorMessage);
    }

    public void findMainClass(String jarPath, String mainClassName) throws IOException {
        try (JarFile jarFile = new JarFile(jarPath);){
            this.checkHazelcastCodebasePresence(jarFile);
            this.mainClassName = mainClassName;
            if (StringUtil.isNullOrEmpty(this.mainClassName)) {
                Manifest manifest = jarFile.getManifest();
                if (manifest == null) {
                    this.errorMessage = "No manifest file in the jar";
                    return;
                }
                Attributes mainAttributes = manifest.getMainAttributes();
                this.mainClassName = mainAttributes.getValue("Main-Class");
                if (this.mainClassName == null) {
                    this.errorMessage = "No Main-Class found in the manifest of the jar";
                }
            }
        }
    }

    private void checkHazelcastCodebasePresence(JarFile jarFile) {
        List<String> classFiles = JarScanner.findClassFiles(jarFile, HazelcastBootstrap.class.getSimpleName());
        if (!classFiles.isEmpty()) {
            String message = String.format("WARNING: Hazelcast code detected in the jar: %s. Hazelcast dependency should be set with the 'provided' scope or equivalent.%n", String.join((CharSequence)", ", classFiles));
            LOGGER.info(message);
        }
    }
}

