/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.events;

import com.hazelcast.internal.config.ConfigNamespace;
import com.hazelcast.internal.dynamicconfig.ConfigUpdateResult;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.management.events.AbstractConfigUpdateEvent;
import com.hazelcast.internal.management.events.EventMetadata;
import java.util.UUID;

public class ConfigUpdateFailedEvent
extends AbstractConfigUpdateEvent {
    private final FailureReason failureReason;
    private final Exception exception;
    private final ConfigNamespace namespace;
    private final ConfigUpdateResult configUpdateResult;

    public ConfigUpdateFailedEvent(UUID uuid, FailureReason failureReason, Exception exception, ConfigNamespace namespace, ConfigUpdateResult configUpdateResult) {
        super(uuid);
        this.failureReason = failureReason;
        this.exception = exception;
        this.namespace = namespace;
        this.configUpdateResult = configUpdateResult;
    }

    @Override
    public EventMetadata.EventType getType() {
        return EventMetadata.EventType.CONFIG_UPDATE_FAILED;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.add("failureReason", this.failureReason.toString());
        json.add("exception", this.exception.getClass().getSimpleName());
        json.add("exceptionMessage", this.exception.getMessage());
        json.add("configUpdateResult", this.configUpdateResult.toJson());
        if (this.namespace != null) {
            json.add("configName", this.namespace.getConfigName() != null ? this.namespace.getConfigName() : "null");
            json.add("sectionName", this.namespace.getSectionName());
        }
        return json;
    }

    public Exception getException() {
        return this.exception;
    }

    public ConfigNamespace getNamespace() {
        return this.namespace;
    }

    public ConfigUpdateResult getConfigUpdateResult() {
        return this.configUpdateResult;
    }

    public FailureReason getFailureReason() {
        return this.failureReason;
    }

    public static enum FailureReason {
        PARSING_FAILURE,
        SCHEMA_VALIDATION_FAILURE,
        GENERIC_FAILURE,
        INVALID_LICENSE;

    }
}

