/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.internal.metrics.DoubleProbeFunction;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.LongProbeFunction;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.ProbeFunction;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.metrics.collectors.MetricsCollector;
import com.hazelcast.internal.metrics.impl.AbstractGauge;
import com.hazelcast.internal.metrics.impl.FieldProbe;
import com.hazelcast.internal.metrics.impl.MethodProbe;
import com.hazelcast.internal.metrics.impl.MetricDescriptorImpl;
import com.hazelcast.internal.metrics.impl.MetricDescriptorReusableData;
import com.hazelcast.internal.metrics.impl.MetricValueCatcher;
import com.hazelcast.internal.metrics.impl.MetricsUtil;
import com.hazelcast.internal.metrics.impl.PoolingMetricDescriptorSupplier;
import com.hazelcast.internal.metrics.impl.ProbeInstance;
import com.hazelcast.internal.metrics.impl.SourceMetadata;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;

class MetricsCollectionCycle {
    private static final MetricValueCatcher NOOP_CATCHER = new NoOpMetricValueCatcher();
    private final PoolingMetricDescriptorSupplier descriptorSupplier;
    private final Function<Class, SourceMetadata> lookupMetadataFn;
    private final Function<MetricDescriptor, MetricValueCatcher> lookupMetricValueCatcherFn;
    private final MetricsCollector metricsCollector;
    private final ProbeLevel minimumLevel;
    private final MetricsContext metricsContext = new MetricsContext();
    private final long collectionId = System.nanoTime();
    private final ILogger logger = Logger.getLogger(MetricsCollectionCycle.class);

    MetricsCollectionCycle(Function<Class, SourceMetadata> lookupMetadataFn, Function<MetricDescriptor, MetricValueCatcher> lookupMetricValueCatcherFn, MetricsCollector metricsCollector, ProbeLevel minimumLevel, MetricDescriptorReusableData metricDescriptorReusableData) {
        this.lookupMetadataFn = lookupMetadataFn;
        this.lookupMetricValueCatcherFn = lookupMetricValueCatcherFn;
        this.metricsCollector = metricsCollector;
        this.minimumLevel = minimumLevel;
        this.descriptorSupplier = metricDescriptorReusableData == null ? new PoolingMetricDescriptorSupplier() : new PoolingMetricDescriptorSupplier(metricDescriptorReusableData);
    }

    void collectStaticMetrics(Map<MetricDescriptorImpl.LookupView, ProbeInstance> probeInstanceEntries) {
        for (Map.Entry<MetricDescriptorImpl.LookupView, ProbeInstance> entry : probeInstanceEntries.entrySet()) {
            MetricDescriptorImpl.LookupView lookupView = entry.getKey();
            ProbeInstance probeInstance = entry.getValue();
            ProbeFunction function = probeInstance.function;
            this.lookupMetricValueCatcher(lookupView.descriptor()).catchMetricValue(this.collectionId, probeInstance, function);
            if (function instanceof LongProbeFunction) {
                this.collectLong(probeInstance.source, probeInstance.descriptor, (LongProbeFunction)function);
                continue;
            }
            if (function instanceof DoubleProbeFunction) {
                this.collectDouble(probeInstance.source, probeInstance.descriptor, (DoubleProbeFunction)function);
                continue;
            }
            throw new IllegalStateException("Unhandled ProbeFunction encountered: " + function.getClass().getName());
        }
    }

    void collectDynamicMetrics(Collection<DynamicMetricsProvider> metricsSources) {
        for (DynamicMetricsProvider metricsSource : metricsSources) {
            try {
                metricsSource.provideDynamicMetrics(this.descriptorSupplier.get(), this.metricsContext);
            }
            catch (Throwable t) {
                this.logger.warning("Collecting metrics from source " + metricsSource.getClass().getName() + " failed", t);
                assert (false) : "Collecting metrics from source " + metricsSource.getClass().getName() + " failed\n" + ExceptionUtil.toString(t);
            }
        }
    }

    void notifyAllGauges(Collection<AbstractGauge> gauges) {
        for (AbstractGauge gauge : gauges) {
            if (gauge == null) continue;
            gauge.onCollectionCompleted(this.collectionId);
        }
    }

    private MetricValueCatcher lookupMetricValueCatcher(MetricDescriptor descriptor) {
        MetricValueCatcher catcher = this.lookupMetricValueCatcherFn.apply(descriptor);
        return catcher != null ? catcher : NOOP_CATCHER;
    }

    private void extractAndCollectDynamicMetrics(MetricDescriptor descriptor, Object source) {
        MetricDescriptor descriptorCopy;
        SourceMetadata metadata = this.lookupMetadataFn.apply(source.getClass());
        for (MethodProbe methodProbe : metadata.methods()) {
            if (!methodProbe.probe.level().isEnabled(this.minimumLevel)) continue;
            descriptorCopy = descriptor.copy().withUnit(methodProbe.probe.unit()).withMetric(methodProbe.getProbeName()).withExcludedTargets(MetricsUtil.extractExcludedTargets(methodProbe, this.minimumLevel));
            this.lookupMetricValueCatcher(descriptorCopy).catchMetricValue(this.collectionId, source, methodProbe);
            this.collect(descriptorCopy, source, methodProbe);
        }
        for (FieldProbe fieldProbe : metadata.fields()) {
            if (!fieldProbe.probe.level().isEnabled(this.minimumLevel)) continue;
            descriptorCopy = descriptor.copy().withUnit(fieldProbe.probe.unit()).withMetric(fieldProbe.getProbeName()).withExcludedTargets(MetricsUtil.extractExcludedTargets(fieldProbe, this.minimumLevel));
            this.lookupMetricValueCatcher(descriptorCopy).catchMetricValue(this.collectionId, source, fieldProbe);
            this.collect(descriptorCopy, source, fieldProbe);
        }
    }

    private void collect(MetricDescriptor descriptor, Object source, ProbeFunction function) {
        if (function == null || source == null) {
            this.metricsCollector.collectNoValue(descriptor);
            return;
        }
        if (function instanceof LongProbeFunction) {
            LongProbeFunction longFunction = (LongProbeFunction)function;
            this.collectLong(source, descriptor, longFunction);
        } else {
            DoubleProbeFunction doubleFunction = (DoubleProbeFunction)function;
            this.collectDouble(source, descriptor, doubleFunction);
        }
        if (descriptor instanceof MetricDescriptorImpl) {
            this.descriptorSupplier.recycle((MetricDescriptorImpl)descriptor);
        }
    }

    private void collectDouble(Object source, MetricDescriptor descriptor, DoubleProbeFunction function) {
        try {
            double value = function.get(source);
            this.metricsCollector.collectDouble(descriptor, value);
        }
        catch (Exception ex) {
            this.metricsCollector.collectException(descriptor, ex);
        }
    }

    private void collectLong(Object source, MetricDescriptor descriptor, LongProbeFunction function) {
        try {
            long value = function.get(source);
            this.metricsCollector.collectLong(descriptor, value);
        }
        catch (Exception ex) {
            this.metricsCollector.collectException(descriptor, ex);
        }
    }

    public MetricDescriptorReusableData cleanUp() {
        return this.descriptorSupplier.close();
    }

    private static final class NoOpMetricValueCatcher
    implements MetricValueCatcher {
        private NoOpMetricValueCatcher() {
        }

        @Override
        public void catchMetricValue(long collectionId, Object source, ProbeFunction function) {
        }

        @Override
        public void catchMetricValue(long collectionId, long value) {
        }

        @Override
        public void catchMetricValue(long collectionId, double value) {
        }
    }

    private class MetricsContext
    implements MetricsCollectionContext {
        private MetricsContext() {
        }

        @Override
        public void collect(MetricDescriptor descriptor, Object source) {
            MetricsCollectionCycle.this.extractAndCollectDynamicMetrics(descriptor, source);
        }

        @Override
        public void collect(MetricDescriptor descriptor, String name, ProbeLevel level, ProbeUnit unit, long value) {
            if (level.isEnabled(MetricsCollectionCycle.this.minimumLevel)) {
                MetricDescriptor descriptorCopy = descriptor.copy().withUnit(unit).withMetric(name);
                MetricsUtil.adjustExclusionsWithLevel(descriptorCopy, level, MetricsCollectionCycle.this.minimumLevel);
                MetricsCollectionCycle.this.lookupMetricValueCatcher(descriptorCopy).catchMetricValue(MetricsCollectionCycle.this.collectionId, value);
                MetricsCollectionCycle.this.metricsCollector.collectLong(descriptorCopy, value);
            }
        }

        @Override
        public void collect(MetricDescriptor descriptor, String name, ProbeLevel level, ProbeUnit unit, double value) {
            if (level.isEnabled(MetricsCollectionCycle.this.minimumLevel)) {
                MetricDescriptor descriptorCopy = descriptor.copy().withUnit(unit).withMetric(name);
                MetricsUtil.adjustExclusionsWithLevel(descriptorCopy, level, MetricsCollectionCycle.this.minimumLevel);
                MetricsCollectionCycle.this.lookupMetricValueCatcher(descriptorCopy).catchMetricValue(MetricsCollectionCycle.this.collectionId, value);
                MetricsCollectionCycle.this.metricsCollector.collectDouble(descriptorCopy, value);
            }
        }

        @Override
        public void collect(MetricDescriptor descriptor, long value) {
            MetricsCollectionCycle.this.lookupMetricValueCatcher(descriptor).catchMetricValue(MetricsCollectionCycle.this.collectionId, value);
            MetricsCollectionCycle.this.metricsCollector.collectLong(descriptor, value);
        }

        @Override
        public void collect(MetricDescriptor descriptor, double value) {
            MetricsCollectionCycle.this.lookupMetricValueCatcher(descriptor).catchMetricValue(MetricsCollectionCycle.this.collectionId, value);
            MetricsCollectionCycle.this.metricsCollector.collectDouble(descriptor, value);
        }
    }
}

