/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio;

import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.shaded.org.objenesis.Objenesis;
import com.hazelcast.shaded.org.objenesis.ObjenesisStd;
import com.hazelcast.shaded.org.objenesis.instantiator.ObjectInstantiator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public final class InstanceCreationUtil {
    private static final Objenesis OBJENESIS = new ObjenesisStd(true);
    private static final Map<Class<?>, Supplier<?>> OBJECT_SUPPLIERS = new ConcurrentHashMap();

    private InstanceCreationUtil() {
    }

    public static <T> T createNewInstance(Class klass) {
        Supplier supplier = OBJECT_SUPPLIERS.computeIfAbsent(klass, clz -> {
            if (InstanceCreationUtil.canUseConstructor(clz)) {
                return () -> InstanceCreationUtil.newInstanceUsingConstructor(clz);
            }
            ObjectInstantiator instantiator = OBJENESIS.getInstantiatorOf(klass);
            return () -> instantiator.newInstance();
        });
        return supplier.get();
    }

    private static boolean canUseConstructor(Class<?> clz) {
        try {
            ClassLoaderUtil.newInstance(clz.getClassLoader(), clz);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static <T> T newInstanceUsingConstructor(Class<T> clz) {
        try {
            return ClassLoaderUtil.newInstance(clz.getClassLoader(), clz);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }
}

