/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.cluster.impl.ClusterTopologyChangedException;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.properties.ClusterProperty;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class ParallelOperationInvoker {
    private final NodeEngine nodeEngine;
    private final ClusterService clusterService;
    private final Supplier<Operation> operationSupplier;
    private final int maxRetries;
    private final long retryDelayMillis;
    private final AtomicInteger retryCount = new AtomicInteger(0);
    private final InternalCompletableFuture<Collection<UUID>> future = new InternalCompletableFuture();
    private final Predicate<Member> memberFilter;
    private volatile Set<Member> members;

    ParallelOperationInvoker(NodeEngine nodeEngine, Supplier<Operation> operationSupplier, int maxRetries, Predicate<Member> memberFilter) {
        this.nodeEngine = nodeEngine;
        this.clusterService = nodeEngine.getClusterService();
        this.operationSupplier = operationSupplier;
        this.maxRetries = maxRetries;
        this.retryDelayMillis = nodeEngine.getProperties().getMillis(ClusterProperty.INVOCATION_RETRY_PAUSE);
        this.memberFilter = memberFilter;
    }

    public InternalCompletableFuture<Collection<UUID>> invoke() {
        this.doInvoke();
        return this.future;
    }

    private void doInvoke() {
        this.members = this.clusterService.getMembers();
        InternalCompletableFuture[] futures = this.invokeOnMatchingMembers(this.members);
        CompletableFuture.allOf(futures).whenCompleteAsync((ignored, throwable) -> this.completeFutureOrRetry(throwable == null, futures), ConcurrencyUtil.getDefaultAsyncExecutor());
    }

    private void doInvokeWithDelay() {
        this.nodeEngine.getExecutionService().schedule(this::doInvoke, this.retryDelayMillis, TimeUnit.MILLISECONDS);
    }

    private InternalCompletableFuture[] invokeOnMatchingMembers(Collection<Member> members) {
        return (InternalCompletableFuture[])members.stream().filter(this.memberFilter).map(this::invokeOnMember).toArray(InternalCompletableFuture[]::new);
    }

    private InternalCompletableFuture<Void> invokeOnMember(Member member) {
        Operation operation = this.operationSupplier.get();
        String serviceName = operation.getServiceName();
        Address target = member.getAddress();
        return this.nodeEngine.getOperationService().invokeOnTargetAsync(serviceName, operation, target);
    }

    private void completeFutureOrRetry(boolean noExceptionReceived, InternalCompletableFuture[] futures) {
        Set<Member> currentMembers = this.clusterService.getMembers();
        if (noExceptionReceived) {
            if (currentMembers.equals(this.members)) {
                List<UUID> memberUuids = this.convertMemberListToMemberUuidList(currentMembers);
                this.future.complete(memberUuids);
            } else {
                this.retry();
            }
        } else {
            this.onExceptionalCompletion(futures, currentMembers);
        }
    }

    private void retry() {
        if (this.retryCount.incrementAndGet() > this.maxRetries) {
            HazelcastException t = new HazelcastException("Cluster topology was not stable for " + this.maxRetries + " retries");
            this.future.completeExceptionally(t);
            return;
        }
        this.doInvokeWithDelay();
    }

    private List<UUID> convertMemberListToMemberUuidList(Collection<Member> members) {
        return members.stream().map(Member::getUuid).collect(Collectors.toList());
    }

    private boolean isIgnorableException(Throwable t) {
        return t instanceof MemberLeftException || t instanceof TargetNotMemberException || t instanceof HazelcastInstanceNotActiveException;
    }

    private void onExceptionalCompletion(InternalCompletableFuture[] futures, Collection<Member> currentMembers) {
        boolean isTerminalExceptionReceived = false;
        Throwable terminalException = null;
        boolean isClusterTopologyChanged = false;
        for (InternalCompletableFuture future : futures) {
            assert (future.isDone());
            if (!future.isCompletedExceptionally()) continue;
            try {
                future.join();
            }
            catch (CancellationException cancellationException) {
                isTerminalExceptionReceived = true;
                terminalException = cancellationException;
                break;
            }
            catch (CompletionException completionException) {
                Throwable cause = completionException.getCause();
                if (cause instanceof ClusterTopologyChangedException) {
                    isClusterTopologyChanged = true;
                    continue;
                }
                if (this.isIgnorableException(cause)) continue;
                isTerminalExceptionReceived = true;
                terminalException = cause != null ? cause : completionException;
                break;
            }
            catch (Throwable t) {
                isTerminalExceptionReceived = true;
                terminalException = t;
                break;
            }
        }
        if (!currentMembers.equals(this.members)) {
            isClusterTopologyChanged = true;
        }
        if (isTerminalExceptionReceived) {
            this.future.completeExceptionally(terminalException);
        } else if (isClusterTopologyChanged) {
            this.retry();
        } else {
            List<UUID> memberUuids = this.convertMemberListToMemberUuidList(this.members);
            this.future.complete(memberUuids);
        }
    }
}

