/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.internal.cluster.impl.MembersView;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.executor.ManagedExecutorService;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.impl.AbstractJobProxy;
import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.JobClassLoaderService;
import com.hazelcast.jet.impl.JobCoordinationService;
import com.hazelcast.jet.impl.JobEventService;
import com.hazelcast.jet.impl.TerminationMode;
import com.hazelcast.jet.impl.deployment.JetDelegatingClassLoader;
import com.hazelcast.jet.impl.exception.CancellationByUserException;
import com.hazelcast.jet.impl.exception.JobTerminateRequestedException;
import com.hazelcast.jet.impl.execution.init.ExecutionPlan;
import com.hazelcast.jet.impl.execution.init.ExecutionPlanBuilder;
import com.hazelcast.jet.impl.operation.InitExecutionOperation;
import com.hazelcast.jet.impl.operation.TerminateExecutionOperation;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.LoggingUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.eventservice.impl.Registration;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.version.Version;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.security.auth.Subject;

public final class LightMasterContext {
    private static final Object NULL_OBJECT = new Object(){

        public String toString() {
            return "NULL_OBJECT";
        }
    };
    private final ReentrantLock lock = new ReentrantLock();
    private final NodeEngine nodeEngine;
    private final JobEventService jobEventService;
    private final long jobId;
    private final ILogger logger;
    private final String jobIdString;
    private final JobConfig jobConfig;
    private final long startTime = System.currentTimeMillis();
    private final Map<MemberInfo, ExecutionPlan> executionPlanMap;
    private final AtomicBoolean invocationsCancelled = new AtomicBoolean();
    private final CompletableFuture<Void> jobCompletionFuture = new CompletableFuture();
    private final Set<Vertex> vertices;
    private final JobClassLoaderService jobClassLoaderService;
    private volatile boolean userInitiatedTermination;

    private LightMasterContext(NodeEngine nodeEngine, long jobId, ILogger logger, String jobIdString, JobConfig jobConfig, Map<MemberInfo, ExecutionPlan> executionPlanMap, Set<Vertex> vertices) {
        this.nodeEngine = nodeEngine;
        this.jobEventService = (JobEventService)nodeEngine.getService("hz:impl:jobEventService");
        this.jobId = jobId;
        this.logger = logger;
        this.jobIdString = jobIdString;
        this.jobConfig = jobConfig;
        this.executionPlanMap = executionPlanMap;
        this.vertices = vertices;
        this.jobClassLoaderService = ((JetServiceBackend)nodeEngine.getService("hz:impl:jetService")).getJobClassLoaderService();
    }

    public static CompletableFuture<LightMasterContext> createContext(NodeEngineImpl nodeEngine, JobCoordinationService coordinationService, DAG dag, long jobId, JobConfig jobConfig, Subject subject) {
        ILogger logger = nodeEngine.getLogger(LightMasterContext.class);
        String jobIdString = com.hazelcast.jet.Util.idToString(jobId);
        MembersView membersView = Util.getMembersView(nodeEngine);
        Version coordinatorVersion = nodeEngine.getLocalMember().getVersion().asVersion();
        List<MemberInfo> members = membersView.getMembers().stream().filter(m -> m.getVersion().asVersion().equals(coordinatorVersion) && !m.isLiteMember() && !coordinationService.isMemberShuttingDown(m.getUuid())).collect(Collectors.toList());
        if (members.isEmpty()) {
            throw new JetException("No data member with version equal to the coordinator version found");
        }
        if (members.size() < membersView.size()) {
            LoggingUtil.logFine(logger, "Light job %s will run on a subset of members: %d out of %d members with version %s", com.hazelcast.jet.Util.idToString(jobId), members.size(), membersView.size(), coordinatorVersion);
        }
        if (logger.isFineEnabled()) {
            JetConfig jetConfig = nodeEngine.getConfig().getJetConfig();
            String dotRepresentation = dag.toDotString(jetConfig.getCooperativeThreadCount(), jetConfig.getDefaultEdgeConfig().getQueueSize());
            LoggingUtil.logFine(logger, "Start executing light job %s, execution graph in DOT format:\n%s\nHINT: You can use graphviz or http://viz-js.com to visualize the printed graph.", jobIdString, dotRepresentation);
            LoggingUtil.logFine(logger, "Building execution plan for %s", jobIdString);
        }
        HashSet vertices = new HashSet();
        dag.iterator().forEachRemaining(vertices::add);
        return ExecutionPlanBuilder.createExecutionPlans(nodeEngine, members, dag, jobId, jobId, jobConfig, 0L, true, subject).handleAsync((planMap, e) -> {
            LightMasterContext mc = new LightMasterContext(nodeEngine, jobId, logger, jobIdString, jobConfig, (Map<MemberInfo, ExecutionPlan>)planMap, vertices);
            if (e != null) {
                mc.finalizeJob((Throwable)e);
                throw com.hazelcast.internal.util.ExceptionUtil.rethrow(e);
            }
            LoggingUtil.logFine(logger, "Built execution plans for %s", jobIdString);
            Set participants = planMap.keySet();
            Function<ExecutionPlan, Operation> operationCtor = plan -> {
                Object serializedPlan = nodeEngine.getSerializationService().toData(plan);
                return new InitExecutionOperation(jobId, jobId, membersView.getVersion(), coordinatorVersion, participants, (Data)serializedPlan, true);
            };
            mc.invokeOnParticipants(operationCtor, responses -> mc.finalizeJob(mc.findError((Collection<Object>)responses)), error -> mc.cancelInvocations());
            return mc;
        }, (Executor)coordinationService.coordinationExecutor());
    }

    public long getJobId() {
        return this.jobId;
    }

    private void finalizeJob(@Nullable Throwable failure) {
        ManagedExecutorService offloadExecutor = this.nodeEngine.getExecutionService().getExecutor("hz:jet-job-offloadable");
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (Vertex vertex : this.vertices) {
            ProcessorMetaSupplier metaSupplier = vertex.getMetaSupplier();
            Executor executor = metaSupplier.closeIsCooperative() ? ConcurrencyUtil.CALLER_RUNS : offloadExecutor;
            futures.add(CompletableFuture.runAsync(() -> this.invokeClose(failure, metaSupplier), executor));
        }
        CompletableFuture<Void> combined = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        combined.whenComplete((ignored, e) -> {
            this.lock.lock();
            try {
                Throwable fail = failure;
                if (fail == null) {
                    this.jobCompletionFuture.complete(null);
                    this.jobEventService.publishEvent(this.jobId, JobStatus.RUNNING, JobStatus.COMPLETED, null, false);
                } else {
                    TerminationMode requestedTerminationMode;
                    TerminationMode terminationMode = requestedTerminationMode = fail instanceof JobTerminateRequestedException ? ((JobTerminateRequestedException)fail).mode() : null;
                    if (requestedTerminationMode == TerminationMode.CANCEL_FORCEFUL) {
                        CancellationException newFailure = this.userInitiatedTermination ? new CancellationByUserException() : new CancellationException();
                        newFailure.initCause(failure);
                        fail = newFailure;
                    }
                    this.jobCompletionFuture.completeExceptionally(fail);
                    this.jobEventService.publishEvent(this.jobId, JobStatus.RUNNING, JobStatus.FAILED, requestedTerminationMode != null ? requestedTerminationMode.actionAfterTerminate().description() : fail.toString(), this.userInitiatedTermination);
                }
                this.jobEventService.removeAllEventListeners(this.jobId);
            }
            finally {
                this.lock.unlock();
            }
        });
    }

    public UUID addStatusListener(Registration registration) {
        this.lock.lock();
        try {
            if (this.jobCompletionFuture.isDone()) {
                throw AbstractJobProxy.cannotAddStatusListener(this.jobCompletionFuture.isCompletedExceptionally() ? JobStatus.FAILED : JobStatus.COMPLETED);
            }
            UUID uUID = this.jobEventService.handleAllRegistrations(this.jobId, registration).getId();
            return uUID;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void invokeClose(@Nullable Throwable failure, ProcessorMetaSupplier metaSupplier) {
        try {
            JetDelegatingClassLoader classLoader = this.jobClassLoaderService.getClassLoader(this.jobId);
            Util.doWithClassLoader((ClassLoader)classLoader, () -> metaSupplier.close(failure));
        }
        catch (Throwable e) {
            this.logger.severe(this.jobIdString + " encountered an exception in ProcessorMetaSupplier.complete(), ignoring it", e);
        }
    }

    private void cancelInvocations() {
        if (this.invocationsCancelled.compareAndSet(false, true)) {
            for (MemberInfo memberInfo : this.executionPlanMap.keySet()) {
                TerminateExecutionOperation op = new TerminateExecutionOperation(this.jobId, this.jobId, TerminationMode.CANCEL_FORCEFUL);
                this.nodeEngine.getOperationService().createInvocationBuilder("hz:impl:jetService", (Operation)op, memberInfo.getAddress()).invoke();
            }
        }
    }

    private void invokeOnParticipants(Function<ExecutionPlan, Operation> operationCtor, @Nullable Consumer<Collection<Object>> completionCallback, @Nullable Consumer<Throwable> errorCallback) {
        ConcurrentHashMap<Address, Object> responses = new ConcurrentHashMap<Address, Object>();
        AtomicInteger remainingCount = new AtomicInteger(this.executionPlanMap.size());
        for (Map.Entry<MemberInfo, ExecutionPlan> entry : this.executionPlanMap.entrySet()) {
            Address address = entry.getKey().getAddress();
            Operation op = operationCtor.apply(entry.getValue());
            this.invokeOnParticipant(address, op, completionCallback, errorCallback, responses, remainingCount);
        }
    }

    private void invokeOnParticipant(Address address, Operation op, @Nullable Consumer<Collection<Object>> completionCallback, @Nullable Consumer<Throwable> errorCallback, ConcurrentMap<Address, Object> collectedResponses, AtomicInteger remainingCount) {
        InvocationFuture future = this.nodeEngine.getOperationService().createInvocationBuilder("hz:impl:jetService", op, address).invoke();
        future.whenComplete((r, throwable) -> {
            Object response;
            Object object = r != null ? r : (response = throwable != null ? ExceptionUtil.peel(throwable) : NULL_OBJECT);
            if (throwable instanceof OperationTimeoutException) {
                this.logger.warning("Retrying " + op.getClass().getSimpleName() + " that failed with " + OperationTimeoutException.class.getSimpleName() + " in " + this.jobIdString);
                this.invokeOnParticipant(address, op, completionCallback, errorCallback, collectedResponses, remainingCount);
                return;
            }
            if (errorCallback != null && throwable != null) {
                errorCallback.accept((Throwable)throwable);
            }
            Object oldResponse = collectedResponses.put(address, response);
            assert (oldResponse == null) : "Duplicate response for " + address + ". Old=" + oldResponse + ", new=" + response;
            if (remainingCount.decrementAndGet() == 0 && completionCallback != null) {
                completionCallback.accept(collectedResponses.values().stream().map(o -> o == NULL_OBJECT ? null : o).collect(Collectors.toList()));
            }
        });
    }

    private Throwable findError(Collection<Object> responses) {
        Throwable result = null;
        for (Object response : responses) {
            if (!(response instanceof Throwable) || result != null && !(result instanceof JobTerminateRequestedException) && !(result instanceof CancellationException)) continue;
            result = (Throwable)response;
        }
        if (result != null && !(result instanceof CancellationException) && !(result instanceof JobTerminateRequestedException)) {
            result = new JetException("Execution on a member failed: " + result, result);
        }
        return result;
    }

    public void requestTermination(boolean userInitiated) {
        this.userInitiatedTermination = userInitiated;
        this.cancelInvocations();
    }

    public boolean isCancelled() {
        return this.invocationsCancelled.get();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public CompletableFuture<Void> getCompletionFuture() {
        return this.jobCompletionFuture;
    }

    public JobConfig getJobConfig() {
        return this.jobConfig;
    }
}

