/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution.init;

import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.ProcessorClassLoaderTLHolder;
import com.hazelcast.jet.impl.execution.init.CustomClassLoadedObject;
import com.hazelcast.jet.impl.execution.init.EdgeDef;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VertexDef
implements IdentifiedDataSerializable {
    private int id;
    private List<EdgeDef> inboundEdges = new ArrayList<EdgeDef>();
    private List<EdgeDef> outboundEdges = new ArrayList<EdgeDef>();
    private String name;
    private ProcessorSupplier processorSupplier;
    private int localParallelism;

    VertexDef() {
    }

    VertexDef(int id, String name, ProcessorSupplier processorSupplier, int localParallelism) {
        this.id = id;
        this.name = name;
        this.processorSupplier = processorSupplier;
        this.localParallelism = localParallelism;
    }

    public String name() {
        return this.name;
    }

    public int localParallelism() {
        return this.localParallelism;
    }

    int vertexId() {
        return this.id;
    }

    void addInboundEdges(List<EdgeDef> edges) {
        this.inboundEdges.addAll(edges);
    }

    void addOutboundEdges(List<EdgeDef> edges) {
        this.outboundEdges.addAll(edges);
    }

    List<EdgeDef> inboundEdges() {
        return this.inboundEdges;
    }

    List<EdgeDef> outboundEdges() {
        return this.outboundEdges;
    }

    public ProcessorSupplier processorSupplier() {
        return this.processorSupplier;
    }

    static Set<Integer> getHigherPriorityVertices(VertexDef[] vertices) {
        HashSet<Integer> res = new HashSet<Integer>();
        HashSet<Integer> seenVertices = new HashSet<Integer>();
        int i = vertices.length;
        block0: while (i-- > 0) {
            VertexDef v = vertices[i];
            assert (seenVertices.add(v.vertexId())) : "duplicate vertex id";
            for (EdgeDef outboundEdge : v.outboundEdges) {
                VertexDef downstream = outboundEdge.destVertex();
                assert (seenVertices.contains(downstream.vertexId())) : "missing child";
                if (!res.contains(downstream.vertexId()) && !outboundEdge.isSnapshotRestoreEdge() && !downstream.inboundEdges.stream().anyMatch(edge -> edge.priority() > outboundEdge.priority())) continue;
                boolean unique = res.add(v.id);
                assert (unique);
                continue block0;
            }
        }
        return res;
    }

    boolean isSnapshotVertex() {
        return this.name.startsWith("__snapshot_");
    }

    public String toString() {
        return "VertexDef{name='" + this.name + '\'' + '}';
    }

    @Override
    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeString(this.name);
        ImdgUtil.writeList(out, this.inboundEdges);
        ImdgUtil.writeList(out, this.outboundEdges);
        CustomClassLoadedObject.write(out, this.processorSupplier);
        out.writeInt(this.localParallelism);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.id = in.readInt();
        this.name = in.readString();
        this.inboundEdges = ImdgUtil.readList(in);
        this.outboundEdges = ImdgUtil.readList(in);
        this.processorSupplier = Util.doWithClassLoader(ProcessorClassLoaderTLHolder.get(this.name), () -> (ProcessorSupplier)CustomClassLoadedObject.read(in));
        this.localParallelism = in.readInt();
    }
}

