/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.jet.JetException;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.impl.JetEvent;
import com.hazelcast.jet.impl.connector.ConvenientSourceP;
import com.hazelcast.jet.pipeline.SourceBuilder;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.annotation.Nonnull;

public class SourceBufferImpl<T>
implements ConvenientSourceP.SourceBufferConsumerSide<T> {
    private final Queue<T> buffer = new ArrayDeque<T>();
    private final Traverser<T> traverser = this.buffer::poll;
    private final boolean isBatch;
    private boolean isClosed;

    private SourceBufferImpl(boolean isBatch) {
        this.isBatch = isBatch;
    }

    final void addInternal(T item) {
        if (this.isClosed) {
            throw new IllegalStateException("Buffer is closed, can't add more items");
        }
        this.buffer.add(item);
    }

    public final int size() {
        return this.buffer.size();
    }

    @Override
    public final Traverser<T> traverse() {
        return this.traverser;
    }

    @Override
    public final boolean isEmpty() {
        return this.buffer.isEmpty();
    }

    public final void close() {
        if (!this.isBatch) {
            throw new JetException("a streaming source must not close the buffer, only batch source can");
        }
        this.isClosed = true;
    }

    @Override
    public final boolean isClosed() {
        return this.isClosed;
    }

    public static class Timestamped<T>
    extends SourceBufferImpl<JetEvent<T>>
    implements SourceBuilder.TimestampedSourceBuffer<T> {
        public Timestamped() {
            super(false);
        }

        @Override
        public void add(@Nonnull T item, long timestamp) {
            this.addInternal(JetEvent.jetEvent(timestamp, item));
        }
    }

    public static class Plain<T>
    extends SourceBufferImpl<T>
    implements SourceBuilder.SourceBuffer<T> {
        public Plain(boolean isBatch) {
            super(isBatch);
        }

        @Override
        public void add(@Nonnull T item) {
            this.addInternal(item);
        }
    }
}

