/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.test;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.ConsumerEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public final class AssertionP<S, T>
extends AbstractProcessor {
    private static final long TIMER_INTERVAL = TimeUnit.MILLISECONDS.toNanos(200L);
    private final SupplierEx<? extends S> createFn;
    private final BiConsumerEx<? super S, ? super T> receiveFn;
    private final ConsumerEx<? super S> timerFn;
    private final ConsumerEx<? super S> completeFn;
    private S state;
    private long nextTimerSchedule;

    private AssertionP(SupplierEx<? extends S> createFn, BiConsumerEx<? super S, ? super T> receiveFn, ConsumerEx<? super S> timerFn, ConsumerEx<? super S> completeFn) {
        this.createFn = createFn;
        this.receiveFn = receiveFn;
        this.timerFn = timerFn;
        this.completeFn = completeFn;
    }

    @Override
    protected void init(@Nonnull Processor.Context context) throws Exception {
        super.init(context);
        this.state = this.createFn.get();
    }

    @Override
    public boolean tryProcess() {
        this.maybeFireTimer();
        return true;
    }

    private void maybeFireTimer() {
        long now = System.nanoTime();
        if (this.nextTimerSchedule == 0L || now >= this.nextTimerSchedule) {
            this.timerFn.accept(this.state);
            this.nextTimerSchedule = now + TIMER_INTERVAL;
        }
    }

    @Override
    protected boolean tryProcess(int ordinal, @Nonnull Object item) {
        this.receiveFn.accept(this.state, item);
        this.maybeFireTimer();
        return true;
    }

    @Override
    public boolean complete() {
        this.completeFn.accept(this.state);
        return true;
    }

    @Override
    public boolean closeIsCooperative() {
        return true;
    }

    @Nonnull
    public static <A, T> ProcessorMetaSupplier assertionP(@Nonnull String name, @Nonnull SupplierEx<? extends A> createFn, @Nonnull BiConsumerEx<? super A, ? super T> receiveFn, @Nonnull ConsumerEx<? super A> timerFn, @Nonnull ConsumerEx<? super A> completeFn) {
        return ProcessorMetaSupplier.forceTotalParallelismOne(ProcessorSupplier.of(() -> new AssertionP(createFn, receiveFn, timerFn, completeFn)), name);
    }
}

