/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.datamodel.ItemsByTag;
import com.hazelcast.jet.datamodel.Tag;
import com.hazelcast.jet.function.TriFunction;
import com.hazelcast.jet.impl.pipeline.PipelineImpl;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.transform.AbstractTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.impl.processor.HashJoinCollectP;
import com.hazelcast.jet.impl.processor.HashJoinP;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.JoinClause;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HashJoinTransform<T0, R>
extends AbstractTransform {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final List<JoinClause<?, ? super T0, ?, ?>> clauses;
    @Nonnull
    private final List<Tag> tags;
    @Nullable
    private final BiFunctionEx mapToOutputBiFn;
    @Nullable
    private final TriFunction mapToOutputTriFn;
    @Nullable
    private final List<Boolean> whereNullsNotAllowed;

    public HashJoinTransform(@Nonnull List<Transform> upstream, @Nonnull List<JoinClause<?, ? super T0, ?, ?>> clauses, @Nonnull List<Tag> tags, @Nonnull BiFunctionEx mapToOutputBiFn) {
        super(upstream.size() + "-way hash-join", upstream);
        this.clauses = clauses;
        this.tags = tags;
        this.mapToOutputBiFn = mapToOutputBiFn;
        this.mapToOutputTriFn = null;
        this.whereNullsNotAllowed = null;
    }

    public <T1, T2> HashJoinTransform(@Nonnull List<Transform> upstream, @Nonnull List<JoinClause<?, ? super T0, ?, ?>> clauses, @Nonnull List<Tag> tags, @Nonnull TriFunction<T0, T1, T2, R> mapToOutputTriFn) {
        super(upstream.size() + "-way hash-join", upstream);
        this.clauses = clauses;
        this.tags = tags;
        this.mapToOutputBiFn = null;
        this.mapToOutputTriFn = mapToOutputTriFn;
        this.whereNullsNotAllowed = null;
    }

    public HashJoinTransform(@Nonnull List<Transform> upstream, @Nonnull List<JoinClause<?, ? super T0, ?, ?>> clauses, @Nonnull List<Tag> tags, @Nonnull BiFunctionEx mapToOutputBiFn, @Nonnull List<Boolean> whereNullsNotAllowed) {
        super(upstream.size() + "-way hash-join", upstream);
        this.clauses = clauses;
        this.tags = tags;
        this.mapToOutputBiFn = mapToOutputBiFn;
        this.mapToOutputTriFn = null;
        this.whereNullsNotAllowed = whereNullsNotAllowed;
    }

    @Override
    public void addToDag(Planner p, PipelineImpl.Context context) {
        this.determineLocalParallelism(-1, context, p.isPreserveOrder());
        Planner.PlannerVertex primary = p.transform2vertex.get(this.upstream().get(0));
        List<FunctionEx> keyFns = Util.toList(this.clauses, JoinClause::leftKeyFn);
        List<Tag> tags = this.tags;
        BiFunctionEx mapToOutputBiFn = this.mapToOutputBiFn;
        TriFunction mapToOutputTriFn = this.mapToOutputTriFn;
        BiFunctionEx<List<Tag>, Object[], ItemsByTag> tupleToItems = HashJoinTransform.tupleToItemsByTag(this.whereNullsNotAllowed);
        Vertex joiner = p.addVertex((Transform)this, (String)new StringBuilder().append((String)this.name()).append((String)"-joiner").toString(), (int)this.determinedLocalParallelism(), (SupplierEx<Processor>)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, lambda$addToDag$8007dee$1(java.util.List java.util.List com.hazelcast.function.BiFunctionEx com.hazelcast.jet.function.TriFunction com.hazelcast.function.BiFunctionEx ), ()Lcom/hazelcast/jet/core/Processor;)(keyFns, tags, (BiFunctionEx)mapToOutputBiFn, (TriFunction)mapToOutputTriFn, tupleToItems)).v;
        Edge edgeToJoiner = Edge.from(primary.v, primary.nextAvailableOrdinal()).to(joiner, 0);
        if (p.isPreserveOrder()) {
            edgeToJoiner.isolated();
        } else {
            Planner.applyRebalancing(edgeToJoiner, this);
        }
        p.dag.edge(edgeToJoiner);
        String collectorName = this.name() + "-collector";
        int collectorOrdinal = 1;
        for (Transform fromTransform : Planner.tailList(this.upstream())) {
            Planner.PlannerVertex fromPv = p.transform2vertex.get(fromTransform);
            JoinClause<?, T0, ?, ?> clause = this.clauses.get(collectorOrdinal - 1);
            FunctionEx<?, ?> getKeyFn = clause.rightKeyFn();
            FunctionEx<?, ?> projectFn = clause.rightProjectFn();
            Vertex collector = p.dag.newVertex(collectorName + collectorOrdinal, () -> new HashJoinCollectP(getKeyFn, projectFn));
            collector.localParallelism(1);
            p.dag.edge(Edge.from(fromPv.v, fromPv.nextAvailableOrdinal()).to(collector, 0).distributed().broadcast());
            p.dag.edge(Edge.from(collector, 0).to(joiner, collectorOrdinal).broadcast().priority(-1));
            ++collectorOrdinal;
        }
    }

    private static BiFunctionEx<List<Tag>, Object[], ItemsByTag> tupleToItemsByTag(List<Boolean> nullsNotAllowed) {
        return (tagList, tuple) -> {
            ItemsByTag res = new ItemsByTag();
            for (int i = 0; i < tagList.size(); ++i) {
                if (tuple[i] == null && ((Boolean)nullsNotAllowed.get(i)).booleanValue()) {
                    return null;
                }
                res.put((Tag)tagList.get(i), tuple[i]);
            }
            return res;
        };
    }

    private static /* synthetic */ Processor lambda$addToDag$8007dee$1(List keyFns, List tags, BiFunctionEx mapToOutputBiFn, TriFunction mapToOutputTriFn, BiFunctionEx tupleToItems) throws Exception {
        return new HashJoinP(keyFns, tags, mapToOutputBiFn, mapToOutputTriFn, tupleToItems);
    }
}

