/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.core.JetDataSerializerHook;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ResettableSingletonTraverser;
import com.hazelcast.jet.impl.processor.AggregateP;
import com.hazelcast.jet.impl.processor.TransformP;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public final class ProcessorSuppliers {

    public static class ProcessorMapPSupplier<T, R>
    implements IdentifiedDataSerializable,
    SupplierEx<Processor> {
        private FunctionEx<? super T, ? extends R> mapFn;

        public ProcessorMapPSupplier() {
        }

        public ProcessorMapPSupplier(FunctionEx<? super T, ? extends R> mapFn) {
            this.mapFn = mapFn;
        }

        @Override
        public Processor getEx() throws Exception {
            ResettableSingletonTraverser trav = new ResettableSingletonTraverser();
            return new TransformP(item -> {
                trav.accept(this.mapFn.apply(item));
                return trav;
            });
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject(this.mapFn);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.mapFn = (FunctionEx)in.readObject();
        }

        @Override
        public int getFactoryId() {
            return JetDataSerializerHook.FACTORY_ID;
        }

        @Override
        public int getClassId() {
            return 15;
        }
    }

    public static class AggregatePSupplier<A, R>
    implements SupplierEx<Processor>,
    IdentifiedDataSerializable {
        private AggregateOperation<A, R> aggrOp;

        public AggregatePSupplier() {
        }

        public AggregatePSupplier(AggregateOperation<A, R> aggrOp) {
            this.aggrOp = aggrOp;
        }

        @Override
        public Processor getEx() throws Exception {
            return new AggregateP<A, R>(this.aggrOp);
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject(this.aggrOp);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.aggrOp = (AggregateOperation)in.readObject();
        }

        @Override
        public int getFactoryId() {
            return JetDataSerializerHook.FACTORY_ID;
        }

        @Override
        public int getClassId() {
            return 8;
        }
    }
}

