/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.submitjob.memberside;

import com.hazelcast.jet.JetException;
import com.hazelcast.jet.impl.submitjob.memberside.JobMetaDataParameterObject;
import com.hazelcast.jet.impl.submitjob.memberside.JobMultiPartParameterObject;
import com.hazelcast.jet.impl.submitjob.memberside.JobUploadStatus;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class JobUploadStore {
    private static final ILogger LOGGER = Logger.getLogger(JobUploadStore.class);
    private ConcurrentHashMap<UUID, JobUploadStatus> jobMap = new ConcurrentHashMap();

    public void cleanExpiredUploads() {
        this.jobMap.forEach((key, value) -> {
            if (value.isExpired()) {
                this.removeBadSession((UUID)key);
            }
        });
    }

    public JobUploadStatus removeBadSession(UUID sessionId) {
        JobUploadStatus jobUploadStatus = this.jobMap.remove(sessionId);
        if (jobUploadStatus != null) {
            jobUploadStatus.removeBadSession();
        }
        return jobUploadStatus;
    }

    public void processJobMetaData(JobMetaDataParameterObject parameterObject) throws IOException {
        UUID sessionId = parameterObject.getSessionId();
        String message = String.format("processJobMetaData : Session : %s ", sessionId);
        LOGGER.info(message);
        if (this.jobMap.containsKey(sessionId)) {
            throw new JetException("Session already exists. sessionID " + sessionId);
        }
        JobUploadStatus jobUploadStatus = this.jobMap.computeIfAbsent(parameterObject.getSessionId(), key -> new JobUploadStatus(parameterObject));
        jobUploadStatus.createNewTemporaryFile();
    }

    public JobMetaDataParameterObject processJobMultipart(JobMultiPartParameterObject parameterObject) throws IOException, NoSuchAlgorithmException {
        UUID sessionId = parameterObject.getSessionId();
        int currentPart = parameterObject.getCurrentPartNumber();
        int totalPart = parameterObject.getTotalPartNumber();
        String message = String.format("processJobMultipart : Session : %s Received : %d of %d", sessionId, currentPart, totalPart);
        LOGGER.info(message);
        JobUploadStatus jobUploadStatus = this.jobMap.get(sessionId);
        if (jobUploadStatus == null) {
            String exceptionMessage = JobUploadStore.getSessionNotFoundExceptionMessage(sessionId);
            throw new JetException(exceptionMessage + sessionId);
        }
        JobMetaDataParameterObject partsComplete = jobUploadStatus.processJobMultipart(parameterObject);
        if (partsComplete != null) {
            message = String.format("Session : %s is complete. It will be removed from the map", sessionId);
            LOGGER.info(message);
            this.jobMap.remove(partsComplete.getSessionId());
        }
        return partsComplete;
    }

    private static String getSessionNotFoundExceptionMessage(UUID sessionId) {
        return String.format("The session %s does not exist. Session has timed out due to upload inactivity? \n If the network is slow, uploading with smaller parts may help.\nIn order to use a smaller upload part\n1. Set \"hazelcast.client.jobupload.partsize\" environment value or \n2. Set ClientProperty.JOB_UPLOAD_PART_SIZE property of ClientConfig", sessionId);
    }
}

