/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.impl.util.Util;
import java.util.Arrays;

public class SkewReductionPolicy {
    final long[] queueWms;
    final int[] drainOrderToQIdx;
    private final long maxSkew;
    private final long priorityDrainingThreshold;
    private final boolean forceAdvanceWm;

    public SkewReductionPolicy(int numQueues) {
        this(numQueues, Long.MAX_VALUE, Long.MAX_VALUE, false);
    }

    public SkewReductionPolicy(int numQueues, long maxSkew, long priorityDrainingThreshold, boolean forceAdvanceWm) {
        Preconditions.checkNotNegative(maxSkew, "maxSkew must not be a negative number");
        Preconditions.checkNotNegative(priorityDrainingThreshold, "priorityDrainingThreshold must not be a negative number");
        Preconditions.checkTrue(priorityDrainingThreshold <= maxSkew, "priorityDrainingThreshold must be less than maxSkew");
        this.maxSkew = maxSkew;
        this.priorityDrainingThreshold = priorityDrainingThreshold;
        this.forceAdvanceWm = forceAdvanceWm;
        this.queueWms = new long[numQueues];
        Arrays.fill(this.queueWms, Long.MIN_VALUE);
        this.drainOrderToQIdx = new int[numQueues];
        Arrays.setAll(this.drainOrderToQIdx, i -> i);
    }

    public int toQueueIndex(int drainOrderIdx) {
        return this.drainOrderToQIdx[drainOrderIdx];
    }

    public boolean observeWm(int queueIndex, long wmValue) {
        if (this.queueWms[queueIndex] >= wmValue) {
            if (!this.forceAdvanceWm) {
                throw new JetException("Watermarks not monotonically increasing on queue: last one=" + this.queueWms[queueIndex] + ", new one=" + wmValue);
            }
            return false;
        }
        boolean didReorder = this.adjustDrainingOrder(queueIndex, wmValue);
        this.queueWms[queueIndex] = wmValue;
        this.forceAdvanceWmIfConfigured();
        return didReorder;
    }

    private void forceAdvanceWmIfConfigured() {
        if (!this.forceAdvanceWm) {
            return;
        }
        long newBottomWm = Util.subtractClamped(this.topObservedWm(), this.maxSkew);
        for (int i = 0; i < this.drainOrderToQIdx.length && this.queueWms[this.drainOrderToQIdx[i]] < newBottomWm; ++i) {
            this.queueWms[this.drainOrderToQIdx[i]] = newBottomWm;
        }
    }

    public boolean shouldStopDraining(int queueIndex, boolean madeProgress) {
        long skew = Util.subtractClamped(this.queueWms[queueIndex], this.queueWms[this.drainOrderToQIdx[0]]);
        return madeProgress && skew > this.priorityDrainingThreshold || !this.forceAdvanceWm && skew > this.maxSkew;
    }

    public long bottomObservedWm() {
        return this.queueWms[this.drainOrderToQIdx[0]];
    }

    private long topObservedWm() {
        return this.queueWms[this.drainOrderToQIdx[this.drainOrderToQIdx.length - 1]];
    }

    private boolean adjustDrainingOrder(int queueIndex, long wmValue) {
        int currPos = this.findCurrentDrainPos(queueIndex);
        int newPos = this.findNewDrainPos(currPos, wmValue);
        if (newPos == currPos) {
            return false;
        }
        assert (newPos > currPos) : "newPos < currPos";
        System.arraycopy(this.drainOrderToQIdx, currPos + 1, this.drainOrderToQIdx, currPos, newPos - currPos);
        this.drainOrderToQIdx[newPos] = queueIndex;
        return true;
    }

    private int findCurrentDrainPos(int queueIndex) {
        for (int i = 0; i < this.drainOrderToQIdx.length; ++i) {
            if (this.drainOrderToQIdx[i] != queueIndex) continue;
            return i;
        }
        throw new AssertionError((Object)("Failed to find the queue index " + queueIndex + " in the drainOrder->queueIndex lookup table"));
    }

    private int findNewDrainPos(int currPos, long queueWm) {
        int i;
        for (i = currPos + 1; i < this.drainOrderToQIdx.length && this.queueWms[this.drainOrderToQIdx[i]] < queueWm; ++i) {
        }
        return i - 1;
    }
}

