/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.internal.serialization.SerializableByConvention;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.pipeline.WindowDefinition;

@SerializableByConvention
public class SlidingWindowDefinition
extends WindowDefinition {
    private static final long serialVersionUID = 1L;
    private final long windowSize;
    private final long slideBy;

    SlidingWindowDefinition(long windowSize, long slideBy) {
        Preconditions.checkPositive(windowSize, "windowSize must be positive");
        Preconditions.checkPositive(slideBy, "slideBy must be positive");
        Preconditions.checkTrue(windowSize % slideBy == 0L, "windowSize must be integer multiple of slideBy, mod(" + windowSize + ", " + slideBy + ") != 0");
        this.windowSize = windowSize;
        this.slideBy = slideBy;
    }

    @Override
    public SlidingWindowDefinition setEarlyResultsPeriod(long earlyResultPeriodMs) {
        return (SlidingWindowDefinition)super.setEarlyResultsPeriod(earlyResultPeriodMs);
    }

    public long windowSize() {
        return this.windowSize;
    }

    public long slideBy() {
        return this.slideBy;
    }
}

