/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.eventservice.impl.operations;

import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.spi.impl.eventservice.impl.Registration;
import com.hazelcast.spi.impl.eventservice.impl.operations.DeregistrationOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.util.UUID;
import java.util.function.Supplier;

public class DeregistrationOperationSupplier
implements Supplier<Operation> {
    private final String serviceName;
    private final String topic;
    private final UUID id;
    private final int orderKey;
    private final ClusterService clusterService;

    public DeregistrationOperationSupplier(Registration reg, ClusterService clusterService) {
        this.serviceName = reg.getServiceName();
        this.topic = reg.getTopic();
        this.id = reg.getId();
        this.orderKey = -1;
        this.clusterService = clusterService;
    }

    public DeregistrationOperationSupplier(String serviceName, String topic, int orderKey, ClusterService clusterService) {
        this.serviceName = serviceName;
        this.topic = topic;
        this.id = null;
        this.orderKey = orderKey;
        this.clusterService = clusterService;
    }

    @Override
    public Operation get() {
        return new DeregistrationOperation(this.topic, this.id, this.orderKey, this.clusterService.getMemberListVersion()).setServiceName(this.serviceName);
    }
}

